/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.XADataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.DataSourceConnector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XADataSourceConnector
implements Connector {
    private TestConfiguration config;
    private XADataSource ds;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = J2EEDataSource.getXADataSource(config, null);
    }

    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getXAConnection().getConnection();
        }
    }

    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getXAConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            XADataSource tmpDs = this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config));
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getXAConnection().getConnection();
        }
    }

    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getXAConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS(DataSourceConnector.makeCreateDBAttributes(this.config)).getXAConnection(user, password).getConnection();
        }
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        return this.openConnection(databaseName, user, password, null);
    }

    public Connection openConnection(String databaseName, String user, String password, Properties connectionProperties) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getXAConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            HashMap hm = DataSourceConnector.makeCreateDBAttributes(this.config);
            if (connectionProperties != null) {
                hm.putAll(connectionProperties);
            }
            XADataSource tmpDs = this.singleUseDS(hm);
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getXAConnection(user, password).getConnection();
        }
    }

    public void shutDatabase() throws SQLException {
        this.singleUseDS(DataSourceConnector.makeShutdownDBAttributes(this.config)).getXAConnection().getConnection();
    }

    public void shutEngine() throws SQLException {
        Assert.fail((String)"shutdown engine not implemened");
    }

    private XADataSource singleUseDS(HashMap hm) throws SQLException {
        XADataSource sds = J2EEDataSource.getXADataSource(this.config, hm);
        return sds;
    }
}

