/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Utilities;

public class IndexStatsUtil {
    private static final boolean INDEX = false;
    private static final boolean TABLE = true;
    private static final int NO_EXPECTATION = -1;
    private static final String SEP = BaseJDBCTestCase.getSystemProperty("line.separator");
    private final Connection con;
    private final long timeout;
    private PreparedStatement psGetTableId;
    private PreparedStatement psGetStatsForTable;
    private PreparedStatement psGetIndexId;
    private PreparedStatement psGetStatsForIndex;
    private PreparedStatement psGetStats;
    private PreparedStatement psGetIdToNameMapConglom;
    private PreparedStatement psGetIdToNameMapTable;

    public IndexStatsUtil(Connection con) {
        this(con, 0L);
    }

    public IndexStatsUtil(Connection con, long timeout) {
        try {
            Assert.assertTrue((boolean)con.getAutoCommit());
        }
        catch (SQLException sqle) {
            Assert.fail((String)("Failed to get auto commit: " + sqle.getMessage()));
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.con = con;
        this.timeout = timeout;
    }

    public void assertNoStats() throws SQLException {
        this.assertStats(0);
    }

    public void assertNoStatsTable(String table) throws SQLException {
        this.assertTableStats(table, 0);
    }

    public void assertStats(int expectedCount) throws SQLException {
        IdxStats[] ret = this.getStats();
        if (ret.length != expectedCount) {
            Assert.assertEquals((String)IndexStatsUtil.buildStatString(ret, "<ALL TABLES>"), (int)expectedCount, (int)ret.length);
        }
    }

    public void assertTableStats(String table, int expectedCount) throws SQLException {
        this.getStatsTable(table, expectedCount);
    }

    public void assertIndexStats(String index, int expectedCount) throws SQLException {
        this.getStatsIndex(index, expectedCount);
    }

    public static String buildStatString(IdxStats[] stats, String name) {
        StringBuffer sb = new StringBuffer("Index statistics for " + name + SEP);
        for (int i = 0; i < stats.length; ++i) {
            sb.append(i + 1).append(": ").append(stats[i].toString()).append(SEP);
        }
        if (stats.length == 0) {
            sb.append(" : <no stats>").append(SEP);
        }
        return sb.toString();
    }

    public IdxStats[] getStats() throws SQLException {
        if (this.psGetStats == null) {
            this.psGetStats = this.con.prepareStatement("select * from SYS.SYSSTATISTICS order by TABLEID, REFERENCEID, COLCOUNT");
        }
        return this.buildStatisticsList(this.psGetStats.executeQuery(), this.getIdToNameMap());
    }

    public IdxStats[] getStatsTable(String table) throws SQLException {
        return this.getStatsTable(table, -1);
    }

    public IdxStats[] getStatsTable(String table, int expectedCount) throws SQLException {
        if (this.psGetTableId == null) {
            this.psGetTableId = this.con.prepareStatement("select TABLEID from SYS.SYSTABLES where TABLENAME = ?");
        }
        this.psGetTableId.setString(1, table);
        ResultSet rs = this.psGetTableId.executeQuery();
        Assert.assertTrue((String)("No such table: " + table), (boolean)rs.next());
        String tableId = rs.getString(1);
        Assert.assertFalse((String)("More than one table named " + table), (boolean)rs.next());
        rs.close();
        IdxStats[] ret = this.querySystemTable(tableId, true, expectedCount);
        if (expectedCount != -1 && ret.length != expectedCount) {
            Assert.assertEquals((String)("failed to get statistics for table " + table + " (#expected=" + expectedCount + ", timeout=" + this.timeout + ")" + SEP + IndexStatsUtil.buildStatString(ret, table)), (int)expectedCount, (int)ret.length);
        }
        return ret;
    }

    public IdxStats[] getNewStatsTable(String table, IdxStats[] currentStats) throws SQLException {
        if (this.timeout == 0L) {
            throw new IllegalStateException("no timeout specified in the constructor");
        }
        this.awaitChange(currentStats, this.timeout);
        return this.getStatsTable(table, currentStats.length);
    }

    public IdxStats[] getStatsIndex(String index) throws SQLException {
        return this.getStatsIndex(index, -1);
    }

    public IdxStats[] getStatsIndex(String index, int expectedCount) throws SQLException {
        if (this.psGetIndexId == null) {
            this.psGetIndexId = this.con.prepareStatement("select CONGLOMERATEID from SYS.SYSCONGLOMERATES where CONGLOMERATENAME = ? and CAST(ISINDEX as VARCHAR(5)) = 'true'");
        }
        this.psGetIndexId.setString(1, index);
        ResultSet rs = this.psGetIndexId.executeQuery();
        Assert.assertTrue((String)("No such index: " + index), (boolean)rs.next());
        String indexId = rs.getString(1);
        Assert.assertFalse((String)("More than one index named " + index), (boolean)rs.next());
        rs.close();
        IdxStats[] ret = this.querySystemTable(indexId, false, expectedCount);
        if (expectedCount != -1 && ret.length != expectedCount) {
            Assert.assertEquals((String)("failed to get statistics for index " + index + " (#expected=" + expectedCount + ", timeout=" + this.timeout + ")" + SEP + IndexStatsUtil.buildStatString(ret, index)), (int)expectedCount, (int)ret.length);
        }
        return ret;
    }

    private IdxStats[] querySystemTable(String conglomId, boolean isTable, int expectedCount) throws SQLException {
        PreparedStatement ps;
        if (isTable) {
            if (this.psGetStatsForTable == null) {
                this.psGetStatsForTable = this.con.prepareStatement("select * from SYS.SYSSTATISTICS where TABLEID = ? order by REFERENCEID, COLCOUNT");
            }
            ps = this.psGetStatsForTable;
        } else {
            if (this.psGetStatsForIndex == null) {
                this.psGetStatsForIndex = this.con.prepareStatement("select * from SYS.SYSSTATISTICS where REFERENCEID = ? order by COLCOUNT");
            }
            ps = this.psGetStatsForIndex;
        }
        ps.setString(1, conglomId);
        long started = System.currentTimeMillis();
        long waited = -1L;
        IdxStats[] ret = null;
        while (waited < this.timeout) {
            if (ret != null) {
                Utilities.sleep(Math.min(250L, this.timeout - waited));
            }
            ret = this.buildStatisticsList(ps.executeQuery(), this.getIdToNameMap());
            if (expectedCount == -1 || ret.length == expectedCount) break;
            waited = System.currentTimeMillis() - started;
        }
        return ret;
    }

    public void printStats() throws SQLException {
        System.out.println(IndexStatsUtil.buildStatString(this.getStats(), "all tables"));
    }

    private Map getIdToNameMap() throws SQLException {
        if (this.psGetIdToNameMapConglom == null) {
            this.psGetIdToNameMapConglom = this.con.prepareStatement("select CONGLOMERATEID, CONGLOMERATENAME from SYS.SYSCONGLOMERATES");
        }
        if (this.psGetIdToNameMapTable == null) {
            this.psGetIdToNameMapTable = this.con.prepareStatement("select TABLEID, TABLENAME from SYS.SYSTABLES");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rs = this.psGetIdToNameMapConglom.executeQuery();
        while (rs.next()) {
            map.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        rs = this.psGetIdToNameMapTable.executeQuery();
        while (rs.next()) {
            map.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        return map;
    }

    private IdxStats[] buildStatisticsList(ResultSet rs, Map idToName) throws SQLException {
        ArrayList<IdxStats> stats = new ArrayList<IdxStats>();
        while (rs.next()) {
            stats.add(new IdxStats(rs.getString(1), rs.getString(2), (String)idToName.get(rs.getString(2)), rs.getString(3), (String)idToName.get(rs.getString(3)), rs.getTimestamp(4), rs.getInt(7), rs.getString(8)));
        }
        rs.close();
        IdxStats[] s = new IdxStats[stats.size()];
        stats.toArray(s);
        return s;
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean closeConnection) {
        PreparedStatement[] psToClose = new PreparedStatement[]{this.psGetStats, this.psGetIndexId, this.psGetStatsForIndex, this.psGetStatsForTable, this.psGetTableId, this.psGetIdToNameMapConglom, this.psGetIdToNameMapTable};
        for (int i = 0; i < psToClose.length; ++i) {
            try {
                if (psToClose[i] == null) continue;
                psToClose[i].close();
                continue;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        try {
            if (!this.con.isClosed()) {
                this.con.rollback();
            }
            if (closeConnection) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void awaitChange(IdxStats[] current, long timeout) throws SQLException {
        HashSet<IdxStats> oldStats = new HashSet<IdxStats>(Arrays.asList(current));
        HashSet<IdxStats> newStats = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout || newStats == null) {
            newStats = new HashSet<IdxStats>(Arrays.asList(this.getStats()));
            newStats.retainAll(oldStats);
            if (newStats.isEmpty()) {
                return;
            }
            Utilities.sleep(200L);
        }
        IdxStats[] outstanding = new IdxStats[newStats.size()];
        newStats.toArray(outstanding);
        Assert.fail((String)(outstanding.length + " missing statistics changes " + "(timeout=" + timeout + "ms): " + IndexStatsUtil.buildStatString(outstanding, "<unchanged statistics>")));
    }

    public static final class IdxStats {
        private static final String NA = "<n/a>";
        public final long rows;
        public final long card;
        public final int lcols;
        public final String id;
        public final String tableId;
        public final String tableName;
        public final String indexId;
        public final String indexName;
        public final Timestamp created;

        public IdxStats(String id, String indexId, String indexName, String tableId, String tableName, Timestamp created, int lcols, String stats) {
            this.id = id;
            this.indexId = indexId;
            this.indexName = indexName != null ? indexName : NA;
            this.tableId = tableId;
            this.tableName = tableName != null ? tableName : NA;
            this.created = created;
            this.lcols = lcols;
            int uniqPos = stats.indexOf(61);
            int space = stats.indexOf(32, uniqPos + 2);
            int rowsPos = stats.indexOf(61, space);
            this.card = Integer.parseInt(stats.substring(uniqPos + 1, space).trim());
            this.rows = Integer.parseInt(stats.substring(rowsPos + 1).trim());
        }

        public boolean after(IdxStats other) {
            return this.created.after(other.created);
        }

        public boolean before(IdxStats other) {
            return this.created.before(other.created);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(200);
            sb.append("{tableId=").append(this.tableId).append(", tableName=").append(this.tableName).append(", indexName=").append(this.indexName).append(", lcols=").append(this.lcols).append(", rows=").append(this.rows).append(", unique/card=").append(this.card).append(", created=").append(this.created).append('}');
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IdxStats other = (IdxStats)obj;
            return this.id.equals(other.id);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + this.id.hashCode();
            return hash;
        }
    }
}

