/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.DriverUnloader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

final class PhaseChanger
extends BaseTestSetup {
    private final int phase;
    private final int[] version;
    private ClassLoader loader;
    private ClassLoader previousLoader;
    private boolean trace = false;
    private String upgradeAttributes = "upgrade=true";

    public PhaseChanger(Test test, int phase, ClassLoader loader, int[] version, boolean useCreateOnUpgrade) {
        super(test);
        this.phase = phase;
        this.loader = loader;
        this.version = version;
        if (useCreateOnUpgrade) {
            this.upgradeAttributes = this.upgradeAttributes + ";create=true";
        }
    }

    protected void setUp() throws SQLException {
        UpgradeChange.phase.set(new Integer(this.phase));
        UpgradeChange.oldVersion.set(this.version);
        TestConfiguration config = TestConfiguration.getCurrent();
        this.trace = config.doTrace();
        if (this.trace) {
            String versStr = ((int[])UpgradeChange.oldVersion.get())[0] + "." + ((int[])UpgradeChange.oldVersion.get())[1] + "." + ((int[])UpgradeChange.oldVersion.get())[2] + "." + ((int[])UpgradeChange.oldVersion.get())[3];
            BaseTestCase.traceit("Test upgrade from: " + versStr + ", phase: " + UpgradeChange.PHASES[this.phase]);
            if (UpgradeChange.PHASES[this.phase].equals("UPGRADE")) {
                BaseTestCase.traceit("Upgrade attributes = " + this.upgradeAttributes);
            }
        }
        if (this.loader != null) {
            this.previousLoader = Thread.currentThread().getContextClassLoader();
            UpgradeClassLoader.setThreadLoader(this.loader);
        }
        DataSource ds = JDBCDataSource.getDataSource();
        switch (this.phase) {
            case 4: {
                return;
            }
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", this.upgradeAttributes);
                break;
            }
        }
        ds.getConnection().close();
    }

    protected void tearDown() throws Exception {
        if (this.trace) {
            BaseTestCase.traceit(" Test upgrade done.");
        }
        Object contextService = this.getDerby23ContextService();
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.shutEngine(ds);
        if (this.phase == 4) {
            this.deregisterDriver();
            this.clearDerby4895ThreadLocal();
        }
        this.clearDerby23ThreadLocals(contextService);
        if (this.loader != null) {
            UpgradeClassLoader.setThreadLoader(this.previousLoader);
        }
        this.loader = null;
        this.previousLoader = null;
        UpgradeChange.phase.set(null);
        UpgradeChange.oldVersion.set(null);
    }

    private void deregisterDriver() throws Exception {
        boolean isAffectedVersion;
        boolean bl = isAffectedVersion = UpgradeRun.lessThan(new int[]{10, 2, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 8, 0, 0});
        if (JDBC.vmSupportsJDBC3()) {
            Class<?> unloader = Class.forName(DriverUnloader.class.getName(), true, this.loader);
            Method m = unloader.getMethod("unload", null);
            Boolean res = (Boolean)m.invoke(null, (Object[])null);
            PhaseChanger.assertEquals((String)"Unexpected result from driver unloading", (boolean)isAffectedVersion, (boolean)res);
        }
    }

    private void clearDerby4895ThreadLocal() throws Exception {
        boolean isAffectedVersion;
        boolean bl = isAffectedVersion = UpgradeRun.lessThan(new int[]{10, 5, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 5, 3, 2}) || UpgradeRun.lessThan(new int[]{10, 6, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 6, 2, 3});
        if (!isAffectedVersion) {
            return;
        }
        Class<?> td = Class.forName("org.apache.derby.iapi.sql.dictionary.TableDescriptor", true, this.loader);
        PhaseChanger.clearField(td, "referencedColumnMap", null);
    }

    private static void clearField(Class cls, String name, Object instance) throws Exception {
        Field f = cls.getDeclaredField(name);
        f.setAccessible(true);
        f.set(instance, null);
    }

    private Object getDerby23ContextService() throws Exception {
        if (this.loader != null && UpgradeRun.lessThan(this.version, new int[]{10, 2, 1, 6})) {
            Class<?> cls = Class.forName("org.apache.derby.iapi.services.context.ContextService", true, this.loader);
            Field f = cls.getDeclaredField("factory");
            f.setAccessible(true);
            return f.get(null);
        }
        return null;
    }

    private void clearDerby23ThreadLocals(Object contextService) throws Exception {
        if (contextService != null) {
            Class<?> cls = contextService.getClass();
            Field tclField = cls.getDeclaredField("threadContextList");
            tclField.setAccessible(true);
            ThreadLocal tcl = (ThreadLocal)tclField.get(contextService);
            tcl.set(null);
            Field acField = cls.getDeclaredField("allContexts");
            acField.setAccessible(true);
            Set ac = (Set)acField.get(contextService);
            ac.clear();
        }
    }
}

