/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class Changes10_2
extends UpgradeChange {
    public static Test suite() {
        TestSuite suite = new TestSuite("Upgrade changes for 10.2");
        suite.addTestSuite(Changes10_2.class);
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest((Test)new Changes10_2("changeEncryptionFromNone"));
            suite.addTest((Test)new Changes10_2("changeEncryptionFromEncryptedDatabase"));
        }
        return suite;
    }

    public Changes10_2(String name) {
        super(name);
    }

    public void testTriggerInternalVTI() throws SQLException {
        Statement s = this.createStatement();
        boolean modeDb2SqlOptional = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                s.execute("CREATE TABLE D438.T438(a int, b varchar(20), c int)");
                s.execute("INSERT INTO D438.T438 VALUES(1, 'DERBY-438', 2)");
                s.execute("CREATE TABLE D438.T438_T1(a int, b varchar(20))");
                s.execute("CREATE TABLE D438.T438_T2(a int, c int)");
                s.execute("create trigger D438.T438_ROW_1 after UPDATE on D438.T438 referencing new as n old as o for each row " + (modeDb2SqlOptional ? "" : "mode db2sql ") + "insert into D438.T438_T1(a, b) values (n.a, n.b || '_ROW')");
                s.executeUpdate("create trigger D438.T438_STMT_1 after UPDATE on D438.T438 referencing new_table as n for each statement " + (modeDb2SqlOptional ? "" : "mode db2sql ") + "insert into D438.T438_T1(a, b) select n.a, n.b || '_STMT' from n");
                this.commit();
                break;
            }
            case 1: {
                s.execute("create trigger D438.T438_ROW_2 after UPDATE on D438.T438 referencing new as n old as o for each row " + (modeDb2SqlOptional ? "" : "mode db2sql ") + "insert into D438.T438_T2(a, c) values (n.a, n.c + 100)");
                s.executeUpdate("create trigger D438.T438_STMT_2 after UPDATE on D438.T438 referencing new_table as n for each statement " + (modeDb2SqlOptional ? "" : "mode db2sql ") + "insert into D438.T438_T2(a, c) select n.a, n.c + 4000 from n");
                this.commit();
                break;
            }
            case 2: {
                break;
            }
        }
        s.executeUpdate("UPDATE D438.T438 set c = c + 1");
        this.commit();
        ResultSet rs = s.executeQuery("SELECT a,b from D438.T438_T1 ORDER BY 2");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "DERBY-438_ROW"}, {"1", "DERBY-438_STMT"}});
        rs.close();
        rs = s.executeQuery("SELECT a,c from D438.T438_T2 ORDER BY 2");
        if (this.getPhase() == 0) {
            Changes10_2.assertFalse((boolean)rs.next());
        } else {
            JDBC.assertFullResultSet(rs, new String[][]{{"1", Integer.toString(102 + this.getPhase() + 1)}, {"1", Integer.toString(4002 + this.getPhase() + 1)}});
        }
        rs.close();
        s.executeUpdate("DELETE FROM D438.T438_T1");
        s.executeUpdate("DELETE FROM D438.T438_T2");
        this.commit();
        s.close();
    }

    public void testReusableRecordIdSequenceNumber() throws SQLException {
        boolean runCompress = this.oldAtLeast(10, 1);
        switch (this.getPhase()) {
            case 0: {
                Statement s = this.createStatement();
                s.execute("create table CT1(id int)");
                s.execute("insert into CT1 values 1,2,3,4,5,6,7,8,9,10");
                s.close();
                this.commit();
                break;
            }
            case 1: {
                if (!runCompress) break;
                PreparedStatement ps = this.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
                ps.setString(1, "APP");
                ps.setString(2, "CT1");
                ps.setInt(3, 1);
                ps.setInt(4, 1);
                ps.setInt(5, 1);
                ps.executeUpdate();
                ps.close();
                this.commit();
                break;
            }
            case 2: {
                Statement s = this.createStatement();
                ResultSet rs = s.executeQuery("select * from CT1");
                while (rs.next()) {
                    rs.getInt(1);
                }
                s.execute("insert into CT1 values 11,12,13,14,15,16,17,18,19");
                s.close();
                this.commit();
                break;
            }
        }
    }

    public void testGrantRevokeStatements() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_2.assertStatementError("42X01", s, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("42X01", s, "REVOKE SELECT ON TABLE1 FROM USER1");
                break;
            }
            case 1: {
                Changes10_2.assertStatementError("XCL47", s, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("XCL47", s, "REVOKE SELECT ON TABLE1 FROM USER1");
                break;
            }
            case 3: {
                Changes10_2.assertStatementError("42Z60", s, "GRANT SELECT ON TABLE1 TO USER1");
                Changes10_2.assertStatementError("42Z60", s, "REVOKE SELECT ON TABLE1 FROM USER1");
            }
        }
        s.close();
    }

    public void testDatabaseOwnerChange() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                this.checkSystemSchemasOwner("DBA");
                break;
            }
            case 3: {
                this.checkSystemSchemasOwner(this.getTestConfiguration().getUserName());
            }
        }
    }

    private void checkSystemSchemasOwner(String name) throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select AUTHORIZATIONID, SCHEMANAME from SYS.SYSSCHEMAS WHERE SCHEMANAME LIKE 'SYS%' OR SCHEMANAME IN ('NULLID', 'SQLJ')");
        while (rs.next()) {
            Changes10_2.assertEquals((String)("AUTHORIZATIONID not valid for " + rs.getString(2)), (String)name, (String)rs.getString(1));
        }
        rs.close();
        s.close();
    }

    public void testSystemRoutinePermissions() throws SQLException {
        switch (this.getPhase()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                Statement s = this.createStatement();
                ResultSet rs = s.executeQuery("select A.ALIAS FROM SYS.SYSROUTINEPERMS R, SYS.SYSALIASES A WHERE R.ALIASID = A.ALIASID AND R.GRANTEE = 'PUBLIC' AND R.GRANTOR = '" + this.getTestConfiguration().getUserName() + "'" + " ORDER BY 1");
                JDBC.assertFullResultSet(rs, new String[][]{{"SYSCS_COMPRESS_TABLE"}, {"SYSCS_DROP_STATISTICS"}, {"SYSCS_GET_RUNTIMESTATISTICS"}, {"SYSCS_INPLACE_COMPRESS_TABLE"}, {"SYSCS_MODIFY_PASSWORD"}, {"SYSCS_PEEK_AT_SEQUENCE"}, {"SYSCS_SET_RUNTIMESTATISTICS"}, {"SYSCS_SET_STATISTICS_TIMING"}, {"SYSCS_UPDATE_STATISTICS"}});
                rs.close();
                s.close();
            }
        }
    }

    public void changeEncryptionFromNone() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical("NO_ENCRYPT_10_2");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                ds.getConnection().close();
                break;
            }
            case 1: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "dataEncryption=true;bootPassword=xyz1234abc");
                try {
                    ds.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection in soft upgrade");
                }
                catch (SQLException e) {
                    Changes10_2.assertSQLState("XJ040", e);
                    e = e.getNextException();
                    Changes10_2.assertNotNull((Object)e);
                    Changes10_2.assertSQLState("XCL47", e);
                }
                break;
            }
            case 2: {
                ds.getConnection().close();
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true;dataEncryption=true;bootPassword=haRD1234upGrAde");
                ds.getConnection().close();
                JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
                JDBCDataSource.shutdownDatabase(ds);
                try {
                    ds.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection without password");
                }
                catch (SQLException e) {
                    Changes10_2.assertSQLState("XJ040", e);
                    e = e.getNextException();
                    Changes10_2.assertNotNull((Object)e);
                    Changes10_2.assertSQLState("XBM06", e);
                }
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=haRD1234upGrAde");
                ds.getConnection().close();
            }
        }
    }

    public void changeEncryptionFromEncryptedDatabase() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSourceLogical("ENCRYPT_10_2");
        switch (this.getPhase()) {
            case 0: {
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "dataEncryption=true;bootPassword=old862phRase");
                ds.getConnection().close();
                break;
            }
            case 1: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=old862phRase;newBootPassword=new902pHrAse");
                try {
                    ds.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection in soft upgrade");
                }
                catch (SQLException e) {
                    Changes10_2.assertSQLState("XJ040", e);
                    e = e.getNextException();
                    Changes10_2.assertNotNull((Object)e);
                    Changes10_2.assertSQLState("XCL47", e);
                }
                break;
            }
            case 2: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=old862phRase");
                ds.getConnection().close();
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "upgrade=true;bootPassword=old862phRase;newBootPassword=hard924pHrAse");
                ds.getConnection().close();
                JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
                JDBCDataSource.shutdownDatabase(ds);
                try {
                    ds.getConnection();
                    Changes10_2.fail((String)"open re-encrypted connection without password");
                }
                catch (SQLException e) {
                    Changes10_2.assertSQLState("XJ040", e);
                    e = e.getNextException();
                    Changes10_2.assertNotNull((Object)e);
                    Changes10_2.assertSQLState("XBM06", e);
                }
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=hard924pHrAse");
                ds.getConnection().close();
            }
        }
    }
}

