/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateLocksTest
extends BaseJDBCTestCase {
    private static final int UNIQUE_INDEX = 0;
    private static final int NON_UNIQUE_INDEX = 1;
    private static final int NO_IDX_1 = 2;
    private static final int NO_IDX_2 = 3;
    private static final String _g = "GRANT";
    private static final String _a = "ACTIVE";
    private static final String _app = "APP";
    private static final String _ut = "UserTran";
    private static final String _t = "TABLE";
    private static final String _r = "ROW";
    private static final String _tl = "Tablelock";
    private static final String _A = "A";
    private static final String _X = "X";
    private static final String _IX = "IX";
    private static final String _U = "U";
    private PreparedStatement getLocksQuery;
    private static final String lock_table_query = "select * from lock_table order by     tabname, type desc, mode, cnt, lockname";

    public UpdateLocksTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getLocksQuery = this.prepareStatement(lock_table_query);
    }

    public void tearDown() throws Exception {
        this.getLocksQuery = null;
        try {
            this.dropTable("a");
        }
        catch (SQLException e) {
            UpdateLocksTest.assertSQLState("42Y55", e);
        }
        super.tearDown();
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(UpdateLocksTest.class);
        Properties p = new Properties();
        p.put("derby.storage.pageSize", "4096");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(suite, p, false)){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create function PADSTRING (data varchar(32000),                            length integer)     returns varchar(32000)     external name     'org.apache.derbyTesting.functionTests.util.Formatters.padString'     language java parameter style java");
                s.executeUpdate("create view LOCK_TABLE as select      cast(username as char(8)) as username,     cast(t.type as char(8)) as trantype,     cast(l.type as char(8)) as type,     cast(lockcount as char(3)) as cnt,     mode,     cast(tablename as char(12)) as tabname,     cast(lockname as char(10)) as lockname,     state,     status from      syscs_diag.lock_table l  right outer join     syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' and       t.type='UserTransaction'");
                s.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            }
        };
    }

    public void testRepeatableRead() throws Exception {
        this.doRunTests(4);
    }

    public void testReadCommitted() throws Exception {
        this.doRunTests(2);
    }

    public void testSerializable() throws Exception {
        this.doRunTests(8);
    }

    public void testReadUncommitted() throws Exception {
        this.doRunTests(1);
    }

    private void insertValuesUnpaddedVarchar(Statement s) throws SQLException {
        s.executeUpdate("insert into a values (1, 10, 'one')");
        s.executeUpdate("insert into a values (2, 20, 'two')");
        s.executeUpdate("insert into a values (3, 30, 'three')");
        s.executeUpdate("insert into a values (4, 40, 'four')");
        s.executeUpdate("insert into a values (5, 50, 'five')");
        s.executeUpdate("insert into a values (6, 60, 'six')");
        s.executeUpdate("insert into a values (7, 70, 'seven')");
    }

    private void doRunTests(int isolation) throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(isolation);
        this.commit();
        Statement s = this.createStatement();
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        this.commit();
        this.updatecursorlocks(this.getConnection(), isolation, 0, 2);
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        this.commit();
        this.updatesetlocks(this.getConnection(), isolation, 0, 2);
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        s.executeUpdate("create unique index a_idx on a (a)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), isolation, 0, true, 0, 0);
        this.updateBtreeCursorLocks2(this.getConnection(), isolation, 0, true, 0, 0);
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        s.executeUpdate("create index a_idx on a (a)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), isolation, 1, true, 0, 0);
        this.updateBtreeCursorLocks2(this.getConnection(), isolation, 1, true, 0, 0);
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        s.executeUpdate("create unique index a_idx on a (a)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), isolation, 0, true, 0, 0);
        s.executeUpdate("create table a(a int, b int)");
        s.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(s);
        s.executeUpdate("create index a_idx on a (a)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), isolation, 1, true, 0, 0);
        s.executeUpdate("create table a (a int, b int, c varchar(1900))");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900))");
        this.commit();
        this.updatecursorlocks(this.getConnection(), isolation, 1900, 3);
        s.executeUpdate("create table a (a int, b int, c varchar(1900))");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900))");
        this.commit();
        this.updatesetlocks(this.getConnection(), isolation, 1900, 3);
        s.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(600) )");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',600))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',600))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',600))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',600))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',600))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',600))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',600))");
        s.executeUpdate("create unique index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), isolation, 0, false, 1900, 600);
        this.updateBtreeCursorLocks2(this.getConnection(), isolation, 0, false, 1900, 600);
        s.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(700) )");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',700))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',700))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',700))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',700))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',700))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',700))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',700))");
        s.executeUpdate("create index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), isolation, 1, false, 1900, 700);
        this.updateBtreeCursorLocks2(this.getConnection(), isolation, 1, false, 1900, 700);
        s.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(800) )");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',800))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',800))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',800))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',800))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',800))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',800))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',800))");
        s.executeUpdate("create unique index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), isolation, 0, false, 1900, 800);
        s.executeUpdate("create table a (a int, b int, c varchar(1900),     index_pad varchar(900) )");
        s.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',900))");
        s.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',900))");
        s.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',900))");
        s.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',900))");
        s.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',900))");
        s.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',900))");
        s.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',900))");
        s.executeUpdate("create index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), isolation, 1, false, 1900, 900);
        this.commit();
    }

    /*
     * Opcode count of 31726 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updatecursorlocks(Connection c, int isolation, int pad, int mode) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        String[][] stringArray26;
        String[][] stringArray27;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        String[][] stringArray31;
        String[][] stringArray32;
        String[][] stringArray33;
        String[][] stringArray34;
        String[][] stringArray35;
        String[][] stringArray36;
        String[][] stringArray37;
        String[][] stringArray38;
        String[][] stringArray39;
        String[][] stringArray40;
        String[][] stringArray41;
        String[][] stringArray42;
        String[][] stringArray43;
        String[][] stringArray44;
        String[][] stringArray45;
        String[][] stringArray46;
        String[][] stringArray47;
        String[][] stringArray48;
        String[][] stringArray49;
        String[][] stringArray50;
        String[][] stringArray51;
        String[][] stringArray52;
        Statement s = c.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select a, b, c from a for update");
        ResultSet ltrs = this.getLocks();
        this.verifyRsMetaData(ltrs);
        if (isolation == 8) {
            String[][] stringArray53 = new String[1][];
            stringArray52 = stringArray53;
            stringArray53[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            String[][] stringArrayArray = new String[1][];
            stringArray52 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray52 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray52);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray54 = new String[1][];
            stringArray51 = stringArray54;
            stringArray54[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray51 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray51);
        rs.next();
        this.assertRow(rs, new String[]{"2", "20", UpdateLocksTest.pad2("two", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray55 = new String[1][];
            stringArray50 = stringArray55;
            stringArray55[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray50 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray50 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray50);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray56 = new String[1][];
            stringArray49 = stringArray56;
            stringArray56[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray49 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray49 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray49 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray49 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray49);
        rs.next();
        this.assertRow(rs, new String[]{"4", "40", UpdateLocksTest.pad2("four", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray57 = new String[1][];
            stringArray48 = stringArray57;
            stringArray57[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray48 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray48 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray48 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray48 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray48);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray58 = new String[1][];
            stringArray47 = stringArray58;
            stringArray58[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray47 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArray47 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray47 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray47 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray47);
        rs.next();
        this.assertRow(rs, new String[]{"6", "60", UpdateLocksTest.pad2("six", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray59 = new String[1][];
            stringArray46 = stringArray59;
            stringArray59[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray46 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray46 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray46 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray46 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray46);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray60 = new String[1][];
            stringArray45 = stringArray60;
            stringArray60[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray45 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray45 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray45 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray45 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray45);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray61 = new String[1][];
            stringArray44 = stringArray61;
            stringArray61[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray44 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray44 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray44 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray44);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray62 = new String[1][];
            stringArray43 = stringArray62;
            stringArray62[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray43 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray43 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray43 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray43);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        rs = s.executeQuery("select a, b, c from a for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray63 = new String[1][];
            stringArray42 = stringArray63;
            stringArray63[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray42 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray42);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray64 = new String[1][];
            stringArray41 = stringArray64;
            stringArray64[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray41 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray41);
        rs.next();
        this.assertRow(rs, new String[]{"2", "20", UpdateLocksTest.pad2(UpdateLocksTest.pad2("two", pad), pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray65 = new String[2][];
            stringArray65[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray40 = stringArray65;
            stringArray65[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray40 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray40 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray40);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray66 = new String[2][];
            stringArray66[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray39 = stringArray66;
            stringArray66[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray39 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray39 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray39 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray39 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray39);
        rs.next();
        this.assertRow(rs, new String[]{"4", "40", UpdateLocksTest.pad2("four", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray67 = new String[2][];
            stringArray67[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray38 = stringArray67;
            stringArray67[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArray38 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray38 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray38 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArray38 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray38);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray68 = new String[2][];
            stringArray68[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray37 = stringArray68;
            stringArray68[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArray37 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray37 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray37 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            stringArray37 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray37);
        rs.next();
        this.assertRow(rs, new String[]{"6", "60", UpdateLocksTest.pad2("six", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray69 = new String[2][];
            stringArray69[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray36 = stringArray69;
            stringArray69[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray36 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray36 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray36 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray36 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray36);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray70 = new String[2][];
            stringArray70[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray35 = stringArray70;
            stringArray70[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray35 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray35 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray35 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray35 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray35);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray71 = new String[2][];
            stringArray71[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray34 = stringArray71;
            stringArray71[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray34 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray34 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray34 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray34 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray34);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray72 = new String[2][];
            stringArray72[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray33 = stringArray72;
            stringArray72[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray33 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray33 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray33 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray33 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray33);
        this.commit();
        s.execute("call wait_for_post_commit()");
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", pad)}, {"3", "30", UpdateLocksTest.pad2("three", pad)}, {"5", "50", UpdateLocksTest.pad2("five", pad)}, {"7", "70", UpdateLocksTest.pad2("seven", pad)}}, false);
        this.commit();
        rs = s.executeQuery("select a, b, c from a for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray73 = new String[1][];
            stringArray32 = stringArray73;
            stringArray73[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray32 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray32);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray74 = new String[1][];
            stringArray31 = stringArray74;
            stringArray74[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray31);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray75 = new String[1][];
            stringArray30 = stringArray75;
            stringArray75[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray30);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray76 = new String[1][];
            stringArray29 = stringArray76;
            stringArray76[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray29);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray77 = new String[1][];
            stringArray28 = stringArray77;
            stringArray77[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray28);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray78 = new String[1][];
            stringArray27 = stringArray78;
            stringArray78[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray27 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray27);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray79 = new String[1][];
            stringArray26 = stringArray79;
            stringArray79[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray26 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray26);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", pad)}, {"3", "30", UpdateLocksTest.pad2("three", pad)}, {"5", "50", UpdateLocksTest.pad2("five", pad)}, {"7", "70", UpdateLocksTest.pad2("seven", pad)}}, false);
        this.commit();
        rs = s.executeQuery("select a, b, c from a for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray80 = new String[1][];
            stringArray25 = stringArray80;
            stringArray80[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray25 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray25);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray81 = new String[1][];
            stringArray24 = stringArray81;
            stringArray81[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray24 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray24);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        rs.updateInt(_A, -3);
        rs.updateInt("B", -30);
        rs.updateString("C", UpdateLocksTest.pad2("-three", pad));
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray82 = new String[2][];
            stringArray82[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray23 = stringArray82;
            stringArray82[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray23);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        rs.updateInt(_A, -5);
        rs.updateInt("B", -50);
        rs.updateString("C", UpdateLocksTest.pad2("-five", pad));
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray83 = new String[2][];
            stringArray83[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArray83;
            stringArray83[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray22);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray84 = new String[2][];
            stringArray84[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArray84;
            stringArray84[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray21);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray85 = new String[2][];
            stringArray85[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArray85;
            stringArray85[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray20);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray86 = new String[2][];
            stringArray86[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArray86;
            stringArray86[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray19);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", pad)}, {"-3", "-30", UpdateLocksTest.pad2("-three", pad)}, {"-5", "-50", UpdateLocksTest.pad2("-five", pad)}, {"7", "70", UpdateLocksTest.pad2("seven", pad)}}, false);
        this.commit();
        rs = s.executeQuery("select a, b, c from a where a < 0 for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray87 = new String[1][];
            stringArray18 = stringArray87;
            stringArray87[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray18 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray18);
        rs.next();
        this.assertRow(rs, new String[]{"-3", "-30", UpdateLocksTest.pad2("-three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray88 = new String[1][];
            stringArray17 = stringArray88;
            stringArray88[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray17);
        rs.next();
        this.assertRow(rs, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray89 = new String[1][];
            stringArray16 = stringArray89;
            stringArray89[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray16);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray90 = new String[1][];
            stringArray15 = stringArray90;
            stringArray90[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray15 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray15);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray91 = new String[1][];
            stringArray14 = stringArray91;
            stringArray91[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray14 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray14);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", pad)}, {"-3", "-30", UpdateLocksTest.pad2("-three", pad)}, {"-5", "-50", UpdateLocksTest.pad2("-five", pad)}, {"7", "70", UpdateLocksTest.pad2("seven", pad)}}, false);
        this.commit();
        rs = s.executeQuery("select a, b, c from a where a > 0 for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray92 = new String[1][];
            stringArray13 = stringArray92;
            stringArray92[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray13 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray13);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray93 = new String[2][];
            stringArray93[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray12 = stringArray93;
            stringArray93[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray12);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray94 = new String[2][];
            stringArray94[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray94;
            stringArray94[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray11);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray95 = new String[2][];
            stringArray95[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArray95;
            stringArray95[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray10);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray96 = new String[2][];
            stringArray96[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray9 = stringArray96;
            stringArray96[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray9);
        this.commit();
        s.execute("call wait_for_post_commit()");
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"-3", "-30", UpdateLocksTest.pad2("-three", pad)}, {"-5", "-50", UpdateLocksTest.pad2("-five", pad)}}, false);
        this.commit();
        rs = s.executeQuery("select a, b, c from a where a >= -5 for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray97 = new String[1][];
            stringArray8 = stringArray97;
            stringArray97[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray8 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray8);
        rs.next();
        this.assertRow(rs, new String[]{"-3", "-30", UpdateLocksTest.pad2("-three", pad)});
        rs.updateInt(_A, 3);
        rs.updateInt("B", 30);
        rs.updateString("C", UpdateLocksTest.pad2("three", pad));
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray98 = new String[2][];
            stringArray98[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArray98;
            stringArray98[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray7);
        rs.next();
        this.assertRow(rs, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray99 = new String[2][];
            stringArray99[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray6 = stringArray99;
            stringArray99[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray6);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray100 = new String[2][];
            stringArray100[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArray100;
            stringArray100[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray5);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        rs = s.executeQuery("select * from a");
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"3", "30", UpdateLocksTest.pad2("three", pad)}, {"-5", "-50", UpdateLocksTest.pad2("-five", pad)}}, true);
        this.commit();
        rs = s.executeQuery("select a, b, c from a where a >= -5 for update");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray101 = new String[1][];
            stringArray4 = stringArray101;
            stringArray101[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray4 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray4);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        rs.updateInt(_A, 33);
        rs.updateInt("B", 3030);
        rs.updateString("C", "threethree");
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray102 = new String[2][];
            stringArray102[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArray102;
            stringArray102[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray3);
        rs.next();
        this.assertRow(rs, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray103 = new String[2][];
            stringArray103[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArray103;
            stringArray103[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray2);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray104 = new String[2][];
            stringArray104[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray = stringArray104;
            stringArray104[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray);
        this.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        this.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"33", "3030", "threethree"}});
        this.commit();
        s.executeUpdate("drop table a");
        rs.close();
        ltrs.close();
        s.close();
    }

    private void updatesetlocks(Connection c, int isolation, int pad, int mode) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("delete from a where a = -42");
        ResultSet ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray12 = new String[1][];
            stringArray11 = stringArray12;
            stringArray12[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray11 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray11);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        s.executeUpdate("update a set b = -b where a = -42");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray13 = new String[1][];
            stringArray10 = stringArray13;
            stringArray13[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray10 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray10);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("update a set a = -a, b = -b where a = -42");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray14 = new String[1][];
            stringArray9 = stringArray14;
            stringArray14[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray9 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray9);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("delete from a where a = 2 or a = 4 or a = 6");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray15 = new String[2][];
            stringArray15[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArray15;
            stringArray15[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray8);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "30", "three"}, {"5", "50", "five"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("delete from a where a = -42");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray16 = new String[1][];
            stringArray7 = stringArray16;
            stringArray16[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray7 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray7);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        s.executeUpdate("update a set b = -b where a = -42");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray17 = new String[1][];
            stringArray6 = stringArray17;
            stringArray17[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray6 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray6);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "30", "three"}, {"5", "50", "five"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("update a set b = -b where a = 3 or a = 5");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArray18 = new String[3][];
            stringArray18[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray18[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray5 = stringArray18;
            stringArray18[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray5);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "-30", "three"}, {"5", "-50", "five"}, {"7", "70", "seven"}});
        c.commit();
        s.executeUpdate("update a set b = 4000 where a < 0");
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        s.executeUpdate("delete from a where b > 0");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray19 = new String[1][];
            stringArray4 = stringArray19;
            stringArray19[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray4);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"3", "-30", "three"}, {"5", "-50", "five"}});
        c.commit();
        s.executeUpdate("update a set b = -b, c = 'three' where a > 2 and a < 5");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray20 = new String[1][];
            stringArray3 = stringArray20;
            stringArray20[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray3);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"3", "30", "three"}, {"5", "-50", "five"}});
        c.commit();
        s.executeUpdate("update a set a=33,b=3030,c='threethree' where a = 3");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray21 = new String[1][];
            stringArray2 = stringArray21;
            stringArray21[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray2);
        s.executeUpdate("delete from a where a = 5");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray22 = new String[1][];
            stringArray = stringArray22;
            stringArray22[0] = new String[]{_app, _ut, _t, "4", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (mode == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (mode == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select * from a"), new String[][]{{"33", "3030", "threethree"}});
        c.commit();
        s.executeUpdate("drop table a");
        ltrs.close();
        s.close();
    }

    /*
     * Opcode count of 33895 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeCursorLocks1(Connection c, int isolation, int mode, boolean unPadded, int pad, int idxPad) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        Object[][] objectArray;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        String[][] stringArray26;
        String[][] stringArray27;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        String[][] stringArray31;
        String[][] stringArray32;
        String[][] stringArray33;
        Object[][] objectArray2;
        c.setAutoCommit(false);
        Statement s = c.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select a, b, c from a for update");
        ResultSet ltrs = this.getLocks();
        this.verifyRsMetaData(ltrs);
        ResultSet resultSet = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray3 = new String[7][];
            objectArray3[0] = new String[]{"1", "10", "one"};
            objectArray3[1] = new String[]{"2", "20", "two"};
            objectArray3[2] = new String[]{"3", "30", "three"};
            objectArray3[3] = new String[]{"4", "40", "four"};
            objectArray3[4] = new String[]{"5", "50", "five"};
            objectArray3[5] = new String[]{"6", "60", "six"};
            objectArray2 = objectArray3;
            objectArray3[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", pad), UpdateLocksTest.pad2("index pad 2", idxPad)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", pad), UpdateLocksTest.pad2("index pad 4", idxPad)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", pad), UpdateLocksTest.pad2("index pad 6", idxPad)};
            objectArray2 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet, objectArray2, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where     a >= 1 and a < 20 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray33 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray33 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray34 = new String[1][];
            stringArray33 = stringArray34;
            stringArray34[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray33);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray35 = new String[1][];
                stringArray32 = stringArray35;
                stringArray35[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray32 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray32 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray32);
        rs.next();
        this.assertRow(rs, new String[]{"2", "20", UpdateLocksTest.pad2("two", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray36 = new String[1][];
                stringArray31 = stringArray36;
                stringArray36[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray31);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray37 = new String[1][];
                stringArray30 = stringArray37;
                stringArray37[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray30);
        rs.next();
        this.assertRow(rs, new String[]{"4", "40", UpdateLocksTest.pad2("four", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray38 = new String[1][];
                stringArray29 = stringArray38;
                stringArray38[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray29);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray39 = new String[1][];
                stringArray28 = stringArray39;
                stringArray39[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray28);
        rs.next();
        this.assertRow(rs, new String[]{"6", "60", UpdateLocksTest.pad2("six", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray40 = new String[1][];
                stringArray27 = stringArray40;
                stringArray40[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray27);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray41 = new String[1][];
                stringArray26 = stringArray41;
                stringArray41[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray26);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray42 = new String[1][];
                stringArray25 = stringArray42;
                stringArray42[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray25 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray25);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray43 = new String[1][];
                stringArray24 = stringArray43;
                stringArray43[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray24 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray24);
        c.commit();
        JDBC.assertEmpty(this.getLocks());
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray23 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray23 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray44 = new String[1][];
            stringArray23 = stringArray44;
            stringArray44[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray23);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray45 = new String[1][];
                stringArray22 = stringArray45;
                stringArray45[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray22);
        rs.next();
        this.assertRow(rs, new String[]{"2", "20", UpdateLocksTest.pad2("two", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray46 = new String[1][];
                stringArray21 = stringArray46;
                stringArray46[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray21);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray47 = new String[1][];
                stringArray20 = stringArray47;
                stringArray47[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray20);
        rs.next();
        this.assertRow(rs, new String[]{"4", "40", UpdateLocksTest.pad2("four", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray48 = new String[1][];
                stringArray19 = stringArray48;
                stringArray48[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray19);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray49 = new String[1][];
                stringArray18 = stringArray49;
                stringArray49[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray18 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray18);
        c.commit();
        JDBC.assertEmpty(this.getLocks());
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray17 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray17 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray50 = new String[1][];
            stringArray17 = stringArray50;
            stringArray50[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray17);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray51 = new String[1][];
                stringArray16 = stringArray51;
                stringArray51[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray16);
        rs.next();
        this.assertRow(rs, new String[]{"2", "20", UpdateLocksTest.pad2("two", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray52 = new String[1][];
                stringArray15 = stringArray52;
                stringArray52[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray15);
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray53 = new String[2][];
                stringArray53[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray14 = stringArray53;
                stringArray53[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray14 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray14 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray14);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray54 = new String[2][];
                stringArray54[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray13 = stringArray54;
                stringArray54[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray13);
        rs.next();
        this.assertRow(rs, new String[]{"4", "40", UpdateLocksTest.pad2("four", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray55 = new String[2][];
                stringArray55[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArray12 = stringArray55;
                stringArray55[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray12);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray56 = new String[2][];
                stringArray56[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArray11 = stringArray56;
                stringArray56[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray11);
        rs.next();
        this.assertRow(rs, new String[]{"6", "60", UpdateLocksTest.pad2("six", pad)});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray57 = new String[2][];
                stringArray57[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray10 = stringArray57;
                stringArray57[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[14][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray10);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray58 = new String[2][];
                stringArray58[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray9 = stringArray58;
                stringArray58[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray9);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray59 = new String[2][];
                stringArray59[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray8 = stringArray59;
                stringArray59[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray8);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray60 = new String[2][];
                stringArray60[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray7 = stringArray60;
                stringArray60[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (mode == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray7);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select a from a"), new String[][]{{"1"}, {"3"}, {"5"}, {"7"}});
        ResultSet resultSet2 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray4 = new String[4][];
            objectArray4[0] = new String[]{"1", "10", "one"};
            objectArray4[1] = new String[]{"3", "30", "three"};
            objectArray4[2] = new String[]{"5", "50", "five"};
            objectArray = objectArray4;
            objectArray4[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet2, objectArray, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray6 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray6 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray61 = new String[1][];
            stringArray6 = stringArray61;
            stringArray61[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray6);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray62 = new String[1][];
                stringArray5 = stringArray62;
                stringArray62[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray5);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray63 = new String[1][];
                stringArray4 = stringArray63;
                stringArray63[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray4);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray64 = new String[1][];
                stringArray3 = stringArray64;
                stringArray64[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray3);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray65 = new String[1][];
                stringArray2 = stringArray65;
                stringArray65[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray2);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray66 = new String[1][];
                stringArray = stringArray66;
                stringArray66[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray);
        rs.close();
    }

    /*
     * Opcode count of 29780 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeCursorLocks2(Connection c, int isolation, int mode, boolean unPadded, int pad, int idxPad) throws SQLException {
        Object[][] objectArray;
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        Object[][] objectArray2;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        Object[][] objectArray3;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        Object[][] objectArray4;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        Object[][] objectArray5;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        Object[][] objectArray6;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        Object[][] objectArray7;
        String[][] stringArray26;
        String[][] stringArray27;
        Object[][] objectArray8;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        Object[][] objectArray9;
        String[][] stringArray31;
        Statement s = c.createStatement(1003, 1008);
        ResultSet rs = null;
        ResultSet ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray32 = new String[1][];
                stringArray31 = stringArray32;
                stringArray32[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray31 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray31);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray10 = new String[4][];
            objectArray10[0] = new String[]{"1", "10", "one"};
            objectArray10[1] = new String[]{"3", "30", "three"};
            objectArray10[2] = new String[]{"5", "50", "five"};
            objectArray9 = objectArray10;
            objectArray10[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray9 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet, objectArray9, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a = 3 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        rs.updateInt("B", -3000);
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8 && mode == 1 && unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,8)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,9)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(1,9)", _g, _a};
        } else if (isolation == 8 && mode == 1 && !unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
        } else if (isolation == 8 && !unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
        } else if (unPadded) {
            String[][] stringArray33 = new String[3][];
            stringArray33[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray33[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray30 = stringArray33;
            stringArray33[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray30);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,9)", _g, _a};
                    stringArray29 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
                    stringArray29 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            if (mode == 0) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            }
        } else {
            String[][] stringArray34 = new String[2][];
            stringArray34[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArray34;
            stringArray34[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray29);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray28 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray28 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray35 = new String[2][];
            stringArray35[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArray35;
            stringArray35[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray28);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet2 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray11 = new String[4][];
            objectArray11[0] = new String[]{"1", "10", "one"};
            objectArray11[1] = new String[]{"3", "-3000", "three"};
            objectArray11[2] = new String[]{"5", "50", "five"};
            objectArray8 = objectArray11;
            objectArray11[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-3000", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet2, objectArray8, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a = 3 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        rs.next();
        this.assertRow(rs, new String[]{"3", "-3000", UpdateLocksTest.pad2("three", pad)});
        rs.updateInt("B", 30);
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray27 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray27 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray36 = new String[3][];
            stringArray36[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray36[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray27 = stringArray36;
            stringArray36[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray27);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray26 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray26 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray37 = new String[2][];
            stringArray37[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArray37;
            stringArray37[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray26);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet3 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray12 = new String[4][];
            objectArray12[0] = new String[]{"1", "10", "one"};
            objectArray12[1] = new String[]{"3", "30", "three"};
            objectArray12[2] = new String[]{"5", "50", "five"};
            objectArray7 = objectArray12;
            objectArray12[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet3, objectArray7, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray25 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray25 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray38 = new String[1][];
            stringArray25 = stringArray38;
            stringArray38[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray25);
        rs.next();
        this.assertRow(rs, new String[]{"1", "10", UpdateLocksTest.pad2("one", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray39 = new String[1][];
                stringArray24 = stringArray39;
                stringArray39[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray24 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray24);
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", UpdateLocksTest.pad2("three", pad)});
        rs.updateInt("B", -30);
        rs.updateString("C", "-three");
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray40 = new String[2][];
                stringArray40[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArray23 = stringArray40;
                stringArray40[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray23);
        rs.next();
        this.assertRow(rs, new String[]{"5", "50", UpdateLocksTest.pad2("five", pad)});
        rs.updateInt("B", -50);
        rs.updateString("C", "-five");
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray41 = new String[2][];
                stringArray41[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray22 = stringArray41;
                stringArray41[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray22);
        rs.next();
        this.assertRow(rs, new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad)});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray42 = new String[2][];
                stringArray42[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray21 = stringArray42;
                stringArray42[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray21);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray43 = new String[2][];
                stringArray43[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray20 = stringArray43;
                stringArray43[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray20);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray44 = new String[2][];
                stringArray44[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray19 = stringArray44;
                stringArray44[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray19);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet4 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray13 = new String[4][];
            objectArray13[0] = new String[]{"1", "10", "one"};
            objectArray13[1] = new String[]{"3", "-30", "-three"};
            objectArray13[2] = new String[]{"5", "-50", "-five"};
            objectArray6 = objectArray13;
            objectArray13[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray6 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet4, objectArray6, false);
        c.commit();
        rs = s.executeQuery("select a from a where a > 0 and b < 0 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray18 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray18 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray45 = new String[1][];
            stringArray18 = stringArray45;
            stringArray45[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray18);
        rs.next();
        this.assertRow(rs, new String[]{"3"});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray46 = new String[1][];
                stringArray17 = stringArray46;
                stringArray46[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray17);
        rs.next();
        this.assertRow(rs, new String[]{"5"});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray47 = new String[1][];
                stringArray16 = stringArray47;
                stringArray47[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray16);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray48 = new String[1][];
                stringArray15 = stringArray48;
                stringArray48[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray15 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray15);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArray49 = new String[1][];
                stringArray14 = stringArray49;
                stringArray49[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray14 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray14);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet5 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray14 = new String[4][];
            objectArray14[0] = new String[]{"1", "10", "one"};
            objectArray14[1] = new String[]{"3", "-30", "-three"};
            objectArray14[2] = new String[]{"5", "-50", "-five"};
            objectArray5 = objectArray14;
            objectArray14[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray5 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet5, objectArray5, false);
        c.commit();
        rs = s.executeQuery("select a from a where a = 1 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        rs.next();
        this.assertRow(rs, new String[]{"1"});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8 && mode == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 8 && mode == 0 && !unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArray50 = new String[3][];
            stringArray50[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray50[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray13 = stringArray50;
            stringArray50[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray13);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8 && mode == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 8 && mode == 0 && !unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            }
        } else if (unPadded) {
            if (mode == 0) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArray51 = new String[2][];
            stringArray51[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray12 = stringArray51;
            stringArray51[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray12);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8 && mode == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 8 && mode == 0 && !unPadded) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 8) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (isolation == 4) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArray52 = new String[2][];
            stringArray52[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray52;
            stringArray52[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray11);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet6 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray15 = new String[3][];
            objectArray15[0] = new String[]{"3", "-30", "-three"};
            objectArray15[1] = new String[]{"5", "-50", "-five"};
            objectArray4 = objectArray15;
            objectArray15[2] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", idxPad)};
            objectArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet6, objectArray4, false);
        c.commit();
        rs = s.executeQuery("select a from a where a <> 3 and a <> 5 for update of b, c");
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray53 = new String[1][];
            stringArray10 = stringArray53;
            stringArray53[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray10 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray10);
        rs.next();
        this.assertRow(rs, new String[]{"7"});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray54 = new String[2][];
            stringArray54[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray9 = stringArray54;
            stringArray54[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (unPadded) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray9);
        UpdateLocksTest.assertFalse((boolean)rs.next());
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray55 = new String[2][];
            stringArray55[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArray55;
            stringArray55[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray8);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray56 = new String[2][];
            stringArray56[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArray56;
            stringArray56[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray7);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet7 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray16 = new String[2][];
            objectArray16[0] = new String[]{"3", "-30", "-three"};
            objectArray3 = objectArray16;
            objectArray16[1] = new String[]{"5", "-50", "-five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", idxPad)};
            objectArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet7, objectArray3, false);
        c.commit();
        rs = s.executeQuery("select a,b,c from a where a > 2 and a <= 5 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        rs.next();
        this.assertRow(rs, new String[]{"3", "-30", "-three"});
        rs.updateInt("B", 30);
        rs.updateString("C", "three");
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray57 = new String[3][];
            stringArray57[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray57[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray6 = stringArray57;
            stringArray57[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray6);
        rs.next();
        this.assertRow(rs, new String[]{"5", "-50", "-five"});
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray58 = new String[3][];
            stringArray58[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray58[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray5 = stringArray58;
            stringArray58[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray5);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray59 = new String[2][];
            stringArray59[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArray59;
            stringArray59[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray4);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet8 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray17 = new String[2][];
            objectArray17[0] = new String[]{"3", "30", "three"};
            objectArray2 = objectArray17;
            objectArray17[1] = new String[]{"5", "-50", "-five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "30", "three", UpdateLocksTest.pad2("index pad 3", idxPad)};
            objectArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet8, objectArray2, false);
        c.commit();
        rs = s.executeQuery("select a, b, c from a where a > 0 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        rs.next();
        this.assertRow(rs, new String[]{"3", "30", "three"});
        rs.updateInt("B", 3030);
        rs.updateString("C", "threethree");
        rs.updateRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (unPadded) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray60 = new String[3][];
            stringArray60[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray60[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray3 = stringArray60;
            stringArray60[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray3);
        rs.next();
        this.assertRow(rs, new String[]{"5", "-50", "-five"});
        rs.deleteRow();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray61 = new String[4][];
            stringArray61[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray61[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray61[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            stringArray2 = stringArray61;
            stringArray61[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray2);
        rs.close();
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray62 = new String[3][];
            stringArray62[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray62[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            stringArray = stringArray62;
            stringArray62[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet9 = s.executeQuery("select * from a");
        if (unPadded) {
            Object[][] objectArray18 = new String[1][];
            objectArray = objectArray18;
            objectArray18[0] = new String[]{"3", "3030", "threethree"};
        } else {
            String[][] stringArrayArray = new String[1][];
            objectArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"3", "3030", "threethree", UpdateLocksTest.pad2("index pad 3", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet9, objectArray, false);
        c.commit();
        s.executeUpdate("drop table a");
        ltrs.close();
        s.close();
        rs.close();
    }

    /*
     * Opcode count of 13492 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeSetLocks(Connection c, int isolation, int mode, boolean unPadded, int pad, int idxPad) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        ResultSet resultSet = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray26 = new String[7][];
            stringArray26[0] = new String[]{"1", "10", "one"};
            stringArray26[1] = new String[]{"2", "20", "two"};
            stringArray26[2] = new String[]{"3", "30", "three"};
            stringArray26[3] = new String[]{"4", "40", "four"};
            stringArray26[4] = new String[]{"5", "50", "five"};
            stringArray26[5] = new String[]{"6", "60", "six"};
            stringArray25 = stringArray26;
            stringArray26[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", pad), UpdateLocksTest.pad2("index pad 2", idxPad)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", pad), UpdateLocksTest.pad2("index pad 4", idxPad)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", pad), UpdateLocksTest.pad2("index pad 6", idxPad)};
            stringArray25 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray25);
        c.commit();
        ResultSet resultSet2 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray27 = new String[7][];
            stringArray27[0] = new String[]{"1", "10", "one"};
            stringArray27[1] = new String[]{"2", "20", "two"};
            stringArray27[2] = new String[]{"3", "30", "three"};
            stringArray27[3] = new String[]{"4", "40", "four"};
            stringArray27[4] = new String[]{"5", "50", "five"};
            stringArray27[5] = new String[]{"6", "60", "six"};
            stringArray24 = stringArray27;
            stringArray27[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", pad), UpdateLocksTest.pad2("index pad 2", idxPad)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", pad), UpdateLocksTest.pad2("index pad 4", idxPad)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", pad), UpdateLocksTest.pad2("index pad 6", idxPad)};
            stringArray24 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray24);
        ResultSet ltrs = this.getLocks();
        if (isolation == 8) {
            String[][] stringArray28 = new String[1][];
            stringArray23 = stringArray28;
            stringArray28[0] = new String[]{_app, _ut, _t, "1", "S", _A, _tl, _g, _a};
        } else if (isolation == 4) {
            if (unPadded) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", "IS", _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,8)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", "IS", _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", "S", _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", "S", _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", "S", _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", "S", _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", "S", _A, "(6,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", "S", _A, "(7,6)", _g, _a};
            }
        } else {
            stringArray23 = new String[][]{};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray23);
        c.commit();
        JDBC.assertEmpty(this.getLocks());
        c.commit();
        s.executeUpdate("delete from a where a = 4");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray22 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray22 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray29 = new String[2][];
            stringArray29[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArray29;
            stringArray29[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray22);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet3 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray30 = new String[6][];
            stringArray30[0] = new String[]{"1", "10", "one"};
            stringArray30[1] = new String[]{"2", "20", "two"};
            stringArray30[2] = new String[]{"3", "30", "three"};
            stringArray30[3] = new String[]{"5", "50", "five"};
            stringArray30[4] = new String[]{"6", "60", "six"};
            stringArray21 = stringArray30;
            stringArray30[5] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[6][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", pad), UpdateLocksTest.pad2("index pad 2", idxPad)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[3] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArrayArray[4] = new String[]{"6", "60", UpdateLocksTest.pad2("six", pad), UpdateLocksTest.pad2("index pad 6", idxPad)};
            stringArray21 = stringArrayArray;
            stringArrayArray[5] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray21);
        c.commit();
        s.execute("call wait_for_post_commit()");
        s.executeUpdate("delete from a where a = 2 or a = 4 or a = 6");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[7][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                    stringArray20 = stringArrayArray;
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[7][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                    stringArray20 = stringArrayArray;
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray31 = new String[4][];
            stringArray31[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray31[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray31[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray20 = stringArray31;
            stringArray31[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray20);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        JDBC.assertUnorderedResultSet(s.executeQuery("select a from a"), new String[][]{{"1"}, {"3"}, {"5"}, {"7"}});
        ResultSet resultSet4 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray32 = new String[4][];
            stringArray32[0] = new String[]{"1", "10", "one"};
            stringArray32[1] = new String[]{"3", "30", "three"};
            stringArray32[2] = new String[]{"5", "50", "five"};
            stringArray19 = stringArray32;
            stringArray32[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray19 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet4, stringArray19);
        c.commit();
        s.executeUpdate("delete from a where (a = 2 or a = 4 or a = 6) and (b < 8)");
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet5 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray33 = new String[4][];
            stringArray33[0] = new String[]{"1", "10", "one"};
            stringArray33[1] = new String[]{"3", "30", "three"};
            stringArray33[2] = new String[]{"5", "50", "five"};
            stringArray18 = stringArray33;
            stringArray33[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray18 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet5, stringArray18);
        c.commit();
        s.executeUpdate("update a  set b = 300 where a = 3");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray17 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArray17 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray34 = new String[2][];
            stringArray34[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArray34;
            stringArray34[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray17);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet6 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray35 = new String[4][];
            stringArray35[0] = new String[]{"1", "10", "one"};
            stringArray35[1] = new String[]{"3", "300", "three"};
            stringArray35[2] = new String[]{"5", "50", "five"};
            stringArray16 = stringArray35;
            stringArray35[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "300", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray16 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet6, stringArray16);
        c.commit();
        s.executeUpdate("update a  set b = 30 where a = 3 and b = 300");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray15 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArray15 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray36 = new String[2][];
            stringArray36[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArray36;
            stringArray36[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray15);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet7 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray37 = new String[4][];
            stringArray37[0] = new String[]{"1", "10", "one"};
            stringArray37[1] = new String[]{"3", "30", "three"};
            stringArray37[2] = new String[]{"5", "50", "five"};
            stringArray14 = stringArray37;
            stringArray37[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray14 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet7, stringArray14);
        c.commit();
        s.executeUpdate("update a  set b = -b where a >= 3 and a < 6");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
                    stringArray13 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                    stringArray13 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray38 = new String[4][];
            stringArray38[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray38[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray38[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
            stringArray13 = stringArray38;
            stringArray38[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray13);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet8 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray39 = new String[4][];
            stringArray39[0] = new String[]{"1", "10", "one"};
            stringArray39[1] = new String[]{"3", "-30", "three"};
            stringArray39[2] = new String[]{"5", "-50", "five"};
            stringArray12 = stringArray39;
            stringArray39[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet8, stringArray12);
        c.commit();
        s.executeUpdate("delete from a  where a = 2");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray11 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray11 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray40 = new String[2][];
            stringArray40[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray40;
            stringArray40[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray11);
        c.commit();
        s.execute("call wait_for_post_commit()");
        s.executeUpdate("update a  set b = -b where a = 2");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray10 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray10 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray41 = new String[2][];
            stringArray41[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArray41;
            stringArray41[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray10);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        ResultSet resultSet9 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray42 = new String[4][];
            stringArray42[0] = new String[]{"1", "10", "one"};
            stringArray42[1] = new String[]{"3", "-30", "three"};
            stringArray42[2] = new String[]{"5", "-50", "five"};
            stringArray9 = stringArray42;
            stringArray42[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray9 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet9, stringArray9);
        c.commit();
        s.executeUpdate("delete from a  where a > 0 and b < -1000");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[1][];
                    stringArray8 = stringArrayArray;
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                    stringArray8 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[1][];
                stringArray8 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray43 = new String[1][];
            stringArray8 = stringArray43;
            stringArray43[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[8][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray8);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        ResultSet resultSet10 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray44 = new String[4][];
            stringArray44[0] = new String[]{"1", "10", "one"};
            stringArray44[1] = new String[]{"3", "-30", "three"};
            stringArray44[2] = new String[]{"5", "-50", "five"};
            stringArray7 = stringArray44;
            stringArray44[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", pad), UpdateLocksTest.pad2("index pad 1", idxPad)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", pad), UpdateLocksTest.pad2("index pad 7", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet10, stringArray7);
        c.commit();
        s.executeUpdate("delete from a  where a = 1 or a = 7");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
                    stringArray6 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                    stringArray6 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray45 = new String[3][];
            stringArray45[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray45[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            stringArray6 = stringArray45;
            stringArray45[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray6);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet11 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray46 = new String[2][];
            stringArray46[0] = new String[]{"3", "-30", "three"};
            stringArray5 = stringArray46;
            stringArray46[1] = new String[]{"5", "-50", "five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet11, stringArray5);
        c.commit();
        s.executeUpdate("update a  set b = 30 where a > 2 and a < 5");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 0) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray4 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArray4 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray47 = new String[3][];
            stringArray47[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray47[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray4 = stringArray47;
            stringArray47[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray4);
        c.commit();
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet12 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray48 = new String[2][];
            stringArray48[0] = new String[]{"3", "30", "three"};
            stringArray3 = stringArray48;
            stringArray48[1] = new String[]{"5", "-50", "five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "30", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", pad), UpdateLocksTest.pad2("index pad 5", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet12, stringArray3);
        c.commit();
        s.executeUpdate("update a  set b = 3030 where a > 2 and a < 5");
        s.executeUpdate("delete from a where a = 5");
        ltrs = this.getLocks();
        if (isolation == 8) {
            if (mode == 1) {
                if (unPadded) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (unPadded) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (unPadded) {
            String[][] stringArray49 = new String[4][];
            stringArray49[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray49[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray49[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            stringArray2 = stringArray49;
            stringArray49[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(ltrs, stringArray2);
        c.commit();
        s.execute("call wait_for_post_commit()");
        ltrs = this.getLocks();
        JDBC.assertEmpty(ltrs);
        c.commit();
        ResultSet resultSet13 = s.executeQuery("select * from a");
        if (unPadded) {
            String[][] stringArray50 = new String[1][];
            stringArray = stringArray50;
            stringArray50[0] = new String[]{"3", "3030", "three"};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"3", "3030", UpdateLocksTest.pad2("three", pad), UpdateLocksTest.pad2("index pad 3", idxPad)};
        }
        JDBC.assertUnorderedResultSet(resultSet13, stringArray);
        c.commit();
        s.executeUpdate("drop table a");
        ltrs.close();
        s.close();
    }

    private void verifyRsMetaData(ResultSet s) throws SQLException {
        ResultSetMetaData rsmd = s.getMetaData();
        UpdateLocksTest.assertEquals((int)rsmd.getColumnCount(), (int)9);
        String[] colNames = new String[]{"USERNAME", "TRANTYPE", "TYPE", "CNT", "MODE", "TABNAME", "LOCKNAME", "STATE", "STATUS"};
        for (int i = 0; i < colNames.length; ++i) {
            UpdateLocksTest.assertTrue((boolean)colNames[i].equals(rsmd.getColumnName(i + 1)));
        }
    }

    private void assertRow(ResultSet rs, String[] expected) throws SQLException {
        UpdateLocksTest.assertEquals((int)rs.getMetaData().getColumnCount(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            UpdateLocksTest.assertEquals((String)expected[i], (String)rs.getString(i + 1));
        }
    }

    private static String pad2(String s, int i) {
        if (i == 0) {
            return s;
        }
        char[] buff = new char[i];
        s.getChars(0, s.length(), buff, 0);
        Arrays.fill(buff, s.length(), i, ' ');
        buff[i - 1] = '\u0000';
        return new String(buff);
    }

    private ResultSet getLocks() throws SQLException {
        return this.getLocksQuery.executeQuery();
    }
}

