/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OSReadOnlyTest
extends BaseJDBCTestCase {
    public OSReadOnlyTest(String name) {
        super(name);
    }

    private static Test newCleanDatabase(TestSuite s) {
        return new CleanDatabaseTestSetup((Test)s){

            protected void decorateSQL(Statement stmt) throws SQLException {
                this.getConnection();
                stmt.executeUpdate("CREATE TABLE foo (a int, b char(100))");
                stmt.execute("insert into foo values (1, 'hello world')");
                stmt.execute("insert into foo values (2, 'happy world')");
                stmt.execute("insert into foo values (3, 'sad world')");
                stmt.execute("insert into foo values (4, 'crazy world')");
                for (int i = 0; i < 7; ++i) {
                    stmt.execute("insert into foo select * from foo");
                }
                stmt.execute("create index fooi on foo(a, b)");
            }
        };
    }

    protected static Test baseSuite(String name) {
        TestSuite readonly = new TestSuite("OSReadOnly");
        TestSuite suite = new TestSuite(name);
        readonly.addTestSuite(OSReadOnlyTest.class);
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(OSReadOnlyTest.newCleanDatabase(readonly)));
        return suite;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OSReadOnlyTest");
        suite.addTest(OSReadOnlyTest.baseSuite("OSReadOnlyTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(OSReadOnlyTest.baseSuite("OSReadOnlyTest:client")));
        return suite;
    }

    public void testOSReadOnly() throws Exception {
        this.setAutoCommit(false);
        Statement stmt = this.createStatement();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        stmt.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        stmt.executeUpdate("insert into foo select * from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.commit();
        stmt.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.setAutoCommit(false);
        TestConfiguration.getCurrent().shutdownDatabase();
        String phDbName = this.getPhysicalDbName();
        this.moveDatabaseOnOS(phDbName, "readOnly");
        this.changeFilePermissions("readOnly");
        this.createDummyLockFile("readOnly");
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readOnly");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, false, 10, "will fail");
        this.shutdownDB(ds);
        this.moveDatabaseOnOS("readOnly", "readWrite");
        ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readWrite");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, true, 20, "will go in");
        this.shutdownDB(ds);
        this.moveDatabaseOnOS("readWrite", "readOnly2");
        this.changeFilePermissions("readOnly2");
        this.createDummyLockFile("readOnly2");
        ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readOnly2");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, false, 30, "will also fail");
        this.shutdownDB(ds);
        this.moveDatabaseOnOS("readOnly2", phDbName);
    }

    private String getPhysicalDbName() {
        String pdbName = TestConfiguration.getCurrent().getJDBCUrl();
        pdbName = pdbName != null ? pdbName.substring(pdbName.lastIndexOf("oneuse"), pdbName.length()) : (String)AccessController.doPrivileged(new PrivilegedAction(){
            String filesep = OSReadOnlyTest.access$000("file.separator");

            public Object run() {
                File dbdir = new File("system" + this.filesep + "singleUse");
                String[] list = dbdir.list();
                if (list != null) {
                    if (list.length > 1) {
                        for (int i = 0; i < list.length; ++i) {
                            if (list[i].indexOf("oneuse") < 0) continue;
                            return list[i];
                        }
                        return "oneuse0";
                    }
                    return list[0];
                }
                return null;
            }
        });
        return pdbName;
    }

    private void shutdownDB(DataSource ds) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        try {
            ds.getConnection();
            OSReadOnlyTest.fail((String)"expected an sqlexception 08006");
        }
        catch (SQLException sqle) {
            OSReadOnlyTest.assertSQLState("08006", sqle);
        }
    }

    private void assertReadDB(DataSource ds) throws SQLException {
        Connection con = ds.getConnection();
        Statement stmt2 = con.createStatement();
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=1"), new String[][]{{"256"}});
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=2"), new String[][]{{"128"}});
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=1 and b='hello world'"), new String[][]{{"256"}});
        stmt2.close();
        con.close();
    }

    private void assertExpectedInsertBehaviour(DataSource ds, boolean expectedSuccess, int insertIntValue, String insertStringValue) throws SQLException {
        Statement stmt;
        Connection con;
        block4: {
            con = ds.getConnection();
            stmt = con.createStatement();
            if (expectedSuccess) {
                stmt.executeUpdate("insert into foo values (" + insertIntValue + ", '" + insertStringValue + "')");
                OSReadOnlyTest.assertTrue((stmt.getUpdateCount() == 1 ? 1 : 0) != 0);
                JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo where a=" + insertIntValue), new String[][]{{"1"}});
            } else {
                try {
                    stmt.executeUpdate("insert into foo values (" + insertIntValue + ", '" + insertStringValue + "')");
                    OSReadOnlyTest.fail((String)"expected an error indicating the db is readonly");
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("25502") || sqle.getSQLState().equals("40XD1")) break block4;
                    OSReadOnlyTest.fail((String)("unexpected sqlstate; expected 25502 or 40XD1, got: " + sqle.getSQLState()));
                }
            }
        }
        stmt.close();
        con.close();
    }

    private void moveDatabaseOnOS(String fromwhere, String todir) throws IOException {
        File from_dir = this.constructDbPath(fromwhere);
        File to_dir = this.constructDbPath(todir);
        PrivilegedFileOpsForTests.copy(from_dir, to_dir);
        OSReadOnlyTest.assertDirectoryDeleted(from_dir);
    }

    private void createDummyLockFile(String dbDir) {
        final File f = new File(this.constructDbPath(dbDir), "db.lck");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!f.exists()) {
                    try {
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(12);
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                f.setReadOnly();
                return null;
            }
        });
    }

    public void changeFilePermissions(String dir) {
        File dir_to_change = this.constructDbPath(dir);
        OSReadOnlyTest.assertTrue((String)("Failed to change files in " + dir_to_change + " to ReadOnly"), (boolean)OSReadOnlyTest.changeDirectoryToReadOnly(dir_to_change));
    }

    private File constructDbPath(String relDbDirName) {
        File f = new File(OSReadOnlyTest.getSystemProperty("user.dir"), "system");
        f = new File(f, "singleUse");
        return new File(f, relDbDirName);
    }

    public static boolean changeDirectoryToReadOnly(File directory) {
        if (null == directory) {
            return false;
        }
        final File sdirectory = directory;
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] list;
                boolean success = true;
                if (!sdirectory.isDirectory()) {
                    success = false;
                }
                if ((list = sdirectory.list()) != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(sdirectory, list[i]);
                        if (entry.isDirectory()) {
                            if (OSReadOnlyTest.changeDirectoryToReadOnly(entry)) continue;
                            success = false;
                            continue;
                        }
                        if (entry.setReadOnly()) continue;
                        success = false;
                    }
                }
                return new Boolean(success);
            }
        });
        return b != false;
    }

    static /* synthetic */ String access$000(String x0) {
        return OSReadOnlyTest.getSystemProperty(x0);
    }
}

