/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InterruptResilienceTest
extends BaseJDBCTestCase {
    private static volatile TestConfiguration thisConf;
    static int NO_OF_THREADS;
    static long NO_OF_MT_OPS;
    private static int threadNo;
    static volatile boolean allDone;

    public InterruptResilienceTest(String name) {
        super(name);
    }

    protected static Test makeSuite(String name) {
        TestSuite suite = new TestSuite(name);
        Test est = TestConfiguration.embeddedSuite(InterruptResilienceTest.class);
        Test cst = TestConfiguration.clientServerSuite(InterruptResilienceTest.class);
        est = TestConfiguration.singleUseDatabaseDecorator(est);
        cst = TestConfiguration.singleUseDatabaseDecorator(cst);
        Properties p = new Properties();
        p.put("derby.system.durability", "test");
        p.put("derby.infolog.append", "true");
        p.put("derby.stream.error.extendedDiagSeverityLevel", "50000");
        suite.addTest((Test)new SystemPropertyTestSetup(est, p, true));
        suite.addTest((Test)new SystemPropertyTestSetup(cst, p, true));
        return suite;
    }

    public static Test suite() {
        String testName = "InterruptResilienceTest";
        if (InterruptResilienceTest.isIBMJVM() && InterruptResilienceTest.getSystemProperty("java.version").startsWith("1.4.2")) {
            InterruptResilienceTest.println("InterruptResilienceTest skipped for this VM, cf. DERBY-5074/5109");
            return new TestSuite(testName);
        }
        if (!JDBC.vmSupportsJDBC3()) {
            InterruptResilienceTest.println("Test skipped for this VM, DriverManager is not supported with JSR169");
            return new TestSuite(testName);
        }
        if (InterruptResilienceTest.hasInterruptibleIO()) {
            InterruptResilienceTest.println("Test skipped due to interruptible IO.");
            InterruptResilienceTest.println("This is default on Solaris/Sun Java <= 1.6, use -XX:-UseVMInterruptibleIO if available.");
            return new TestSuite(testName);
        }
        return InterruptResilienceTest.makeSuite(testName);
    }

    protected void setUp() throws Exception {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        super.setUp();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t1(x int primary key)");
        stmt.executeUpdate("create table mtTab(i bigint, inserter varchar(40), primary key(i, inserter))");
        stmt.close();
        thisConf = TestConfiguration.getCurrent();
        threadNo = 0;
        allDone = false;
    }

    protected void tearDown() throws Exception {
        this.rollback();
        this.dropTable("t1");
        this.dropTable("mtTab");
        this.commit();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tstRAFwriteInterrupted() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        c.setAutoCommit(false);
        PreparedStatement insert = null;
        long seen = 0L;
        long lost = 0L;
        try {
            insert = c.prepareStatement("insert into t1 values (?)");
            for (int i = 0; i < 100000; ++i) {
                if (i % 1000 == 0) {
                    c.commit();
                }
                Thread.currentThread().interrupt();
                insert.setLong(1, i);
                insert.executeUpdate();
                InterruptResilienceTest.assertTrue((String)"interrupt flag lost", (boolean)Thread.interrupted());
            }
        }
        finally {
            Thread.interrupted();
            if (insert != null) {
                try {
                    insert.close();
                }
                catch (SQLException e) {}
            }
            c.close();
        }
    }

    public void testRAFWriteInterrupted() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create procedure tstRAFWriteInterrupted () modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstRAFwriteInterrupted' language java parameter style java");
        s.executeUpdate("call tstRAFWriteInterrupted()");
    }

    public static void tstRAFReadWriteMultipleThreads() throws Exception {
        WorkerThread w;
        int i;
        WorkerThread w2;
        int i2;
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        ArrayList<WorkerThread> workers = new ArrayList<WorkerThread>();
        ArrayList<InterruptorThread> interruptors = new ArrayList<InterruptorThread>();
        for (i2 = 0; i2 < NO_OF_THREADS; ++i2) {
            w2 = new WorkerThread(thisConf.openDefaultConnection(), false, NO_OF_MT_OPS);
            workers.add(w2);
            w2.start();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            InterruptorThread it = new InterruptorThread(w2, 500);
            interruptors.add(it);
            it.start();
        }
        for (i2 = 0; i2 < workers.size(); ++i2) {
            w2 = (WorkerThread)workers.get(i2);
            w2.join();
            if (w2.e == null) continue;
            InterruptResilienceTest.fail("WorkerThread " + i2, w2.e);
        }
        allDone = true;
        for (i2 = 0; i2 < interruptors.size(); ++i2) {
            ((Thread)interruptors.get(i2)).join();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select count(*) from mtTab");
        JDBC.assertSingleValueResultSet(rs, Long.toString((long)NO_OF_THREADS * NO_OF_MT_OPS));
        allDone = false;
        threadNo = 0;
        workers.clear();
        interruptors.clear();
        for (i = 0; i < NO_OF_THREADS; ++i) {
            w = new WorkerThread(thisConf.openDefaultConnection(), true, NO_OF_MT_OPS);
            workers.add(w);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            InterruptorThread it = new InterruptorThread(w, 500);
            interruptors.add(it);
            it.start();
        }
        for (i = 0; i < workers.size(); ++i) {
            ((Thread)workers.get(i)).start();
        }
        for (i = 0; i < workers.size(); ++i) {
            w = (WorkerThread)workers.get(i);
            w.join();
            if (w.e == null) continue;
            InterruptResilienceTest.fail("WorkerThread " + i, w.e);
        }
        allDone = true;
        for (i = 0; i < interruptors.size(); ++i) {
            ((Thread)interruptors.get(i)).join();
        }
        c.close();
    }

    static synchronized int getThreadNo() {
        return ++threadNo;
    }

    private static long randAbs(long l) {
        if (l == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return Math.abs(l);
    }

    public void testRAFReadWriteMultipleThreads() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create procedure tstRAFReadWriteMultipleThreads () modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstRAFReadWriteMultipleThreads' language java parameter style java");
        s.executeUpdate("call tstRAFReadWriteMultipleThreads()");
    }

    public static void tstInterruptLongQuery() throws Exception {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        try {
            Thread.currentThread().interrupt();
            ResultSet rs = s.executeQuery("select * from sys.syscolumns");
            while (rs.next()) {
            }
            InterruptResilienceTest.fail((String)"expected CONN_INTERRUPT");
        }
        catch (SQLException e) {
            InterruptResilienceTest.assertSQLState("expected CONN_INTERRUPT", "08000", e);
            InterruptResilienceTest.assertTrue((boolean)Thread.interrupted());
        }
    }

    public void testLongQueryInterrupt() throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("create procedure tstInterruptLongQuery() reads sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstInterruptLongQuery' language java parameter style java");
        try {
            s.executeUpdate("call tstInterruptLongQuery()");
            InterruptResilienceTest.fail((String)"expected 40XC0 exception");
        }
        catch (SQLException e) {
            InterruptResilienceTest.assertSQLState("expected 40XC0", "40XC0", e);
            InterruptResilienceTest.assertTrue((boolean)c.isClosed());
        }
    }

    public static void tstInterruptBatch() throws Exception {
        int i;
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        s.executeUpdate("create table tmp(i int)");
        PreparedStatement ps = c.prepareStatement("insert into tmp values (?)");
        for (i = 0; i < 10; ++i) {
            s.addBatch("insert into tmp values (" + i + ")");
        }
        s.executeBatch();
        for (i = 0; i < 10; ++i) {
            s.addBatch("insert into tmp values (" + i + ")");
        }
        try {
            Thread.currentThread().interrupt();
            s.executeBatch();
            InterruptResilienceTest.fail((String)"expected CONN_INTERRUPT");
        }
        catch (SQLException e) {
            InterruptResilienceTest.assertSQLState("expected CONN_INTERRUPT", "08000", e);
            InterruptResilienceTest.assertTrue((boolean)Thread.interrupted());
        }
    }

    public void testInterruptBatch() throws SQLException {
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        this.setAutoCommit(false);
        s.executeUpdate("create procedure tstInterruptBatch() modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.store.InterruptResilienceTest.tstInterruptBatch' language java parameter style java");
        try {
            s.executeUpdate("call tstInterruptBatch()");
            InterruptResilienceTest.fail((String)"expected 40XC0 exception");
        }
        catch (SQLException e) {
            InterruptResilienceTest.assertSQLState("expected 40XC0", "40XC0", e);
            InterruptResilienceTest.assertTrue((boolean)c.isClosed());
        }
        this.setAutoCommit(false);
        s = this.createStatement();
        s.executeUpdate("create table tmp(i int)");
        this.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptShutdown() throws SQLException {
        if (!InterruptResilienceTest.usingEmbedded()) {
            return;
        }
        this.setAutoCommit(false);
        try {
            Statement s = this.createStatement();
            s.executeUpdate("create table foo (i int)");
            PreparedStatement ps = this.prepareStatement("insert into foo values ?");
            for (int i = 0; i < 1000; ++i) {
                ps.setInt(1, i);
                ps.executeUpdate();
            }
            Thread.currentThread().interrupt();
            TestConfiguration.getCurrent().shutdownDatabase();
            InterruptResilienceTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDropInterrupted() throws SQLException {
        if (!InterruptResilienceTest.usingEmbedded()) {
            return;
        }
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        try {
            Thread.currentThread().interrupt();
            s.executeUpdate("create table foo (i int)");
            s.executeUpdate("insert into foo values 1");
            s.executeUpdate("drop table foo");
            InterruptResilienceTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    static {
        NO_OF_THREADS = 3;
        NO_OF_MT_OPS = 10000L;
    }

    static class WorkerThread
    extends Thread {
        private final boolean readertest;
        private final long noOps;
        public Throwable e;
        private Connection c;

        public WorkerThread(Connection c, boolean readertest, long noOps) {
            this.readertest = readertest;
            this.noOps = noOps;
            this.c = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int threadNo = InterruptResilienceTest.getThreadNo();
            int interruptsSeen = 0;
            this.setName("WorkerThread. Thread#" + threadNo);
            BaseTestCase.println("Running " + this.getName());
            try {
                this.c.setAutoCommit(false);
                String pStmtText = this.readertest ? "select * from mtTab where i=?" : "insert into mtTab values (?,?)";
                PreparedStatement s = this.c.prepareStatement(pStmtText);
                Random rnd = new Random();
                int retries = 0;
                for (long ops = 0L; ops < this.noOps + (long)retries; ++ops) {
                    if (this.readertest) {
                        long candidate = InterruptResilienceTest.randAbs(rnd.nextLong()) % this.noOps;
                        s.setLong(1, candidate);
                        try {
                            ResultSet rs = s.executeQuery();
                            rs.next();
                            if (WorkerThread.interrupted()) {
                                ++interruptsSeen;
                            }
                            Assert.assertEquals((String)"wrong row content", (long)candidate, (long)rs.getLong(1));
                            rs.close();
                        }
                        catch (SQLException e) {
                            if ("08000".equals(e.getSQLState())) {
                                this.c = thisConf.openDefaultConnection();
                                s = this.c.prepareStatement(pStmtText);
                                Assert.assertTrue((boolean)WorkerThread.interrupted());
                                ++interruptsSeen;
                                ++retries;
                                continue;
                            }
                            BaseTestCase.fail("expected 08000", e);
                        }
                        this.c.commit();
                        if (!WorkerThread.interrupted()) continue;
                        ++interruptsSeen;
                        continue;
                    }
                    s.setLong(1, ops);
                    s.setString(2, this.getName());
                    try {
                        s.executeUpdate();
                    }
                    catch (SQLException e) {
                        if ("08000".equals(e.getSQLState())) {
                            this.c = thisConf.openDefaultConnection();
                            s = this.c.prepareStatement(pStmtText);
                            Assert.assertTrue((boolean)WorkerThread.interrupted());
                            ++interruptsSeen;
                            ++retries;
                            continue;
                        }
                        BaseTestCase.fail("expected 08000", e);
                    }
                    if (WorkerThread.interrupted()) {
                        ++interruptsSeen;
                    }
                    this.c.commit();
                    if (!WorkerThread.interrupted()) continue;
                    ++interruptsSeen;
                }
                s.close();
            }
            catch (Throwable e) {
                this.e = e;
            }
            finally {
                try {
                    this.c.close();
                }
                catch (Exception e) {}
            }
            BaseTestCase.println("Thread " + this.getName() + " saw " + interruptsSeen + " interrupts");
        }
    }

    static class InterruptorThread
    extends Thread {
        private WorkerThread myVictim;
        private int millisBetweenShots;

        public InterruptorThread(WorkerThread v, int m) {
            this.myVictim = v;
            this.millisBetweenShots = m;
        }

        public void run() {
            this.setName("InterruptorThread. Thread #" + InterruptResilienceTest.getThreadNo());
            BaseTestCase.println("Running " + this.getName() + " with victim " + this.myVictim.getName());
            int shots = 0;
            while (!allDone) {
                try {
                    Thread.sleep(this.millisBetweenShots);
                    this.myVictim.interrupt();
                    ++shots;
                }
                catch (Exception exception) {}
            }
            BaseTestCase.println(this.getName() + " shot " + shots + " interrupts at " + this.myVictim.getName());
        }
    }
}

