/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class EncryptDatabaseTest
extends BaseJDBCTestCase {
    private static final String ENCRYPTION_NOCHANGE_ALGORITHM = "XBCXD";
    private static final String ENCRYPTION_NOCHANGE_PROVIDER = "XBCXE";
    private static final String ILLEGAL_BP_LENGTH = "XBCX2";
    private static final String NULL_BOOT_PASSWORD = "XBCX5";
    private static final String WRONG_BOOT_PASSWORD = "XBCXA";
    private static final String WRONG_PASSWORD_CHANGE_FORMAT = "XBCX7";

    public EncryptDatabaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("EncryptDatabase");
        suite.addTest(EncryptDatabaseTest.wrapTest());
        suite.addTest(EncryptDatabaseTest.wrapTest("DESede/CBC/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("DESede/CFB/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("DES/OFB/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("DES/ECB/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("DES/CBC/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("Blowfish/CBC/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("AES/CBC/NoPadding"));
        suite.addTest(EncryptDatabaseTest.wrapTest("AES/OFB/NoPadding"));
        return suite;
    }

    private static Test wrapTest() {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(EncryptDatabaseTest.class), "Thursday");
    }

    private static Test wrapTest(String encryptionMethod) {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(EncryptDatabaseTest.class), encryptionMethod, "Thursday");
    }

    public void testEncryption() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday, Wednesday')");
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot("Thursday");
        EncryptDatabaseTest.assertSuccessfulBoot("Wednesday");
        s = this.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Wednesday, Thursday')");
        s.executeUpdate("create table t1 ( a char(20))");
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        s.executeUpdate("insert into t1 values ('hello world')");
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', null)", NULL_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'wrongkey, ')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday')", WRONG_PASSWORD_CHANGE_FORMAT);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , ')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , short')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursdya , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursdayx , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'xThursday , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'thursday , derbypwd')", WRONG_BOOT_PASSWORD);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', ' Thursday , Saturday')");
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , derbypwd')", WRONG_BOOT_PASSWORD);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Saturday,derbypwd')");
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot(null);
        this.assertFailedBoot("Thursday");
        this.assertFailedBoot("Saturday");
        EncryptDatabaseTest.assertSuccessfulBoot("derbypwd");
        s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', '   derbypwd   ,  bbderbypwdx  ')");
        s.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'bbderbypwdx, derbypwdxx ')");
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot("derbypwd");
        EncryptDatabaseTest.assertSuccessfulBoot("derbypwdxx");
        s = this.createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t1"), "hello world");
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('encryptionAlgorithm', 'DES/blabla/NoPadding')", ENCRYPTION_NOCHANGE_ALGORITHM);
        EncryptDatabaseTest.assertFailedStatement(s, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('encryptionProvider', 'com.pom.aplomb')", ENCRYPTION_NOCHANGE_PROVIDER);
    }

    private void assertFailedBoot(String bootPassword) throws SQLException {
        block2: {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", bootPassword != null ? "bootPassword=" + bootPassword : "");
            try {
                ds.getConnection();
                EncryptDatabaseTest.fail((String)"boot worked: unexpected");
            }
            catch (SQLException e) {
                String[] accepted = new String[]{"XBM06", "XJ040"};
                boolean found = Arrays.asList(accepted).contains(e.getSQLState());
                if (found) break block2;
                throw e;
            }
        }
    }

    private static void assertSuccessfulBoot(String bootPassword) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "bootPassword=" + bootPassword);
        ds.getConnection().close();
    }

    private static void assertFailedStatement(Statement s, String sql, String state) {
        EncryptDatabaseTest.assertStatementError(state, s, sql);
    }
}

