/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5234Test
extends BaseJDBCTestCase {
    private static final long ITERATIONS = 12500L;
    private static final long MAX_KEY_PER_FIRST_EXTENT = 10217L;
    private static final int VARCHAR_LENGTH = 2000;
    private static final String SEED = "0123456789";

    public Derby5234Test(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby5234Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.goodStatement(this.getConnection(), "create table t5234( a bigint, b varchar( 2000 ) )");
    }

    protected void tearDown() throws Exception {
        this.goodStatement(this.getConnection(), "drop table t5234");
        super.tearDown();
    }

    public void test_01_basic() throws Exception {
        this.vetBasic(12500L);
    }

    private void vetBasic(long rowCount) throws Exception {
        Connection conn = this.getConnection();
        boolean oldAutoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        this.insertRows(conn, rowCount);
        this.deleteRows(conn);
        this.compressTable(conn);
        this.insertRows(conn, rowCount);
        conn.setAutoCommit(oldAutoCommit);
    }

    private void insertRows(Connection conn, long iterations) throws Exception {
        PreparedStatement insert = this.chattyPrepare(conn, "insert into t5234( a, b ) values ( ?, ? )");
        String varcharValue = this.makeVarcharValue();
        long percent = 0L;
        for (long i = 0L; i < iterations; ++i) {
            if (i * 10L / iterations > percent) {
                conn.commit();
                ++percent;
            }
            insert.setLong(1, i);
            insert.setString(2, varcharValue);
            insert.executeUpdate();
        }
        conn.commit();
    }

    private String makeVarcharValue() {
        StringBuffer buffer = new StringBuffer();
        int count = 2000 / SEED.length();
        for (int i = 0; i < count; ++i) {
            buffer.append(SEED);
        }
        return buffer.toString();
    }

    private void deleteRows(Connection conn) throws Exception {
        this.goodStatement(conn, "delete from t5234");
        conn.commit();
    }

    private void compressTable(Connection conn) throws Exception {
        this.goodStatement(conn, "call syscs_util.syscs_inplace_compress_table( 'APP', 'T5234', 0, 0, 1 )");
        conn.commit();
    }

    public void test_02_maxOK() throws Exception {
        this.vetBasic(10217L);
    }

    public void test_03_triggeringEdge() throws Exception {
        this.vetBasic(10218L);
    }

    private void goodStatement(Connection conn, String command) throws SQLException {
        PreparedStatement ps = this.chattyPrepare(conn, command);
        ps.execute();
        ps.close();
    }

    private PreparedStatement chattyPrepare(Connection conn, String text) throws SQLException {
        Derby5234Test.println("Preparing statement:\n\t" + text);
        return conn.prepareStatement(text);
    }
}

