/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.IndexStatsUtil;

public class AutomaticIndexStatisticsMultiTest
extends BaseJDBCTestCase {
    private static final String TAB = "MTSEL";
    private static final int _100K = 100000;

    public AutomaticIndexStatisticsMultiTest(String name) {
        super(name);
    }

    public void testMTSelect() throws Exception {
        int i;
        this.prepareTable(true);
        int threadCount = 5;
        long runTime = 10000L;
        MTCompileThread[] compileThreads = new MTCompileThread[threadCount];
        for (int i2 = 0; i2 < threadCount; ++i2) {
            compileThreads[i2] = new MTCompileThread(this.openDefaultConnection(), runTime);
        }
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(compileThreads[i]);
            threads[i].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join(600000L);
        }
        int total = 0;
        int totalError = 0;
        ArrayList errors = new ArrayList();
        for (int i3 = 0; i3 < threadCount; ++i3) {
            MTCompileThread ct = compileThreads[i3];
            int count = ct.getCount();
            int errorCount = ct.getErrorCount();
            total += count;
            totalError += errorCount;
            errors.addAll(ct.getErrors());
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + total + " (of which " + totalError + " errors)");
        if (totalError > 0) {
            StringWriter msg = new StringWriter();
            PrintWriter out = new PrintWriter(msg);
            out.println(totalError + " select/compile errors reported:");
            Iterator ei = errors.iterator();
            while (ei.hasNext()) {
                out.println("------");
                SQLException sqle = (SQLException)ei.next();
                sqle.printStackTrace(out);
            }
            out.close();
            AutomaticIndexStatisticsMultiTest.fail((String)msg.toString());
        }
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    public void testMTSelectWithDDL() throws Exception {
        int i;
        this.prepareTable(true);
        int threadCount = 5;
        long runTime = 10000L;
        MTCompileThread[] compileThreads = new MTCompileThread[threadCount];
        for (int i2 = 0; i2 < threadCount; ++i2) {
            compileThreads[i2] = new MTCompileThread(this.openDefaultConnection(), runTime);
        }
        MTCreateDropThread createThread = new MTCreateDropThread(this.openDefaultConnection(), runTime);
        Thread[] threads = new Thread[threadCount + 1];
        threads[0] = new Thread(createThread);
        threads[0].start();
        for (i = 0; i < threadCount; ++i) {
            threads[i + 1] = new Thread(compileThreads[i]);
            threads[i + 1].start();
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].join(600000L);
        }
        int total = 0;
        int totalError = 0;
        ArrayList errors = new ArrayList();
        for (int i3 = 0; i3 < threadCount; ++i3) {
            MTCompileThread ct = compileThreads[i3];
            int count = ct.getCount();
            int errorCount = ct.getErrorCount();
            total += count;
            totalError += errorCount;
            errors.addAll(ct.getErrors());
        }
        AutomaticIndexStatisticsMultiTest.println("TOTAL = " + total + " (of which " + totalError + " errors) CREATES = " + createThread.getCreates());
        if (totalError > 0 || createThread.failed()) {
            StringWriter msg = new StringWriter();
            PrintWriter out = new PrintWriter(msg);
            out.println("create/drop thread " + (createThread.failed() ? "died" : "survived") + ", " + totalError + " select/compile errors reported:");
            if (createThread.failed()) {
                out.println("create/drop thread error: ");
                createThread.getError().printStackTrace(out);
            }
            out.println("select/compile errors:");
            Iterator ei = errors.iterator();
            while (ei.hasNext()) {
                out.println("------");
                SQLException sqle = (SQLException)ei.next();
                sqle.printStackTrace(out);
            }
            out.close();
            AutomaticIndexStatisticsMultiTest.fail((String)msg.toString());
        }
        this.verifyStatistics();
        this.getTestConfiguration().shutdownDatabase();
    }

    private void verifyStatistics() throws SQLException {
        IndexStatsUtil stats = new IndexStatsUtil(this.getConnection(), 5000L);
        IndexStatsUtil.IdxStats[] myStats = stats.getStatsTable(TAB, 2);
        block4: for (int i = 0; i < myStats.length; ++i) {
            IndexStatsUtil.IdxStats s = myStats[i];
            AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)s.rows);
            switch (s.lcols) {
                case 1: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)10L, (long)s.card);
                    continue block4;
                }
                case 2: {
                    AutomaticIndexStatisticsMultiTest.assertEquals((long)100000L, (long)s.card);
                    continue block4;
                }
                default: {
                    AutomaticIndexStatisticsMultiTest.fail((String)("unexpected number of leading columns: " + s.lcols));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareTable(boolean dropIfExists) throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = this.getConnection().getMetaData().getTables(null, null, TAB, null);
        if (rs.next()) {
            AutomaticIndexStatisticsMultiTest.assertFalse((boolean)rs.next());
            rs.close();
            if (!dropIfExists) {
                AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, reusing");
                return;
            }
            AutomaticIndexStatisticsMultiTest.println("table MTSEL already exists, dropping");
            stmt.executeUpdate("drop table MTSEL");
        } else {
            rs.close();
        }
        stmt.executeUpdate("create table MTSEL (val1 int, val2 int)");
        stmt.executeUpdate("create index mtsel_idx on MTSEL (val1, val2)");
        this.setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into MTSEL values (?,?)");
        int blockCount = 10;
        int blockSize = 10000;
        int i = 0;
        while (true) {
            if (i >= blockCount) {
                this.setAutoCommit(true);
                return;
            }
            ps.setInt(1, i);
            for (int j = 0; j < blockSize; ++j) {
                ps.setInt(2, j);
                ps.addBatch();
            }
            ps.executeBatch();
            this.commit();
            AutomaticIndexStatisticsMultiTest.println("inserted block " + (i + 1) + "/" + blockCount);
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(AutomaticIndexStatisticsMultiTest.class);
    }

    private static class MTCreateDropThread
    implements Runnable {
        private final Connection con;
        private final long runTime;
        private volatile long creates;
        private volatile SQLException error;

        public MTCreateDropThread(Connection con, long runTime) throws SQLException {
            this.con = con;
            this.runTime = runTime;
        }

        public void run() {
            long started = System.currentTimeMillis();
            try {
                ResultSet rs = this.con.getMetaData().getTables(null, null, "TMPTABLE", null);
                boolean lastWasCreate = rs.next();
                rs.close();
                Statement stmt = this.con.createStatement();
                while (System.currentTimeMillis() - started < this.runTime) {
                    if (lastWasCreate) {
                        stmt.executeUpdate("drop table TMPTABLE");
                    } else {
                        stmt.executeUpdate("create table TMPTABLE(i int primary key, v varchar(30), b blob)");
                        ++this.creates;
                    }
                    lastWasCreate = !lastWasCreate;
                }
            }
            catch (SQLException sqle) {
                this.error = sqle;
                BaseTestCase.println("create/drop thread failed: " + sqle.getMessage());
            }
        }

        public long getCreates() {
            return this.creates;
        }

        public boolean failed() {
            return this.error != null;
        }

        public SQLException getError() {
            return this.error;
        }
    }

    private static class MTCompileThread
    implements Runnable {
        private final Random rand = new Random();
        private final Connection con;
        private final long runTime;
        private final ArrayList errors = new ArrayList();
        private volatile int count;

        public MTCompileThread(Connection con, long runTime) throws SQLException {
            this.con = con;
            this.runTime = runTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long started = System.currentTimeMillis();
            int counter = 0;
            while (System.currentTimeMillis() - started < this.runTime) {
                try {
                    this.con.prepareStatement("select * from mtsel where " + ++counter + " = " + counter + " AND val2 = " + (1 + this.rand.nextInt(10)));
                }
                catch (SQLException sqle) {
                    MTCompileThread mTCompileThread = this;
                    synchronized (mTCompileThread) {
                        this.errors.add(sqle);
                    }
                }
                ++this.count;
            }
        }

        public int getCount() {
            return this.count;
        }

        public synchronized int getErrorCount() {
            return this.errors.size();
        }

        public synchronized List getErrors() {
            return (List)this.errors.clone();
        }
    }
}

