/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class AccessTest
extends BaseJDBCTestCase {
    private static final String[] MODIFIED_DB_PROPS = new String[]{"derby.storage.pageSize", "derby.storage.minimumRecordSize", "derby.storage.pageReservedSpace"};

    public AccessTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties sysProps = new Properties();
        sysProps.put("derby.optimizer.optimizeJoinOrder", "false");
        sysProps.put("derby.optimizer.ruleBasedOptimization", "true");
        sysProps.put("derby.optimizer.noTimeout", "true");
        Test suite = TestConfiguration.embeddedSuite(AccessTest.class);
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(suite, sysProps, true)){

            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = s.getConnection();
                conn.setAutoCommit(false);
                s.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
        };
    }

    protected void tearDown() throws Exception {
        this.rollback();
        Statement s = this.createStatement();
        try {
            s.executeUpdate("DROP TABLE FOO");
        }
        catch (SQLException se) {
            AccessTest.assertSQLState("42Y55", se);
        }
        PreparedStatement clearProp = this.prepareStatement("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        for (int i = 0; i < MODIFIED_DB_PROPS.length; ++i) {
            clearProp.setString(1, MODIFIED_DB_PROPS[i]);
            clearProp.executeUpdate();
        }
        this.commit();
        super.tearDown();
    }

    public void testQualifierSkipLOLB() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '32768')");
        cSt.execute();
        st.executeUpdate("create table a ( i1 int, col00 varchar(384), col01 varchar(390), i2 int )");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("insert into a values (1, PADSTRING('10',384), PADSTRING('100',390), 1000)");
        st.executeUpdate("insert into a values (2, PADSTRING('20',384), PADSTRING('200',390), 2000)");
        st.executeUpdate("insert into a values (3, PADSTRING('30',384), PADSTRING('300',390), 3000)");
        rs = st.executeQuery("select i1, i2 from a where i2 = 3000");
        String[] expColNames = new String[]{"I1", "I2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"3", "3000"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table a");
        this.commit();
    }

    public void testCSBug2590() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table foo (a int, b varchar(900), c int)");
        st.executeUpdate("insert into foo values (1, PADSTRING('1',900), 1)");
        st.executeUpdate("insert into foo values (2, PADSTRING('2',900), 1)");
        st.executeUpdate("insert into foo values (3, PADSTRING('3',900), 1)");
        st.executeUpdate("insert into foo values (4, PADSTRING('4',900), 1)");
        st.executeUpdate("insert into foo values (5, PADSTRING('5',900), 1)");
        st.executeUpdate("insert into foo values (6, PADSTRING('6',900), 1)");
        st.executeUpdate("insert into foo values (7, PADSTRING('7',900), 1)");
        st.executeUpdate("insert into foo values (8, PADSTRING('8',900), 1)");
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        cSt.execute();
        st.executeUpdate("create index foox on foo (a, b)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        this.commit();
        AccessTest.assertUpdateCount(st, 7, "delete from foo where foo.a <> 2");
        ResultSet rs = null;
        rs = st.executeQuery("select a, b, c from foo for update of c");
        Object[][] expRS = new String[][]{{"2", "2", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        PreparedStatement ps_scan_cursor = this.prepareStatement("select a, b, c from foo for update of c");
        ResultSet scan_cursor = ps_scan_cursor.executeQuery();
        expRS = new String[][]{{"2", "2", "1"}};
        JDBC.assertFullResultSet(scan_cursor, expRS, true);
        st.executeUpdate("insert into foo values (1, PADSTRING('11',900), 1)");
        st.executeUpdate("insert into foo values (1, PADSTRING('12',900), 1)");
        st.executeUpdate("insert into foo values (1, PADSTRING('13',900), 1)");
        st.executeUpdate("insert into foo values (1, PADSTRING('14',900), 1)");
        st.executeUpdate("insert into foo values (1, PADSTRING('15',900), 1)");
        this.commit();
        st.executeUpdate("drop table foo");
        this.commit();
    }

    public void testCSBug735() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        st.executeUpdate("create table foo (a int)");
        st.executeUpdate("insert into foo values (1024)");
        st.executeUpdate("insert into foo (select foo.a - 1   from foo)");
        st.executeUpdate("insert into foo (select foo.a - 2   from foo)");
        st.executeUpdate("insert into foo (select foo.a - 4   from foo)");
        st.executeUpdate("insert into foo (select foo.a - 8   from foo)");
        st.executeUpdate("insert into foo (select foo.a - 16  from foo)");
        st.executeUpdate("insert into foo (select foo.a - 32  from foo)");
        st.executeUpdate("insert into foo (select foo.a - 64  from foo)");
        st.executeUpdate("insert into foo (select foo.a - 128 from foo)");
        st.executeUpdate("insert into foo (select foo.a - 256 from foo)");
        st.executeUpdate("insert into foo (select foo.a - 512 from foo)");
        AccessTest.assertEquals((int)0, (int)st.executeUpdate("create index a on foo (a)"));
        rs = st.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'FOO')");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AccessTest.assertUpdateCount(st, 1024, "delete from foo");
        st.executeUpdate("drop table foo");
    }

    public void test_conglomDirectory() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table a (a int)");
        this.commit();
        st.executeUpdate("alter table a add column c1 int");
        this.rollback();
        rs = st.executeQuery("select * from a");
        String[] expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("drop table a");
        this.commit();
    }

    public void testPartialRowRTStats() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        st.executeUpdate("create table foo (a int, b int, c int, d int, e int)");
        st.executeUpdate("insert into foo values (1, 2, 3, 4, 5)");
        st.executeUpdate("insert into foo values (10, 20, 30, 40, 50)");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.runQueriesNormal(st);
        st.executeUpdate("create index foo_cover on foo (e, d, c, b, a)");
        this.runQueriesWithIndex(st);
        st.executeUpdate("drop index foo_cover");
        st.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','FOO',null)");
        st.executeUpdate("insert into foo values (100, 2, 3, 4, 5)");
        st.executeUpdate("insert into foo values (1000, 2, 3, 4, 5)");
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 100");
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 1000");
        this.runQueriesWithDeletedRows(st);
        st.execute("create index foo_cover on foo (e, d, c, b, a)");
        st.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','FOO',null)");
        st.executeUpdate("insert into foo values (100, 2, 3, 4, 5)");
        st.executeUpdate("insert into foo values (1000, 2, 3, 4, 5)");
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 100");
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 1000");
        this.runQueriesWithIndexDeletedRows(st);
        st.executeUpdate("drop table foo");
    }

    private void assertStatsOK(Statement st, String expectedScan, String expTableInIndexScan, String expIndexInIndexScan, String expBits, String expNumCols, String expDelRowsV, String expPages, String expRowsQ, String expRowsV, String expScanType, String expStartPosition, String expStopPosition, String expQualifier, String expQualifierInfo) throws SQLException {
        ResultSet rs = st.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        rs.next();
        RuntimeStatisticsParser rtsp = new RuntimeStatisticsParser(rs.getString(1));
        rs.close();
        try {
            if (expectedScan.equals("Table")) {
                AccessTest.assertTrue((boolean)rtsp.usedTableScan());
            } else if (expectedScan.equals("Index")) {
                AccessTest.assertTrue((boolean)rtsp.usedIndexScan());
                AccessTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan(expTableInIndexScan, expIndexInIndexScan));
            } else if (expectedScan.equals("Constraint")) {
                AccessTest.assertTrue((boolean)rtsp.usedIndexScan());
                AccessTest.assertTrue((boolean)rtsp.usedConstraintForIndexScan(expTableInIndexScan));
            }
            AccessTest.assertTrue((boolean)rtsp.findString("Bit set of columns fetched=" + expBits, 1));
            AccessTest.assertTrue((boolean)rtsp.findString("Number of columns fetched=" + expNumCols, 1));
            if (expDelRowsV != null) {
                AccessTest.assertTrue((boolean)rtsp.findString("Number of deleted rows visited=" + expDelRowsV, 1));
            }
            if (expPages != null) {
                AccessTest.assertTrue((String)("RuntimeStatisticsParser.findstring(Number of pages visited= " + expPages + ") returned false" + "full runtime statistics = " + rtsp.toString()), (boolean)rtsp.findString("Number of pages visited=" + expPages, 1));
            }
            AccessTest.assertTrue((boolean)rtsp.findString("Number of rows qualified=" + expRowsQ, 1));
            AccessTest.assertTrue((boolean)rtsp.findString("Number of rows visited=" + expRowsV, 1));
            AccessTest.assertTrue((boolean)rtsp.findString("Scan type=" + expScanType, 1));
            AccessTest.assertTrue((rtsp.getStartPosition()[1].indexOf(expStartPosition) > 1 ? 1 : 0) != 0);
            AccessTest.assertTrue((rtsp.getStopPosition()[1].indexOf(expStopPosition) > 1 ? 1 : 0) != 0);
            if (expQualifier.equals("None")) {
                AccessTest.assertTrue((boolean)rtsp.hasNoQualifiers());
            } else if (expQualifier.equals("Equals")) {
                AccessTest.assertTrue((boolean)rtsp.hasEqualsQualifier());
            }
            if (expQualifierInfo != null) {
                AccessTest.assertTrue((boolean)rtsp.findString(expQualifierInfo, 1));
            }
        }
        catch (AssertionFailedError e) {
            AccessTest.fail("Statistics didn't match:\n" + rtsp.toString(), e);
        }
    }

    private void runQueriesNormal(Statement st) throws SQLException {
        this.doQuery1(st);
        this.assertStatsOK(st, "Table", null, null, "All", "5", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery2(st);
        this.assertStatsOK(st, "Table", null, null, "{4}", "1", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery3(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 2, 4}", "3", null, "1", "2", "2", "heap", "null", "null", "None", null);
        this.doQuery4(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 2, 4}", "3", null, "1", "1", "2", "heap", "null", "null", "Equals", "Column[0][0] Id: 4");
        this.doQuery5(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 1, 2, 4}", "4", null, "1", "1", "2", "heap", "null", "null", "Equals", "Column[0][0] Id: 1");
        this.doQuery6(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 1}", "2", null, "1", "2", "2", "heap", "null", "null", "None", null);
    }

    private void runQueriesWithIndex(Statement st) throws SQLException {
        this.doQuery1(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 1, 2, 3, 4}", "5", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery2(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0}", "1", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery3(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "0", "1", "2", "2", "btree", "None", "None", "None", null);
        this.doQuery4(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "0", "1", "1", "2", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        this.doQuery5(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 3, 4}", "4", "0", "1", "1", "2", "btree", "None", "None", "Equals", "Column[0][0] Id: 3");
        this.doQuery6(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{3, 4}", "2", "0", "1", "2", "2", "btree", "None", "None", "None", null);
    }

    private void runQueriesWithDeletedRows(Statement st) throws SQLException {
        this.doQuery1(st);
        this.assertStatsOK(st, "Table", null, null, "All", "5", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery2(st);
        this.assertStatsOK(st, "Table", null, null, "{4}", "1", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery3(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 2, 4}", "3", null, "1", "2", "4", "heap", "null", "null", "None", null);
        this.doQuery4(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 2, 4}", "3", null, "1", "1", "4", "heap", "null", "null", "Equals", "Column[0][0] Id: 4");
        this.doQuery5(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 1, 2, 4}", "4", null, "1", "1", "4", "heap", "null", "null", "Equals", "Column[0][0] Id: 1");
        this.doQuery6(st);
        this.assertStatsOK(st, "Table", null, null, "{0, 1}", "2", null, "1", "2", "4", "heap", "null", "null", "None", null);
    }

    private void runQueriesWithIndexDeletedRows(Statement st) throws SQLException {
        this.doQuery1(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 1, 2, 3, 4}", "5", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery2(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0}", "1", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery3(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "2", "1", "2", "4", "btree", "None", "None", "None", null);
        this.doQuery4(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 4}", "3", "2", "1", "1", "4", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        this.doQuery5(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{0, 2, 3, 4}", "4", "2", "1", "1", "4", "btree", "None", "None", "Equals", "Column[0][0] Id: 3");
        this.doQuery6(st);
        this.assertStatsOK(st, "Index", "FOO", "FOO_COVER", "{3, 4}", "2", "2", "1", "2", "4", "btree", "None", "None", "None", null);
    }

    private void doQuery1(Statement st) throws SQLException {
        this.doQuery(st, "select * from foo", new String[]{"A", "B", "C", "D", "E"}, new String[][]{{"1", "2", "3", "4", "5"}, {"10", "20", "30", "40", "50"}});
    }

    private void doQuery2(Statement st) throws SQLException {
        this.doQuery(st, "select e from foo", new String[]{"E"}, new String[][]{{"5"}, {"50"}});
    }

    private void doQuery3(Statement st) throws SQLException {
        this.doQuery(st, "select e, c, a from foo", new String[]{"E", "C", "A"}, new String[][]{{"5", "3", "1"}, {"50", "30", "10"}});
    }

    private void doQuery4(Statement st) throws SQLException {
        this.doQuery(st, "select e, c, a from foo where foo.e = 5", new String[]{"E", "C", "A"}, new String[][]{{"5", "3", "1"}});
    }

    private void doQuery5(Statement st) throws SQLException {
        this.doQuery(st, "select e, c, a from foo where foo.b = 20", new String[]{"E", "C", "A"}, new String[][]{{"50", "30", "10"}});
    }

    private void doQuery6(Statement st) throws SQLException {
        this.doQuery(st, "select a, b from foo", new String[]{"A", "B"}, new String[][]{{"1", "2"}, {"10", "20"}});
    }

    private void doQuery(Statement st, String query, String[] expColNames, String[][] expRS) throws SQLException {
        ResultSet rs = null;
        rs = st.executeQuery(query);
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertFullResultSet(rs, (Object[][])expRS, true);
    }

    public void testCostingCoveredQuery() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        st.executeUpdate("create table base_table (a int, b varchar(1000))");
        st.executeUpdate("insert into base_table values (1, PADSTRING('1',1000))");
        st.executeUpdate("insert into base_table values (2, PADSTRING('2',1000))");
        st.executeUpdate("insert into base_table values (3,  PADSTRING('3',1000))");
        st.executeUpdate("insert into base_table values (4,  PADSTRING('4',1000))");
        st.executeUpdate("insert into base_table values (5,  PADSTRING('5',1000))");
        st.executeUpdate("insert into base_table values (6,  PADSTRING('6',1000))");
        st.executeUpdate("insert into base_table values (7,  PADSTRING('7',1000))");
        st.executeUpdate("insert into base_table values (8,  PADSTRING('8',1000))");
        st.executeUpdate("insert into base_table values (9,  PADSTRING('9',1000))");
        st.executeUpdate("insert into base_table values (10, PADSTRING('10',1000))");
        st.executeUpdate("create index cover_idx on base_table(a)");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.doQuery(st, "select a from base_table", new String[]{"A"}, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}});
        this.assertStatsOK(st, "Index", "BASE_TABLE", "COVER_IDX", "{0}", "1", "0", "1", "10", "10", "btree", "None", "None", "None", null);
    }

    public void testKeyTooBigError() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table d (id int not null, t_bigvarchar varchar(400), unique (id))");
        st.executeUpdate("create index t_bigvarchar_ind on d ( t_bigvarchar)");
        st.executeUpdate("alter table d alter t_bigvarchar set data type varchar(4096)");
        String bigString = "1111111";
        for (int i = 0; i < 314; ++i) {
            bigString = bigString + "1234567890";
        }
        bigString = bigString + "123456";
        AccessTest.assertStatementError("XSCB6", st, "insert into d (id, t_bigvarchar) values (1, '" + bigString + "')");
    }

    public void testSpaceForUpdate() throws Exception {
        int i;
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '0')");
        cSt.execute();
        st.executeUpdate("create table testing (a varchar(100))");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        cSt.execute();
        st.executeUpdate("insert into testing values ('a')");
        for (i = 0; i < 7; ++i) {
            st.executeUpdate("insert into testing (select testing.a from testing)");
        }
        AccessTest.assertUpdateCount(st, 128, "update testing set a = 'abcd' where a = 'a'");
        st.executeUpdate("create index zz on testing (a)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        cSt.execute();
        st.executeUpdate("create table t1 (a varchar(100))");
        st.executeUpdate("insert into t1 values ('a')");
        for (i = 0; i < 7; ++i) {
            st.executeUpdate("insert into t1 (select t1.a from t1)");
        }
        AccessTest.assertUpdateCount(st, 128, " update t1 set a = 'abcd' where a = 'a'");
        st.executeUpdate("create index zz1 on t1 (a)");
    }

    public void testLoadLongColumnsCreateIndex() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        st.executeUpdate("insert into long1 values ('this is a long row which will get even longer and longer to force a stream', 1, 2)");
        st.executeUpdate("insert into long1 values ('this is another long row which will get even longer and longer to force a stream', 2, 3)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a");
        rs = st.executeQuery("select LENGTH(a) from long1");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long2 (a varchar(16384), b int, c int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        cSt.execute();
        st.executeUpdate("create index long2i1 on long2 (a)");
        st.executeUpdate("create index long2i2 on long2 (a,b)");
        st.executeUpdate("create index long2i3 on long2 (a,b,c)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("insert into long2 select * from long1");
        rs = st.executeQuery("select LENGTH(a) from long2");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select LENGTH(a) from long2 /*derby_properties index=long2i2*/");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5328"}, {"5760"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("insert into long2 select * from long1");
        rs = st.executeQuery("select LENGTH(a) from long2");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5328"}, {"5328"}, {"5760"}, {"5760"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select LENGTH(a) from long2 /*derby_properties index=long2i2*/");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5328"}, {"5328"}, {"5760"}, {"5760"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AccessTest.assertUpdateCount(st, 4, "delete from long2");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create index long2small on long2 (a, c)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        AccessTest.assertStatementError("XSCB6", st, "insert into long2 select * from long1");
        AccessTest.assertStatementError("XSCB6", st, "insert into long2 select * from long1");
        rs = st.executeQuery("select LENGTH(a) from long2");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("drop table long1");
        st.executeUpdate("drop table long2");
    }

    public void testCS1346() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        this.setAutoCommit(false);
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("insert into long1 values ('this is a long row which will get even longer', 1, 2)");
        st.executeUpdate("insert into long1 values ('a second row that will also grow very long', 2, 3)");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a");
        rs = st.executeQuery("select LENGTH(a) as x from long1 order by x");
        String[] expColNames = new String[]{"X"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"3024"}, {"3240"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long2 (a varchar(30000), b int, c int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        cSt.execute();
        st.executeUpdate("create index long2i1 on long2 (a)");
        st.executeUpdate("create index long2i2 on long2 (b, a)");
        st.executeUpdate("create index long2i3 on long2 (b, a, c)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("insert into long2 select * from long1");
        st.executeUpdate("insert into long2 select * from long1");
        rs = st.executeQuery("select LENGTH(a) as x from long2 order by x");
        expColNames = new String[]{"X"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3024"}, {"3024"}, {"3240"}, {"3240"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table long1");
        st.executeUpdate("drop table long2");
    }

    public void testCS1346b() throws Exception {
        int i;
        ResultSet rs = null;
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long1 (a varchar(32000), b int, c int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("insert into long1 values ('this is a long row which will get even longer', 1, 2)");
        st.executeUpdate("insert into long1 values ('a second row that will also grow very long', 2, 3)");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a||a||a||a||a");
        AccessTest.assertUpdateCount(st, 2, "update long1 set a = a||a");
        rs = st.executeQuery("select LENGTH(a) as x from long1 order by x");
        String[] expColNames = new String[]{"X"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"3024"}, {"3240"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '1024')");
        cSt.execute();
        st.executeUpdate("create table long2 (a varchar(32000), b int, c int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '16384')");
        cSt.execute();
        st.executeUpdate("create index long2i1 on long2 (a)");
        st.executeUpdate("create index long2i2 on long2 (b, a)");
        st.executeUpdate("create index long2i3 on long2 (b, a, c)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        for (i = 0; i < 10; ++i) {
            st.executeUpdate("insert into long2 select * from long1");
        }
        rs = st.executeQuery("select LENGTH(a) as x from long2 order by x");
        expColNames = new String[]{"X"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[20][1];
        for (i = 0; i < 10; ++i) {
            expRS[i][0] = "3024";
        }
        for (i = 10; i < 20; ++i) {
            expRS[i][0] = "3240";
        }
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select count(*) from long2");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"20"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table long1");
        st.executeUpdate("drop table long2");
    }

    public void testCS1552() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize','4096')");
        cSt.execute();
        st.executeUpdate("create table a (a int, b varchar(4000), c varchar(4000), d varchar(4000))");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        st.executeUpdate("create index a_idx on a (a)");
        st.executeUpdate("insert into a values (5, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        st.executeUpdate("insert into a values (4, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        st.executeUpdate("insert into a values (3, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        st.executeUpdate("insert into a values (2, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        st.executeUpdate("insert into a values (1, PADSTRING('a',4000), PADSTRING('a',4000), PADSTRING('a',4000))");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        cSt.execute();
        rs = st.executeQuery("select a, d from a");
        String[] expColNames = new String[]{"A", "D"};
        JDBC.assertColumnNames(rs, expColNames);
        String paddeda = Formatters.padString("a", 4000);
        Object[][] expRS = new String[][]{{"5", paddeda}, {"4", paddeda}, {"3", paddeda}, {"2", paddeda}, {"1", paddeda}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.assertStatsOK(st, "Table", null, null, "{0, 3}", "2", null, "6", "5", "5", "heap", "null", "null", "None", null);
        st.execute("drop table a");
        this.commit();
    }

    public void testCS2241() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', NULL)");
        cSt.execute();
        st.executeUpdate("create table b2241 (a int, b varchar(32000))");
        st.executeUpdate("insert into b2241 values (1024, '01234567890123456789012345678901234567890123456789')");
        String inshalf1 = "insert into b2241 (select b2241.a + ";
        String inshalf2 = ", b from b2241)";
        st.executeUpdate(inshalf1 + "1" + inshalf2);
        st.executeUpdate(inshalf1 + "2" + inshalf2);
        st.executeUpdate(inshalf1 + "4" + inshalf2);
        st.executeUpdate(inshalf1 + "8" + inshalf2);
        st.executeUpdate(inshalf1 + "16" + inshalf2);
        st.executeUpdate(inshalf1 + "32" + inshalf2);
        st.executeUpdate(inshalf1 + "64" + inshalf2);
        for (int i = 0; i < 5; ++i) {
            AccessTest.assertUpdateCount(st, 128, "update b2241 set b = b||b");
        }
        rs = st.executeQuery("select LENGTH(b) from b2241 where a = 1025");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1600"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" insert into b2241 (select 1, b||b||b||b||b||b||b||b from b2241 where a = 1024)");
        st.executeUpdate(" insert into b2241 (select 8000, b||b||b||b||b||b||b||b from b2241 where a = 1024)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        cSt.execute();
        AccessTest.assertStatementError("XSCB6", st, "create index a on b2241 (b, a)");
        AccessTest.assertStatementError("XSCB6", st, "create index a on b2241 (b, a)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        AccessTest.assertUpdateCount(st, 1, "delete from b2241 where a = 1");
        AccessTest.assertUpdateCount(st, 1, "delete from b2241 where a = 8000");
        st.executeUpdate("create index a on b2241 (b, a)");
        rs = st.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'B2241')");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table b2241");
    }

    private void reclaimTest(String createIndex, String expectedError) throws SQLException {
        this.setAutoCommit(false);
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.minimumRecordSize', '1')");
        cSt.execute();
        cSt.close();
        this.commit();
        st.executeUpdate("create table foo (a int, b char(200), c int)");
        st.executeUpdate("insert into foo values (1024, 'even', 0)");
        st.executeUpdate("insert into foo (select foo.a - 1, 'odd' , 1 from foo)");
        st.executeUpdate("insert into foo (select foo.a - 2, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 4, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 8, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 16, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 32, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 64, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 128, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 256, foo.b, foo.c from foo)");
        st.executeUpdate("insert into foo (select foo.a - 512, foo.b, foo.c from foo)");
        st.executeUpdate("create table foo2 (a int, b char(200), c int)");
        st.executeUpdate("insert into foo2 (select * from foo)");
        AccessTest.assertUpdateCount(st, 512, "delete from foo2 where foo2.c = 1");
        st.executeUpdate(createIndex);
        AccessTest.assertUpdateCount(st, 512, "delete from foo where foo.c = 0");
        this.commit();
        st.executeUpdate("insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        this.commit();
        if (expectedError != null) {
            AccessTest.assertStatementError("23505", st, "insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        } else {
            AccessTest.assertUpdateCount(st, 512, "insert into foo (select foo2.a, 'even2', foo2.c from foo2)");
        }
        this.commit();
        if (expectedError != null) {
            AccessTest.assertUpdateCount(st, 1024, "delete from foo");
            AccessTest.assertUpdateCount(st, 512, "delete from foo2");
        } else {
            AccessTest.assertUpdateCount(st, 1536, "delete from foo");
            AccessTest.assertUpdateCount(st, 512, "delete from foo2");
        }
        this.commit();
        st.executeUpdate("drop table foo");
        st.executeUpdate("drop table foo2");
        this.commit();
    }

    public void testReclaimDeletedRowsDuringSplit() throws Exception {
        this.reclaimTest("create index a on foo (a, b)", null);
    }

    public void testReclaimDeletedRowsUniqueIndex() throws Exception {
        this.reclaimTest("create unique index a on foo (a, b)", "23505");
    }

    private void setupForReclaim2(Statement st) throws SQLException {
        st.executeUpdate("create table foo (a int, b varchar(1100), c int)");
        st.executeUpdate("create index a on foo (a, b)");
        st.executeUpdate("insert into foo values (1, PADSTRING('a',1100), 1)");
        st.executeUpdate("insert into foo values (2, PADSTRING('a',1100), 1)");
        st.executeUpdate("insert into foo values (3, PADSTRING('a',1100), 1)");
    }

    private void reclaimDeletedRows2(boolean toCommit) throws SQLException {
        Statement st = this.createStatement();
        this.setupForReclaim2(st);
        this.commit();
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 1");
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 2");
        if (toCommit) {
            this.commit();
        }
        st.executeUpdate("insert into foo values (-1, PADSTRING('ab',1100), 1)");
        st.executeUpdate("insert into foo values (-2, PADSTRING('ab',1100), 1)");
        this.rollback();
        st.executeUpdate("drop table foo");
        this.commit();
    }

    public void testUncommittedDeletesNotReclaimed() throws Exception {
        this.reclaimDeletedRows2(false);
    }

    public void testCommittedDeletesReclaim() throws Exception {
        this.reclaimDeletedRows2(true);
    }

    public void testAllUncommittedReclaim() throws Exception {
        Statement st = this.createStatement();
        this.setupForReclaim2(st);
        AccessTest.assertUpdateCount(st, 1, "delete from foo where foo.a = 1");
        st.executeUpdate("insert into foo values (0, PADSTRING('a',1100), 1)");
        st.executeUpdate("insert into foo values (1, PADSTRING('a',1100), 1)");
        this.rollback();
        st.executeUpdate("drop table foo");
    }

    public void testCS2778() throws Exception {
        ResultSet rs = null;
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '2048')");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '10')");
        cSt.execute();
        st.executeUpdate("create table t2778 (col00 char(2), col01 char(1), col02 char(99), col03 char(11), col04 char(7), col05 char(11), col06 char(6), col07 char(6), col08 char(2), col09 char(6), col10 varchar(1000), col11 char(2), col12 char(1), col13 char(7), col14 char(24), col15 char(1), col16 char(166), col17 char(207), col18 char(2))");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        cSt.execute();
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        cSt.execute();
        st.executeUpdate("create unique index a_idx on t2778 (col00)");
        this.commit();
        st.executeUpdate("insert into t2778 values ( '0_', '0', '0_col02', '0_col03', '0_col04', '0_col05', '0_06', '0_07', '0_', '0_09', '0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllll', '0_', '0', '0_col13', '0_col14', '0', '0_col16', '0_col17', '0_' )");
        st.executeUpdate("insert into t2778 values ( '1_', '1', '1_col02', '1_col03', '1_col04', '1_col05', '1_06', '1_07', '1_', '1_09', '1_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxxxxxxxxxxxxxxx', '1_', '1', '1_col13', '1_col14', '1', '1_col16', '1_col17', '1_' )");
        this.commit();
        rs = st.executeQuery(" select col16, col17, col18 from t2778");
        String[] expColNames = new String[]{"COL16", "COL17", "COL18"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"0_col16", "0_col17", "0_"}, {"1_col16", "1_col17", "1_"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.commit();
        AccessTest.assertUpdateCount(st, 1, "update t2778 /*derby-properties index=a_idx*/ set col10 = '0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxx' where col00 = '0_'");
        this.rollback();
        rs = st.executeQuery("select col01, col02, col03, col04, col05,  col06, col07, col08, col09, col10, col11, col12, col13, col14, col15, col16, col17, col18 from t2778");
        expColNames = new String[]{"COL01", "COL02", "COL03", "COL04", "COL05", "COL06", "COL07", "COL08", "COL09", "COL10", "COL11", "COL12", "COL13", "COL14", "COL15", "COL16", "COL17", "COL18"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"0", "0_col02", "0_col03", "0_col04", "0_col05", "0_06", "0_07", "0_", "0_09", "0_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxx", "0_", "0", "0_col13", "0_col14", "0", "0_col16", "0_col17", "0_"}, {"1", "1_col02", "1_col03", "1_col04", "1_col05", "1_06", "1_07", "1_", "1_09", "1_col10llllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllllll012340_col10lllllllllllxxxxxxxxxxxxxxxxxxx", "1_", "1", "1_col13", "1_col14", "1", "1_col16", "1_col17", "1_"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.commit();
        st.executeUpdate("drop table t2778");
        this.commit();
    }

    public void testCS3149() throws Exception {
        String s;
        int i;
        ResultSet rs = null;
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table foo (a int, b varchar(500), c int)");
        String insertPart1 = "insert into foo values (";
        String insertPart2 = ", PADSTRING('";
        String insertPart3 = "',500), 1)";
        for (i = 1; i < 10; ++i) {
            s = String.valueOf(i);
            st.executeUpdate(insertPart1 + s + insertPart2 + s + insertPart3);
        }
        for (i = 11; i < 19; ++i) {
            s = String.valueOf(i);
            st.executeUpdate(insertPart1 + s + insertPart2 + s + insertPart3);
        }
        st.executeUpdate("create index foox on foo (b)");
        this.commit();
        rs = st.executeQuery("select max(b) from foo");
        String[] expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"9"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AccessTest.assertUpdateCount(st, 1, "delete from foo where a = 9");
        rs = st.executeQuery("select max(b) from foo");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"8"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AccessTest.assertUpdateCount(st, 1, "delete from foo where a = 8");
        rs = st.executeQuery("select max(b) from foo");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"7"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        AccessTest.assertUpdateCount(st, 13, "delete from foo where a > 2");
        rs = st.executeQuery("select max(b) from foo");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.commit();
        st.executeUpdate("drop table foo");
        this.commit();
    }

    public void testCS3368_3370() throws Exception {
        Statement st = this.createStatement();
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', '100')");
        cSt.execute();
        st.executeUpdate("create table a (a int)");
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageReservedSpace', NULL)");
        cSt.execute();
        st.executeUpdate("insert into a values (1)");
        this.checkSpaceTable(st, "2");
        st.executeUpdate("insert into a values (2)");
        this.checkSpaceTable(st, "3");
        st.executeUpdate("insert into a values (1)");
        this.checkSpaceTable(st, "4");
        st.executeUpdate("insert into a values (2)");
        this.checkSpaceTable(st, "5");
        st.executeUpdate("drop table a");
    }

    private void checkSpaceTable(Statement st, String expValue) throws SQLException {
        ResultSet rs = null;
        rs = st.executeQuery("select numallocatedpages from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'A')) a");
        Object[][] expRS = new String[][]{{expValue}};
        JDBC.assertFullResultSet(rs, expRS, true);
    }

    private void doTestCaseCS4595A(Statement st, String indexOrConstraint) throws SQLException {
        ResultSet rs = null;
        String indexName = indexOrConstraint.equals("Index") ? "FOOX" : null;
        st.executeUpdate("set ISOLATION to RR");
        AccessTest.assertUpdateCount(st, 0, "delete from foo where a = 1");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0, 1}", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        AccessTest.assertUpdateCount(st, 0, "update foo set b = 1 where a = 2");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "All", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select * from foo where a = 2");
        JDBC.assertEmpty(rs);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "All", "2", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select a from foo where a = 2");
        String[] expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0}", "1", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select a from foo where a = 2");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0}", "1", "0", "1", "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        st.execute("insert into foo values (1, 1)");
        AccessTest.assertUpdateCount(st, 1, "update foo set b = 2 where a = 1");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "All", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        st.execute("delete from foo where a = 1");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0, 1}", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        st.execute("drop table foo");
        this.commit();
    }

    private void doTestCaseCS4595B(Statement st, String indexOrConstraint) throws SQLException {
        ResultSet rs = null;
        String indexName = indexOrConstraint.equals("Index") ? "FOOX" : null;
        this.commit();
        AccessTest.assertUpdateCount(st, 1, "update foo set b = 2 where a = 1");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "All", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        st.execute("delete from foo where a = 1");
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0, 1}", "2", "0", "1", "1", "1", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select * from foo where a = 2");
        JDBC.assertEmpty(rs);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "All", "2", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select a from foo where a = 2");
        String[] expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0}", "1", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        rs = st.executeQuery("select a from foo where a = 2");
        expColNames = new String[]{"A"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        this.assertStatsOK(st, indexOrConstraint, "FOO", indexName, "{0}", "1", "0", null, "0", "0", "btree", ">= on first 1 column(s).", "> on first 1 column(s).", "None", null);
        st.execute("drop table foo");
    }

    public void testCS4595A_UniqueIndex() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int, b int)");
        st.executeUpdate("create unique index foox on foo (a)");
        this.doTestCaseCS4595A(st, "Index");
    }

    public void testCS4595B_UniqueIndex() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int, b int)");
        st.executeUpdate("insert into foo values (1, 1)");
        st.executeUpdate("create unique index foox on foo (a)");
        this.doTestCaseCS4595B(st, "Index");
    }

    public void testCS4595A_PrimaryKey() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int not null primary key, b int)");
        this.doTestCaseCS4595A(st, "Constraint");
    }

    public void testCS4595B_PrimaryKey() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int not null primary key, b int)");
        st.executeUpdate("insert into foo values (1, 1)");
        this.doTestCaseCS4595B(st, "Constraint");
    }

    public void testCaseCS4595A_NonUniqueIndex() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int, b int)");
        st.executeUpdate("create index foox on foo (a)");
        this.doTestCaseCS4595A(st, "Index");
    }

    public void testCaseCS4595B_NonUniqueIndex() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set ISOLATION to RR");
        st.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        st.executeUpdate("create table foo (a int, b int)");
        st.executeUpdate("create index foox on foo (a)");
        st.executeUpdate("insert into foo values (1, 1)");
        this.doTestCaseCS4595B(st, "Index");
    }

    public void testQualifiers() throws Exception {
        this.setAutoCommit(false);
        ResultSet rs = null;
        Statement st = this.createStatement();
        st.executeUpdate("create table foo (a int, b int, c int)");
        st.executeUpdate("insert into foo values (1, 10, 100)");
        st.executeUpdate("insert into foo values (2, 20, 200)");
        st.executeUpdate("insert into foo values (3, 30, 300)");
        rs = st.executeQuery("select a, b, c from foo where a = 1 and b = 20");
        String[] expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select a, b, c from foo where a = 3 and b = 30");
        expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"3", "30", "300"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select a, b, c from foo where a = 3 or c = 40");
        expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3", "30", "300"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select a, b, c from foo where a = 1 or b = 20");
        expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "10", "100"}, {"2", "20", "200"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select a, b, c from foo where a = 1 or a = 3");
        expColNames = new String[]{"A", "B", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "10", "100"}, {"3", "30", "300"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
        st.close();
    }
}

