/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_1Indexing
extends ReplicationRun {
    public ReplicationRun_Local_1Indexing(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ReplicationRun_Local_1Indexing Suite");
        suite.addTestSuite(ReplicationRun_Local_1Indexing.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Local_1_Indexing() throws Exception {
        this.makeReadyForReplication();
        String masterDbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int tuplesToInsert = 10000;
        this.executeOnMaster("create table t(i integer primary key, s varchar(64), ii integer)");
        this.executeOnMaster("create index index1ii on t(ii)");
        this.executeOnMaster("create index index1s on t(s)");
        int tuplesInserted = 0;
        this._fillTableOnServer(masterServerHost, masterServerPort, masterDbPath, tuplesInserted, tuplesToInsert);
        tuplesInserted += tuplesToInsert;
        this.executeOnMaster("drop index index1ii");
        this.executeOnMaster("drop index index1s");
        this.executeOnMaster("create index index2ii on t(ii)");
        this.executeOnMaster("create index index2s on t(s)");
        this._fillTableOnServer(masterServerHost, masterServerPort, masterDbPath, tuplesToInsert, tuplesToInsert);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        String slaveDbPath = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, slaveDbPath, tuplesInserted += tuplesToInsert);
        this._verifyIndexOnSlave("index2ii");
        this._verifyIndexOnSlave("index2s");
        masterDbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, masterDbPath, tuplesInserted);
    }

    void _fillTableOnServer(String serverHost, int serverPort, String dbPath, int startVal, int _noTuplesToInsert) throws SQLException {
        ClientDataSource ds = new ClientDataSource();
        ds.setDatabaseName(dbPath);
        ds.setServerName(serverHost);
        ds.setPortNumber(serverPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        Connection conn = ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("insert into t values (?,?,?)");
        for (int i = 0; i < _noTuplesToInsert; ++i) {
            ps.setInt(1, i + startVal);
            ps.setString(2, "dilldall" + (i + startVal));
            ps.setInt(3, (i + startVal) % (_noTuplesToInsert / 10));
            ps.execute();
            if (i % 10000 != 0) continue;
            conn.commit();
        }
        this._verify(conn, startVal + _noTuplesToInsert);
        conn.close();
    }

    private void _verifyIndexOnSlave(String indexName) throws SQLException {
        this.executeOnSlave("drop index " + indexName);
    }
}

