/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RolesDependencyTest
extends BaseJDBCTestCase {
    public RolesDependencyTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = new TestSuite(RolesDependencyTest.class);
        test = new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create schema s1");
                s.execute("create table s1.t1(x int)");
                s.execute("insert into s1.t1 values 1");
                s.execute("create role role1");
                s.execute("grant select on s1.t1 to role1");
                s.execute("grant role1 to user1");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator((Test)test);
    }

    public void testCurrentRoleDependencyMemleak() throws SQLException {
        Connection c = this.openUserConnection("user1");
        Statement s = c.createStatement();
        s.execute("set role role1");
        for (int i = 0; i < 40000; ++i) {
            ResultSet rs = s.executeQuery("select * from s1.t1");
            JDBC.assertDrainResults(rs, 1);
        }
        s.close();
        c.close();
    }
}

