/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.jdbc.EmbeddedDriver;

public class ConnectionHandling {
    public static void main(String[] args) throws Exception {
        System.out.println("Test ConnectionHandling starting");
        new EmbeddedDriver();
        Connection conn = DriverManager.getConnection("jdbc:derby:wombat;create=true");
        conn.close();
        conn = null;
        ArrayList<Connection> list = new ArrayList<Connection>();
        list.ensureCapacity(30000);
        Properties p = new Properties();
        while (true) {
            Connection c;
            try {
                c = DriverManager.getConnection("jdbc:derby:wombat", p);
            }
            catch (SQLException e) {
                if ("08004".equals(e.getSQLState())) {
                    System.out.println("FIRST OOME: " + e.getSQLState() + " " + e.getMessage());
                    break;
                }
                System.out.println("UNKNOWN ERROR " + e.getSQLState() + " " + e.getMessage());
                e.printStackTrace(System.out);
                break;
            }
            catch (Throwable t) {
                System.out.println("UNKNOWN ERROR " + t);
                t.printStackTrace(System.out);
                break;
            }
            list.add(c);
            if (list.size() % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println("");
        System.out.println(list.size() + " successful connections");
        list.ensureCapacity(list.size() + 500);
        int fail_sqloome = 0;
        int fail_sql = 0;
        int fail_bad = 0;
        int ok = 0;
        for (int i = 0; i < 500; ++i) {
            if (i == 300) {
                Thread.sleep(10000L);
            }
            try {
                Connection c = DriverManager.getConnection("jdbc:derby:wombat", p);
                list.add(c);
                ++ok;
                continue;
            }
            catch (SQLException e) {
                if ("08004".equals(e.getSQLState())) {
                    ++fail_sqloome;
                    continue;
                }
                ++fail_sql;
                System.out.println("UNKNOWN ERROR " + e.getSQLState() + " " + e.getMessage());
                e.printStackTrace(System.out);
                continue;
            }
            catch (Throwable t) {
                ++fail_bad;
                System.out.println("UNKNOWN ERROR " + t);
                t.printStackTrace(System.out);
            }
        }
        System.out.println("OK                  : " + ok);
        System.out.println("Failed 08004        : " + fail_sqloome);
        System.out.println("Failed SQLException : " + fail_sql);
        System.out.println("Failed Throwable    : " + fail_bad);
        System.out.println("closing connections : " + list.size());
        int alreadyClosed = 0;
        for (int i = 0; i < list.size(); ++i) {
            Connection c = (Connection)list.get(i);
            list.set(i, null);
            if (c.isClosed()) {
                ++alreadyClosed;
                continue;
            }
            c.close();
        }
        System.out.println("already closed      : " + alreadyClosed);
    }
}

