/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobMemTest
extends BaseJDBCTestCase {
    private static final int LONG_CLOB_LENGTH = 18000000;
    private static final String LONG_CLOB_LENGTH_STRING = "18000000";
    private static final char[] SHORT_CLOB_CHARS = new char[]{'\uc911', '\uc5d0', 'a', '\uc608', '\uae30', '\uce58'};

    public ClobMemTest(String name) {
        super(name);
    }

    private void testClobLength(boolean lengthless) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int size;
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE CLOBTABLE (K INT CONSTRAINT PK PRIMARY KEY, C CLOB(18000000))");
        PreparedStatement ps = this.prepareStatement("INSERT INTO CLOBTABLE VALUES(?,?)");
        ps.setInt(1, 1);
        LoopingAlphabetReader reader = new LoopingAlphabetReader(18000000L);
        if (lengthless) {
            Method m = null;
            try {
                Class<?> c = ps.getClass();
                m = c.getMethod("setCharacterStream", Integer.TYPE, InputStream.class);
            }
            catch (NoSuchMethodException e) {
                ClobMemTest.println("Skipping lengthless insert because method is not available");
                return;
            }
            m.invoke((Object)ps, new Integer(2), reader);
        } else {
            ps.setCharacterStream(2, (Reader)reader, 18000000);
        }
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setString(2, "");
        ps.executeUpdate();
        ps.setInt(1, 3);
        ps.setString(2, null);
        ps.executeUpdate();
        ps.setInt(1, 4);
        ps.setString(2, new String(SHORT_CLOB_CHARS));
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT K, LENGTH(C), C FROM CLOBTABLE-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        rs.next();
        ClobMemTest.assertEquals((String)LONG_CLOB_LENGTH_STRING, (String)rs.getString(2));
        Reader rsReader = rs.getCharacterStream(3);
        int len = 0;
        char[] buf = new char[32672];
        while ((size = rsReader.read(buf)) != -1) {
            int expectedValue = ((len += size) - 1) % 26 + 97;
            if (size == 0) continue;
            ClobMemTest.assertEquals((int)expectedValue, (int)buf[size - 1]);
        }
        ClobMemTest.assertEquals((int)18000000, (int)len);
        rs.next();
        ClobMemTest.assertEquals((String)"0", (String)rs.getString(2));
        String chars = rs.getString(3);
        ClobMemTest.assertEquals((int)0, (int)chars.length());
        rs.next();
        ClobMemTest.assertEquals(null, (String)rs.getString(2));
        chars = rs.getString(3);
        ClobMemTest.assertEquals(null, (String)chars);
        rs.next();
        ClobMemTest.assertEquals((String)("" + SHORT_CLOB_CHARS.length), (String)rs.getString(2));
        chars = rs.getString(3);
        ClobMemTest.assertTrue((boolean)Arrays.equals(chars.toCharArray(), SHORT_CLOB_CHARS));
        rs.close();
        rs = s.executeQuery("SELECT K, LENGTH(C)  FROM CLOBTABLE ORDER BY K");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", LONG_CLOB_LENGTH_STRING}, {"2", "0"}, {"3", null}, {"4", "6"}});
    }

    public void testClobLength() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testClobLength(false);
    }

    public void testClobLengthWithLengthlessInsert() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testClobLength(true);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(ClobMemTest.class);
        Properties p = new Properties();
        p.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup(suite, p);
    }

    public void testDerby4477_3645_3646_Repro_lowmem_clob() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        int clobsize = 18000000;
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V CLOB(" + clobsize + ") )");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        int blobLen = clobsize;
        LoopingAlphabetReader stream = new LoopingAlphabetReader(blobLen);
        ps.setCharacterStream(1, (Reader)stream, blobLen);
        ps.executeUpdate();
        ps.close();
        s.executeUpdate("CREATE TABLE T_COPY ( V1 CLOB(" + clobsize + "), V2 CLOB(" + clobsize + "))");
        s.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet rs = s.executeQuery("SELECT * FROM T_COPY");
        rs.next();
        Reader is = rs.getCharacterStream(1);
        stream = new LoopingAlphabetReader(blobLen);
        ClobMemTest.assertEquals(stream, is);
        is = rs.getCharacterStream(2);
        stream = new LoopingAlphabetReader(blobLen);
        ClobMemTest.assertEquals(stream, is);
        rs.close();
        rs = s.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        rs.next();
        is = rs.getCharacterStream(2);
        stream = new LoopingAlphabetReader(blobLen);
        ClobMemTest.assertEquals(stream, is);
        is = rs.getCharacterStream(4);
        stream = new LoopingAlphabetReader(blobLen);
        ClobMemTest.assertEquals(stream, is);
        stream.close();
        is.close();
        s.close();
        rs.close();
        this.rollback();
    }
}

