/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class Derby5624Test
extends BaseJDBCTestCase {
    public Derby5624Test(String name) {
        super(name);
    }

    public void testDERBY_5624() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO TESTBIGTABLE (col1, col2, col3) VALUES(?, ?, ?)");
        for (i = 0; i < 3000; ++i) {
            insert_stmt.setInt(1, i);
            insert_stmt.setInt(2, -i);
            insert_stmt.setInt(3, i);
            insert_stmt.executeUpdate();
        }
        this.commit();
        for (i = 0; i < 1000; ++i) {
            stmt.executeUpdate("CREATE INDEX INDEXBIG" + i + " on TESTBIGTABLE (col" + i + ")");
        }
        this.commit();
        stmt.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TESTBIGTABLE', 0)");
        this.commit();
        JDBC.assertUnorderedResultSet(this.prepareStatement("select col1, col2 from TESTBIGTABLE where col1 = 10").executeQuery(), new String[][]{{"10", "-10"}});
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(Derby5624Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = stmt.getConnection();
                StringBuffer create_table_qry = new StringBuffer(10000);
                create_table_qry.append("CREATE TABLE TESTBIGTABLE (col0 int");
                for (int colnum = 1; colnum < 1000; ++colnum) {
                    create_table_qry.append(", col" + colnum + " int");
                }
                create_table_qry.append(")");
                stmt.executeUpdate(create_table_qry.toString());
                conn.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Derby5624Test");
        suite.addTest(Derby5624Test.baseSuite("Derby5624Test:embedded"));
        return suite;
    }
}

