/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class XMLConcurrencyTest
extends BaseJDBCTestCase {
    public XMLConcurrencyTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (XML.classpathMeetsXMLReqs()) {
            return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(XMLConcurrencyTest.class)){

                protected void decorateSQL(Statement s) throws SQLException {
                    XMLConcurrencyTest.createTestTable(s);
                }
            };
        }
        return new TestSuite("XMLConcurrencyTest - empty");
    }

    public void testConcurrency() throws Exception {
        int i;
        WorkerThread[] allThreads = new WorkerThread[4];
        for (i = 0; i < allThreads.length; ++i) {
            allThreads[i] = new WorkerThread(this.openDefaultConnection(), 100);
            allThreads[i].start();
        }
        for (i = 0; i < allThreads.length; ++i) {
            allThreads[i].join();
            Throwable t = allThreads[i].throwable;
            if (t == null) continue;
            XMLConcurrencyTest.fail("Worker thread failed", t);
        }
    }

    private static void createTestTable(Statement s) throws SQLException {
        s.executeUpdate("create table t (id int primary key generated always as identity, vc varchar(100), x generated always as (xmlparse(document vc preserve whitespace)))");
        PreparedStatement ins = s.getConnection().prepareStatement("insert into t(vc) values ?");
        String[] docs = new String[]{"<doc><a x='1'>abc</a><b x='2'>def</b></doc>", "<doc><a x='2'>abc</a><b x='3'>def</b></doc>", "<doc/>", "<a/>", null};
        for (int i = 0; i < docs.length; ++i) {
            ins.setString(1, docs[i]);
            ins.executeUpdate();
        }
        ins.close();
    }

    private static void runXMLTest(Connection conn, int iterations) throws SQLException {
        PreparedStatement ps1 = conn.prepareStatement("select id, xmlserialize(xmlquery('count(//*[@x>1])' passing by ref x empty on empty) as varchar(100)) from t order by id");
        String[][] expected1 = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "0"}, {"4", "0"}, {"5", null}};
        PreparedStatement ps2 = conn.prepareStatement("select id from t where xmlexists('/doc/a[@x=2]' passing by ref x) order by id");
        String expected2 = "2";
        PreparedStatement ps3 = conn.prepareStatement("select count(*) from t where xmlserialize(xmlparse(document vc preserve whitespace) as varchar(100)) = xmlserialize(x as varchar(100))");
        String expected3 = "4";
        for (int i = 0; i < iterations; ++i) {
            JDBC.assertFullResultSet(ps1.executeQuery(), expected1);
            JDBC.assertSingleValueResultSet(ps2.executeQuery(), expected2);
            JDBC.assertSingleValueResultSet(ps3.executeQuery(), expected3);
        }
        ps1.close();
        ps2.close();
        ps3.close();
        conn.close();
    }

    private class WorkerThread
    extends Thread {
        final Connection conn;
        final int iterations;
        Throwable throwable;

        WorkerThread(Connection conn, int iterations) {
            this.conn = conn;
            this.iterations = iterations;
        }

        public void run() {
            try {
                XMLConcurrencyTest.runXMLTest(this.conn, this.iterations);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }
    }
}

