/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class SysDiagVTIMappingTest
extends BaseJDBCTestCase {
    private static final String testLogFile = "sys_vti_test_derby.tstlog";

    public SysDiagVTIMappingTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Diagnostic VTI Table Mappings");
        Test defaultSetup = TestConfiguration.defaultSuite(SysDiagVTIMappingTest.class);
        Properties sysprops = new Properties();
        sysprops.put("derby.language.logStatementText", "true");
        SystemPropertyTestSetup verboseTest = new SystemPropertyTestSetup(defaultSetup, sysprops);
        suite.addTest((Test)verboseTest);
        return SecurityManagerSetup.noSecurityManager((Test)new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"}));
    }

    public void setUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table app.t1 (i int, c varchar(10))");
        stmt.execute("insert into app.t1 values (1, 'one'), (2, 'two'), (4, 'four')");
        stmt.close();
    }

    public void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("drop table app.t1");
        stmt.close();
        super.tearDown();
    }

    public void testSpaceTable() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(SPACE_TABLE('APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from TABLE TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from TABLE TABLE (select * from t1) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", st, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1', 'APP')) x");
        SysDiagVTIMappingTest.assertStatementError("42Y07", st, "select * from TABLE(SYSCS_DIAG.SPACE_TABLE('NOTTHERE', 'T1')) x");
        st.executeUpdate("set schema SYSCS_DIAG");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from TABLE(APP.SPACE_TABLE('APP', 'T1')) x");
        st.executeUpdate("set schema APP");
        ResultSet rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x");
        String[] expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from TABLE(SYSCS_DIAG.SPACE_TABLE('T1')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        PreparedStatement pSt = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?, ?)) x");
        pSt.setString(1, "APP");
        pSt.setString(2, "T1");
        rs = pSt.executeQuery();
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        pSt = this.prepareStatement("select * from TABLE(SYSCS_DIAG.SPACE_TABLE(?)) x");
        pSt.setString(1, "T1");
        rs = pSt.executeQuery();
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'NOTTHERE')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'NOTTHERE')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('SYSCS_DIAG', 'LOCK_TABLE')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("set schema syscs_diag");
        pSt = this.prepareStatement("select * from TABLE(SPACE_TABLE(?, ?)) x");
        pSt.setString(1, "APP");
        pSt.setString(2, "T1");
        rs = pSt.executeQuery();
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        pSt = this.prepareStatement("select * from TABLE(SPACE_TABLE(?)) x");
        pSt.setString(1, "T1");
        rs = pSt.executeQuery();
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        rs = st.executeQuery("select * from TABLE(SPACE_TABLE('LOCK_TABLE')) x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("set schema app");
        rs = st.executeQuery("select cast (conglomeratename as varchar(30)), t1.* from  TABLE(SYSCS_DIAG.SPACE_TABLE('APP', 'T1')) x,  t1 where x.conglomeratename is not null");
        expColNames = new String[]{"1", "I", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "1", "one"}, {"T1", "2", "two"}, {"T1", "4", "four"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("set schema APP");
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('T1') as x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.SpaceTable('APP', 'T1') as x");
        expColNames = new String[]{"CONGLOMERATENAME", "ISINDEX", "NUMALLOCATEDPAGES", "NUMFREEPAGES", "NUMUNFILLEDPAGES", "PAGESIZE", "ESTIMSPACESAVING"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"T1", "0", "1", "0", "1", "4096", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "space_table", "SpaceTable", "('APP', 'T1')", "conglomeratename");
        this.getConnection().rollback();
        st.close();
    }

    public void testStatementDuration() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        URL logURL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String vtiArg = "('" + logURL.getFile() + "')";
        ResultSet rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.STATEMENT_DURATION" + vtiArg + ") x");
        String[] expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.StatementDuration" + vtiArg + " as x");
        expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "LOGTEXT", "DURATION"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "(DATABASE = ugh), (DRDAID = null), Cleanup action starting", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "statement_duration", "StatementDuration", vtiArg, "logtext");
    }

    public void testErrorLogReader() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        URL logURL = SupportFilesSetup.getReadOnlyURL(testLogFile);
        String vtiArg = "('" + logURL.getFile() + "')";
        ResultSet rs = st.executeQuery(" select * from TABLE(SYSCS_DIAG.ERROR_LOG_READER" + vtiArg + ") x");
        String[] expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("SELECT * FROM NEW org.apache.derby.diag.ErrorLogReader" + vtiArg + " as x");
        expColNames = new String[]{"TS", "THREADID", "XID", "LCCID", "DATABASE", "DRDAID", "LOGTEXT"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Cleanup action starting"}, {"2006-12-15 16:14:58.280 GMT", "main,5,main", "1111", "0", "ugh", "null", "Failed Statement is: select * from oops"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.checkIllegalUses(st, "error_log_reader", "ErrorLogReader", vtiArg, "logtext");
    }

    public void testInvalidTableFunctions() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        ResultSet rs = st.executeQuery("select * from table (select * from t1) x");
        String[] expColNames = new String[]{"I", "C"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "one"}, {"2", "two"}, {"4", "four"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select * from table (values (1, 2), (2, 3)) x");
        expColNames = new String[]{"1", "2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "2"}, {"2", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (app.t1) x");
        SysDiagVTIMappingTest.assertStatementError("42ZB4", st, "select * from table (app.t1()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.lock_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.lock_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.transaction_table) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.transaction_table()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.statement_cache) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.statement_cache()) x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from table (syscs_diag.error_messages) x");
        SysDiagVTIMappingTest.assertStatementError("42Y03", st, "select * from table (syscs_diag.error_messages()) x");
        this.getConnection().rollback();
        st.close();
    }

    public void testOrderBy() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("set schema APP");
        st.execute("create table ob_t1 (i int, c char(250))");
        st.execute("create index i_ix on ob_t1 (i)");
        st.execute("create index c_ix on ob_t1 (c desc)");
        String[][] expRS = new String[][]{{"C_IX", "1", "0"}, {"I_IX", "1", "0"}, {"OB_T1", "0", "0"}};
        ResultSet rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 1");
        JDBC.assertFullResultSet(rs, expRS);
        expRS = new String[][]{{"OB_T1", "0", "0"}, {"C_IX", "1", "0"}, {"I_IX", "1", "0"}};
        rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1");
        JDBC.assertFullResultSet(rs, expRS);
        expRS = new String[][]{{"OB_T1", "0", "0"}, {"I_IX", "1", "0"}, {"C_IX", "1", "0"}};
        rs = st.executeQuery("select CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(rs, expRS);
        rs = st.executeQuery("select distinct CONGLOMERATENAME, ISINDEX, NUMFREEPAGES from table(syscs_diag.space_table('OB_T1')) X order by 2, 1 desc");
        JDBC.assertFullResultSet(rs, expRS);
        st.execute("drop table ob_t1");
        st.close();
    }

    public void testCorrelatedReferences() throws SQLException {
        Statement st = this.createStatement();
        String[][] expRS = new String[][]{};
        ResultSet rs = st.executeQuery("select s.schemaname, t.tableName\nfrom sys.sysschemas s, sys.systables t\nwhere t.schemaid=s.schemaid\nand exists\n(\n  select vti.*\n  from table( syscs_diag.space_table( s.schemaname, t.tableName ) ) as vti\n  where vti.numfreepages < -1\n)\n");
        JDBC.assertFullResultSet(rs, expRS);
        rs.close();
        st.close();
    }

    public void testContainedRoles() throws SQLException {
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select * from table(syscs_diag.contained_roles(null, 0))t");
        JDBC.assertEmpty(rs);
        rs = st.executeQuery("select * from table(syscs_diag.contained_roles(null))t");
        JDBC.assertEmpty(rs);
        rs.close();
        st.close();
    }

    public void test_5391() throws Exception {
        Statement st = this.createStatement();
        ResultSet rs1 = st.executeQuery("select * from table (syscs_diag.error_log_reader( )) as t1");
        this.vetTimestamp(rs1);
        rs1.close();
        ResultSet rs2 = st.executeQuery("select * from table (syscs_diag.statement_duration()) as t1");
        this.vetTimestamp(rs2);
        rs2.close();
        st.close();
    }

    private void vetTimestamp(ResultSet rs) throws Exception {
        SysDiagVTIMappingTest.assertTrue((boolean)rs.next());
        String timestampString = rs.getString(1).trim();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Timestamp timestamp = new Timestamp(sdf.parse(timestampString).getTime());
        SysDiagVTIMappingTest.println(timestamp.toString());
    }

    private void checkIllegalUses(Statement st, String vtiTableName, String vtiMethodName, String args, String colName) throws SQLException {
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "select * from syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from syscs_diag." + vtiTableName + args + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from (syscs_diag." + vtiTableName + args + ") x");
        SysDiagVTIMappingTest.assertStatementError("42Y55", st, "drop table syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "drop table syscs_diag." + vtiTableName + args);
        SysDiagVTIMappingTest.assertStatementError("42X62", st, "drop function syscs_diag." + vtiTableName);
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "drop function syscs_diag." + vtiTableName + args);
        SysDiagVTIMappingTest.assertStatementError("42X62", st, "alter table syscs_diag." + vtiTableName + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "alter table syscs_diag." + vtiTableName + args + " add column bad int");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "update syscs_diag." + vtiTableName + " set " + colName + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "update syscs_diag." + vtiTableName + args + " set " + colName + "  = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "delete from syscs_diag." + vtiTableName + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "delete from syscs_diag." + vtiTableName + args + " where 1 = 1");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "insert into syscs_diag." + vtiTableName + " values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X05", st, "insert into syscs_diag." + vtiTableName + " (" + colName + ") values('bad')");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "insert into syscs_diag." + vtiTableName + args + " values('bad')");
        CallableStatement cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, 1)");
        cSt.setString(1, "SYSCS_DIAG");
        cSt.setString(2, vtiTableName.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42X62", cSt);
        cSt = this.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        cSt.setString(1, "SYSCS_DIAG");
        cSt.setString(2, vtiTableName.toUpperCase());
        SysDiagVTIMappingTest.assertStatementError("42Y55", cSt);
        SysDiagVTIMappingTest.assertStatementError("42X08", st, "update new org.apache.derby.diag." + vtiMethodName + args + " set " + colName + " = NULL");
        SysDiagVTIMappingTest.assertStatementError("42X08", st, "delete from new org.apache.derby.diag." + vtiMethodName + args + " where 1 = 0");
        st.execute("set schema syscs_diag");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from " + vtiTableName + args + " x");
        SysDiagVTIMappingTest.assertStatementError("42X01", st, "select * from (" + vtiTableName + args + ") x");
        st.execute("set schema app");
    }
}

