/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.Connection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DBOAccessTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String JANET = "JANET";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "JANET"};
    private static final String TEST_LOG_FILE = "sys_vti_test_derby.tstlog";
    private static final String ONLY_DBO = "4251D";
    private static final String HIDDEN_COLUMN = "4251E";

    public DBOAccessTest(String name) {
        super(name);
    }

    public boolean authorizationIsOn() {
        return true;
    }

    public static Test suite() {
        String[] testFiles = new String[]{"functionTests/tests/lang/sys_vti_test_derby.tstlog"};
        Object authorizedRun = TestConfiguration.embeddedSuite(DBOAccessTest.class);
        authorizedRun = DatabasePropertyTestSetup.builtinAuthentication(authorizedRun, LEGAL_USERS, "authorizationOnDBOAccessTest");
        authorizedRun = new SupportFilesSetup((Test)authorizedRun, testFiles);
        authorizedRun = TestConfiguration.sqlAuthorizationDecorator(authorizedRun);
        Object unauthorizedRun = TestConfiguration.embeddedSuite(NoAuthorization.class);
        unauthorizedRun = new SupportFilesSetup((Test)unauthorizedRun, testFiles);
        TestSuite suite = new TestSuite();
        suite.addTest(authorizedRun);
        suite.addTest(unauthorizedRun);
        return suite;
    }

    public void test_5395() throws Exception {
        DBOAccessTest.println("authorizationIsOn() = " + this.authorizationIsOn());
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.minion_5395(dboConnection, true);
        this.minion_5395(janetConnection, !this.authorizationIsOn());
    }

    private void minion_5395(Connection conn, boolean shouldSucceed) throws Exception {
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.statement_cache");
        this.vet_5395(conn, shouldSucceed, "select * from syscs_diag.transaction_table");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration() ) s");
        URL logURL = SupportFilesSetup.getReadOnlyURL(TEST_LOG_FILE);
        String vtiArg = "'" + logURL.getFile() + "'";
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.error_log_reader( " + vtiArg + " ) ) s");
        this.vet_5395(conn, shouldSucceed, "select * from table( syscs_diag.statement_duration( " + vtiArg + " ) ) s");
    }

    private void vet_5395(Connection conn, boolean shouldSucceed, String query) throws Exception {
        if (shouldSucceed) {
            this.goodStatement(conn, query);
        } else {
            this.expectCompilationError(conn, ONLY_DBO, query);
        }
    }

    public void testSYSUSERS() throws Exception {
        DBOAccessTest.println("testSYSUSERS authorizationIsOn() = " + this.authorizationIsOn());
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection janetConnection = this.openUserConnection(JANET);
        this.goodStatement(dboConnection, "create view v2 as select username, hashingscheme, lastmodified from sys.sysusers");
        if (this.authorizationIsOn()) {
            this.goodStatement(dboConnection, "grant select on v2 to public");
        }
        this.vetDBO_OKProbes(dboConnection, true);
        this.vetDBO_OKProbes(janetConnection, !this.authorizationIsOn());
        this.vetUnauthorizedProbes(dboConnection, !this.authorizationIsOn(), HIDDEN_COLUMN);
        this.vetUnauthorizedProbes(janetConnection, !this.authorizationIsOn(), ONLY_DBO);
    }

    private void vetDBO_OKProbes(Connection conn, boolean shouldSucceed) throws Exception {
        this.vetUserProbes(conn, shouldSucceed, "select count(*) from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, hashingscheme, lastmodified from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username from sys.sysusers", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select count(*) from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select * from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username, hashingscheme, lastmodified from test_dbo.v2", ONLY_DBO);
        this.vetUserProbes(conn, shouldSucceed, "select username from test_dbo.v2", ONLY_DBO);
    }

    private void vetUnauthorizedProbes(Connection conn, boolean shouldSucceed, String expectedSQLState) throws Exception {
        this.vetUserProbes(conn, shouldSucceed, "select * from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select * from sys.sysusers where username='foo'", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select password from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select username, password from sys.sysusers", expectedSQLState);
        this.vetUserProbes(conn, shouldSucceed, "select username from sys.sysusers where password = 'foo'", expectedSQLState);
    }

    private void vetUserProbes(Connection conn, boolean shouldSucceed, String query, String expectedSQLState) throws Exception {
        if (shouldSucceed) {
            this.goodStatement(conn, query);
        } else {
            this.expectCompilationError(conn, expectedSQLState, query);
        }
    }

    public static final class NoAuthorization
    extends DBOAccessTest {
        public NoAuthorization(String name) {
            super(name);
        }

        public boolean authorizationIsOn() {
            return false;
        }
    }
}

