/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class CurrentOfTest
extends BaseJDBCTestCase {
    public CurrentOfTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("CurrentOfTest");
        suite.addTestSuite(CurrentOfTest.class);
        return suite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table t (i int, c char(50))");
        stmt.executeUpdate("create table s (i int, c char(50))");
        stmt.executeUpdate("insert into t values (1956, 'hello world')");
        stmt.executeUpdate("insert into t values (456, 'hi yourself')");
        stmt.executeUpdate("insert into t values (180, 'rubber ducky')");
        stmt.executeUpdate("insert into t values (3, 'you are the one')");
        stmt.close();
        this.commit();
    }

    protected void tearDown() throws Exception {
        JDBC.dropSchema(this.getConnection().getMetaData(), this.getTestConfiguration().getUserName());
        super.tearDown();
    }

    public void testReadOnlyCursors() throws SQLException {
        String[] readOnlySQL = new String[]{"select I, C from t for read only", "select I, C from t for fetch only", "select I, C FROM T ORDER BY 1", "values (1, 2, 3)", "select I, C from t union all select I, C from t", "select t1.I, t1.C from t t1, t t2 where t1.I = t2.I", "select I, C from (select * from t) t1", "select I, C from t where I in (select I from t)"};
        for (int i = 0; i < readOnlySQL.length; ++i) {
            PreparedStatement select = this.prepareStatement(readOnlySQL[i]);
            ResultSet cursor = select.executeQuery();
            CurrentOfTest.assertNull((String)readOnlySQL[i], (Object)cursor.getCursorName());
            cursor.close();
            select.setCursorName("PLEASE_UPDATE");
            cursor = select.executeQuery();
            CurrentOfTest.assertEquals((String)readOnlySQL[i], (String)"PLEASE_UPDATE", (String)cursor.getCursorName());
            this.assertCompileError("42X23", "DELETE FROM T WHERE CURRENT OF PLEASE_UPDATE");
            this.assertCompileError("42X23", "UPDATE T SET I = 3 WHERE CURRENT OF PLEASE_UPDATE");
            cursor.close();
            select.close();
        }
    }

    public void testDelete() throws SQLException {
        String tableRows = "select i, c from t for read only";
        Statement delete1 = this.createStatement();
        Object[][] expectedRows = new Object[][]{{new String("1956"), new String("hello world")}, {new String("456"), new String("hi yourself")}, {new String("180"), new String("rubber ducky")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(delete1.executeQuery(tableRows), expectedRows, true);
        PreparedStatement select = this.prepareStatement("select i, c from t for update");
        ResultSet cursor = select.executeQuery();
        this.assertCompileError("42X28", "delete from s where current of " + cursor.getCursorName());
        PreparedStatement delete = this.prepareStatement("delete from t where current of " + cursor.getCursorName());
        CurrentOfTest.assertStatementError("24000", delete);
        cursor.next();
        CurrentOfTest.assertEquals((int)1956, (int)cursor.getInt(1));
        CurrentOfTest.assertUpdateCount(delete, 1);
        cursor.next();
        CurrentOfTest.assertEquals((int)456, (int)cursor.getInt(1));
        cursor.next();
        CurrentOfTest.assertEquals((int)180, (int)cursor.getInt(1));
        CurrentOfTest.assertUpdateCount(delete, 1);
        cursor.next();
        CurrentOfTest.assertEquals((int)3, (int)cursor.getInt(1));
        CurrentOfTest.assertFalse((boolean)cursor.next());
        if (CurrentOfTest.usingEmbedded()) {
            CurrentOfTest.assertStatementError("24000", delete);
        } else {
            CurrentOfTest.assertStatementError("42X30", delete);
        }
        cursor.close();
        if (CurrentOfTest.usingEmbedded()) {
            CurrentOfTest.assertStatementError("42X30", delete);
        } else {
            CurrentOfTest.assertStatementError("XCL16", delete);
        }
        Statement delete2 = this.createStatement();
        CurrentOfTest.assertStatementError("42X30", delete2, "delete from t where current of myCursor");
        expectedRows = new Object[][]{{new String("456"), new String("hi yourself")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(delete1.executeQuery(tableRows), expectedRows, true);
        delete.close();
        delete2.close();
        select.close();
        select = this.prepareStatement("SELECT I, C FROM T FOR UPDATE OF I");
        cursor = select.executeQuery();
        delete = this.prepareStatement("delete from t where current of " + cursor.getCursorName());
        CurrentOfTest.assertTrue((boolean)cursor.next());
        CurrentOfTest.assertUpdateCount(delete, 1);
        delete.close();
        delete1.close();
        cursor.close();
        select.close();
    }

    public void testUpdate() throws SQLException {
        String tableRows = "select i, c from t for read only";
        PreparedStatement select = this.prepareStatement("select I, C from t for update of I");
        ResultSet cursor = select.executeQuery();
        this.assertCompileError("42X31", "update t set C = 'abcde' where current of " + cursor.getCursorName());
        cursor.close();
        select.close();
        Statement select1 = this.createStatement();
        Object[][] expectedRows = new Object[][]{{new String("1956"), new String("hello world")}, {new String("456"), new String("hi yourself")}, {new String("180"), new String("rubber ducky")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(select1.executeQuery(tableRows), expectedRows, true);
        select = this.prepareStatement("select I, C from t for update");
        cursor = select.executeQuery();
        this.assertCompileError("42X29", "update s set i=1 where current of " + cursor.getCursorName());
        PreparedStatement update = this.prepareStatement("update t set i=i+10, c='Gumby was here' where current of " + cursor.getCursorName());
        CurrentOfTest.assertStatementError("24000", update);
        cursor.next();
        CurrentOfTest.assertEquals((int)1956, (int)cursor.getInt(1));
        CurrentOfTest.assertUpdateCount(update, 1);
        CurrentOfTest.assertUpdateCount(update, 1);
        cursor.next();
        CurrentOfTest.assertEquals((int)456, (int)cursor.getInt(1));
        cursor.next();
        CurrentOfTest.assertEquals((int)180, (int)cursor.getInt(1));
        CurrentOfTest.assertUpdateCount(update, 1);
        cursor.next();
        CurrentOfTest.assertEquals((int)3, (int)cursor.getInt(1));
        CurrentOfTest.assertFalse((boolean)cursor.next());
        CurrentOfTest.assertStatementError("24000", update);
        cursor.close();
        select.close();
        CurrentOfTest.assertStatementError("42X30", update);
        update.close();
        Statement update2 = this.createStatement();
        CurrentOfTest.assertStatementError("42X30", update2, "update t set i=1 where current of nosuchcursor");
        update2.close();
        expectedRows = new Object[][]{{new String("1976"), new String("Gumby was here")}, {new String("456"), new String("hi yourself")}, {new String("190"), new String("Gumby was here")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(select1.executeQuery(tableRows), expectedRows, true);
        cursor.close();
    }

    public void testUpdateRecompileCreateIndex() throws Exception {
        this.recompile("UPDATE T SET I = I + 1 WHERE CURRENT OF ", "CREATE INDEX IT ON T(I)", null);
    }

    public void testUpdateRecompileChangeFunction() throws Exception {
        Statement s = this.createStatement();
        s.execute("CREATE FUNCTION F(V INTEGER) RETURNS INTEGER NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".doubleValue'");
        this.commit();
        String changeSQL = "CREATE FUNCTION F(V INTEGER) RETURNS INTEGER NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".tripleValue'";
        int firstI = this.recompile("UPDATE T SET I = F(I) WHERE CURRENT OF ", "DROP FUNCTION F", changeSQL);
        String[][] values = new String[][]{{"3"}, {"180"}, {"456"}, {"1956"}};
        if (firstI == 180) {
            values[1] = new String[]{"360"};
            values[2] = new String[]{"1368"};
        } else {
            values[1] = new String[]{"540"};
            values[2] = new String[]{"912"};
        }
        JDBC.assertFullResultSet(s.executeQuery("SELECT I FROM T ORDER BY I"), values);
        s.close();
    }

    public void testDeleteRecompileCreateIndex() throws Exception {
        this.recompile("DELETE FROM T WHERE CURRENT OF ", "CREATE INDEX IT ON T(I)", null);
    }

    private int recompile(String positionedSQL, String changeSQL1, String changeSQL2) throws SQLException {
        Statement s = this.createStatement();
        PreparedStatement select = this.prepareStatement("select I, C from t for update");
        ResultSet cursor = select.executeQuery();
        PreparedStatement update = this.prepareStatement(positionedSQL + cursor.getCursorName());
        int firstRowI = -1;
        while (cursor.next()) {
            int i = cursor.getInt(1);
            if (i != 180 && i != 456) continue;
            update.execute();
            firstRowI = i;
            break;
        }
        CurrentOfTest.assertTrue((firstRowI == 180 || firstRowI == 456 ? 1 : 0) != 0);
        s.execute(changeSQL1);
        if (changeSQL2 != null) {
            s.execute(changeSQL2);
        }
        int secondRowI = -1;
        while (cursor.next()) {
            int i = cursor.getInt(1);
            if (i != 180 && i != 456) continue;
            update.execute();
            secondRowI = i;
            break;
        }
        CurrentOfTest.assertTrue((firstRowI != secondRowI ? 1 : 0) != 0);
        CurrentOfTest.assertTrue((secondRowI == 180 || secondRowI == 456 ? 1 : 0) != 0);
        update.close();
        cursor.close();
        select.close();
        this.commit();
        s.close();
        this.assertCheckTable("T");
        return firstRowI;
    }

    public void testCursorChangeUpdateList() throws SQLException {
        this.cursorChange("42X31", "select I, C from t for update", "update t set i=i+19, c='OLD' || cast(i as CHAR(20)) where current of ", "select I, C from t for update of I");
        this.cursorChange(null, "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "select I, C from t for update of I");
    }

    public void testCursorChangeToReadOnly() throws SQLException {
        this.cursorChange("42X23", "select I, C from t for update", "update t set i=i+23 where current of ", "select I, C from t for fetch only");
        this.cursorChange("42X23", "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "select I, C from t for fetch only");
    }

    public void testCursorChangeToDifferentTable() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("INSERT INTO S(I,C) SELECT I,C FROM T");
        s.close();
        this.commit();
        this.cursorChange("42X29", "select I, C from t for update", "update t set i=i+23 where current of ", "SELECT I, C FROM S FOR UPDATE");
        this.cursorChange("42X28", "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "SELECT I, C FROM S FOR UPDATE");
    }

    private void cursorChange(String sqlState, String initialCursor, String positionedStatement, String changeToCursor) throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("insert into t values (425, 'apache db derby')");
        s.executeUpdate("insert into t values (280, 'derby-user users')");
        s.close();
        this.commit();
        this.cursorChange(sqlState, "CHANGE_ME", initialCursor, positionedStatement, changeToCursor);
        this.cursorChange(sqlState, null, initialCursor, positionedStatement, changeToCursor);
    }

    private void cursorChange(String sqlState, String cursorName, String initialCursor, String positionedStatement, String changeToCursor) throws SQLException {
        PreparedStatement select = this.prepareStatement(initialCursor);
        if (cursorName != null) {
            select.setCursorName(cursorName);
        }
        ResultSet cursor = select.executeQuery();
        cursorName = cursor.getCursorName();
        PreparedStatement update = this.prepareStatement(positionedStatement + cursorName);
        CurrentOfTest.assertTrue((boolean)cursor.next());
        CurrentOfTest.assertUpdateCount(update, 1);
        cursor.close();
        PreparedStatement selectdd = this.prepareStatement(changeToCursor);
        selectdd.setCursorName(cursorName);
        cursor = selectdd.executeQuery();
        CurrentOfTest.assertTrue((boolean)cursor.next());
        if (sqlState != null) {
            CurrentOfTest.assertStatementError(sqlState, update);
        } else {
            CurrentOfTest.assertUpdateCount(update, 1);
        }
        cursor.close();
        cursor = select.executeQuery();
        cursor.next();
        CurrentOfTest.assertUpdateCount(update, 1);
        cursor.close();
        update.close();
        selectdd.close();
        select.close();
    }

    public static int doubleValue(int i) {
        return i * 2;
    }

    public static int tripleValue(int i) {
        return i * 3;
    }
}

