/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ColumnDefaultsTest
extends BaseJDBCTestCase {
    public ColumnDefaultsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ColumnDefaultsTest Test");
        suite.addTest(TestConfiguration.defaultSuite(ColumnDefaultsTest.class));
        return suite;
    }

    public void testNegativeTestsForColumnDefaults() throws Exception {
        Statement st = this.createStatement();
        ColumnDefaultsTest.assertStatementError("42X01", st, "create table neg(c1 int default ?)");
        ColumnDefaultsTest.assertStatementError("42X01", st, "create table neg(c1 int, c2 int default c1)");
        ColumnDefaultsTest.assertStatementError("42X01", st, "create table neg(c1 int default (values 1))");
        ColumnDefaultsTest.assertStatementError("42821", st, "create table neg(c1 date default 1)");
        st.executeUpdate("create table neg(c1 int, c2 date default '1')");
        ColumnDefaultsTest.assertStatementError("22007", st, " insert into neg (c1) values 1");
        st.executeUpdate(" drop table neg");
        st.executeUpdate("CREATE FUNCTION ASDF (DATA DOUBLE) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Math.sin' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ColumnDefaultsTest.assertStatementError("42894", st, " create table neg(c1 int default asdf(0))");
        ColumnDefaultsTest.assertStatementError("42Y55", st, " drop table neg");
        ColumnDefaultsTest.assertStatementError("42Y85", st, "values default");
        ColumnDefaultsTest.assertStatementError("42Y85", st, " values 1, default");
        st.executeUpdate("create table neg(c1 date)");
        ColumnDefaultsTest.assertStatementError("42X01", st, " alter table neg modify x default null");
        ColumnDefaultsTest.assertStatementError("42821", st, " alter table neg add column x date default 1");
        st.executeUpdate("alter table neg add column x date default '1'");
        ColumnDefaultsTest.assertStatementError("22007", st, " insert into neg (c1) values default");
        st.executeUpdate(" drop table neg");
        st.executeUpdate("create table neg(c1 int default 10)");
        ColumnDefaultsTest.assertStatementError("42X06", st, " insert into neg values (1, default)");
        ColumnDefaultsTest.assertStatementError("42802", st, " insert into neg values (default, 1)");
        ColumnDefaultsTest.assertStatementError("42Y85", st, " insert into neg values (default) union values (default)");
        ColumnDefaultsTest.assertStatementError("42Y85", st, " insert into neg values (default) except values (default)");
        ColumnDefaultsTest.assertStatementError("42Y85", st, " insert into neg select * from (values default) t");
        st.executeUpdate(" drop table neg");
        st.executeUpdate("drop function asdf");
        this.rollback();
        st.close();
    }

    public void testPositiveTestsForColumnDefaults() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table t1(c1 int, c2 int with default 5, c3 date default current_date, c4 int)");
        st.executeUpdate("insert into t1 (c1) values 1");
        st.executeUpdate(" insert into t1 (c4) values 4");
        ResultSet rs = st.executeQuery("select c1, c2, c4 from t1");
        String[] expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertUpdateCount(st, 2, "update t1 set c1 = default");
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertUpdateCount(st, 2, "update t1 set c2 = 7");
        rs = st.executeQuery(" select c2 from t1");
        expColNames = new String[]{"C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"7"}, {"7"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertUpdateCount(st, 2, " update t1 set c2 = default");
        rs = st.executeQuery(" select c2 from t1");
        expColNames = new String[]{"C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5"}, {"5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertUpdateCount(st, 2, "delete from t1");
        st.executeUpdate(" insert into t1 values (5, default, '1999-09-09', default)");
        st.executeUpdate(" insert into t1 values (default, 6, default, 5)");
        st.executeUpdate(" insert into t1 values (default, 6, default, 5), (7, default, '1997-07-07', 3)");
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "6", "5"}, {null, "6", "5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 <> current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5", "5", null}, {"7", "5", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertUpdateCount(st, 4, " delete from t1");
        st.executeUpdate(" insert into t1 (c1, c3, c4) values (5, '1999-09-09', default)");
        st.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, 5)");
        st.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, default)");
        st.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, 5), (7, '1997-07-07', 3)");
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{null, "5", "5"}, {null, "5", null}, {null, "5", "5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery(" select c1, c2, c4 from t1 where c3 <> current_date");
        expColNames = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"5", "5", null}, {"7", "5", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table \"x1\" (\"c1\" int)");
        st.executeUpdate(" insert into \"x1\" values 1");
        st.executeUpdate(" alter table \"x1\" add column \"c2\" char(1) default 'x'");
        rs = st.executeQuery(" select * from \"x1\"");
        expColNames = new String[]{"c1", "c2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "x"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create schema \"otherschema\"");
        st.executeUpdate(" create table \"otherschema\".\"y1\" (\"c11\" int)");
        st.executeUpdate(" insert into \"otherschema\".\"y1\" values 2");
        st.executeUpdate(" alter table \"otherschema\".\"y1\" add column \"c22\" char(1) default 'y'");
        rs = st.executeQuery(" select * from \"otherschema\".\"y1\"");
        expColNames = new String[]{"c11", "c22"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2", "y"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("create table t7(c1 int default 10)");
        st.executeUpdate(" insert into t7 values (default)");
        rs = st.executeQuery(" select * from t7");
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"10"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("delete from t7");
        st.executeUpdate("insert into t7 values 1, default");
        rs = st.executeQuery(" select * from t7");
        expRS = new String[][]{{"1"}, {"10"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" drop table t1");
        st.executeUpdate(" drop table t7");
        st.executeUpdate(" drop table \"x1\"");
        st.executeUpdate(" drop table \"otherschema\".\"y1\"");
        st.executeUpdate(" drop schema \"otherschema\" restrict");
        this.rollback();
        st.close();
    }

    public void testJira331() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table t_331 (a int not null, b int default 0, unique (a))");
        st.executeUpdate(" insert into t_331 values (4, default)");
        ColumnDefaultsTest.assertStatementError("23505", st, " insert into t_331 values (4, default)");
        ResultSet rs = st.executeQuery(" select * from t_331");
        String[] expColNames = new String[]{"A", "B"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"4", "0"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" drop table t_331");
        this.rollback();
        st.close();
    }

    public void testJira3013() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table tabWithUserAndSchemaDefaults(             cUser           CHAR(8) default user,             cCurrent_user   CHAR(8) default current_user,             cSession_user   CHAR(8) default session_user,             cCurrent_schema CHAR(128) default current schema)");
        st.executeUpdate("insert into tabWithUserAndSchemaDefaults values (default, default, default, default)");
        ResultSet rs = st.executeQuery(" select * from tabWithUserAndSchemaDefaults");
        String[] expColNames = new String[]{"CUSER", "CCURRENT_USER", "CSESSION_USER", "CCURRENT_SCHEMA"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"APP", "APP", "APP", "APP"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        ColumnDefaultsTest.assertStatementError("42894", st, "create table tabWithUserDefaultTooNarrowColumn(       c1 CHAR(7) default user)");
        ColumnDefaultsTest.assertStatementError("42894", st, "create table tabWithSchemaDefaultTooNarrowColumn(       c1 CHAR(127) default current sqlid)");
        st.executeUpdate(" drop table tabWithUserAndSchemaDefaults");
        this.rollback();
        st.close();
    }
}

