/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class UpdateXXXTest
extends BaseJDBCTestCase {
    private static final String TABLE_NAME = "MultiTypeTable";
    private static final String SELECT_STMT = "SELECT * FROM MultiTypeTable";
    private static final int COLUMNS = 10;

    public UpdateXXXTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = UpdateXXXTest.baseSuite("UpdateXXXTest");
        suite.addTest(TestConfiguration.clientServerDecorator((Test)UpdateXXXTest.baseSuite("UpdateXXXTest:client")));
        return suite;
    }

    private static TestSuite baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(UpdateXXXTest.class);
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest((Test)new UpdateXXXTest("jdbc2testUpdateBigDecimal"));
        }
        return suite;
    }

    public void setUp() throws Exception {
        Connection con = this.getConnection();
        try {
            con.setAutoCommit(false);
            Statement stmt = con.createStatement();
            String createTableString = "CREATE TABLE MultiTypeTable (F01 SMALLINT,F02 INTEGER,F03 BIGINT,F04 REAL,F05 FLOAT,F06 DOUBLE,F07 DECIMAL,F08 NUMERIC,F09 CHAR(100),F10 VARCHAR(256) )";
            UpdateXXXTest.println(createTableString);
            stmt.executeUpdate(createTableString);
            PreparedStatement ps = con.prepareStatement("insert into MultiTypeTable values(?,?,?,?,?,?,?,?,?,?)");
            ps.setShort(1, (short)1);
            ps.setInt(2, 1);
            ps.setLong(3, 1L);
            ps.setFloat(4, 1.0f);
            ps.setDouble(5, 1.0);
            ps.setDouble(6, 1.0);
            ps.setString(7, "1");
            ps.setString(8, "1");
            ps.setString(9, "1");
            ps.setString(10, "1");
            ps.executeUpdate();
            ps.close();
            stmt.close();
        }
        catch (SQLException e) {
            con.rollback();
            throw e;
        }
    }

    public void testUpdateString() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateString(i, "2");
            UpdateXXXTest.assertEquals((String)("Expected rs.getDouble(" + i + ") to match updated value"), (int)2, (int)((int)rs.getDouble(i)));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateInt() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateInt(i, 2);
            UpdateXXXTest.assertEquals((String)("Expected rs.getInt(" + i + ") to match updated value"), (int)2, (int)rs.getInt(i));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateLong() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateLong(i, 2L);
            UpdateXXXTest.assertEquals((String)("Expected rs.getLong(" + i + ") to match updated value"), (long)2L, (long)rs.getLong(i));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateShort() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateShort(i, (short)2);
            UpdateXXXTest.assertEquals((String)("Expected rs.getShort(" + i + ") to match updated value"), (int)2, (int)rs.getShort(i));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateFloat() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateFloat(i, 2.0f);
            UpdateXXXTest.assertEquals((String)("Expected rs.getFloat(" + i + ") to match updated value"), (int)2, (int)((int)rs.getFloat(i)));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateDouble() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateDouble(i, 2.0);
            UpdateXXXTest.assertEquals((String)("Expected rs.getDouble(" + i + ") to match updated value"), (int)2, (int)((int)rs.getDouble(i)));
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void jdbc2testUpdateBigDecimal() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateBigDecimal(i, BigDecimal.valueOf(2L));
            UpdateXXXTest.assertEquals((String)("Expected rs.getBigDecimal(" + i + ") to match updated value"), (int)2, (int)rs.getBigDecimal(i).intValue());
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreUpdated();
        s.close();
    }

    public void testUpdateObjectWithNull() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        Object value = null;
        for (int i = 1; i <= 10; ++i) {
            rs.updateObject(i, value);
            UpdateXXXTest.assertNull((String)("Expected rs.getObject(" + i + ") to be null"), (Object)rs.getObject(i));
            UpdateXXXTest.assertTrue((String)"Expected rs.wasNull() to return true", (boolean)rs.wasNull());
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreNull();
        s.close();
    }

    public void testUpdateNull() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            rs.updateNull(i);
            UpdateXXXTest.assertNull((String)("Expected rs.getObject(" + i + ") to be null"), (Object)rs.getObject(i));
            UpdateXXXTest.assertTrue((String)"Expected rs.wasNull() to return true", (boolean)rs.wasNull());
        }
        rs.updateRow();
        rs.close();
        this.checkColumnsAreNull();
        s.close();
    }

    private void checkColumnsAreNull() throws SQLException {
        Statement s = this.createStatement(1003, 1007);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            UpdateXXXTest.assertNull((String)("Expected column " + i + " to be null"), (Object)rs.getObject(i));
            UpdateXXXTest.assertTrue((String)("Expected wasNull() after reading column " + i + " to be true when data is SQL Null on column"), (boolean)rs.wasNull());
        }
        s.close();
    }

    private void checkColumnsAreUpdated() throws SQLException {
        Statement s = this.createStatement(1003, 1007);
        ResultSet rs = s.executeQuery(SELECT_STMT);
        rs.next();
        for (int i = 1; i <= 10; ++i) {
            int expectedVal = 2;
            int actualVal = (int)rs.getDouble(i);
            UpdateXXXTest.assertEquals((String)("Unexpected value from rs.getDouble( + " + i + ")"), (int)expectedVal, (int)actualVal);
        }
        s.close();
    }
}

