/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementJdbc30Test
extends BaseJDBCTestCase {
    private static final String CLIENT_SUITE_NAME = "StatementJdbc30Test:client";

    public StatementJdbc30Test(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("StatementJdbc30Test");
        suite.addTest(StatementJdbc30Test.baseSuite("StatementJdbc30Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(StatementJdbc30Test.baseSuite(CLIENT_SUITE_NAME)));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(StatementJdbc30Test.class);
        if (name.equals(CLIENT_SUITE_NAME)) {
            suite.addTest((Test)new StatementJdbc30Test("xtestMultiExecWithQueryTimeout"));
            suite.addTest((Test)new StatementJdbc30Test("xtestMaxOpenStatementsWithQueryTimeout"));
        }
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table tab1 (i int, s smallint, r real)");
                stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)");
            }
        };
    }

    public void testReadingData() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from tab1");
        StatementJdbc30Test.assertTrue((boolean)rs.next());
        rs.close();
    }

    public void testGetMoreResults() throws SQLException {
        Statement stmt = this.createStatement();
        StatementJdbc30Test.assertFalse((boolean)stmt.getMoreResults(1));
    }

    public void testInsertNoGenKeys() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("insert into tab1 values(2, 3, 4.1)", 2);
        StatementJdbc30Test.assertNull((String)"Expected NULL ResultSet after stmt.execute()", (Object)stmt.getGeneratedKeys());
    }

    public void testExecuteUpdateNoAutoGenColumnIndex() throws SQLException {
        Statement stmt = this.createStatement();
        int[] columnIndexes = new int[]{1, 2};
        try {
            stmt.executeUpdate("insert into tab1 values(2, 3, 4.1)", columnIndexes);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException ex) {
            this.assertFailedExecuteUpdateForColumnIndex(ex);
        }
    }

    public void testExecuteUpdateNoAutoGenColumnName() throws SQLException {
        Statement stmt = this.createStatement();
        String[] columnNames = new String[]{"I", "S"};
        try {
            stmt.executeUpdate("insert into tab1 values(2, 3, 4.1)", columnNames);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException ex) {
            this.assertFailedExecuteUpdateForColumnName(ex);
        }
    }

    public void testSelectNoGenKeys() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("select * from tab1", 2);
        StatementJdbc30Test.assertNull((String)"Expected NULL ResultSet after stmt.execute()", (Object)stmt.getGeneratedKeys());
    }

    public void testExecuteNoAutoGenColumnIndex() throws SQLException {
        Statement stmt = this.createStatement();
        int[] columnIndexes = new int[]{1, 2};
        try {
            stmt.execute("insert into tab1 values(2, 3, 4.1)", columnIndexes);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException ex) {
            this.assertFailedExecuteUpdateForColumnIndex(ex);
        }
    }

    private void assertFailedExecuteUpdateForColumnIndex(SQLException ex) {
        if (StatementJdbc30Test.usingDerbyNetClient()) {
            StatementJdbc30Test.assertSQLState("X0X0D", ex);
        } else {
            StatementJdbc30Test.assertSQLState("X0X0E", ex);
        }
    }

    private void assertFailedExecuteUpdateForColumnName(SQLException ex) {
        if (StatementJdbc30Test.usingDerbyNetClient()) {
            StatementJdbc30Test.assertSQLState("X0X0D", ex);
        } else {
            StatementJdbc30Test.assertSQLState("X0X0F", ex);
        }
    }

    public void testExecuteNoAutoGenColumnName() throws SQLException {
        Statement stmt = this.createStatement();
        String[] columnNames = new String[]{"I", "S"};
        try {
            stmt.executeUpdate("insert into tab1 values(2, 3, 4.1)", columnNames);
            StatementJdbc30Test.fail((String)"FAIL -- executeUpdate should have failed...");
        }
        catch (SQLException ex) {
            this.assertFailedExecuteUpdateForColumnName(ex);
        }
    }

    public void xtestMultiExecWithQueryTimeout() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setQueryTimeout(10);
        for (int i = 0; i < 33000; ++i) {
            ResultSet rs = stmt.executeQuery("VALUES(1)");
            rs.close();
        }
    }

    public void xtestMaxOpenStatementsWithQueryTimeout() throws SQLException {
        int i;
        this.setAutoCommit(false);
        Statement[] stmts = new Statement[16500];
        try {
            for (i = 0; i < 16500; ++i) {
                stmts[i] = this.createStatement();
                stmts[i].setQueryTimeout(10);
                stmts[i].executeQuery("VALUES(1)");
            }
        }
        catch (SQLException e) {
            StatementJdbc30Test.assertSQLState("XJ200", e);
            StatementJdbc30Test.assertTrue((String)("16383 >= (i=" + i + ")"), (16383 >= i ? 1 : 0) != 0);
        }
    }

    public void testGetResultSetHoldability() throws SQLException {
        Statement stmt = this.createStatement();
        StatementJdbc30Test.assertEquals((int)1, (int)stmt.getResultSetHoldability());
    }

    public void testGetGenerateKeys() throws SQLException {
        Statement stmt = this.createStatement();
        StatementJdbc30Test.assertNull((Object)stmt.getGeneratedKeys());
    }
}

