/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.CRC32;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetStreamTest
extends BaseJDBCTestCase {
    private static String filePath;
    private static String sep;
    static final String TEST_STRING_DATA = "ABCDEFG\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00ff\u0100\u3042\u3044\u3046\u3048\u304a";

    public ResultSetStreamTest(String name) {
        super(name);
    }

    public void testInsertData() throws SQLException, Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException, FileNotFoundException, IOException {
                    ResultSetStreamTest.this.insertData();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private void insertData() throws SQLException, FileNotFoundException, IOException {
        Connection conn = this.getConnection();
        PreparedStatement ppw = conn.prepareStatement("insert into t2 (len, data) values (?, ?)");
        filePath = "extin";
        String userDir = System.getProperty("user.dir");
        sep = System.getProperty("file.separator");
        filePath = userDir + sep + filePath;
        File file = new File(filePath + sep + "littleclob.utf");
        int fileSize = (int)file.length();
        BufferedInputStream fileData = new BufferedInputStream(new FileInputStream(file));
        ppw.setInt(1, fileSize);
        ppw.setBinaryStream(2, (InputStream)fileData, fileSize);
        ppw.executeUpdate();
        fileData.close();
        file = new File(filePath + sep + "short.utf");
        fileSize = (int)file.length();
        fileData = new BufferedInputStream(new FileInputStream(file));
        ppw.setInt(1, fileSize);
        ppw.setBinaryStream(2, (InputStream)fileData, fileSize);
        ppw.executeUpdate();
        fileData.close();
        ppw.setInt(1, -1);
        ppw.setBinaryStream(2, (InputStream)null, 0);
        ppw.executeUpdate();
        File rssg = new File(filePath + sep + "resultsetStream.gif");
        int rssgLength = (int)rssg.length();
        ppw.setInt(1, rssgLength);
        fileData = new BufferedInputStream(new FileInputStream(rssg));
        ppw.setBinaryStream(2, (InputStream)fileData, rssgLength);
        ppw.executeUpdate();
        fileData.close();
        byte[] tooFew = new byte[234];
        ppw.setInt(1, 234);
        ppw.setBinaryStream(2, (InputStream)new ByteArrayInputStream(tooFew), 234);
        ppw.executeUpdate();
        ppw.setInt(1, 235);
        ppw.setBinaryStream(2, (InputStream)new ByteArrayInputStream(tooFew), 235);
        try {
            ppw.executeUpdate();
            ResultSetStreamTest.fail((String)"FAIL - execute with setBinaryStream() with too few bytes succeeded");
        }
        catch (SQLException sqle) {
            this.assertMisMatchStreamLength(sqle);
        }
        ppw.setInt(1, 233);
        ppw.setBinaryStream(2, (InputStream)new ByteArrayInputStream(tooFew), 233);
        try {
            ppw.executeUpdate();
            ResultSetStreamTest.fail((String)"FAIL - execute with setBinaryStream() with too many bytes succeeded");
        }
        catch (SQLException sqle) {
            this.assertMisMatchStreamLength(sqle);
        }
        ppw.close();
    }

    private void assertMisMatchStreamLength(SQLException sqle) {
        if (ResultSetStreamTest.usingEmbedded()) {
            ResultSetStreamTest.assertEquals((String)"XSDA4", (String)sqle.getSQLState());
            sqle = sqle.getNextException();
            ResultSetStreamTest.assertSQLState("XJ001", sqle);
        } else {
            String state = sqle.getSQLState();
            ResultSetStreamTest.assertTrue((String)"SQLState not XN015 or XN017 as expected", ("XN015".equals(state) || "XN017".equals(state) ? 1 : 0) != 0);
        }
    }

    public void testBinaryStreamProcessing() throws SQLException, Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException, FileNotFoundException, IOException {
                    ResultSetStreamTest.this.binaryStreamProcessing();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public void binaryStreamProcessing() throws SQLException, IOException {
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        filePath = "extin";
        String userDir = System.getProperty("user.dir");
        sep = System.getProperty("file.separator");
        filePath = userDir + sep + filePath;
        File rssg = new File(filePath + sep + "resultsetStream.gif");
        int rssgLength = (int)rssg.length();
        ResultSet rs = s.executeQuery("select data from t2 where len = " + rssgLength);
        ResultSetMetaData met = rs.getMetaData();
        ResultSetStreamTest.assertEquals((int)1, (int)met.getColumnCount());
        while (rs.next()) {
            int data;
            int count;
            int r;
            InputStream is = rs.getBinaryStream(1);
            if (is == null) {
                ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() return null");
                break;
            }
            byte[] b200 = new byte[200];
            for (count = 0; count < 200 && (r = is.read(b200, count, 200 - count)) != -1; count += r) {
            }
            if (count != 200) {
                ResultSetStreamTest.fail((String)"FAIL - failed to read 200 bytes from known file");
                break;
            }
            CRC32 cs = new CRC32();
            cs.reset();
            cs.update(b200);
            ResultSetStreamTest.assertEquals((String)"Incorrect checksum value", (long)3061553656L, (long)cs.getValue());
            count = 200;
            while (is.read() != -1) {
                ++count;
            }
            ResultSetStreamTest.assertEquals((String)"unexpected size of file", (int)3470, (int)count);
            rs.close();
            rs = s.executeQuery("select data, len from t2 where len = " + rssgLength);
            met = rs.getMetaData();
            ResultSetStreamTest.assertEquals((int)2, (int)met.getColumnCount());
            while (rs.next()) {
                int r2;
                is = rs.getBinaryStream(1);
                if (is == null) {
                    ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() return null");
                    break;
                }
                b200 = new byte[200];
                for (count = 0; count < 200 && (r2 = is.read(b200, count, 200 - count)) != -1; count += r2) {
                }
                if (count != 200) {
                    ResultSetStreamTest.fail((String)"FAIL - failed to read 200 bytes from known file");
                    break;
                }
                cs = new CRC32();
                cs.reset();
                cs.update(b200);
                ResultSetStreamTest.assertEquals((String)"Incorrect checksum value", (long)3061553656L, (long)cs.getValue());
                ResultSetStreamTest.assertEquals((int)3470, (int)rs.getInt(2));
                try {
                    is.read();
                    ResultSetStreamTest.fail((String)("FAIL - stream was not closed after a get*() call. " + is.getClass()));
                    break;
                }
                catch (IOException ioe) {
                }
            }
            rs.close();
            rs = s.executeQuery("select data from t2 where len = -1");
            met = rs.getMetaData();
            ResultSetStreamTest.assertEquals((int)1, (int)met.getColumnCount());
            while (rs.next()) {
                is = rs.getBinaryStream(1);
                if (is == null) continue;
                ResultSetStreamTest.fail((String)"FAIL - getBinaryStream() did not return null for SQL null");
                break;
            }
            rs.close();
            File file = new File(filePath + sep + "short.utf");
            int fileSize = (int)file.length();
            rs = s.executeQuery("select len, data from t2 where len = " + fileSize);
            rs.next();
            fileSize = rs.getInt(1);
            BufferedInputStream fileData = new BufferedInputStream(rs.getBinaryStream(2));
            int readCount = 0;
            while ((data = fileData.read()) != -1) {
                ++readCount;
            }
            fileData.close();
            ResultSetStreamTest.assertEquals((int)56, (int)fileSize);
            ResultSetStreamTest.assertEquals((int)56, (int)readCount);
        }
        rs.close();
        s.close();
    }

    public void testGetAsciiStream() throws SQLException, IOException {
        Connection conn = this.getConnection();
        PreparedStatement st = conn.prepareStatement("insert into t3(text_data) values(?)");
        st.setCharacterStream(1, (Reader)new StringReader(TEST_STRING_DATA), TEST_STRING_DATA.length());
        st.executeUpdate();
        st = conn.prepareStatement("select text_data as text_data_col1,text_data as text_data_col2 from t3");
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            InputStream is = rs.getAsciiStream(1);
            int i = 0;
            int c = is.read();
            while (c > -1) {
                int exp;
                if ((exp = TEST_STRING_DATA.charAt(i++)) > 255) {
                    exp = 63;
                }
                ResultSetStreamTest.assertEquals((int)exp, (int)c);
                c = is.read();
            }
            Statement s = this.createStatement();
            s.executeUpdate("delete from t3");
        }
    }

    public void testGetCharacterStream() throws SQLException, IOException {
        Connection conn = this.getConnection();
        PreparedStatement st = conn.prepareStatement("insert into t3(text_data) values(?)");
        st.setCharacterStream(1, (Reader)new StringReader(TEST_STRING_DATA), TEST_STRING_DATA.length());
        st.executeUpdate();
        st = conn.prepareStatement("select text_data as text_data_col1,text_data as text_data_col2 from t3");
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            Reader r = rs.getCharacterStream(1);
            int i = 0;
            int c = r.read();
            while (c > -1) {
                char exp = TEST_STRING_DATA.charAt(i++);
                ResultSetStreamTest.assertEquals((int)exp, (int)c);
                c = r.read();
            }
        }
        Statement s = this.createStatement();
        s.executeUpdate("delete from t3");
    }

    public void testSetMaxFieldSizeLarge() throws IOException, SQLException {
        int id = 1;
        int clobSize = 0x200000;
        int vcSize = 32672;
        int limit = 10;
        PreparedStatement ps = this.prepareStatement("insert into setMaxFieldSize values (?,?,?)");
        ps.setInt(1, id);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(vcSize), vcSize);
        ps.setCharacterStream(3, (Reader)new LoopingAlphabetReader(clobSize), clobSize);
        ps.executeUpdate();
        Statement stmt = this.createStatement();
        stmt.setMaxFieldSize(limit);
        ResultSet rs = stmt.executeQuery("select dVarchar, dClob from setMaxFieldSize where id = " + id);
        ResultSetStreamTest.assertTrue((boolean)rs.next());
        String vcStr = ResultSetStreamTest.drainStringFromSource(rs.getCharacterStream(1));
        ResultSetStreamTest.assertEquals((int)limit, (int)vcStr.length());
        String vsClob = ResultSetStreamTest.drainStringFromSource(rs.getCharacterStream(2));
        ResultSetStreamTest.assertEquals((int)clobSize, (int)vsClob.length());
        rs.close();
        stmt = this.createStatement();
        rs = stmt.executeQuery("select dVarchar, dClob from setMaxFieldSize where id = " + id);
        ResultSetStreamTest.assertTrue((boolean)rs.next());
        vcStr = ResultSetStreamTest.drainStringFromSource(rs.getCharacterStream(1));
        ResultSetStreamTest.assertEquals((int)vcSize, (int)vcStr.length());
        vsClob = ResultSetStreamTest.drainStringFromSource(rs.getCharacterStream(2));
        ResultSetStreamTest.assertEquals((int)clobSize, (int)vsClob.length());
        rs.close();
    }

    private static String drainStringFromSource(Reader src) throws IOException {
        int read;
        StringBuffer str = new StringBuffer();
        char[] buf = new char[1024];
        while ((read = src.read(buf)) != -1) {
            str.append(buf, 0, read);
        }
        return str.toString();
    }

    public static Test basesuite(String name) {
        TestSuite suite = new TestSuite(ResultSetStreamTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/ResultSetStream/littleclob.utf", "functionTests/testData/ResultSetStream/short.utf", "functionTests/testData/ResultSetStream/resultsetStream.gif"});
        return new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t2 (len int, data LONG VARCHAR FOR BIT DATA)");
                s.execute("create table t3(text_data clob)");
                s.execute("create table setMaxFieldSize(id int unique, dVarchar VARCHAR(32672), dClob clob)");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ResultSetStreamTest");
        suite.addTest(ResultSetStreamTest.basesuite("ResultSetStreamTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ResultSetStreamTest.basesuite("ResultSetStreamTest:client")));
        return suite;
    }
}

