/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobLengthTest
extends BaseJDBCTestCase {
    public LobLengthTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(LobLengthTest.class);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement st = this.createStatement();
        st.execute("create table lobTable100M(bl blob(100M))");
        st.close();
    }

    public void tearDown() throws Exception {
        Statement st = this.createStatement();
        st.execute("drop table lobTable100M");
        st.close();
        this.commit();
        super.tearDown();
    }

    public void testLongLobLengths() throws Exception {
        PreparedStatement pSt = this.prepareStatement("insert into lobTable100M(bl) values (?)");
        int lobSize = 16800000;
        pSt.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(lobSize), lobSize);
        pSt.execute();
        pSt.close();
    }
}

