/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AutoGenJDBC30Test
extends BaseJDBCTestCase {
    private static final String[] ROUTINES = new String[]{"CREATE FUNCTION MMWNI() RETURNS VARCHAR(20) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + AutoGenJDBC30Test.class.getName() + ".MyMethodWithNoInsert'", "CREATE FUNCTION AddMe(P1 INT) RETURNS INT READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + AutoGenJDBC30Test.class.getName() + ".addMe'"};
    private static final String[][] TABLES = new String[][]{{"t11_AutoGen", "create table t11_AutoGen (c11 int, c12 int generated always as identity (increment by 1))"}, {"t31_AutoGen", "create table t31_AutoGen (c31 int, c32 int generated always as identity (increment by 1), c33 int default 2)"}, {"t21_noAutoGen", "create table t21_noAutoGen (c21 int not null unique, c22 char(5))"}};

    public AutoGenJDBC30Test(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AutoGenJDBC30Test");
        suite.addTest(AutoGenJDBC30Test.baseSuite("AutoGenJDBC30Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(AutoGenJDBC30Test.baseSuite("AutoGenJDBC30Test:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        if (!JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        suite.addTestSuite(AutoGenJDBC30Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                for (i = 0; i < ROUTINES.length; ++i) {
                    s.execute(ROUTINES[i]);
                }
                for (i = 0; i < TABLES.length; ++i) {
                    s.execute(TABLES[i][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            s.execute("DELETE FROM " + TABLES[i][0]);
        }
        s.execute("ALTER TABLE t11_AutoGen ALTER COLUMN c12 RESTART WITH 1");
        s.execute("ALTER TABLE t31_AutoGen ALTER COLUMN c32 RESTART WITH 1");
        s.close();
        conn.commit();
    }

    public void testNoSql() throws SQLException {
        Statement s = this.createStatement();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet", (Object)s.getGeneratedKeys());
        s.close();
    }

    public void testSelect() throws SQLException {
        String sql = "select * from t11_AutoGen";
        Statement s = this.createStatement();
        s.execute(sql, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 1);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testInsertManyRowsNoPriorKey() throws SQLException {
        String sqlStmt = "insert into t31_AutoGen(c31) values (99), (98), (97)";
        this.runInsertFourWaysKeyIsNull(sqlStmt);
    }

    public void testInsertManyRowsAfterOneRowKey() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values (99)");
        int expected = 1;
        String sql = "insert into t31_AutoGen(c31) values (99), (98), (97)";
        s.execute(sql, 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)expected, (int)keyval);
        s.executeUpdate(sql, 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)expected, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)expected, (int)keyval);
        ps = this.prepareStatement(sql, 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)expected, (int)keyval);
        ps.close();
    }

    public void testInsertNoAutoGen() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t21_noAutoGen values(21, 'true')");
        s.execute("insert into t21_noAutoGen values(22, 'true')");
        s.execute("insert into t21_noAutoGen values(23, 'true')", 1);
        this.verifyNullKey("s.execute()", s.getGeneratedKeys());
        s.executeUpdate("insert into t21_noAutoGen values(24, 'true')", 1);
        this.verifyNullKey("s.executeUpdate()", s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement("insert into t21_noAutoGen values(25, 'true')", 1);
        ps.execute();
        this.verifyNullKey("PreparedStatement.execute()", ps.getGeneratedKeys());
        ps = this.prepareStatement("insert into t21_noAutoGen values(26, 'true')", 1);
        ps.executeUpdate();
        this.verifyNullKey("ps.executeUpdate()", ps.getGeneratedKeys());
        ps.close();
    }

    public void testInsertSubqueryNoWhereClause() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t21_noAutoGen values(21, 'true')");
        s.close();
        String sql = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen";
        this.runInsertFourWaysKeyIsNull(sql);
    }

    public void testInsertSubqueryWhere1is2() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t21_noAutoGen values(21, 'true')");
        s.close();
        String sql = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen where 1=2";
        this.runInsertFourWaysKeyIsNull(sql);
    }

    public void testInsertSubqueryWhereClause() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t21_noAutoGen(c21,c22) values(23, 'true')");
        s.close();
        String sql = "insert into t11_AutoGen(c11) select c21 from t21_noAutoGen where c21=23";
        this.runInsertFourWaysKeyIsNull(sql);
    }

    public void testInsertOneRowKey() throws SQLException {
        String sql = "insert into t11_AutoGen(c11) values (99)";
        Statement s = this.createStatement();
        s.execute(sql, 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)1, (int)keyval);
        s.executeUpdate(sql, 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)2, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)3, (int)keyval);
        ps = this.prepareStatement(sql, 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)4, (int)keyval);
        ps.close();
    }

    public void testInsertNoGenColAfterOneRowKey() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values (99)");
        int expected = 1;
        s.execute("insert into t21_noAutoGen values(27, 'true')", 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)expected, (int)keyval);
        s.executeUpdate("insert into t21_noAutoGen values(28, 'true')", 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)expected, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement("insert into t21_noAutoGen values(29, 'true')", 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)expected, (int)keyval);
        ps = this.prepareStatement("insert into t21_noAutoGen values(30, 'true')", 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)expected, (int)keyval);
        ps.close();
    }

    public void testUpdate() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values(999)");
        String sqlStmt = "update t11_AutoGen set c11=1";
        s.execute(sqlStmt, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sqlStmt, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sqlStmt, 1);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testDelete() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values(999)");
        String sqlStmt = "delete from t11_AutoGen";
        s.execute(sqlStmt, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sqlStmt, 1);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sqlStmt, 1);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testGetKeyAfterCommit() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values(999)");
        Connection conn = this.getConnection();
        conn.commit();
        int expected = 1;
        s.execute("insert into t21_noAutoGen values(31, 'true')", 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)expected, (int)keyval);
        s.executeUpdate("insert into t21_noAutoGen values(32, 'true')", 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)expected, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement("insert into t21_noAutoGen values(33, 'true')", 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)expected, (int)keyval);
        ps = this.prepareStatement("insert into t21_noAutoGen values(34, 'true')", 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)expected, (int)keyval);
        ps.close();
    }

    public void testGetKeyAfterRollback() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        s.execute("insert into t11_AutoGen(c11) values(999)");
        conn.rollback();
        int expected = 1;
        s.execute("insert into t21_noAutoGen values(35, 'true')", 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)expected, (int)keyval);
        s.executeUpdate("insert into t21_noAutoGen values(36, 'true')", 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)expected, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement("insert into t21_noAutoGen values(37, 'true')", 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)expected, (int)keyval);
        ps = this.prepareStatement("insert into t21_noAutoGen values(38, 'true')", 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"key value after ps.executeUpdate()", (int)expected, (int)keyval);
        ps.close();
    }

    public void testGetKeyAfterSavepointRollback() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        Savepoint savepoint1 = conn.setSavepoint();
        int expected = 1;
        s.execute("insert into t11_AutoGen(c11) values(99)", 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value before rollback", (int)expected, (int)keyval);
        conn.rollback(savepoint1);
        s.execute("insert into t21_noAutoGen values(39, 'true')", 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after rollback", (int)expected, (int)keyval);
        s.close();
    }

    public void testGetKeyMetadataAfterInsert() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t31_AutoGen(c31) values (99)", 1);
        ResultSet rs = s.getGeneratedKeys();
        ResultSetMetaData rsmd = rs.getMetaData();
        AutoGenJDBC30Test.assertEquals((String)"ResultSet column count", (int)1, (int)rsmd.getColumnCount());
        AutoGenJDBC30Test.assertEquals((String)"Column type", (String)"DECIMAL", (String)rsmd.getColumnTypeName(1));
        AutoGenJDBC30Test.assertEquals((String)"Column precision", (int)31, (int)rsmd.getPrecision(1));
        AutoGenJDBC30Test.assertEquals((String)"Column scale", (int)0, (int)rsmd.getScale(1));
        int keyval = this.getKeyValue(rs);
        AutoGenJDBC30Test.assertEquals((String)"Key value", (int)1, (int)keyval);
        rs.close();
        s.close();
    }

    public void testInsertNoGenKeys() throws SQLException {
        Statement s = this.createStatement();
        String sql = "insert into t31_AutoGen(c31) values (99)";
        s.execute(sql, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 2);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, 2);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testInsertJDBC20syntax() throws SQLException {
        Statement s = this.createStatement();
        String sql = "insert into t31_AutoGen(c31) values (99)";
        s.execute(sql);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testUpdateAutoGenNoGenKeys() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t31_AutoGen(c31) values (99)");
        String sql = "update t31_AutoGen set c31=98";
        s.execute(sql, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, 2);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 2);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, 2);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testDeleteAutoGenNoGenKeysJDBC20syntax() throws SQLException {
        Statement s = this.createStatement();
        String sql = "delete from t31_AutoGen";
        s.execute(sql);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate", (Object)s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    public void testInsertNoAutoGenExecuteSQLfunc() throws SQLException {
        Statement s = this.createStatement();
        s.execute("insert into t21_noAutoGen values(40, MMWNI())", 1);
        this.verifyNullKey("First insert", s.getGeneratedKeys());
        this.assertTableRowCount("T21_NOAUTOGEN", 1);
        s.execute("insert into t31_AutoGen(c31) values (99)", 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after insert into t31_AutoGen", (int)1, (int)keyval);
        s.execute("insert into t21_noAutoGen values(42, MMWNI())", 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after insert into t21_noAutoGen", (int)1, (int)keyval);
        this.assertTableRowCount("T21_NOAUTOGEN", 2);
        s.close();
    }

    public void testInsertAutoGenExecuteSQLfunc() throws SQLException {
        String sql = "insert into t31_AutoGen(c31) values (AddMe(1))";
        Statement s = this.createStatement();
        s.execute(sql, 1);
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)1, (int)keyval);
        s.executeUpdate(sql, 1);
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)2, (int)keyval);
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 1);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)3, (int)keyval);
        ps = this.prepareStatement(sql, 1);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)4, (int)keyval);
        ps.close();
    }

    public void testResultSetGarbageCollection() throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement ps = this.prepareStatement("insert into t11_AutoGen(c11) values(?)", 1);
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, 100 + i);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            while (rs.next()) {
                rs.getInt(1);
            }
            rs.close();
            conn.commit();
            System.runFinalization();
            System.gc();
            System.runFinalization();
            System.gc();
        }
    }

    public void testColumnIndexes() throws SQLException {
        int[] colIndexes = new int[]{2};
        this.testUserGivenColumns(colIndexes, null, 1);
        colIndexes = new int[]{1, 2};
        this.testUserGivenColumnsError(colIndexes, null);
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        colIndexes = new int[]{100};
        this.testUserGivenColumnsError(colIndexes, null);
        colIndexes[0] = 1;
        this.testUserGivenColumnsError(colIndexes, null);
        colIndexes = new int[]{2, 2, 2};
        this.testUserGivenColumns(colIndexes, null, 5);
        colIndexes[1] = 100;
        this.testUserGivenColumnsError(colIndexes, null);
        colIndexes[2] = 100;
        this.testUserGivenColumnsError(colIndexes, null);
        colIndexes[1] = 100;
        colIndexes[2] = 1;
        this.testUserGivenColumnsError(colIndexes, null);
    }

    public void testColumnNames() throws SQLException {
        String[] colNames = new String[]{"C12"};
        this.testUserGivenColumns(null, colNames, 1);
        colNames = new String[]{"C12", "C13"};
        this.testUserGivenColumnsError(null, colNames);
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        colNames = new String[]{"NOTTHERE"};
        this.testUserGivenColumnsError(null, colNames);
        colNames[0] = "C11";
        this.testUserGivenColumnsError(null, colNames);
        colNames[0] = null;
        this.testUserGivenColumnsError(null, colNames);
        colNames = new String[]{"C12", "C12", "C12"};
        this.testUserGivenColumns(null, colNames, 5);
        colNames[1] = "NOTTHERE";
        this.testUserGivenColumnsError(null, colNames);
        colNames[1] = "C11";
        this.testUserGivenColumnsError(null, colNames);
        colNames[1] = null;
        this.testUserGivenColumnsError(null, colNames);
        colNames[1] = "C11";
        colNames[2] = "NOTTHERE";
        this.testUserGivenColumnsError(null, colNames);
        colNames[1] = "NOTTHERE";
        colNames[2] = "C11";
        this.testUserGivenColumnsError(null, colNames);
    }

    public void testUserGivenColumnsEmpty() throws SQLException {
        Statement s = this.createStatement();
        String sql = "insert into t11_AutoGen(c11) values (99)";
        s.execute(sql, new String[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, new String[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        PreparedStatement ps = null;
        ps = this.prepareStatement(sql, new String[0]);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, new String[0]);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        s.execute(sql, new int[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, new int[0]);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        if (!AutoGenJDBC30Test.usingEmbedded()) {
            ps = this.prepareStatement(sql, new int[0]);
            ps.execute();
            AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
            ps = this.prepareStatement(sql, new int[0]);
            ps.executeUpdate();
            AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        }
    }

    public void testUserGivenColumnsNull() throws SQLException {
        Statement s = this.createStatement();
        String sql = "insert into t11_AutoGen(c11) values (99)";
        s.execute(sql, (String[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, (String[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        PreparedStatement ps = this.prepareStatement(sql, (String[])null);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, (String[])null);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        if (AutoGenJDBC30Test.usingDerbyNetClient()) {
            return;
        }
        s.execute(sql, (int[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.execute()", (Object)s.getGeneratedKeys());
        s.executeUpdate(sql, (int[])null);
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after s.executeUpdate()", (Object)s.getGeneratedKeys());
        ps = this.prepareStatement(sql, (int[])null);
        ps.execute();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.execute()", (Object)ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, (int[])null);
        ps.executeUpdate();
        AutoGenJDBC30Test.assertNull((String)"Expected NULL ResultSet after ps.executeUpdate()", (Object)ps.getGeneratedKeys());
        ps.close();
    }

    private void testUserGivenColumns(int[] colIndexes, String[] colNames, int expectedVal) throws SQLException {
        AutoGenJDBC30Test.assertTrue((String)"Exactly one of colIndexes or colNames should be null", (boolean)(colIndexes != null ^ colNames != null));
        boolean useIndexes = colIndexes != null;
        Statement s = this.createStatement();
        String sql = "insert into t11_AutoGen(c11) values (99)";
        if (useIndexes) {
            s.execute(sql, colIndexes);
        } else {
            s.execute(sql, colNames);
        }
        int keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.execute()", (int)expectedVal++, (int)keyval);
        if (useIndexes) {
            s.executeUpdate(sql, colIndexes);
        } else {
            s.executeUpdate(sql, colNames);
        }
        keyval = this.getKeyValue(s.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after s.executeUpdate()", (int)expectedVal++, (int)keyval);
        s.close();
        PreparedStatement ps = null;
        ps = useIndexes ? this.prepareStatement(sql, colIndexes) : this.prepareStatement(sql, colNames);
        ps.execute();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.execute()", (int)expectedVal++, (int)keyval);
        ps = useIndexes ? this.prepareStatement(sql, colIndexes) : this.prepareStatement(sql, colNames);
        ps.executeUpdate();
        keyval = this.getKeyValue(ps.getGeneratedKeys());
        AutoGenJDBC30Test.assertEquals((String)"Key value after ps.executeUpdate()", (int)expectedVal++, (int)keyval);
        ps.close();
    }

    private void testUserGivenColumnsError(int[] colIndexes, String[] colNames) throws SQLException {
        String expectedSQLState;
        AutoGenJDBC30Test.assertTrue((String)"Exactly one of colIndexes or colNames should be null.", (boolean)(colIndexes != null ^ colNames != null));
        boolean useIndexes = colIndexes != null;
        String string = expectedSQLState = useIndexes ? "X0X0E" : "X0X0F";
        if (AutoGenJDBC30Test.usingDerbyNetClient() && colNames != null && colNames.length != 1) {
            expectedSQLState = "X0X0D";
        }
        Statement s = this.createStatement();
        String sql = "insert into t11_AutoGen(c11) values (99)";
        try {
            if (useIndexes) {
                s.execute(sql, colIndexes);
            } else {
                s.execute(sql, colNames);
            }
            AutoGenJDBC30Test.fail((String)"Expected s.execute() to fail, but it did not.");
        }
        catch (SQLException se) {
            AutoGenJDBC30Test.assertSQLState(expectedSQLState, se.getSQLState(), se);
        }
        try {
            if (useIndexes) {
                s.executeUpdate(sql, colIndexes);
            } else {
                s.executeUpdate(sql, colNames);
            }
            AutoGenJDBC30Test.fail((String)"Expected s.executeUpdate() to fail, but it did not.");
        }
        catch (SQLException se) {
            AutoGenJDBC30Test.assertSQLState(expectedSQLState, se.getSQLState(), se);
        }
        s.close();
        PreparedStatement ps = null;
        ps = useIndexes ? this.prepareStatement(sql, colIndexes) : this.prepareStatement(sql, colNames);
        try {
            ps.execute();
            AutoGenJDBC30Test.fail((String)"Expected ps.execute() to fail, but it did not.");
        }
        catch (SQLException se) {
            AutoGenJDBC30Test.assertSQLState(expectedSQLState, se.getSQLState(), se);
        }
        try {
            ps.executeUpdate();
            AutoGenJDBC30Test.fail((String)"Expected ps.executeUpdate() to fail, but it did not.");
        }
        catch (SQLException se) {
            AutoGenJDBC30Test.assertSQLState(expectedSQLState, se.getSQLState(), se);
        }
        ps.close();
    }

    public void runInsertFourWaysKeyIsNull(String sql) throws SQLException {
        Statement s = this.createStatement();
        s.execute(sql, 1);
        this.verifyNullKey("After s.execute()", s.getGeneratedKeys());
        s.executeUpdate(sql, 1);
        this.verifyNullKey("After s.executeUpdate()", s.getGeneratedKeys());
        s.close();
        PreparedStatement ps = this.prepareStatement(sql, 1);
        ps.execute();
        this.verifyNullKey("After ps.execute()", ps.getGeneratedKeys());
        ps = this.prepareStatement(sql, 1);
        ps.executeUpdate();
        this.verifyNullKey("ps.executeUpdate()", ps.getGeneratedKeys());
        ps.close();
    }

    public void verifyNullKey(String description, ResultSet r) throws SQLException {
        JDBC.assertGeneratedKeyResultSet(description, r);
        int i = 0;
        while (r.next()) {
            AutoGenJDBC30Test.assertNull((String)description, (Object)r.getString(1));
            ++i;
        }
        AutoGenJDBC30Test.assertEquals((String)description, (int)1, (int)i);
    }

    public int getKeyValue(ResultSet r) throws SQLException {
        JDBC.assertGeneratedKeyResultSet("AutoGenJDBC30Test.getKeyValue", r);
        int i = 0;
        int retval = 0;
        while (r.next()) {
            AutoGenJDBC30Test.assertNotNull((String)"Key value is NULL", (Object)r.getString(1));
            retval = r.getInt(1);
            ++i;
        }
        AutoGenJDBC30Test.assertEquals((String)"ResultSet rows", (int)1, (int)i);
        return retval;
    }

    public static String MyMethodWithNoInsert() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement s = conn.createStatement();
        s.executeQuery("select * from t11_AutoGen");
        s.close();
        conn.close();
        return "true";
    }

    public static int addMe(int p1) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement s = conn.createStatement();
        s.executeQuery("select * from t11_AutoGen");
        s.close();
        conn.close();
        return p1 + p1;
    }
}

