/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.StringUtil;

public class SystemInfo {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    protected static final String _OS_NAME = OS_NAME.toLowerCase();
    public static final boolean isWindows = _OS_NAME.startsWith("windows");
    public static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    public static final boolean isMac = _OS_NAME.startsWith("mac");
    public static final boolean isLinux = _OS_NAME.startsWith("linux");
    public static final boolean isUnix = !isWindows && !isOS2;
    public static final boolean isFileSystemCaseSensitive = isUnix && !isMac;
    public static final boolean isMacOSLion = SystemInfo.isLion();
    public static final boolean isAppleJvm = SystemInfo.isAppleJvm();
    public static final boolean isOracleJvm = SystemInfo.isOracleJvm();
    public static final boolean isSunJvm = SystemInfo.isSunJvm();
    public static final boolean isJetbrainsJvm = SystemInfo.isJetbrainsJvm();

    public static boolean isOsVersionAtLeast(String version) {
        return SystemInfo.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    private static boolean isTiger() {
        return isMac && !OS_VERSION.startsWith("10.0") && !OS_VERSION.startsWith("10.1") && !OS_VERSION.startsWith("10.2") && !OS_VERSION.startsWith("10.3");
    }

    private static boolean isLeopard() {
        return isMac && SystemInfo.isTiger() && !OS_VERSION.startsWith("10.4");
    }

    private static boolean isSnowLeopard() {
        return isMac && SystemInfo.isLeopard() && !OS_VERSION.startsWith("10.5");
    }

    private static boolean isLion() {
        return isMac && SystemInfo.isSnowLeopard() && !OS_VERSION.startsWith("10.6");
    }

    private static boolean isMountainLion() {
        return isMac && SystemInfo.isLion() && !OS_VERSION.startsWith("10.7");
    }

    public static int compareVersionNumbers(String v1, String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        if (part1.length > idx) {
            return 1;
        }
        return -1;
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean isOracleJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Oracle");
    }

    private static boolean isSunJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Sun") && StringUtil.containsIgnoreCase(vendor, "Microsystems");
    }

    private static boolean isAppleJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Apple");
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    private static boolean isJetbrainsJvm() {
        String vendor = System.getProperty("java.vendor");
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "jetbrains");
    }
}

