/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

public class PGCatalogQueryBuilder {
    public static String BuildCatalogQuery(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) throws ErrorException {
        String string = null;
        switch (metadataSourceID) {
            case CATALOG_ONLY: {
                string = PGCatalogQueryBuilder.BuildCatalogOnlyQuery();
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                string = PGCatalogQueryBuilder.BuildCatalogSchemaOnlyQuery();
                break;
            }
            case TABLES: {
                string = PGCatalogQueryBuilder.BuildTablesQuery(map, pGJDBCSettings);
                break;
            }
            case TABLE_PRIVILEGES: {
                string = PGCatalogQueryBuilder.BuildTablePriviledgesQuery(map);
                break;
            }
            case COLUMNS: {
                string = PGCatalogQueryBuilder.BuildColumnsQuery(map, pGJDBCSettings);
                break;
            }
            case FOREIGN_KEYS: {
                string = PGCatalogQueryBuilder.BuildForeignKeysQuery(map);
                break;
            }
            case PRIMARY_KEYS: {
                string = PGCatalogQueryBuilder.BuildPrimaryKeysQuery(map);
                break;
            }
            case PROCEDURES: {
                string = PGCatalogQueryBuilder.BuildProceduresQuery(map);
                break;
            }
            case PROCEDURE_COLUMNS: {
                string = PGCatalogQueryBuilder.BuildProcedureColumnsQuery(map);
                break;
            }
            case FUNCTIONS_JDBC4: {
                string = PGCatalogQueryBuilder.BuildFunctionsQuery(map);
                break;
            }
            default: {
                string = "Query not support";
            }
        }
        return string;
    }

    public static String buildProcedureColumnsQueryForOldPostgres(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT PROCEDURE_CAT , PROCEDURE_SCHEM , PROCEDURE_NAME, COLUMN_NAME,  COLUMN_TYPE, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, LENGTH , DECIMAL_DIGITS ,   NUM_PREC_RADIX , NULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB,  CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SPECIFIC_NAME   FROM (");
        stringBuilder.append("SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(CASE ((array_upper(proargnames, 0) - array_lower(proargnames, 0)) > 0)  WHEN 't' THEN proargnames[array_upper(proargnames, 1)]  ELSE ''  END AS VARCHAR(256)) AS COLUMN_NAME,  CAST(CASE p.proretset  WHEN 't' THEN 3  ELSE 0  END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN 'timestamptz' THEN 93  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF,  CAST(CASE  pg_catalog.format_type(p.prorettype, NULL) WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.prooid AS SPECIFIC_NAME,  p.prooid as PROOID,  -1 AS PROARGINDEX  FROM pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  WHERE pg_catalog.format_type(p.prorettype, NULL) != 'void' ");
        if (null != string && !string.isEmpty()) {
            stringBuilder.append(" AND  n.nspname LIKE ?");
            if (null != string2 && !string2.isEmpty()) {
                stringBuilder.append(" AND  proname LIKE ?");
            }
        } else if (null != string2 && !string2.isEmpty()) {
            stringBuilder.append(" AND  proname LIKE ? ");
        }
        stringBuilder.append(" UNION ALL ");
        stringBuilder.append(" SELECT DISTINCT current_database() AS PROCEDURE_CAT,  PROCEDURE_SCHEM,  PROCEDURE_NAME, CAST(CASE (char_length(COLUMN_NAME) > 0) WHEN 't' THEN COLUMN_NAME ELSE '' END AS VARCHAR(256)) AS COLUMN_NAME,  CAST( CASE COLUMN_TYPE  WHEN 98 THEN 1  WHEN 111 THEN 2  ELSE 0 END AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE DATA_TYPE  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  ELSE 12  END AS SMALLINT) AS DATA_TYPE,  TYPE_NAME,  CASE COLUMN_SIZE  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE LENGTH  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF, CAST( CASE SQL_DATA_TYPE WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  PROARGINDEX AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  SPECIFIC_NAME, PROOID, PROARGINDEX  FROM (  SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CASE WHEN (proallargtypes is NULL) THEN proargnames[pos+1]  ELSE proargnames[pos] END AS COLUMN_NAME, CASE WHEN proargmodes is NULL THEN proargtypes[pos]  ELSE CAST(proargmodes[pos] AS INT) END AS COLUMN_TYPE,  CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DATA_TYPE, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL)  ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS TYPE_NAME, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS COLUMN_SIZE, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS LENGTH, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS DECIMAL_DIGITS, CASE WHEN proallargtypes is NULL THEN pg_catalog.format_type(proargtypes[pos], NULL) ELSE pg_catalog.format_type(proallargtypes[pos], NULL) END AS RADIX, CAST(2 AS SMALLINT) AS NULLABLE, CAST(''AS VARCHAR(256)) AS REMARKS, CAST(NULL AS SMALLINT) AS COLUMN_DEF, pg_catalog.format_type(proargtypes[pos], NULL) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, pg_catalog.format_type(proargtypes[pos], NULL) AS CHAR_OCTET_LENGTH, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS ORDINAL_POSITION, CAST('' AS VARCHAR(256)) AS IS_NULLABLE, p.prooid AS PROOID, CASE WHEN (proallargtypes is NULL) THEN pos+1 WHEN pos = array_upper(proallargtypes, 1) THEN 0 ELSE pos END AS PROARGINDEX,  p.proname || '_' || p.prooid AS SPECIFIC_NAME  FROM (pg_catalog.pg_proc_info p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace) LEFT JOIN (SELECT  CASE WHEN (proallargtypes IS NULL)  THEN generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1))-1 ELSE generate_series(array_lower(proargnames, 1), array_upper(proargnames, 1)+1)-1  END AS pos FROM pg_catalog.pg_proc_info p ) AS s ON (pos >= 0 AND pos <= pronargs+1)");
        if (null != string && !string.isEmpty()) {
            stringBuilder.append(" WHERE  n.nspname LIKE ?");
            if (null != string2 && !string2.isEmpty()) {
                stringBuilder.append(" AND  proname LIKE ?");
            }
        } else if (null != string2 && !string2.isEmpty()) {
            stringBuilder.append(" WHERE  proname LIKE ?");
        }
        stringBuilder.append(" ) AS INPUT_PARAM_TABLE WHERE ORDINAL_POSITION IS NOT NULL ) AS RESULT_SET WHERE (DATA_TYPE IS NOT NULL OR (TYPE_NAME IS NOT NULL AND TYPE_NAME != '-')) ORDER BY PROCEDURE_CAT ,PROCEDURE_SCHEM, PROCEDURE_NAME, PROOID, PROARGINDEX, COLUMN_TYPE DESC");
        return stringBuilder.toString();
    }

    private static String BuildCatalogOnlyQuery() {
        String string = "SELECT * FROM(select CAST(current_database() AS VARCHAR(124)) AS \"TABLE_CAT\") S ";
        return string;
    }

    private static String BuildCatalogSchemaOnlyQuery() {
        String string = "SELECT * FROM (select CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, CAST(nspname AS VARCHAR(124)) AS TABLE_SCHEM, CAST(NULL AS VARCHAR(124)) AS TABLE_NAME, CAST(NULL AS VARCHAR(124)) AS TABLE_TYPE, CAST('' AS VARCHAR(250)) AS REMARKS FROM pg_catalog.pg_namespace n WHERE true AND nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_' OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_' OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_'))) S ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return string;
    }

    private static String BuildColumnsQuery(Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) {
        if (pGJDBCSettings.m_hasExtSchemaPatternMatch) {
            return PGCatalogQueryBuilder.BuildColumnsQueryNew(map, pGJDBCSettings);
        }
        return PGCatalogQueryBuilder.BuildColumnsQueryOld(map, pGJDBCSettings);
    }

    private static String BuildColumnsQueryOld(Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ( ");
        stringBuilder.append("SELECT current_database() AS TABLE_CAT, ");
        stringBuilder.append("n.nspname , ");
        stringBuilder.append("c.relname as TABLE_NAME , ");
        stringBuilder.append("a.attname as COLUMN_NAME, ");
        stringBuilder.append("CAST(case typname ");
        stringBuilder.append("when 'text' THEN 12 ");
        stringBuilder.append("when 'bit' THEN -7 ");
        stringBuilder.append("when 'bool' THEN -7 ");
        stringBuilder.append("when 'varchar' THEN 12 ");
        stringBuilder.append("when 'character varying' THEN 12 ");
        stringBuilder.append("when 'char' THEN 1 ");
        stringBuilder.append("when 'character' THEN 1 ");
        stringBuilder.append("when 'nchar' THEN 1 ");
        stringBuilder.append("when 'bpchar' THEN 1 ");
        stringBuilder.append("when 'nvarchar' THEN 1 ");
        stringBuilder.append("when 'date' THEN 91 ");
        stringBuilder.append("when 'timestamp' THEN 93 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 4 ");
        stringBuilder.append("when 'int' THEN 4 ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'bigint' THEN -5 ");
        stringBuilder.append("when 'int8' THEN -5 ");
        stringBuilder.append("when 'decimal' THEN 3 ");
        stringBuilder.append("when 'real' THEN 7 ");
        stringBuilder.append("when 'float4' THEN 7 ");
        stringBuilder.append("when 'double precision' THEN 8 ");
        stringBuilder.append("when 'float8' THEN 8 ");
        stringBuilder.append("when 'float' THEN 6 ");
        stringBuilder.append("when 'numeric' THEN 2 ");
        stringBuilder.append("when '_float4' THEN 2003 ");
        stringBuilder.append("when 'timestamptz' THEN 93 ");
        stringBuilder.append("when '_aclitem' THEN 2003 ");
        stringBuilder.append("when '_text' THEN 2003 ");
        stringBuilder.append("when 'bytea' THEN -2 ");
        stringBuilder.append("when 'oid' THEN -5 ");
        stringBuilder.append("when 'name' THEN 12 ");
        stringBuilder.append("when '_int4' THEN 2003 ");
        stringBuilder.append("when '_int2' THEN 2003 ");
        stringBuilder.append("else 1111 END as SMALLINT) AS DATA_TYPE, ");
        stringBuilder.append("t.typname as TYPE_NAME, ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bit' THEN 1 ");
        stringBuilder.append("when 'bool' THEN 1 ");
        stringBuilder.append("when 'varchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'character varying' THEN atttypmod -4 ");
        stringBuilder.append("when 'char' THEN atttypmod -4 ");
        stringBuilder.append("when 'character' THEN atttypmod -4 ");
        stringBuilder.append("when 'nchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'bpchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'nvarchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'date' THEN 13 ");
        stringBuilder.append("when 'timestamp' THEN 29 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 10 ");
        stringBuilder.append("when 'int' THEN 10 ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bigint' THEN 19 ");
        stringBuilder.append("when 'int8' THEN 19 ");
        stringBuilder.append("when 'decimal' then (atttypmod - 4) >> 16 ");
        stringBuilder.append("when 'real' THEN 8 ");
        stringBuilder.append("when 'float4' THEN 8 ");
        stringBuilder.append("when 'double precision' THEN 17 ");
        stringBuilder.append("when 'float8' THEN 17 ");
        stringBuilder.append("when 'float' THEN 17 ");
        stringBuilder.append("when 'numeric' THEN (atttypmod - 4) >> 16 ");
        stringBuilder.append("when '_float4' THEN 8 ");
        stringBuilder.append("when 'timestamptz' THEN 35 ");
        stringBuilder.append("when 'oid' THEN 10 ");
        stringBuilder.append("when '_int4' THEN 10 ");
        stringBuilder.append("when '_int2' THEN 5 ");
        if (pGJDBCSettings.m_unknownLength == null) {
            stringBuilder.append("else 2147483647 end as COLUMN_SIZE , ");
        } else {
            stringBuilder.append("else ");
            stringBuilder.append(pGJDBCSettings.m_unknownLength);
            stringBuilder.append(" end as COLUMN_SIZE , ");
        }
        stringBuilder.append("null as BUFFER_LENGTH , ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'float4' then 8 ");
        stringBuilder.append("when 'float8' then 17 ");
        stringBuilder.append("when 'numeric' then (atttypmod - 4) & 65535 ");
        stringBuilder.append("when 'timestamp' then 6 ");
        stringBuilder.append("else 0 end as DECIMAL_DIGITS, ");
        stringBuilder.append("10 AS NUM_PREC_RADIX , ");
        stringBuilder.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        stringBuilder.append("when 'false' then 1 ");
        stringBuilder.append("when NULL then 2 ");
        stringBuilder.append("else 0 end AS NULLABLE , ");
        stringBuilder.append("dsc.description as REMARKS , ");
        stringBuilder.append("pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS COLUMN_DEF, ");
        stringBuilder.append("CAST(case typname ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'text' THEN 12 ");
        stringBuilder.append("when 'bit' THEN -7 ");
        stringBuilder.append("when 'bool' THEN -7 ");
        stringBuilder.append("when 'varchar' THEN 12 ");
        stringBuilder.append("when 'character varying' THEN 12 ");
        stringBuilder.append("when 'char' THEN 1 ");
        stringBuilder.append("when 'character' THEN 1 ");
        stringBuilder.append("when 'nchar' THEN 1 ");
        stringBuilder.append("when 'bpchar' THEN 1 ");
        stringBuilder.append("when 'nvarchar' THEN 1 ");
        stringBuilder.append("when 'date' THEN 91 ");
        stringBuilder.append("when 'timestamp' THEN 93 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 4 ");
        stringBuilder.append("when 'int' THEN 4 ");
        stringBuilder.append("when 'int4' THEN 4 ");
        stringBuilder.append("when 'bigint' THEN -5 ");
        stringBuilder.append("when 'int8' THEN -5 ");
        stringBuilder.append("when 'decimal' THEN 3 ");
        stringBuilder.append("when 'real' THEN 7 ");
        stringBuilder.append("when 'float4' THEN 7 ");
        stringBuilder.append("when 'double precision' THEN 8 ");
        stringBuilder.append("when 'float8' THEN 8 ");
        stringBuilder.append("when 'float' THEN 6 ");
        stringBuilder.append("when 'numeric' THEN 2 ");
        stringBuilder.append("when '_float4' THEN 2003 ");
        stringBuilder.append("when 'timestamptz' THEN 93 ");
        stringBuilder.append("when '_aclitem' THEN 2003 ");
        stringBuilder.append("when '_text' THEN 2003 ");
        stringBuilder.append("when 'bytea' THEN -2 ");
        stringBuilder.append("when 'oid' THEN -5 ");
        stringBuilder.append("when 'name' THEN 12 ");
        stringBuilder.append("when '_int4' THEN 2003 ");
        stringBuilder.append("when '_int2' THEN 2003 ");
        stringBuilder.append("else 1111 END as SMALLINT) AS SQL_DATA_TYPE, ");
        stringBuilder.append("CAST(NULL AS SMALLINT) as SQL_DATETIME_SUB , ");
        stringBuilder.append("case typname ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bit' THEN 1 ");
        stringBuilder.append("when 'bool' THEN 1 ");
        stringBuilder.append("when 'varchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'character varying' THEN atttypmod -4 ");
        stringBuilder.append("when 'char' THEN atttypmod -4 ");
        stringBuilder.append("when 'character' THEN atttypmod -4 ");
        stringBuilder.append("when 'nchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'bpchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'nvarchar' THEN atttypmod -4 ");
        stringBuilder.append("when 'date' THEN 13 ");
        stringBuilder.append("when 'timestamp' THEN 29 ");
        stringBuilder.append("when 'smallint' THEN 5 ");
        stringBuilder.append("when 'int2' THEN 5 ");
        stringBuilder.append("when 'integer' THEN 10 ");
        stringBuilder.append("when 'int' THEN 10 ");
        stringBuilder.append("when 'int4' THEN 10 ");
        stringBuilder.append("when 'bigint' THEN 19 ");
        stringBuilder.append("when 'int8' THEN 19 ");
        stringBuilder.append("when 'decimal' then ((atttypmod - 4) >> 16) & 65535 ");
        stringBuilder.append("when 'real' THEN 8 ");
        stringBuilder.append("when 'float4' THEN 8 ");
        stringBuilder.append("when 'double precision' THEN 17 ");
        stringBuilder.append("when 'float8' THEN 17 ");
        stringBuilder.append("when 'float' THEN 17 ");
        stringBuilder.append("when 'numeric' THEN ((atttypmod - 4) >> 16) & 65535 ");
        stringBuilder.append("when '_float4' THEN 8 ");
        stringBuilder.append("when 'timestamptz' THEN 35 ");
        stringBuilder.append("when 'oid' THEN 10 ");
        stringBuilder.append("when '_int4' THEN 10 ");
        stringBuilder.append("when '_int2' THEN 5 ");
        if (pGJDBCSettings.m_unknownLength == null) {
            stringBuilder.append("else 2147483647 end as CHAR_OCTET_LENGTH , ");
        } else {
            stringBuilder.append("else ");
            stringBuilder.append(pGJDBCSettings.m_unknownLength);
            stringBuilder.append(" end as CHAR_OCTET_LENGTH , ");
        }
        stringBuilder.append("a.attnum AS ORDINAL_POSITION, ");
        stringBuilder.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        stringBuilder.append("when 'false' then 'YES' ");
        stringBuilder.append("else 'NO' end AS IS_NULLABLE, ");
        stringBuilder.append("null as SCOPE_CATLOG , ");
        stringBuilder.append("null as SCOPE_SCHEMA , ");
        stringBuilder.append("null as SCOPE_TABLE, ");
        stringBuilder.append("t.typbasetype AS SOURCE_DATA_TYPE , ");
        stringBuilder.append("'NO' as IS_AUTOINCREMENT ");
        stringBuilder.append("FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid) ");
        stringBuilder.append("JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) ");
        stringBuilder.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid) ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class') ");
        stringBuilder.append("LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog') ");
        stringBuilder.append("WHERE a.attnum > 0 AND NOT a.attisdropped    ");
        if (null != string && !string.equals("")) {
            stringBuilder.append(" AND n.nspname LIKE ? ");
        } else {
            stringBuilder.append(" AND n.nspname LIKE '%' ");
        }
        if (null != string2 && !string2.equals("")) {
            stringBuilder.append(" AND c.relname LIKE ? ");
        }
        if (null != string3 && !string3.equals("")) {
            stringBuilder.append(" AND attname LIKE ? ");
        }
        stringBuilder.append(" ORDER BY nspname,c.relname,attnum  )");
        stringBuilder.append(" UNION ALL ");
        stringBuilder.append("SELECT current_database()::VARCHAR(128) AS TABLE_CAT, ");
        stringBuilder.append("schemaname::varchar(128) AS table_schema, ");
        stringBuilder.append("tablename::varchar(128) AS table_name, ");
        stringBuilder.append("columnname::varchar(128) AS column_name, ");
        stringBuilder.append("CAST(CASE columntype_rep ");
        stringBuilder.append("WHEN 'text' THEN 12 ");
        stringBuilder.append("WHEN 'bit' THEN -7 ");
        stringBuilder.append("WHEN 'bool' THEN -7 ");
        stringBuilder.append("WHEN 'boolean' THEN -7 ");
        stringBuilder.append("WHEN 'varchar' THEN 12 ");
        stringBuilder.append("WHEN 'character varying' THEN 12 ");
        stringBuilder.append("WHEN 'char' THEN 1 ");
        stringBuilder.append("WHEN 'character' THEN 1 ");
        stringBuilder.append("WHEN 'nchar' THEN 1 ");
        stringBuilder.append("WHEN 'bpchar' THEN 1 ");
        stringBuilder.append("WHEN 'nvarchar' THEN 1 ");
        stringBuilder.append("WHEN '\"char\"' THEN 1 ");
        stringBuilder.append("WHEN 'date' THEN 91 ");
        stringBuilder.append("WHEN 'timestamp' THEN 93 ");
        stringBuilder.append("WHEN 'timestamp without time zone' THEN 93 ");
        stringBuilder.append("WHEN 'timestamp with time zone' THEN 2014 ");
        stringBuilder.append("WHEN 'smallint' THEN 5 ");
        stringBuilder.append("WHEN 'int2' THEN 5 ");
        stringBuilder.append("WHEN 'integer' THEN 4 ");
        stringBuilder.append("WHEN 'int' THEN 4 WHEN 'int4' THEN 4 ");
        stringBuilder.append("WHEN 'bigint' THEN -5 ");
        stringBuilder.append("WHEN 'int8' THEN -5 ");
        stringBuilder.append("WHEN 'decimal' THEN 3 ");
        stringBuilder.append("WHEN 'real' THEN 7 ");
        stringBuilder.append("WHEN 'float4' THEN 7 ");
        stringBuilder.append("WHEN 'double precision' THEN 8 ");
        stringBuilder.append("WHEN 'float8' THEN 8 ");
        stringBuilder.append("WHEN 'float' THEN 6 ");
        stringBuilder.append("WHEN 'numeric' THEN 2 ");
        stringBuilder.append("WHEN 'timestamptz' THEN 2014 ");
        stringBuilder.append("WHEN 'bytea' THEN -2 ");
        stringBuilder.append("WHEN 'oid' THEN -5 ");
        stringBuilder.append("WHEN 'name' THEN 12 ");
        stringBuilder.append("WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS DATA_TYPE, ");
        stringBuilder.append("COALESCE(NULL,CASE columntype WHEN 'boolean' THEN 'bool' ");
        stringBuilder.append("WHEN 'character varying' THEN 'varchar' ");
        stringBuilder.append("WHEN '\"char\"' THEN 'char' ");
        stringBuilder.append("WHEN 'smallint' THEN 'int2' ");
        stringBuilder.append("WHEN 'integer' THEN 'int4'");
        stringBuilder.append("WHEN 'bigint' THEN 'int8' ");
        stringBuilder.append("WHEN 'real' THEN 'float4' ");
        stringBuilder.append("WHEN 'double precision' THEN 'float8' ");
        stringBuilder.append("WHEN 'timestamp without time zone' THEN 'timestamp' ");
        stringBuilder.append("WHEN 'timestamp with time zone' THEN 'timestamptz' ");
        stringBuilder.append("ELSE columntype END) AS TYPE_NAME,  ");
        stringBuilder.append("CASE columntype_rep ");
        stringBuilder.append("WHEN 'int4' THEN 10  ");
        stringBuilder.append("WHEN 'bit' THEN 1    ");
        stringBuilder.append("WHEN 'bool' THEN 1");
        stringBuilder.append("WHEN 'boolean' THEN 1");
        stringBuilder.append("WHEN 'varchar' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'character varying' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'char' THEN regexp_substr (columntype,'[0-9]+',4)::INTEGER ");
        stringBuilder.append("WHEN 'character' THEN regexp_substr (columntype,'[0-9]+',4)::INTEGER ");
        stringBuilder.append("WHEN 'nchar' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'bpchar' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'nvarchar' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'date' THEN 13 ");
        stringBuilder.append("WHEN 'timestamp' THEN 29 ");
        stringBuilder.append("WHEN 'timestamp without time zone' THEN 29 ");
        stringBuilder.append("WHEN 'smallint' THEN 5 ");
        stringBuilder.append("WHEN 'int2' THEN 5 ");
        stringBuilder.append("WHEN 'integer' THEN 10 ");
        stringBuilder.append("WHEN 'int' THEN 10 ");
        stringBuilder.append("WHEN 'int4' THEN 10 ");
        stringBuilder.append("WHEN 'bigint' THEN 19 ");
        stringBuilder.append("WHEN 'int8' THEN 19 ");
        stringBuilder.append("WHEN 'decimal' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN 'real' THEN 8 ");
        stringBuilder.append("WHEN 'float4' THEN 8 ");
        stringBuilder.append("WHEN 'double precision' THEN 17 ");
        stringBuilder.append("WHEN 'float8' THEN 17 ");
        stringBuilder.append("WHEN 'float' THEN 17");
        stringBuilder.append("WHEN 'numeric' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN '_float4' THEN 8 ");
        stringBuilder.append("WHEN 'timestamptz' THEN 35 ");
        stringBuilder.append("WHEN 'timestamp with time zone' THEN 35 ");
        stringBuilder.append("WHEN 'oid' THEN 10 ");
        stringBuilder.append("WHEN '_int4' THEN 10 ");
        stringBuilder.append("WHEN '_int2' THEN 5 ");
        stringBuilder.append("ELSE 2147483647 END AS COLUMN_SIZE,  NULL AS BUFFER_LENGTH, CASE columntype ");
        stringBuilder.append("WHEN 'real' THEN 8 ");
        stringBuilder.append("WHEN 'float4' THEN 8 ");
        stringBuilder.append("WHEN 'double precision' THEN 17 ");
        stringBuilder.append("WHEN 'float8' THEN 17 ");
        stringBuilder.append("WHEN 'timestamp' THEN 6 ");
        stringBuilder.append("WHEN 'timestamp without time zone' THEN 6 ");
        stringBuilder.append("ELSE 0 END AS DECIMAL_DIGITS, 10 AS NUM_PREC_RADIX, ");
        stringBuilder.append("NULL AS NULLABLE,  NULL AS REMARKS,   NULL AS COLUMN_DEF, ");
        stringBuilder.append("CAST(CASE columntype_rep ");
        stringBuilder.append("WHEN 'text' THEN 12 ");
        stringBuilder.append("WHEN 'bit' THEN -7 ");
        stringBuilder.append("WHEN 'bool' THEN -7 ");
        stringBuilder.append("WHEN 'boolean' THEN -7 ");
        stringBuilder.append("WHEN 'varchar' THEN 12 ");
        stringBuilder.append("WHEN 'character varying' THEN 12 ");
        stringBuilder.append("WHEN 'char' THEN 1 ");
        stringBuilder.append("WHEN 'character' THEN 1 ");
        stringBuilder.append("WHEN 'nchar' THEN 1 ");
        stringBuilder.append("WHEN 'bpchar' THEN 1 ");
        stringBuilder.append("WHEN 'nvarchar' THEN 1 ");
        stringBuilder.append("WHEN '\"char\"' THEN 1 ");
        stringBuilder.append("WHEN 'date' THEN 91 ");
        stringBuilder.append("WHEN 'timestamp' THEN 93 ");
        stringBuilder.append("WHEN 'timestamp without time zone' THEN 93 ");
        stringBuilder.append("WHEN 'timestamp with time zone' THEN 2014 ");
        stringBuilder.append("WHEN 'smallint' THEN 5 ");
        stringBuilder.append("WHEN 'int2' THEN 5 ");
        stringBuilder.append("WHEN 'integer' THEN 4 ");
        stringBuilder.append("WHEN 'int' THEN 4 ");
        stringBuilder.append("WHEN 'int4' THEN 4 ");
        stringBuilder.append("WHEN 'bigint' THEN -5 ");
        stringBuilder.append("WHEN 'int8' THEN -5 ");
        stringBuilder.append("WHEN 'decimal' THEN 3 ");
        stringBuilder.append("WHEN 'real' THEN 7 ");
        stringBuilder.append("WHEN 'float4' THEN 7 ");
        stringBuilder.append("WHEN 'double precision' THEN 8 ");
        stringBuilder.append("WHEN 'float8' THEN 8 ");
        stringBuilder.append("WHEN 'float' THEN 6 ");
        stringBuilder.append("WHEN 'numeric' THEN 2 ");
        stringBuilder.append("WHEN 'timestamptz' THEN 2014 ");
        stringBuilder.append("WHEN 'bytea' THEN -2 ");
        stringBuilder.append("WHEN 'oid' THEN -5 ");
        stringBuilder.append("WHEN 'name' THEN 12 ");
        stringBuilder.append("WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, ");
        stringBuilder.append("CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE ");
        stringBuilder.append("WHEN LEFT (columntype,7) = 'varchar' THEN regexp_substr (columntype,'[0-9]+',7)::INTEGER ");
        stringBuilder.append("WHEN LEFT (columntype,4) = 'char' THEN regexp_substr (columntype,'[0-9]+',4)::INTEGER ");
        stringBuilder.append("WHEN columntype = 'string' THEN 16383  ELSE NULL ");
        stringBuilder.append("END AS CHAR_OCTET_LENGTH, columnnum AS ORDINAL_POSITION, ");
        stringBuilder.append("NULL AS IS_NULLABLE,  NULL AS SCOPE_CATLOG,  NULL AS SCOPE_SCHEMA, ");
        stringBuilder.append("NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, 'NO' AS IS_AUTOINCREMENT ");
        stringBuilder.append("FROM (select lbv_cols.schemaname, ");
        stringBuilder.append("lbv_cols.tablename, lbv_cols.columnname,");
        stringBuilder.append("REGEXP_REPLACE(REGEXP_REPLACE(lbv_cols.columntype,'\\\\(.*\\\\)'),'^_.+','ARRAY') as columntype_rep,");
        stringBuilder.append("columntype, ");
        stringBuilder.append("lbv_cols.columnnum ");
        stringBuilder.append("from pg_get_late_binding_view_cols() lbv_cols( ");
        stringBuilder.append("schemaname name, tablename name, columnname name, ");
        stringBuilder.append("columntype text, columnnum int)) lbv_columns  ");
        stringBuilder.append(" WHERE ");
        if (null != string && !string.equals("")) {
            stringBuilder.append(" table_schema LIKE ? ");
        } else {
            stringBuilder.append(" table_schema LIKE '%' ");
        }
        if (null != string2 && !string2.equals("")) {
            stringBuilder.append(" AND table_name LIKE ? ");
        }
        if (null != string3 && !string3.equals("")) {
            stringBuilder.append(" AND column_name LIKE ? ");
        }
        return stringBuilder.toString();
    }

    private static String BuildColumnsQueryNew(Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string && !string.equals("")) {
            return PGCatalogQueryBuilder.BuildColumnsQueryExternal(map, pGJDBCSettings);
        }
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string4 = pGJDBCSettings.m_unknownLength != null ? String.valueOf(pGJDBCSettings.m_unknownLength) : "2147483647";
        StringBuilder stringBuilder = new StringBuilder(8192);
        stringBuilder.append("SELECT current_database()::varchar(128) AS TABLE_CAT, table_schema, table_name, COLUMN_NAME, CAST(CASE regexp_replace(data_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 1 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'timestamptz' THEN 2014 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS DATA_TYPE, COALESCE( domain_name, CASE data_type WHEN 'boolean' THEN 'bool' WHEN 'character varying' THEN 'varchar' WHEN '\"char\"' THEN 'char' WHEN 'smallint' THEN 'int2' WHEN 'integer' THEN 'int4' WHEN 'bigint' THEN 'int8' WHEN 'real' THEN 'float4' WHEN 'double precision' THEN 'float8' WHEN 'timestamp without time zone' THEN 'timestamp' WHEN 'timestamp with time zone' THEN 'timestamptz' ELSE data_type END) AS TYPE_NAME, CASE data_type WHEN 'int4' THEN 10 WHEN 'bit' THEN 1 WHEN 'bool' THEN 1 WHEN 'boolean' THEN 1 WHEN 'varchar' THEN character_maximum_length WHEN 'character varying' THEN character_maximum_length WHEN 'char' THEN character_maximum_length WHEN 'character' THEN character_maximum_length WHEN 'nchar' THEN character_maximum_length WHEN 'bpchar' THEN character_maximum_length WHEN 'nvarchar' THEN character_maximum_length WHEN 'date' THEN 13 WHEN 'timestamp' THEN 29 WHEN 'timestamp without time zone' THEN 29 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 10 WHEN 'int' THEN 10 WHEN 'int4' THEN 10 WHEN 'bigint' THEN 19 WHEN 'int8' THEN 19 WHEN 'decimal' THEN numeric_precision WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'float' THEN 17 WHEN 'numeric' THEN numeric_precision WHEN '_float4' THEN 8 WHEN 'timestamptz' THEN 35 WHEN 'timestamp with time zone' THEN 35 WHEN 'oid' THEN 10 WHEN '_int4' THEN 10 WHEN '_int2' THEN 5 ELSE " + string4 + " END AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, CASE data_type WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'numeric' THEN numeric_scale WHEN 'timestamp' THEN 6 WHEN 'timestamp without time zone' THEN 6 ELSE 0 END AS DECIMAL_DIGITS, 10 AS NUM_PREC_RADIX, CASE is_nullable WHEN 'YES' THEN 1 ELSE 0 end AS NULLABLE, REMARKS, column_default AS COLUMN_DEF, CAST(CASE regexp_replace(data_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 1 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'timestamptz' THEN 2014 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE data_type WHEN 'int4' THEN 10 WHEN 'bit' THEN 1 WHEN 'bool' THEN 1 WHEN 'boolean' THEN 1 WHEN 'varchar' THEN character_maximum_length WHEN 'character varying' THEN character_maximum_length WHEN 'char' THEN character_maximum_length WHEN 'character' THEN character_maximum_length WHEN 'nchar' THEN character_maximum_length WHEN 'bpchar' THEN character_maximum_length WHEN 'nvarchar' THEN character_maximum_length WHEN 'date' THEN 13 WHEN 'timestamp' THEN 29 WHEN 'timestamp without time zone' THEN 29 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 10 WHEN 'int' THEN 10 WHEN 'int4' THEN 10 WHEN 'bigint' THEN 19 WHEN 'int8' THEN 19 WHEN 'decimal' THEN numeric_precision WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'float' THEN 17 WHEN 'numeric' THEN numeric_precision WHEN '_float4' THEN 8 WHEN 'timestamptz' THEN 35 WHEN 'timestamp with time zone' THEN 35 WHEN 'oid' THEN 10 WHEN '_int4' THEN 10 WHEN '_int2' THEN 5 ELSE " + string4 + " END AS CHAR_OCTET_LENGTH, ordinal_position AS ORDINAL_POSITION, is_nullable AS IS_NULLABLE, NULL AS SCOPE_CATLOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, CASE WHEN domain_name is not null THEN data_type END AS SOURCE_DATA_TYPE, 'NO' AS IS_AUTOINCREMENT FROM svv_columns");
        boolean bl = false;
        if (null != string && !string.equals("")) {
            bl = true;
            stringBuilder.append(" WHERE table_schema like ?");
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                bl = true;
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" table_name like ?");
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" COLUMN_NAME LIKE ?");
        }
        stringBuilder.append(" ORDER BY table_schema,table_name,COLUMN_NAME");
        return stringBuilder.toString();
    }

    private static String BuildColumnsQueryExternal(Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string4 = pGJDBCSettings.m_unknownLength != null ? String.valueOf(pGJDBCSettings.m_unknownLength) : "2147483647";
        StringBuilder stringBuilder = new StringBuilder(8192);
        stringBuilder.append("SELECT current_database()::varchar(128) AS TABLE_CAT, schemaname AS table_schema, tablename AS table_name, columnname AS column_name, CAST(CASE regexp_replace(external_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 1 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'timestamptz' THEN 2014 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS DATA_TYPE, COALESCE( null, CASE external_type WHEN 'boolean' THEN 'bool' WHEN 'character varying' THEN 'varchar' WHEN '\"char\"' THEN 'char' WHEN 'smallint' THEN 'int2' WHEN 'integer' THEN 'int4' WHEN 'bigint' THEN 'int8' WHEN 'real' THEN 'float4' WHEN 'double precision' THEN 'float8' WHEN 'timestamp without time zone' THEN 'timestamp' WHEN 'timestamp with time zone' THEN 'timestamptz' ELSE external_type END) AS TYPE_NAME, CASE external_type WHEN 'int4' THEN 10 WHEN 'bit' THEN 1 WHEN 'bool' THEN 1 WHEN 'boolean' THEN 1 WHEN 'varchar' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'character varying' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'char' THEN regexp_substr(external_type,'[0-9]+',4)::integer WHEN 'character' THEN regexp_substr(external_type,'[0-9]+',4)::integer WHEN 'nchar' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'bpchar' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'nvarchar' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'date' THEN 13 WHEN 'timestamp' THEN 29 WHEN 'timestamp without time zone' THEN 29 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 10 WHEN 'int' THEN 10 WHEN 'int4' THEN 10 WHEN 'bigint' THEN 19 WHEN 'int8' THEN 19 WHEN 'decimal' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'float' THEN 17 WHEN 'numeric' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN '_float4' THEN 8 WHEN 'timestamptz' THEN 35 WHEN 'timestamp with time zone' THEN 35 WHEN 'oid' THEN 10 WHEN '_int4' THEN 10 WHEN '_int2' THEN 5 ELSE " + string4 + " END AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, CASE external_type WHEN 'real' THEN 8 WHEN 'float4' THEN 8 WHEN 'double precision' THEN 17 WHEN 'float8' THEN 17 WHEN 'timestamp' THEN 6 WHEN 'timestamp without time zone' THEN 6 ELSE 0 END AS DECIMAL_DIGITS, 10 AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, CAST(CASE regexp_replace(external_type, '^_.+', 'ARRAY') WHEN 'text' THEN 12 WHEN 'bit' THEN -7 WHEN 'bool' THEN -7 WHEN 'boolean' THEN -7 WHEN 'varchar' THEN 12 WHEN 'character varying' THEN 12 WHEN 'char' THEN 1 WHEN 'character' THEN 1 WHEN 'nchar' THEN 1 WHEN 'bpchar' THEN 1 WHEN 'nvarchar' THEN 1 WHEN '\"char\"' THEN 1 WHEN 'date' THEN 91 WHEN 'timestamp' THEN 93 WHEN 'timestamp without time zone' THEN 93 WHEN 'timestamp with time zone' THEN 2014 WHEN 'smallint' THEN 5 WHEN 'int2' THEN 5 WHEN 'integer' THEN 4 WHEN 'int' THEN 4 WHEN 'int4' THEN 4 WHEN 'bigint' THEN -5 WHEN 'int8' THEN -5 WHEN 'decimal' THEN 3 WHEN 'real' THEN 7 WHEN 'float4' THEN 7 WHEN 'double precision' THEN 8 WHEN 'float8' THEN 8 WHEN 'float' THEN 6 WHEN 'numeric' THEN 2 WHEN 'timestamptz' THEN 2014 WHEN 'bytea' THEN -2 WHEN 'oid' THEN -5 WHEN 'name' THEN 12 WHEN 'ARRAY' THEN 2003 ELSE 1111 END AS SMALLINT) AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CASE WHEN left(external_type,7) = 'varchar' THEN regexp_substr(external_type,'[0-9]+',7)::integer WHEN left(external_type,4) = 'char' THEN regexp_substr(external_type,'[0-9]+',4)::integer WHEN external_type = 'string' THEN 16383 ELSE NULL END AS CHAR_OCTET_LENGTH, columnnum AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATLOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, 'NO' AS IS_AUTOINCREMENT, 'NO' AS IS_GENERATEDCOLUMN FROM svv_external_columns");
        boolean bl = false;
        if (null != string && !string.equals("")) {
            bl = true;
            stringBuilder.append(" WHERE table_schema like ?");
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                bl = true;
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" table_name like ?");
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" COLUMN_NAME LIKE ?");
        }
        stringBuilder.append(" ORDER BY table_schema,table_name,COLUMN_NAME");
        return stringBuilder.toString();
    }

    private static String BuildForeignKeysQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        if (null == string && null == string2) {
            return PGCatalogQueryBuilder.buildImportedKeyQueryString(string3, string4);
        }
        String string5 = "SELECT DISTINCT current_database() AS PKTABLE_CAT, n1.nspname AS PKTABLE_SCHEM, c1.relname AS PKTABLE_NAME, a1.attname AS PKCOLUMN_NAME, current_database() AS FKTABLE_CAT, n2.nspname AS FKTABLE_SCHEM, c2.relname AS FKTABLE_NAME, a2.attname AS FKCOLUMN_NAME, i::int2 AS KEY_SEQ, CASE ref.confupdtype WHEN 'c' THEN 0::int2 WHEN 'n' THEN 2::int2 WHEN 'd' THEN 4::int2 WHEN 'r' THEN 1::int2 ELSE 3::int2 END AS UPDATE_RULE, CASE ref.confdeltype WHEN 'c' THEN 0::int2 WHEN 'n' THEN 2::int2 WHEN 'd' THEN 4::int2 WHEN 'r' THEN 1::int2 ELSE 3::int2 END AS DELETE_RULE, cn.conname AS FK_NAME, ref.conname AS PK_NAME, CASE WHEN ref.condeferrable THEN CASE WHEN ref.condeferred THEN 5::int2 ELSE 6::int2 END ELSE 7::int2 END AS DEFERRABILITY FROM((((((((SELECT cn.oid, conrelid, conkey, confrelid, confkey, GENERATE_SERIES(ARRAY_LOWER(conkey, 1), ARRAY_UPPER(conkey, 1)) AS i, confupdtype, confdeltype, conname, condeferrable, condeferred FROM pg_catalog.pg_constraint cn, pg_catalog.pg_class c, pg_catalog.pg_namespace n WHERE contype = 'p' AND conrelid = c.oid ";
        if (null != string && !string.equals("")) {
            string5 = string5 + " AND  relname = ?";
        }
        if (null != string2 && !string2.equals("")) {
            string5 = string5 + " AND  n.nspname LIKE ?";
        }
        string5 = string5 + ") ref INNER JOIN pg_catalog.pg_class c1 ON c1.oid = ref.conrelid) INNER JOIN pg_catalog.pg_namespace n1 ON n1.oid = c1.relnamespace) INNER JOIN pg_catalog.pg_attribute a1 ON a1.attrelid = c1.oid AND a1.attnum = ref.conkey[i]) LEFT OUTER JOIN pg_catalog.pg_constraint cn ON cn.confrelid = ref.conrelid AND cn.contype = 'f') INNER JOIN pg_catalog.pg_class c2 ON c2.oid = cn.conrelid) INNER JOIN pg_catalog.pg_namespace n2 ON n2.oid = c2.relnamespace) INNER JOIN pg_catalog.pg_attribute a2 ON a2.attrelid = c2.oid AND a2.attnum = cn.conkey[i]) ";
        if (null != string3 && !string3.equals("")) {
            string5 = string5 + "WHERE c2.relname = ?";
        }
        if (null != string4 && !string4.equals("")) {
            string5 = null == string3 || string3.equals("") ? string5 + "WHERE n2.nspname LIKE ?" : string5 + " AND  n2.nspname LIKE ?";
        }
        string5 = string5 + "ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        return string5;
    }

    private static String buildImportedKeyQueryString(String string, String string2) {
        String string3 = "SELECT DISTINCT current_database() AS PKTABLE_CAT,  n2.nspname AS PKTABLE_SCHEM,  c2.relname AS PKTABLE_NAME,  a2.attname AS PKCOLUMN_NAME,  current_database() AS FKTABLE_CAT,  n1.nspname AS FKTABLE_SCHEM,  c1.relname AS FKTABLE_NAME,  a1.attname AS FKCOLUMN_NAME,  i::int2 AS KEY_SEQ,  CASE ref.confupdtype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS UPDATE_RULE,  CASE ref.confdeltype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS DELETE_RULE,  ref.conname AS FK_NAME,  cn.conname AS PK_NAME,  CASE  WHEN ref.condeferrable THEN  CASE  WHEN ref.condeferred THEN 5::int2  ELSE 6::int2  END  ELSE 7::int2  END AS DEFERRABILITY  FROM  ((((((((SELECT cn.oid, conrelid, conkey, confrelid, confkey,  GENERATE_SERIES(ARRAY_LOWER(conkey, 1), ARRAY_UPPER(conkey, 1)) AS i,  confupdtype, confdeltype, conname,  condeferrable, condeferred  FROM pg_catalog.pg_constraint cn,  pg_catalog.pg_class c,  pg_catalog.pg_namespace n  WHERE contype = 'f'  AND  conrelid = c.oid ";
        if (null != string && !string.equals("")) {
            string3 = string3 + " AND  relname = ?";
        }
        if (null != string2 && !string2.equals("")) {
            string3 = string3 + " AND  n.nspname LIKE ?";
        }
        string3 = string3 + " ) ref INNER JOIN pg_catalog.pg_class c1  ON c1.oid = ref.conrelid)  INNER JOIN pg_catalog.pg_namespace n1  ON  n1.oid = c1.relnamespace)  INNER JOIN pg_catalog.pg_attribute a1  ON  a1.attrelid = c1.oid  AND  a1.attnum = conkey[i])  INNER JOIN pg_catalog.pg_class c2  ON  c2.oid = ref.confrelid)  INNER JOIN pg_catalog.pg_namespace n2  ON  n2.oid = c2.relnamespace)  INNER JOIN pg_catalog.pg_attribute a2  ON  a2.attrelid = c2.oid  AND  a2.attnum = confkey[i])  LEFT OUTER JOIN pg_catalog.pg_constraint cn  ON cn.conrelid = ref.confrelid  AND cn.contype = 'p') ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ";
        return string3;
    }

    private static String BuildPrimaryKeysQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string3 = "SELECT current_database() AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  ct.relname AS TABLE_NAME,   a.attname AS COLUMN_NAME,   a.attnum AS KEY_SEQ,   ci.relname AS PK_NAME   FROM  pg_catalog.pg_namespace n,  pg_catalog.pg_class ct,  pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid  AND a.attrelid=ci.oid AND i.indisprimary  AND ct.relnamespace = n.oid ";
        if (null != string2) {
            string3 = string3 + " AND ct.relname= ?";
        }
        if (null != string && !string.equals("")) {
            string3 = string3 + " AND  n.nspname = ?";
        }
        string3 = string3 + " ORDER BY table_name, pk_name, key_seq";
        return string3;
    }

    private static String BuildProceduresQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname AS PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(NULL AS VARCHAR(256)) AS NUM_INPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_OUTPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_RESULT_SETS,  d.description AS REMARKS,  CASE p.prokind  WHEN 'f' THEN 2  WHEN 'p' THEN 1  ELSE 0  END AS PROCEDURE_TYPE,  p.proname || '_' || p.prooid AS SPECIFIC_NAME FROM pg_catalog.pg_namespace n,  pg_catalog.pg_proc_info p  LEFT JOIN pg_catalog.pg_description d ON (p.prooid=d.objoid) LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc') LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog') WHERE p.pronamespace=n.oid ";
        if (null != string && !string.equals("")) {
            string3 = string3 + " AND n.nspname LIKE ?";
            if (null != string2 && !string2.equals("")) {
                string3 = string3 + " AND p.proname LIKE ?";
            }
        } else if (null != string2 && !string2.equals("")) {
            string3 = string3 + " AND n.nspname LIKE ?";
        }
        string3 = string3 + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.prooid::text";
        return string3;
    }

    private static String BuildFunctionsQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = "SELECT routine_catalog AS FUNCTION_CAT,  routine_schema AS FUNCTION_SCHEM,  routine_name AS FUNCTION_NAME, CAST('' AS VARCHAR(256)) AS REMARKS,  0 AS FUNCTION_TYPE, specific_name AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES";
        if (null != string && !string.equals("")) {
            string3 = string3 + " WHERE  routine_schema LIKE ?";
            if (null != string2 && !string2.equals("")) {
                string3 = string3 + " AND  routine_name LIKE ?";
            }
        } else if (null != string2 && !string2.equals("")) {
            string3 = string3 + " WHERE  routine_name LIKE ?";
        }
        string3 = string3 + " ORDER BY routine_catalog, routine_schema, routine_name";
        return string3;
    }

    private static String BuildProcedureColumnsQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(5 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN 'timestamptz' THEN 93  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF,  CAST(CASE  pg_catalog.format_type(p.prorettype, NULL) WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  UNION ALL  SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(1 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(unnest(p.proargtypes), NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF, CAST(CASE  pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace";
        if (null != string && !string.equals("")) {
            string3 = string3 + " WHERE  n.nspname LIKE ?";
            if (null != string2 && !string2.equals("")) {
                string3 = string3 + " AND  proname LIKE ?";
            }
        } else if (null != string2 && !string2.equals("")) {
            string3 = string3 + " WHERE  proname LIKE ?";
        }
        return string3;
    }

    private static String BuildTablePriviledgesQuery(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        stringBuilder.append("CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT,");
        stringBuilder.append("n.nspname AS TABLE_SCHEM,");
        stringBuilder.append("c.relname AS TABLE_NAME,");
        stringBuilder.append("u.usename,");
        stringBuilder.append("c.relacl ");
        stringBuilder.append("FROM ");
        stringBuilder.append("pg_catalog.pg_namespace n, ");
        stringBuilder.append("pg_catalog.pg_class c, ");
        stringBuilder.append("pg_catalog.pg_user u ");
        stringBuilder.append("WHERE ");
        stringBuilder.append("c.relnamespace = n.oid");
        stringBuilder.append(" AND u.usesysid = c.relowner");
        stringBuilder.append(" AND c.relkind = 'r'");
        stringBuilder.append(" AND n.nspname LIKE '%'");
        stringBuilder.append(" AND c.relname LIKE '%'");
        if (null != string && !string.equals("")) {
            stringBuilder.append(" AND n.nspname LIKE ?");
        }
        if (null != string2 && !string2.equals("")) {
            stringBuilder.append(" AND c.relname LIKE ?");
        }
        stringBuilder.append(" ORDER BY nspname, relname");
        return stringBuilder.toString();
    }

    private static String BuildTablesQuery(Map<MetadataSourceColumnTag, String> map, PGJDBCSettings pGJDBCSettings) {
        if (pGJDBCSettings.m_hasExtSchemaPatternMatch) {
            return PGCatalogQueryBuilder.BuildTablesQueryNew(map);
        }
        return PGCatalogQueryBuilder.BuildTablesQueryOld(map);
    }

    private static String BuildTablesQueryOld(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        String string4 = "SELECT * FROM (SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  c.relname AS TABLE_NAME, CAST( CASE c.relkind WHEN 'r' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM TABLE'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST TABLE' WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY TABLE'  ELSE 'TABLE'  END  WHEN 'v' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM VIEW'  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY VIEW' ELSE 'VIEW'  END  WHEN 'i' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM INDEX'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST INDEX'  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY INDEX'  ELSE 'INDEX'  END  WHEN 'S' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN NULL  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY SEQUENCE'  ELSE 'SEQUENCE'  END  END  AS VARCHAR(124)) AS TABLE_TYPE, d.description AS REMARKS FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0) WHERE c.relnamespace = n.oid ";
        if (null != string && !string.equals("")) {
            string4 = string4 + "AND n.nspname like ? ";
        } else if (null != string2 && !string2.equals("")) {
            string4 = string4 + "AND n.nspname like current_schema() ";
        }
        if (null != string2 && !string2.equals("")) {
            string4 = string4 + "AND c.relname like ? ";
        }
        string4 = string4 + ") S ";
        if (null != string3 && !string3.equals("")) {
            string4 = string4 + " WHERE TABLE_TYPE IN (? ";
            String[] stringArray = string3.split(",");
            if (1 < stringArray.length) {
                int n = stringArray.length;
                while (1 < n--) {
                    string4 = string4 + ", ? ";
                }
            }
            string4 = string4 + ") ";
        }
        string4 = string4 + "ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return string4;
    }

    private static String BuildTablesQueryNew(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string && !string.equals("")) {
            return PGCatalogQueryBuilder.BuildTablesQueryExternal(map);
        }
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("SELECT * FROM (SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, table_schema AS TABLE_SCHEM, table_name AS TABLE_NAME, CAST( CASE table_type WHEN 'BASE TABLE' THEN CASE WHEN table_schema = 'pg_catalog' OR table_schema = 'information_schema' THEN 'SYSTEM TABLE' WHEN table_schema = 'pg_toast' THEN 'SYSTEM TOAST TABLE' WHEN table_schema ~ '^pg_' AND table_schema != 'pg_toast' THEN 'TEMPORARY TABLE' ELSE 'TABLE' END WHEN 'VIEW' THEN CASE WHEN table_schema = 'pg_catalog' OR table_schema = 'information_schema' THEN 'SYSTEM VIEW' WHEN table_schema = 'pg_toast' THEN NULL WHEN table_schema ~ '^pg_' AND table_schema != 'pg_toast' THEN 'TEMPORARY VIEW' ELSE 'VIEW' END WHEN 'EXTERNAL TABLE' THEN 'EXTERNAL TABLE' END AS VARCHAR(124)) AS TABLE_TYPE, REMARKS FROM svv_tables)");
        boolean bl = false;
        if (null != string && !string.equals("")) {
            bl = true;
            stringBuilder.append(" WHERE TABLE_SCHEM like ?");
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                bl = true;
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" TABLE_NAME like ?");
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" TABLE_TYPE IN (?");
            String[] stringArray = string3.split(",");
            if (1 < stringArray.length) {
                int n = stringArray.length;
                while (1 < n--) {
                    stringBuilder.append(", ? ");
                }
            }
            stringBuilder.append(") ");
        }
        stringBuilder.append(" ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME");
        return stringBuilder.toString();
    }

    private static String BuildTablesQueryExternal(Map<MetadataSourceColumnTag, String> map) {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("SELECT * FROM (SELECT CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, schemaname AS table_schem, tablename AS TABLE_NAME, 'EXTERNAL TABLE' AS TABLE_TYPE, NULL AS REMARKS FROM svv_external_tables)");
        boolean bl = false;
        if (null != string && !string.equals("")) {
            bl = true;
            stringBuilder.append(" WHERE TABLE_SCHEM like ?");
        }
        if (null != string2 && !string2.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                bl = true;
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" TABLE_NAME like ?");
        }
        if (null != string3 && !string3.equals("")) {
            if (bl) {
                stringBuilder.append(" AND");
            } else {
                stringBuilder.append(" WHERE");
            }
            stringBuilder.append(" TABLE_TYPE IN (? ");
            String[] stringArray = string3.split(",");
            if (1 < stringArray.length) {
                int n = stringArray.length;
                while (1 < n--) {
                    stringBuilder.append(", ? ");
                }
            }
            stringBuilder.append(") ");
        }
        stringBuilder.append(" ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME");
        return stringBuilder.toString();
    }

    public static String convertTableTypesListToInClause(String string) {
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != stringArray.length - 1) {
                    stringBuilder.append(stringArray[i]).append(", ");
                    continue;
                }
                stringBuilder.append(stringArray[i]);
            }
        } else {
            stringBuilder.append(stringArray[0]);
        }
        return stringBuilder.toString();
    }

    private static String PGNamespaceQueryBuilder() {
        return "SELECT n.nspname,    c.relname,    a.attname,    a.atttypid,    a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,    a.atttypmod,    a.attlen,    a.attnum,    pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,    dsc.description,    t.typbasetype,    t.typtype,    c.relnameFROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped  AND attname LIKE '%'  AND   (    c.relname LIKE 'pg_attribute'        OR    c.relname LIKE 'pg_type'  ) ORDER BY nspname,c.relname,attnum";
    }

    public static String PGAttNotNullBuilder(List<String> list, List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT a.attrelid, a.attnum, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) FROM pg_catalog.pg_attribute a JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) WHERE ");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append("(a.attrelid = ");
            stringBuilder.append(list.get(i));
            stringBuilder.append(" AND a.attnum = ");
            stringBuilder.append(list2.get(i));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private static String PGAttrDefBuilder(byte[] byArray, byte[] byArray2) {
        return "SELECT 1 FROM pg_catalog.pg_attrdef WHERE adrelid = " + PGDataTypeUtilities.toUTF8String(byArray) + " AND adnum = " + PGDataTypeUtilities.toUTF8String(byArray2) + " AND pg_catalog.pg_get_expr(adbin, adrelid) LIKE '%nextval(%' ";
    }

    private static String PGTypeNameBuilder(byte[] byArray) {
        return "SELECT typname FROM pg_catalog.pg_type WHERE oid = " + PGDataTypeUtilities.toUTF8String(byArray);
    }

    private static String PGRegProcBuilder() {
        return "SELECT typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type WHERE typname = 'regproc'";
    }
}

