/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.interfaces;

import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.channels.AbstractSocketChannel;
import com.amazon.support.channels.ISocketChannelReadCallback;
import com.amazon.support.exceptions.ErrorException;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractInboundDataHandler
implements ISocketChannelReadCallback,
Closeable {
    public static int BLOCKING_QUEUE_TIMEOUT = 100;
    private InboundMessagesContainer m_results;
    protected ILogger m_log;
    protected List<InboundMessagesPipeline> m_pipelines;
    protected AbstractSocketChannel m_socketChannel;
    protected int m_defaultNRowMode;
    protected int m_activeNRowMode;
    protected InboundMessagesPipeline m_currentPipeline;
    private boolean m_close;
    protected int m_filterLevel;
    public ReentrantLock m_addToPipelineLock = new ReentrantLock(true);

    public AbstractInboundDataHandler(ILogger iLogger, int n, int n2) {
        this.m_pipelines = Collections.synchronizedList(new LinkedList());
        this.m_log = iLogger;
        this.m_activeNRowMode = this.m_defaultNRowMode = n;
        this.m_filterLevel = n2;
        this.m_close = false;
    }

    protected boolean validateCurrentPipeline() {
        if (null == this.m_currentPipeline && !this.m_pipelines.isEmpty()) {
            this.m_currentPipeline = this.m_pipelines.remove(0);
        }
        if (null != this.m_currentPipeline) {
            InboundMessagesContainer inboundMessagesContainer;
            this.m_activeNRowMode = this.m_currentPipeline.getNRowMode();
            if (null == this.m_results && null != this.m_currentPipeline.m_messageContainersQueue && null != (inboundMessagesContainer = (InboundMessagesContainer)this.m_currentPipeline.m_messageContainersQueue.peek())) {
                this.m_results = inboundMessagesContainer;
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.close();
            this.m_currentPipeline = null;
        }
        if (null != this.m_pipelines) {
            while (this.validateCurrentPipeline()) {
                this.m_currentPipeline.close();
                this.m_currentPipeline = null;
            }
        }
    }

    public void close(ErrorException errorException) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.close(errorException);
            this.m_currentPipeline = null;
        }
        if (null != this.m_pipelines) {
            while (this.validateCurrentPipeline()) {
                this.m_currentPipeline.close(errorException);
                this.m_currentPipeline = null;
            }
        }
    }

    public void addPipeline(InboundMessagesPipeline inboundMessagesPipeline) {
        if (null != inboundMessagesPipeline && !this.m_pipelines.add(inboundMessagesPipeline)) {
            LogUtilities.logFatal("Could not add to pipeline", this.m_log);
        }
    }

    public void setSocketChannel(AbstractSocketChannel abstractSocketChannel) {
        this.m_socketChannel = abstractSocketChannel;
    }

    public void removeCurrentContainer() {
        this.m_results = null;
    }

    public void closeOperation() {
        if (null != this.m_currentPipeline) {
            this.m_currentPipeline.closeCurrentOperation();
        }
    }

    public void addToPipeline(IInboundMessage iInboundMessage, boolean bl) {
        this.m_addToPipelineLock.lock();
        try {
            this.validateCurrentPipeline();
            if (0 == this.m_activeNRowMode) {
                if (null == this.m_results || !this.m_results.add(iInboundMessage)) {
                    this.addToNewContainer(iInboundMessage);
                }
                ++this.m_currentPipeline.m_totalMessageCount;
                this.addPipelineToBlockingQueue();
            } else if (this.m_currentPipeline.getCurrentMessagesContainer().add(iInboundMessage, bl)) {
                ++this.m_currentPipeline.m_totalMessageCount;
            } else if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Pipeline would not accept message: " + iInboundMessage.toString(), this.m_log);
            }
        }
        finally {
            this.m_addToPipelineLock.unlock();
        }
    }

    private void addToNewContainer(IInboundMessage iInboundMessage) {
        this.m_results = new InboundMessagesContainer(this.m_activeNRowMode);
        if (!this.m_results.add(iInboundMessage)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("addToNewPipeline failed:");
            stringBuilder.append(iInboundMessage.getClass().getSimpleName());
            LogUtilities.logFatal(stringBuilder.toString(), this.m_log);
        }
    }

    private void addPipelineToBlockingQueue() {
        if (null != this.m_results && !this.m_results.isInQueue()) {
            while (!this.m_close) {
                try {
                    if (this.m_currentPipeline.m_messageContainersQueue.offer(this.m_results, BLOCKING_QUEUE_TIMEOUT, TimeUnit.MILLISECONDS)) {
                        this.m_results.setInQueue();
                    } else {
                        LogUtilities.logFatal("addPipelineToBlockingQueue failed:", this.m_log);
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public abstract boolean isOpenOperation();
}

