/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OS {
    Windows,
    Mac,
    Linux,
    FreeBSD,
    Solaris,
    Unknown;

    private static final String OS_NAME;
    private static final String OS_VERSION;

    static {
        OS_NAME = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
    }

    public static OS getCurrentOS() {
        if (OS_NAME.startsWith("Windows")) {
            return Windows;
        }
        if (OS_NAME.startsWith("Mac")) {
            return Mac;
        }
        if (OS_NAME.startsWith("Linux") || OS_NAME.toUpperCase().startsWith("LINUX")) {
            return Linux;
        }
        if (OS_NAME.startsWith("FreeBSD") || OS_NAME.toUpperCase().startsWith("FREEBSD")) {
            return FreeBSD;
        }
        if (OS_NAME.startsWith("Solaris")) {
            return Solaris;
        }
        return Unknown;
    }

    public static String getName() {
        return OS_NAME;
    }

    public static String getVersion() {
        return OS_VERSION;
    }
}

