/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.plaf.basic.BasicJYTabbedPaneUI;
import java.awt.Color;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaJYTabbedPaneUI
extends BasicJYTabbedPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        WeakReference weakReference;
        ComponentUI componentUI;
        if (jComponent.getName() == null) {
            jComponent.setName("JYTabbedPane");
        }
        ComponentUI componentUI2 = componentUI = (weakReference = (WeakReference)uis.get(jComponent)) == null ? null : (ComponentUI)weakReference.get();
        if (componentUI == null) {
            componentUI = new SyntheticaJYTabbedPaneUI();
            uis.put(jComponent, new WeakReference<ComponentUI>(componentUI));
        }
        return componentUI;
    }

    protected void installDefaults(JComponent jComponent) {
        super.installDefaults(jComponent);
        JYTabbedPane jYTabbedPane = (JYTabbedPane)jComponent;
        Border border = jYTabbedPane.getBorder();
        if (border == null || border instanceof UIResource) {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE);
            SynthContext synthContext = new SynthContext(this.tabPane, Region.TABBED_PANE, synthStyle, 0);
            jYTabbedPane.setBorder(new BorderUIResource.EmptyBorderUIResource(synthStyle.getInsets(synthContext, null)));
        }
        if (jYTabbedPane.paintSelectedTabBoldIsUIResource()) {
            jYTabbedPane.setPaintSelectedTabBold(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tab.selectedBold", jComponent), true);
        }
    }

    protected void updateTabbedPaneBorder() {
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE);
        SynthContext synthContext = new SynthContext(this.tabPane, Region.TABBED_PANE, synthStyle, 0);
        Border border = this.tabPane.getBorder();
        if (border == null || border instanceof UIResource) {
            this.tabPane.setBorder(new BorderUIResource.EmptyBorderUIResource(synthStyle.getInsets(synthContext, null)));
        }
    }

    protected Color getDefaultTabForeground(int n) {
        boolean bl;
        boolean bl2 = bl = this.tabPane.getSelectedIndex() == n;
        boolean bl3 = n < 0 || n >= this.tabPane.getTabCount() ? false : !this.tabPane.isEnabledAt(n);
        boolean bl4 = SyntheticaLookAndFeel.getClientProperty("Synthetica.MOUSE_OVER", this.tabPane, Integer.MIN_VALUE) == n;
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
        SynthContext synthContext = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, synthStyle, bl ? 512 : (bl3 ? 8 : (bl4 ? 2 : 0)));
        Color color = synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND);
        return color;
    }

    protected Insets getTabInsets(boolean bl) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
        SynthContext synthContext = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, synthStyle, 0);
        Insets insets = synthStyle.getInsets(synthContext, null);
        insets.top += 2;
        ++insets.left;
        insets.bottom += 0;
        ++insets.right;
        if (bl) {
            insets.top -= 2;
            insets.bottom += 2;
            if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.tab.selected.text.insets", this.tabPane) != null) {
                Insets insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.selected.text.insets", this.tabPane);
                insets.top += insets2.top;
                insets.bottom -= insets2.top;
            }
        } else if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.tab.text.insets", this.tabPane) != null) {
            Insets insets3 = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.text.insets", this.tabPane);
            insets.top += insets3.top;
            insets.bottom -= insets3.top;
        }
        return insets;
    }

    protected Insets getTabAreaPanelInsets() {
        Insets insets = this.tabAreaInsets;
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB_AREA);
        SynthContext synthContext = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB_AREA, synthStyle, 0);
        insets = synthStyle.getInsets(synthContext, null);
        return insets;
    }
}

