/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jydocking;

import de.javasoft.swing.JYDockingView;
import de.javasoft.swing.plaf.DockingViewTitlebarUI;
import de.javasoft.swing.plaf.basic.BasicDockingViewTitlebarUI;
import de.javasoft.swing.plaf.jydocking.AbstractDockingViewAction;
import de.javasoft.swing.plaf.jydocking.DefaultCloseAction;
import de.javasoft.swing.plaf.jydocking.DefaultFloatAction;
import de.javasoft.swing.plaf.jydocking.DefaultMaximizeAction;
import de.javasoft.swing.plaf.jydocking.DefaultMinimizeAction;
import de.javasoft.swing.plaf.jydocking.DockingButton;
import de.javasoft.swing.plaf.jydocking.IDockingButtonFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DockingViewTitlebar
extends JComponent {
    private static final long serialVersionUID = -8936591064762821423L;
    public static final String uiClassID = "JYDockingViewTitlebarUI";
    private JLabel titleLabel = new TitleLabel();
    private Color titleForeground;
    private Color activeTitleForeground;
    private LinkedHashMap<Action, DockingButton> dockingButtons;
    private JYDockingView parentView;

    public DockingViewTitlebar() {
        this(null, null);
    }

    public DockingViewTitlebar(String string, Action[] actionArray) {
        this.setTitleText(string);
        this.setActions(actionArray);
        this.add(this.titleLabel);
        this.add(Box.createHorizontalGlue());
        this.updateUI();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewTitlebarUI.class));
    }

    public DockingViewTitlebarUI getUI() {
        return (DockingViewTitlebarUI)this.ui;
    }

    protected void setActions(Action[] actionArray) {
        if (actionArray == null) {
            actionArray = new Action[]{};
            this.dockingButtons = new LinkedHashMap(4);
        }
        this.removeActions();
        int n = 0;
        while (n < actionArray.length) {
            this.addAction(actionArray[n]);
            ++n;
        }
    }

    protected void removeActions() {
        Action[] actionArray = this.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.removeAction(action);
            ++n2;
        }
    }

    public Action[] getActions() {
        return this.dockingButtons.keySet().toArray(new Action[0]);
    }

    public void addAction(Action action) {
        if (!this.dockingButtons.keySet().contains(action)) {
            DockingButton dockingButton = this.createDockingButton(action);
            this.dockingButtons.put(action, dockingButton);
            this.add(dockingButton);
        }
    }

    public void removeAction(Action action) {
        if (this.dockingButtons.keySet().contains(action)) {
            this.remove(this.dockingButtons.get(action));
            this.dockingButtons.remove(action);
        }
    }

    public boolean isActive() {
        return this.parentView == null ? false : this.parentView.isActive();
    }

    public void setView(JYDockingView jYDockingView) {
        this.parentView = jYDockingView;
    }

    public JYDockingView getView() {
        return (JYDockingView)SwingUtilities.getAncestorOfClass(JYDockingView.class, this);
    }

    private DockingButton createDockingButton(Action action) {
        ButtonModel buttonModel;
        DockingButton dockingButton = null;
        IDockingButtonFactory iDockingButtonFactory = ((BasicDockingViewTitlebarUI)this.getUI()).getDockingButtonFactory();
        if (action instanceof DefaultMinimizeAction) {
            dockingButton = iDockingButtonFactory.createMinimizeButton(action);
        } else if (action instanceof DefaultMaximizeAction) {
            dockingButton = iDockingButtonFactory.createMaximizeButton(action);
        } else if (action instanceof DefaultFloatAction) {
            dockingButton = iDockingButtonFactory.createFloatButton(action);
        } else if (action instanceof DefaultCloseAction) {
            dockingButton = iDockingButtonFactory.createCloseButton(action);
        }
        if (action instanceof AbstractDockingViewAction && (buttonModel = ((AbstractDockingViewAction)action).createButtonModel()) != null) {
            dockingButton.setModel(buttonModel);
        }
        return dockingButton;
    }

    public void setTitleText(String string) {
        this.titleLabel.setText(string == null ? "" : string);
    }

    public String getTitleText() {
        return this.titleLabel.getText();
    }

    public Icon getTitleIcon() {
        return this.titleLabel.getIcon();
    }

    public void setTitleIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setActiveTitleForeground(Color color) {
        this.activeTitleForeground = color;
    }

    public Color getActiveTitleForeground() {
        return this.activeTitleForeground;
    }

    protected Icon getIcon(Action action) {
        Object object = action == null ? null : action.getValue("SmallIcon");
        return object instanceof Icon ? (Icon)object : null;
    }

    private class TitleLabel
    extends JLabel {
        private static final long serialVersionUID = -1108225465058579891L;

        private TitleLabel() {
        }

        public Dimension getMinimumSize() {
            int n = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            return new Dimension(n, super.getMinimumSize().height);
        }

        public Color getForeground() {
            return DockingViewTitlebar.this.isActive() ? DockingViewTitlebar.this.getActiveTitleForeground() : DockingViewTitlebar.this.getTitleForeground();
        }

        public Font getFont() {
            return DockingViewTitlebar.this.getFont();
        }

        public boolean isFocusable() {
            return false;
        }
    }
}

