/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jycombobox;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYComboBoxPainter;
import de.javasoft.swing.JYComboBox;
import de.javasoft.swing.jycombobox.IPopupComponentInitializer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ComponentPopup
extends BasicComboPopup
implements AWTEventListener,
WindowListener {
    private static final long serialVersionUID = 7196620101607920884L;
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private int preferredWidth;
    private int preferredHeight;
    private boolean resizable;
    private boolean sizeRestorable;
    private int dragStartX;
    private int dragStartY;
    private Rectangle dragBounds;
    private boolean openLocked;
    private static ArrayList<ComponentPopup> popupList = new ArrayList();

    public ComponentPopup(JComboBox jComboBox) {
        super(jComboBox);
    }

    private boolean isComboListPopup() {
        return this.scroller.getViewport().getView() == this.list;
    }

    private boolean isPopupFocusable() {
        return !this.isComboListPopup();
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public void setPopupComponent(JComponent jComponent) {
        this.configureScroller();
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        SyntheticaLookAndFeel.findComponent("JYComboBox.ResizeHandle", (Container)this).setVisible(bl);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setSizeRestorable(boolean bl) {
        this.sizeRestorable = bl;
    }

    public boolean isSizeRestorable() {
        return this.sizeRestorable;
    }

    public Dimension getPreferredSize() {
        int n;
        SynthContext synthContext;
        SynthStyle synthStyle;
        Insets insets;
        int n2 = 0;
        int n3 = 0;
        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel && !SyntheticaLookAndFeel.getClientProperty("JComboBox.isTableCellEditor", this.comboBox, false).booleanValue() && (insets = (Insets)(synthStyle = SynthLookAndFeel.getStyle(this.comboBox, Region.COMBO_BOX)).get(synthContext = new SynthContext(this.comboBox, Region.COMBO_BOX, synthStyle, 0), "ComboBox.popupInsets")) != null) {
            n2 -= insets.left + insets.right;
            n3 -= insets.top + insets.bottom;
        }
        if ((n = ((JYComboBox)this.comboBox).getPopupWidth()) > 0 && !this.sizeRestorable) {
            this.preferredWidth = n;
        } else if (this.preferredWidth <= 0 || !this.sizeRestorable) {
            this.preferredWidth = n2 + (this.isComboListPopup() ? super.getPreferredSize().width : this.scroller.getViewport().getView().getPreferredSize().width + this.getInsets().left + this.getInsets().right);
        }
        int n4 = ((JYComboBox)this.comboBox).getPopupHeight();
        if (n4 > 0 && !this.sizeRestorable) {
            this.preferredHeight = n4;
        } else if (this.preferredHeight <= 0 || !this.sizeRestorable) {
            this.preferredHeight = n3 + (this.isComboListPopup() ? super.getPreferredSize().height : this.scroller.getViewport().getView().getPreferredSize().height + this.getInsets().top + this.getInsets().bottom);
            if (this.resizable && !this.isComboListPopup()) {
                this.preferredHeight += SyntheticaLookAndFeel.findComponent((String)"JYComboBox.ResizeHandle", (Container)this).getPreferredSize().height;
            }
        }
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        int n = this.comboBox.getSelectedIndex();
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
        this.installListListeners();
    }

    protected void configurePopup() {
        super.configurePopup();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(this.scroller);
        this.add((Component)this.createResizeHandle(), "South");
        JYComboBox jYComboBox = (JYComboBox)this.comboBox;
        this.setPreferredWidth(jYComboBox.getPopupWidth());
        this.setPreferredHeight(jYComboBox.getPopupHeight());
        this.setResizable(jYComboBox.isPopupResizable());
        this.setSizeRestorable(jYComboBox.isPopupSizeRestorable());
    }

    public void show(Component component, int n, int n2) {
        SynthContext synthContext;
        SynthStyle synthStyle;
        Insets insets;
        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel && !SyntheticaLookAndFeel.getClientProperty("JComboBox.isTableCellEditor", (JComponent)component, false).booleanValue() && (insets = (Insets)(synthStyle = SynthLookAndFeel.getStyle((JComponent)component, Region.COMBO_BOX)).get(synthContext = new SynthContext((JComponent)component, Region.COMBO_BOX, synthStyle, 0), "ComboBox.popupInsets")) != null) {
            n += insets.left;
            n2 += insets.top;
        }
        super.show(component, n, n2);
    }

    protected JComponent createResizeHandle() {
        JPanel jPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = -6512380715333168624L;

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                    JYComboBoxPainter.getInstance().paintResizeHandle(ComponentPopup.this.comboBox, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight());
                } else {
                    int n = 1;
                    int n2 = 2;
                    int n3 = this.getWidth();
                    graphics.setColor(new Color(0xC0C0C0));
                    graphics.drawLine(n, n2, n + n3 - 2 * n - 1, n2);
                    graphics.drawLine(n, n2 + 2, n + n3 - 2 * n - 1, n2 + 2);
                }
            }
        };
        int n = SyntheticaLookAndFeel.getInt("JYComboBox.resizeHandle.size", this.comboBox, 7);
        jPanel.setPreferredSize(new Dimension(0, n));
        jPanel.setName("JYComboBox.ResizeHandle");
        jPanel.setOpaque(SyntheticaLookAndFeel.getBoolean("JYComboBox.resizeHandle.opaque", this.comboBox, true));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                ComponentPopup.this.dragStartX = point.x;
                ComponentPopup.this.dragStartY = point.y;
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                ComponentPopup.this.dragBounds = window.getBounds();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        };
        jPanel.addMouseListener(mouseAdapter);
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                rectangle.x = 0;
                rectangle.y = 0;
                rectangle.width -= SyntheticaLookAndFeel.getInt("JYComboBox.resizeHandle.edgeSize", ComponentPopup.this.comboBox, 16);
                boolean bl = rectangle.contains(mouseEvent.getPoint());
                component.setCursor(new Cursor(bl ? 9 : 5));
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                boolean bl = component.getCursor().getType() == 9;
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, component);
                int n = bl ? 0 : point.x - ComponentPopup.this.dragStartX;
                int n2 = point.y - ComponentPopup.this.dragStartY;
                Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
                window.setBounds(((ComponentPopup)ComponentPopup.this).dragBounds.x, ((ComponentPopup)ComponentPopup.this).dragBounds.y, ((ComponentPopup)ComponentPopup.this).dragBounds.width + n, ((ComponentPopup)ComponentPopup.this).dragBounds.height + n2);
                ComponentPopup.this.preferredWidth = ((ComponentPopup)ComponentPopup.this).dragBounds.width + n;
                ComponentPopup.this.preferredHeight = ((ComponentPopup)ComponentPopup.this).dragBounds.height + n2;
                if (JAVA5) {
                    window.validate();
                    window.repaint();
                }
            }
        };
        jPanel.addMouseMotionListener(mouseMotionListener);
        return jPanel;
    }

    protected JScrollPane createScroller() {
        return new JScrollPane();
    }

    protected void configureScroller() {
        JComponent jComponent;
        super.configureScroller();
        if (this.scroller.getName() == null) {
            this.scroller.setName("ComboBox.scrollPane");
        }
        if ((jComponent = ((JYComboBox)this.comboBox).getPopupComponent()) == null) {
            jComponent = this.list;
        }
        this.scroller.setHorizontalScrollBarPolicy(jComponent == this.list ? 31 : 30);
        this.scroller.setViewportView(jComponent);
        if (jComponent != this.list) {
            this.scroller.getHorizontalScrollBar().setFocusable(false);
        }
        this.scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void menuSelectionChanged(boolean bl) {
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.installHandler();
        } else {
            this.uninstallHandler();
        }
    }

    private boolean isPressedWithinPopup(ComponentPopup componentPopup, MouseEvent mouseEvent) {
        if (!componentPopup.isShowing()) {
            return false;
        }
        Point point = componentPopup.getLocationOnScreen();
        Rectangle rectangle = new Rectangle(point.x, point.y, componentPopup.getWidth(), componentPopup.getHeight());
        Point point2 = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point2, mouseEvent.getComponent());
        return rectangle.contains(point2);
    }

    private void installHandler() {
        if (this.openLocked && !(this.comboBox.getParent() instanceof JTable)) {
            return;
        }
        Component component = this.scroller.getViewport().getView();
        if (component instanceof IPopupComponentInitializer) {
            ((IPopupComponentInitializer)((Object)component)).initializePopupComponent((JYComboBox)this.comboBox);
        }
        popupList.add(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        if (popupList.size() == 1) {
            SwingUtilities.getWindowAncestor(this.comboBox).addWindowListener(this);
        }
        super.setVisible(true);
        if (this.isPopupFocusable()) {
            Window window = SwingUtilities.getWindowAncestor(this);
            window.setName("###focusableSwingPopup###");
            window.setFocusableWindowState(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component component = FocusManager.getCurrentManager().getDefaultFocusTraversalPolicy().getDefaultComponent(ComponentPopup.this);
                if (ComponentPopup.this.isPopupFocusable() && component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    private void uninstallHandler() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        Window window = SwingUtilities.getWindowAncestor(this.comboBox);
        if (window != null) {
            window.removeWindowListener(this);
        }
        MenuSelectionManager.defaultManager().clearSelectedPath();
        super.setVisible(false);
        popupList.remove(this);
        if (JAVA5) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ComponentPopup.this.isPopupFocusable() && MenuSelectionManager.defaultManager().getSelectedPath().length == 0) {
                        ComponentPopup.this.comboBox.requestFocus();
                    }
                }
            });
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        InputEvent inputEvent;
        if (aWTEvent.getID() == 401) {
            inputEvent = (KeyEvent)aWTEvent;
            if (popupList.get(popupList.size() - 1) != this) {
                return;
            }
            int n = ((KeyEvent)inputEvent).getKeyCode();
            if (n == 27 || !this.isPopupFocusable() && n == 10 || !this.isPopupFocusable() && n == 9) {
                if (n == 27 || n == 9) {
                    this.firePopupMenuCanceled();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ComponentPopup.this.setVisible(false);
                    }
                });
            }
        }
        if (aWTEvent.getID() == 501) {
            boolean bl;
            inputEvent = (MouseEvent)aWTEvent;
            Component component = inputEvent.getComponent();
            if (this.isShowing()) {
                bl = false;
                for (ComponentPopup componentPopup : popupList) {
                    bl |= this.isPressedWithinPopup(componentPopup, (MouseEvent)inputEvent);
                }
                if (bl) {
                    boolean bl2;
                    if (popupList.get(popupList.size() - 1) != this) {
                        return;
                    }
                    if (this.isPressedWithinPopup(this, (MouseEvent)inputEvent) && !this.isComboListPopup()) {
                        return;
                    }
                    if (this.isComboListPopup() && (bl2 = SwingUtilities.isDescendingFrom(component, this))) {
                        if (component != this.list) {
                            return;
                        }
                        this.comboBox.setSelectedIndex(this.list.getSelectedIndex());
                    }
                } else {
                    if ((component == this.comboBox || "ComboBox.arrowButton".equals(component.getName())) && this.comboBox.getParent() instanceof JTable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ComponentPopup.this.setVisible(false);
                            }
                        });
                        return;
                    }
                    this.firePopupMenuCanceled();
                }
            }
            this.openLocked = true;
            this.setVisible(false);
            bl = SyntheticaLookAndFeel.getClientProperty("JYComboBox.closePopupByArrowButton", this.comboBox, true);
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ComponentPopup.this.openLocked = false;
                    }
                });
            } else {
                this.openLocked = false;
            }
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.setVisible(false);
    }
}

