/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYFormattedSearchField;
import de.javasoft.swing.JYSearchField;
import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.swing.plaf.basic.BasicJYTextFieldUI;
import de.javasoft.swing.plaf.jysearchfield.ButtonFactory;
import de.javasoft.swing.plaf.jysearchfield.IButtonFactory;
import de.javasoft.swing.plaf.jysearchfield.SearchActionEvent;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicJYSearchFieldUI
extends BasicJYTextFieldUI {
    private IButtonFactory buttonFactory;
    private SearchDelayThread searchDelayThread;
    private KeyListener returnKeyListener;

    protected String getPropertyPrefix() {
        return this.getComponent() instanceof JYFormattedSearchField ? "FormattedTextField" : "TextField";
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYSearchFieldUI();
    }

    protected void installDefaults(JComponent jComponent) {
        Object object;
        super.installDefaults(jComponent);
        this.installButtonFactory();
        JYSearchField jYSearchField = (JYSearchField)jComponent;
        if (jYSearchField.searchPopupButtonEnabledIsUIResource()) {
            object = SyntheticaLookAndFeel.getBoolean("JYSearchField.searchPopupButton.enabled", jComponent);
            jYSearchField.setSearchPopupButtonEnabled((Boolean)object, true);
        }
        this.installSearchButton(jYSearchField, jYSearchField.getSearchAction(), false);
        this.installDeleteButton(jYSearchField);
        if (jYSearchField.showSearchButtonIsUIResource()) {
            object = SyntheticaLookAndFeel.getBoolean("JYSearchField.showSearchButton", jComponent, true);
            jYSearchField.setShowSearchButton((Boolean)object, true);
        }
        if (jYSearchField.searchControlsPositionIsUIResource()) {
            object = SyntheticaLookAndFeel.getString("JYSearchField.searchControlsPosition", jComponent);
            if (object == null) {
                object = JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING.name();
            }
            jYSearchField.setSearchControlsPosition(JYSearchField.SearchControlsPosition.valueOf((String)object), true);
        }
        if (jYSearchField.searchModeIsUIResource()) {
            object = SyntheticaLookAndFeel.getString("JYSearchField.searchMode", jComponent);
            if (object == null) {
                object = JYSearchField.SearchMode.MANUAL.name();
            }
            jYSearchField.setSearchMode(JYSearchField.SearchMode.valueOf((String)object), true);
        }
        if (jYSearchField.searchDelayIsUIResource()) {
            int n = SyntheticaLookAndFeel.getInt("JYSearchField.searchDelay", jComponent, 400);
            jYSearchField.setSearchDelay(n, true);
        }
        if (jYSearchField.promptTextIsUIResource()) {
            String string = SyntheticaLookAndFeel.getString("JYSearchField.promptText", jComponent);
            if (string == null) {
                string = "";
            }
            jYSearchField.setPromptText(string, true);
        }
        jYSearchField.getInputMap().put(KeyStroke.getKeyStroke(40, 512), "openPopup");
        jYSearchField.getActionMap().put("openPopup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JYSearchField jYSearchField = (JYSearchField)actionEvent.getSource();
                AbstractButton abstractButton = BasicJYSearchFieldUI.this.getSearchButton(jYSearchField);
                if (abstractButton instanceof SimpleDropDownButton) {
                    abstractButton.getActionMap().get("openPopup").actionPerformed(new ActionEvent(jYSearchField, 1001, actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                }
            }
        });
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        JYSearchField jYSearchField = (JYSearchField)this.getComponent();
        JPanel jPanel = this.getDeleteButtonPanel(jYSearchField);
        jPanel.remove(this.getDeleteButton(jYSearchField));
    }

    protected void installListeners() {
        super.installListeners();
        this.returnKeyListener = new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    JYSearchField jYSearchField = (JYSearchField)keyEvent.getSource();
                    if (BasicJYSearchFieldUI.this.searchDelayThread != null) {
                        BasicJYSearchFieldUI.this.searchDelayThread.interrupt();
                        BasicJYSearchFieldUI.this.searchDelayThread = null;
                    }
                    BasicJYSearchFieldUI.this.fireSearchAction(jYSearchField);
                }
            }
        };
        this.getComponent().addKeyListener(this.returnKeyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(this.returnKeyListener);
    }

    private void installButtonFactory() {
        String string = SyntheticaLookAndFeel.getString("JYSearchField.buttonFactory.className", this.getComponent());
        if (string == null) {
            this.buttonFactory = new ButtonFactory();
        } else {
            try {
                this.buttonFactory = (IButtonFactory)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void installSearchButton(JYSearchField jYSearchField, Action action, boolean bl) {
        AbstractButton abstractButton = this.getSearchButton(jYSearchField);
        boolean bl2 = abstractButton instanceof SimpleDropDownButton;
        boolean bl3 = jYSearchField.getSearchPopupButtonEnabled();
        if (abstractButton == null || !bl2 && bl3 || bl2 && !bl3 || abstractButton.getAction() != action || bl) {
            if (abstractButton != null) {
                abstractButton.getParent().remove(abstractButton);
            }
            JPanel jPanel = this.getSearchButtonPanel(jYSearchField);
            if (bl3) {
                jPanel.add(this.buttonFactory.createSearchPopupButton(jYSearchField, action));
            } else {
                jPanel.add(this.buttonFactory.createSearchButton(jYSearchField, action), null, jPanel.getComponentCount());
            }
        }
    }

    private AbstractButton getSearchButton(JYSearchField jYSearchField) {
        ArrayList arrayList = new ArrayList();
        SyntheticaLookAndFeel.findComponents(AbstractButton.class, (Container)jYSearchField, arrayList);
        for (AbstractButton abstractButton : arrayList) {
            if (abstractButton.getName() == null || !abstractButton.getName().contains("JYSearchField.SearchButton")) continue;
            return abstractButton;
        }
        return null;
    }

    private AbstractButton getDeleteButton(JYSearchField jYSearchField) {
        return (AbstractButton)SyntheticaLookAndFeel.findComponent("JYSearchField.DeleteButton", (Container)jYSearchField);
    }

    private JPanel getSearchButtonPanel(JYSearchField jYSearchField) {
        return jYSearchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING ? jYSearchField.getLeadingPanel() : jYSearchField.getTrailingPanel();
    }

    private JPanel getDeleteButtonPanel(JYSearchField jYSearchField) {
        return jYSearchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING ? jYSearchField.getTrailingPanel() : jYSearchField.getLeadingPanel();
    }

    private void installDeleteButton(final JYSearchField jYSearchField) {
        AbstractButton abstractButton = this.getDeleteButton(jYSearchField);
        if (abstractButton != null) {
            abstractButton.getParent().remove(abstractButton);
        }
        this.getDeleteButtonPanel(jYSearchField).add(this.buttonFactory.createDeleteButton(jYSearchField, new AbstractAction(){
            private static final long serialVersionUID = 3382162676275722429L;

            public void actionPerformed(ActionEvent actionEvent) {
                jYSearchField.setText("");
                if (BasicJYSearchFieldUI.this.searchDelayThread != null) {
                    BasicJYSearchFieldUI.this.searchDelayThread.interrupt();
                    BasicJYSearchFieldUI.this.searchDelayThread = null;
                }
                BasicJYSearchFieldUI.this.fireSearchAction(actionEvent.getSource());
            }
        }), null, 0);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        JYSearchField jYSearchField = (JYSearchField)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("documentLength".equals(string)) {
            this.getDeleteButton(jYSearchField).setVisible((Integer)propertyChangeEvent.getNewValue() != 0);
            if (jYSearchField.getSearchMode() == JYSearchField.SearchMode.AUTO && jYSearchField.getSearchDelay() > 0) {
                if (this.searchDelayThread != null && !this.searchDelayThread.isInterrupted()) {
                    this.searchDelayThread.interrupt();
                }
                this.searchDelayThread = new SearchDelayThread(jYSearchField.getSearchDelay(), jYSearchField.getSearchAction());
                this.searchDelayThread.start();
            }
        } else if ("searchPopupButtonEnabled".equals(string) || "searchAction".equals(string)) {
            this.installSearchButton(jYSearchField, "searchAction".equals(string) ? (Action)propertyChangeEvent.getNewValue() : jYSearchField.getSearchAction(), false);
        } else if ("showSearchButton".equals(string)) {
            this.getSearchButton(jYSearchField).setVisible((Boolean)propertyChangeEvent.getNewValue());
        } else if ("searchPopup".equals(string)) {
            AbstractButton abstractButton = this.getSearchButton(jYSearchField);
            if (abstractButton instanceof SimpleDropDownButton) {
                ((SimpleDropDownButton)abstractButton).setPopupMenu((JPopupMenu)propertyChangeEvent.getNewValue());
            }
        } else if ("searchControlsPosition".equals(string)) {
            AbstractButton abstractButton = this.getSearchButton(jYSearchField);
            this.installSearchButton(jYSearchField, abstractButton.getAction(), true);
            this.installDeleteButton(jYSearchField);
        }
    }

    private void fireSearchAction(Object object) {
        JYSearchField jYSearchField = (JYSearchField)this.getComponent();
        Action action = jYSearchField.getSearchAction();
        if (action != null) {
            SearchActionEvent.Initiator initiator = SearchActionEvent.Initiator.SEARCH_FIELD;
            if (object instanceof Runnable) {
                initiator = SearchActionEvent.Initiator.AUTO_SEARCH;
            } else if (object instanceof AbstractButton) {
                initiator = SearchActionEvent.Initiator.CLEAR_BUTTON;
            }
            action.actionPerformed(new SearchActionEvent(jYSearchField, 1001, null, System.currentTimeMillis(), 0, initiator));
        }
    }

    private class SearchDelayThread
    extends Thread {
        private int delay;
        private Action action;

        public SearchDelayThread(int n, Action action) {
            this.delay = n;
            this.action = action;
            this.setDaemon(true);
        }

        public void run() {
            try {
                SearchDelayThread.sleep(this.delay);
                if (this.action != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (!SearchDelayThread.this.isInterrupted()) {
                                if (BasicJYSearchFieldUI.this.getComponent() != null) {
                                    BasicJYSearchFieldUI.this.fireSearchAction(this);
                                }
                                BasicJYSearchFieldUI.this.searchDelayThread = null;
                            }
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

