/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.plaf.DockingViewTitlebarUI;
import de.javasoft.swing.plaf.basic.BasicDockingPainter;
import de.javasoft.swing.plaf.jydocking.DockingButtonFactory;
import de.javasoft.swing.plaf.jydocking.DockingViewTitlebar;
import de.javasoft.swing.plaf.jydocking.IDockingButtonFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class BasicDockingViewTitlebarUI
extends DockingViewTitlebarUI {
    private IDockingButtonFactory dockingButtonFactory;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDockingViewTitlebarUI();
    }

    public void installUI(JComponent jComponent) {
        Serializable serializable;
        super.installUI(jComponent);
        DockingViewTitlebar dockingViewTitlebar = (DockingViewTitlebar)jComponent;
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            String string;
            float f;
            serializable = UIManager.getFont("Panel.font");
            int n = 0;
            String string2 = SyntheticaLookAndFeel.getString("JYDocking.titlebar.font.style", jComponent);
            if (string2 != null) {
                if (string2.contains("BOLD")) {
                    n |= 1;
                }
                if (string2.contains("ITALIC")) {
                    n |= 2;
                }
            }
            if ((f = SyntheticaLookAndFeel.scaleFontSize(SyntheticaLookAndFeel.getInt("JYDocking.titlebar.font.size", jComponent, 0))) == 0.0f) {
                f = ((Font)serializable).getSize();
            }
            if ((string = SyntheticaLookAndFeel.getString("JYDocking.titlebar.font.name", jComponent)) == null) {
                string = ((Font)serializable).getFamily();
            }
            jComponent.setFont(new FontUIResource(string, n, (int)f));
        }
        if ((serializable = dockingViewTitlebar.getTitleForeground()) == null || serializable instanceof UIResource) {
            dockingViewTitlebar.setTitleForeground(SyntheticaLookAndFeel.getColor("JYDocking.titlebar.foreground", jComponent, Color.BLACK));
        }
        if ((serializable = dockingViewTitlebar.getActiveTitleForeground()) == null || serializable instanceof UIResource) {
            dockingViewTitlebar.setActiveTitleForeground(SyntheticaLookAndFeel.getColor("JYDocking.titlebar.active.foreground", jComponent, Color.BLACK));
        }
        jComponent.setLayout(new BoxLayout(jComponent, 2));
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.insets", jComponent);
        if (insets == null) {
            insets = new Insets(3, 4, 1, 4);
        }
        jComponent.setBorder(new EmptyBorder(insets));
        this.installDockingButtonFactory(dockingViewTitlebar);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        this.paintBackground(jComponent, graphics, n, n2, n3, n4);
        this.paintBorder(jComponent, graphics, n, n2, n3, n4);
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        BasicDockingPainter.getInstance().paintDockingTitleBarBackground(jComponent, new SyntheticaState(((DockingViewTitlebar)jComponent).isActive() ? SyntheticaState.State.SELECTED.toInt() : 0), graphics, n, n2, n3, n4);
    }

    protected void paintBorder(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    private void installDockingButtonFactory(DockingViewTitlebar dockingViewTitlebar) {
        String string = SyntheticaLookAndFeel.getString("JYDocking.dockingButtonFactory.className", dockingViewTitlebar);
        if (string == null) {
            this.dockingButtonFactory = new DockingButtonFactory();
        } else {
            try {
                this.dockingButtonFactory = (IDockingButtonFactory)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public IDockingButtonFactory getDockingButtonFactory() {
        return this.dockingButtonFactory;
    }
}

