/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarLabel;
import de.javasoft.swing.plaf.DockbarLabelUI;
import de.javasoft.swing.plaf.basic.BasicDockingPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class BasicDockbarLabelUI
extends DockbarLabelUI {
    protected DockbarLabel label;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDockbarLabelUI();
    }

    public void installUI(JComponent jComponent) {
        this.label = (DockbarLabel)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListener();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults();
        this.uninstallListener();
    }

    protected void installDefaults() {
        this.updateDefaults();
    }

    protected void uninstallDefaults() {
    }

    protected void installListener() {
        this.label.addPropertyChangeListener(this);
    }

    protected void uninstallListener() {
        this.label.removePropertyChangeListener(this);
    }

    private void updateDefaults() {
        Serializable serializable;
        Font font = this.label.getFont();
        if (font == null || font instanceof UIResource) {
            String string;
            float f;
            serializable = UIManager.getFont("Label.font");
            int n = 0;
            String string2 = SyntheticaLookAndFeel.getString("JYDocking.dockbarLabel.font.style", this.label);
            if (string2 != null) {
                if (string2.contains("BOLD")) {
                    n |= 1;
                }
                if (string2.contains("ITALIC")) {
                    n |= 2;
                }
            }
            if ((f = SyntheticaLookAndFeel.scaleFontSize(SyntheticaLookAndFeel.getInt("JYDocking.dockbarLabel.font.size", this.label, 0))) == 0.0f) {
                f = ((Font)serializable).getSize();
            }
            if ((string = SyntheticaLookAndFeel.getString("JYDocking.dockbarLabel.font.name", this.label)) == null) {
                string = ((Font)serializable).getFamily();
            }
            this.label.setFont(new FontUIResource(string, n, (int)f));
        }
        if ((serializable = this.label.getForeground()) == null || serializable instanceof UIResource) {
            this.label.setForeground(SyntheticaLookAndFeel.getColor("JYDocking.dockbarLabel.foreground", this.label, (Color)serializable));
        }
        this.label.setOpaque(SyntheticaLookAndFeel.getBoolean("JYDocking.dockbarLabel.opaque", this.label, false));
        this.updateInsets(this.label.getPlacement());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        this.paintBackground(jComponent, graphics, n, n2, n3, n4, ((DockbarLabel)jComponent).getPlacement());
        super.paint(graphics, jComponent);
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        BasicDockingPainter.getInstance().paintDockingDockbarLabelBackground(jComponent, new SyntheticaState(), graphics, n, n2, n3, n4, n5);
    }

    protected void updateInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.dockbarLabel." + Dockbar.placementAsString(n) + ".insets", this.label);
        if (insets == null) {
            insets = n == 3 ? new Insets(2, 2, 2, 2) : (n == 4 ? new Insets(2, 2, 2, 2) : new Insets(2, 2, 2, 2));
        }
        this.label.setBorder(new EmptyBorder(insets));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateDefaults();
        }
        if ("placement".equals(string)) {
            this.updateInsets((Integer)propertyChangeEvent.getNewValue());
        }
    }
}

