/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jytable.filter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYButtonIcon;
import de.javasoft.swing.JYTable;
import de.javasoft.swing.JYTableHeader;
import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.ColumnFilterFactories;
import de.javasoft.swing.filter.IColumnFilterFactory;
import de.javasoft.swing.jytable.JYTableColumnExt;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.NumberFormatter;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.util.Contract;

public class FilterRowController
extends AbstractBean
implements UIDependent {
    public static final String CLEAR_FILTERS_DEFAULT_KEY_STROKE = "shift ESCAPE";
    private static final Logger LOG = Logger.getLogger(FilterRowController.class.getName());
    public static final String CLEAR_FILTERS_ACTION_COMMAND = "column.filtersClear";
    private final JYTable table;
    private JYTableHeader filterRow;
    private AbstractButton cornerButton;
    private List<ColumnFilter<? extends TableModel>> filters;
    private boolean andFilters;
    private boolean includeHidden;
    private boolean incremental;
    private PropertyChangeListener tableListener;
    private PropertyChangeListener headerListener;
    private TableColumnModelExtListener columnModelListener;
    private Map<Class<?>, IColumnFilterFactory<? extends TableModel>> defaultFilterFactories;
    private PropertyChangeListener filterListener;
    private AbstractActionExt clearAction;

    public FilterRowController(JYTable table) {
        this.table = table;
        this.includeHidden = true;
        this.andFilters = true;
        this.incremental = true;
        this.createDefaultFilterFactories();
        this.install();
    }

    public final JYTable getTable() {
        return this.table;
    }

    public JComponent getFilterRow() {
        return this.filterRow;
    }

    public JComponent getFilterRowCorner() {
        if (this.cornerButton == null) {
            this.cornerButton = this.createAndInstallCornerButton();
        }
        return this.cornerButton;
    }

    public void clearFilters() {
        for (ColumnFilter<? extends TableModel> input : this.getFilters()) {
            input.clear();
        }
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        if (this.isIncremental() == incremental) {
            return;
        }
        this.incremental = incremental;
        for (ColumnFilter<? extends TableModel> filter : this.getFilters()) {
            filter.setIncremental(incremental);
        }
        this.firePropertyChange("incremental", !incremental, this.isIncremental());
    }

    public void setAndFilters(boolean andFilters) {
        if (this.isAndFilters() == andFilters) {
            return;
        }
        this.andFilters = andFilters;
        this.updateCompoundFilter();
        this.firePropertyChange("andFilters", !andFilters, andFilters);
    }

    public boolean isAndFilters() {
        return this.andFilters;
    }

    public void setIncludeHidden(boolean includeHidden) {
        if (this.isIncludeHidden() == includeHidden) {
            return;
        }
        this.includeHidden = includeHidden;
        this.updateCompoundFilter();
        this.firePropertyChange("includeHidden", !includeHidden, includeHidden);
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public void setDefaultColumnFilterFactory(Class<?> clazz, IColumnFilterFactory<? extends TableModel> factory) {
        Contract.asNotNull(clazz, (String)"class must not be null in setting ColumnFilterFactory");
        if (clazz.equals(Object.class) && factory == null) {
            factory = this.createDefaultFilterFactory();
        }
        this.defaultFilterFactories.put(clazz, factory);
    }

    protected IColumnFilterFactory<TableModel> createDefaultFilterFactory() {
        return new ColumnFilterFactories.PatternColumnFilterFactory<TableModel>();
    }

    public IColumnFilterFactory<? extends TableModel> getDefaultColumnFilterFactory(Class<?> clazz) {
        if (clazz == null) {
            return this.getDefaultColumnFilterFactory(Object.class);
        }
        IColumnFilterFactory<? extends TableModel> factory = this.defaultFilterFactories.get(clazz);
        if (factory != null) {
            return factory;
        }
        return this.getDefaultColumnFilterFactory(clazz.getSuperclass());
    }

    protected void createDefaultFilterFactories() {
        this.defaultFilterFactories = new HashMap();
        this.defaultFilterFactories.put(Object.class, this.createDefaultFilterFactory());
        this.defaultFilterFactories.put(Date.class, new ColumnFilterFactories.DateColumnFilterFactory());
        this.defaultFilterFactories.put(Number.class, new ColumnFilterFactories.ComparableColumnFilterFactory());
        this.defaultFilterFactories.put(Float.class, this.createNumberFilterFactory(Float.class));
        this.defaultFilterFactories.put(Double.class, this.createNumberFilterFactory(Double.class));
        this.defaultFilterFactories.put(Boolean.class, new ColumnFilterFactories.BooleanColumnFilterFactory());
    }

    protected IColumnFilterFactory<? extends TableModel> createNumberFilterFactory(Class<? extends Number> numberClass) {
        NumberFormatter formatter = new NumberFormatter(NumberFormat.getNumberInstance());
        formatter.setValueClass(numberClass);
        ColumnFilterFactories.ComparableColumnFilterFactory factory = new ColumnFilterFactories.ComparableColumnFilterFactory(formatter);
        return factory;
    }

    public void updateUI() {
        SyntheticaAddonsUtilities.updateChildrenUI(this.getFilterRow());
        if (this.cornerButton != null) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.cornerButton);
        }
    }

    private void install() {
        this.initFilterRow();
        this.installTable();
    }

    private void initFilterRow() {
        this.filterRow = new JYTableHeader(this.table.getColumnModel());
        this.filterRow.setTable((JTable)((Object)this.table));
        this.filterRow.setSubHeader(true);
        this.propagateComponentPopup(false);
        this.filterRow.getActionMap().put(this.getClearFiltersAction().getActionCommand(), (Action)this.getClearFiltersAction());
        this.filterRow.getInputMap(1).put(this.getClearFiltersAction().getAccelerator(), this.getClearFiltersAction().getActionCommand());
    }

    protected AbstractButton createAndInstallCornerButton() {
        JButton cornerButton = new JButton((Action)this.getClearFiltersAction()){

            @Override
            protected void actionPropertyChanged(Action action, String propertyName) {
                super.actionPropertyChanged(action, propertyName);
                if (propertyName.equals("Name") || propertyName.equals("ShortDescription")) {
                    this.setToolTipText((String)action.getValue("Name"));
                }
            }

            @Override
            protected void configurePropertiesFromAction(Action a) {
                super.configurePropertiesFromAction(a);
                this.setToolTipText(a != null ? (String)a.getValue("Name") : null);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                CompoundBorder border = new CompoundBorder(BorderFactory.createEmptyBorder(), this.getBorder()){

                    @Override
                    public Insets getBorderInsets(Component c) {
                        Insets insets = super.getBorderInsets(c);
                        insets.left = 0;
                        insets.right = 0;
                        return insets;
                    }
                };
                this.setBorder(new BorderUIResource(border));
            }
        };
        cornerButton.setName("JYTable.FilterRowButton");
        cornerButton.setIcon((Icon)((Object)new FilterRowIcon(cornerButton, "JYTable.filterRow.button.icon", 7, 16)));
        cornerButton.setAction((Action)this.clearAction);
        cornerButton.setHideActionText(true);
        cornerButton.setFocusable(false);
        return cornerButton;
    }

    protected AbstractActionExt getClearFiltersAction() {
        if (this.clearAction == null) {
            this.clearAction = this.createClearFiltersAction();
        }
        return this.clearAction;
    }

    protected AbstractActionExt createClearFiltersAction() {
        BoundAction action = new BoundAction(null, CLEAR_FILTERS_ACTION_COMMAND);
        action.registerCallback((Object)this, "clearFilters");
        action.setAccelerator(this.getClearFiltersBinding());
        return action;
    }

    protected KeyStroke getClearFiltersBinding() {
        KeyStroke stroke;
        String key = UIManagerExt.getString((Object)"FilterRowController.column.filtersClear");
        if (key != null && (stroke = KeyStroke.getKeyStroke(key)) != null) {
            return stroke;
        }
        return KeyStroke.getKeyStroke(CLEAR_FILTERS_DEFAULT_KEY_STROKE);
    }

    private void installTable() {
        this.table.getActionMap().put(this.getClearFiltersAction().getActionCommand(), (Action)this.getClearFiltersAction());
        this.installHeaderListener();
        this.updateFromColumnModelChanged(null);
        this.table.addPropertyChangeListener(this.getTableListener());
    }

    private void addColumnFilters() {
        for (TableColumn tableColumn : this.table.getColumns(true)) {
            if (!(tableColumn instanceof JYTableColumnExt)) continue;
            this.createAndAddColumnFilter((JYTableColumnExt)((Object)tableColumn));
        }
    }

    protected void updateClearActionEnabled() {
        this.getClearFiltersAction().setEnabled(this.getTable().isEnabled() && this.getTable().getRowFilter() != null);
    }

    protected void updateFromColumnModelChanged(TableColumnModel oldColumnModel) {
        this.removeAll();
        if (oldColumnModel != null) {
            oldColumnModel.removeColumnModelListener((TableColumnModelListener)this.getColumnModelListener());
        }
        this.table.getColumnModel().addColumnModelListener((TableColumnModelListener)this.getColumnModelListener());
        this.filterRow.setColumnModel(this.table.getColumnModel());
        this.addColumnFilters();
        this.addFilteringComponents();
        this.updateCompoundFilter();
    }

    protected void updateFromTableHeaderChanged(JTableHeader oldHeader) {
        if (oldHeader != null) {
            oldHeader.removePropertyChangeListener(this.getHeaderListener());
        }
        if (this.table.getTableHeader() != null) {
            this.table.getTableHeader().addPropertyChangeListener(this.getHeaderListener());
            this.propagateComponentPopup(false);
        }
    }

    private PropertyChangeListener getTableListener() {
        if (this.tableListener == null) {
            this.tableListener = this.createTableListener();
        }
        return this.tableListener;
    }

    private PropertyChangeListener createTableListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnModel".equals(evt.getPropertyName())) {
                    FilterRowController.this.updateFromColumnModelChanged((TableColumnModel)evt.getOldValue());
                } else if ("enabled".equals(evt.getPropertyName())) {
                    FilterRowController.this.updateClearActionEnabled();
                } else if ("tableHeader".equals(evt.getPropertyName())) {
                    FilterRowController.this.updateFromTableHeaderChanged((JTableHeader)evt.getOldValue());
                }
            }
        };
        return l;
    }

    protected void propagateDraggedDistance(boolean toMainHeader) {
        if (toMainHeader) {
            this.table.getTableHeader().setDraggedDistance(this.filterRow.getDraggedDistance());
        } else {
            this.filterRow.setDraggedDistance(this.table.getTableHeader().getDraggedDistance());
        }
    }

    protected void propagateDraggedColumn(boolean toMainHeader) {
        if (toMainHeader) {
            this.table.getTableHeader().setDraggedColumn(this.filterRow.getDraggedColumn());
        } else {
            this.filterRow.setDraggedColumn(this.table.getTableHeader().getDraggedColumn());
        }
    }

    protected void propagateResizingColumn(boolean toMainHeader) {
        if (toMainHeader) {
            this.table.getTableHeader().setResizingColumn(this.filterRow.getResizingColumn());
        } else {
            this.filterRow.setResizingColumn(this.table.getTableHeader().getResizingColumn());
        }
    }

    protected void propagateComponentPopup(boolean toMainHeader) {
        if (toMainHeader) {
            return;
        }
        this.filterRow.setComponentPopupMenu(this.table.getTableHeader().getComponentPopupMenu());
    }

    private void installHeaderListener() {
        if (this.table.getTableHeader() == null) {
            return;
        }
        this.table.getTableHeader().addPropertyChangeListener(this.getHeaderListener());
        this.filterRow.addPropertyChangeListener(this.getHeaderListener());
    }

    private PropertyChangeListener getHeaderListener() {
        if (this.headerListener == null) {
            this.headerListener = this.createHeaderListener();
        }
        return this.headerListener;
    }

    private PropertyChangeListener createHeaderListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("draggedColumn".equals(evt.getPropertyName())) {
                    FilterRowController.this.propagateDraggedColumn(evt.getSource() == FilterRowController.this.filterRow);
                } else if ("draggedDistance".equals(evt.getPropertyName())) {
                    FilterRowController.this.propagateDraggedDistance(evt.getSource() == FilterRowController.this.filterRow);
                } else if ("resizingColumn".equals(evt.getPropertyName())) {
                    FilterRowController.this.propagateResizingColumn(evt.getSource() == FilterRowController.this.filterRow);
                } else if ("componentPopupMenu".equals(evt.getPropertyName())) {
                    FilterRowController.this.propagateComponentPopup(evt.getSource() == FilterRowController.this.filterRow);
                }
            }
        };
        return l;
    }

    protected void updateCompoundFilter() {
        ArrayList<RowFilter<? super TableModel, ? super Integer>> rowFilters = new ArrayList<RowFilter<? super TableModel, ? super Integer>>();
        for (ColumnFilter<? extends TableModel> filter : this.getFilters()) {
            RowFilter<? extends TableModel, Integer> rowFilter;
            if (this.ignoreFilter(filter) || !this.isFilterable(filter) || (rowFilter = filter.getRowFilter()) == null) continue;
            rowFilters.add(rowFilter);
        }
        this.table.setRowFilter(this.createRowFilter(rowFilters));
        this.updateClearActionEnabled();
    }

    private RowFilter<? super TableModel, ? super Integer> createRowFilter(List<RowFilter<? super TableModel, ? super Integer>> rowFilters) {
        if (rowFilters.size() == 0) {
            return null;
        }
        if (rowFilters.size() == 1) {
            return rowFilters.get(0);
        }
        if (this.isAndFilters()) {
            return RowFilter.andFilter(rowFilters);
        }
        return RowFilter.orFilter(rowFilters);
    }

    protected void updateFromFilterableChanged(JYTableColumnExt source) {
        ColumnFilter<? extends TableModel> filter = this.getColumnFilter(source);
        JComponent input = this.getFilteringComponent(filter);
        if (this.isFilterable(filter)) {
            if (input != null) {
                throw new IllegalStateException("unexpected input found: " + filter.getColumnIndex());
            }
            this.addFilteringComponent(filter);
        } else {
            this.filterRow.remove(input);
            filter.clear();
        }
    }

    protected void updateFromColumnFilterFactoryChanged(JYTableColumnExt source) {
        ColumnFilter<? extends TableModel> oldFilter = this.getColumnFilter(source);
        this.releaseFilterAndComponent(oldFilter);
        ColumnFilter<?> filter = this.createAndAddColumnFilter(source);
        this.addFilteringComponent(filter);
        this.updateCompoundFilter();
    }

    protected void updateFromColumnRemoved(int fromIndex) {
        if (this.isVisibilityChange(fromIndex, false)) {
            return;
        }
        for (ColumnFilter<? extends TableModel> filter : this.getFilters()) {
            TableColumn column = this.getColumnByModelIndex(filter.getColumnIndex());
            if (column != null) continue;
            this.releaseFilterAndComponent(filter);
            this.updateCompoundFilter();
            return;
        }
        throw new IllegalStateException("unexpected state after columnRemoved - either TableColumn was not of type JYTableColumnExt or TableColumnModel not of type DefaultTableColumnExt or  ?? ");
    }

    protected void updateFromColumnAdded(int toIndex) {
        if (this.isVisibilityChange(toIndex, true)) {
            return;
        }
        TableColumnExt column = this.table.getColumnExt(toIndex);
        if (column == null) {
            throw new IllegalStateException("unexpected state after columnAdded - either TableColumn was not of type JYTableColumnExt or TableColumnModel not of type DefaultTableColumnExt or  ?? ");
        }
        ColumnFilter<?> filter = this.createAndAddColumnFilter(column);
        this.addFilteringComponent(filter);
    }

    private boolean isVisibilityChange(int index, boolean added) {
        if (!(this.getTable().getColumnModel() instanceof DefaultTableColumnModelExt)) {
            return false;
        }
        DefaultTableColumnModelExt model = (DefaultTableColumnModelExt)this.getTable().getColumnModel();
        if (added) {
            return model.isAddedFromInvisibleEvent(index);
        }
        return model.isRemovedToInvisibleEvent(index);
    }

    protected TableColumnModelExtListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = this.createColumnModelListener();
        }
        return this.columnModelListener;
    }

    protected TableColumnModelExtListener createColumnModelListener() {
        return new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent event) {
                if ("filterable".equals(event.getPropertyName())) {
                    FilterRowController.this.updateFromFilterableChanged((JYTableColumnExt)((Object)event.getSource()));
                } else if ("columnFilterFactory".equals(event.getPropertyName())) {
                    FilterRowController.this.updateFromColumnFilterFactoryChanged((JYTableColumnExt)((Object)event.getSource()));
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
                FilterRowController.this.updateFromColumnAdded(e.getToIndex());
            }

            public void columnRemoved(TableColumnModelEvent e) {
                FilterRowController.this.updateFromColumnRemoved(e.getFromIndex());
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    private void removeAll() {
        int i = this.getFilters().size() - 1;
        while (i >= 0) {
            this.releaseFilterAndComponent(this.getFilters().get(i));
            --i;
        }
    }

    private void releaseFilterAndComponent(ColumnFilter<?> filter) {
        this.filterRow.remove(filter.getFilteringComponent());
        filter.removePropertyChangeListener(this.getColumnFilterListener());
        filter.release();
        this.getFilters().remove(filter);
    }

    private JComponent getFilteringComponent(ColumnFilter<?> filter) {
        Component[] componentArray = this.filterRow.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component input = componentArray[n2];
            if (input == filter.getFilteringComponent()) {
                return (JComponent)input;
            }
            ++n2;
        }
        return null;
    }

    public ColumnFilter<? extends TableModel> getColumnFilter(TableColumnExt source) {
        for (ColumnFilter<? extends TableModel> filter : this.getFilters()) {
            if (filter.getColumnIndex() != source.getModelIndex()) continue;
            return filter;
        }
        throw new IllegalStateException("could not find filter for column " + source);
    }

    protected ColumnFilter<?> createAndAddColumnFilter(TableColumnExt column) {
        ColumnFilter<? extends TableModel> filter = this.createColumnFilter(column);
        filter.addPropertyChangeListener(this.getColumnFilterListener());
        this.configureColumnFilter(filter);
        this.getFilters().add(filter);
        return filter;
    }

    private PropertyChangeListener getColumnFilterListener() {
        if (this.filterListener == null) {
            this.filterListener = this.createColumnFilterListener();
        }
        return this.filterListener;
    }

    private PropertyChangeListener createColumnFilterListener() {
        PropertyChangeListener filterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("rowFilter".equals(evt.getPropertyName())) {
                    FilterRowController.this.updateCompoundFilter();
                }
            }
        };
        return filterListener;
    }

    protected void configureColumnFilter(ColumnFilter<?> filter) {
        filter.setIncremental(this.isIncremental());
    }

    protected ColumnFilter<? extends TableModel> createColumnFilter(TableColumnExt tableColumn) {
        IColumnFilterFactory<? extends TableModel> factory = null;
        if (tableColumn instanceof JYTableColumnExt) {
            factory = ((JYTableColumnExt)tableColumn).getColumnFilterFactory();
        }
        if (factory == null) {
            Class<?> columnClass = this.table.getModel().getColumnClass(tableColumn.getModelIndex());
            factory = this.getDefaultColumnFilterFactory(columnClass);
        }
        return factory.createColumnFilter(tableColumn.getModelIndex());
    }

    private void addFilteringComponents() {
        for (ColumnFilter<? extends TableModel> columnFilter : this.getFilters()) {
            this.addFilteringComponent(columnFilter);
        }
    }

    private void addFilteringComponent(ColumnFilter<?> columnFilter) {
        if (!this.isFilterable(columnFilter)) {
            return;
        }
        this.filterRow.add(columnFilter.getFilteringComponent(), columnFilter.getColumnIndex());
    }

    protected boolean isFilterable(ColumnFilter<?> columnFilter) {
        TableColumn column = this.getColumnByModelIndex(columnFilter.getColumnIndex());
        if (column instanceof JYTableColumnExt) {
            return ((JYTableColumnExt)((Object)column)).isFilterable();
        }
        return true;
    }

    protected boolean ignoreFilter(ColumnFilter<?> filter) {
        if (this.isIncludeHidden()) {
            return false;
        }
        TableColumn column = this.getColumnByModelIndex(filter.getColumnIndex());
        if (column instanceof TableColumnExt) {
            return !((TableColumnExt)column).isVisible();
        }
        return false;
    }

    private TableColumn getColumnByModelIndex(int modelIndex) {
        List columns = this.table.getColumns(true);
        for (TableColumn tableColumn : columns) {
            if (tableColumn.getModelIndex() != modelIndex) continue;
            return tableColumn;
        }
        return null;
    }

    private List<ColumnFilter<? extends TableModel>> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<ColumnFilter<? extends TableModel>>();
        }
        return this.filters;
    }

    private static class FilterRowIcon
    extends JYButtonIcon {
        private AbstractButton b;

        public FilterRowIcon(AbstractButton b, String uiKey, int width, int height) {
            super(b, uiKey, width, height);
            this.b = b;
        }

        private Color getPaintColor(SyntheticaState state) {
            Color color = UIManager.getColor("Button.foreground");
            boolean isDarkForeground = (double)Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3])[2] < 0.5;
            int alpha = 255;
            if (state.isSet(SyntheticaState.State.DISABLED)) {
                alpha = isDarkForeground ? 80 : 96;
            } else if (state.isSet(SyntheticaState.State.PRESSED)) {
                alpha = 255;
            } else if (state.isSet(SyntheticaState.State.HOVER)) {
                alpha = isDarkForeground ? 136 : 255;
            }
            int rgba = alpha << 24 | 0xFFFFFF & color.getRGB();
            return new Color(rgba, true);
        }

        @Override
        public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
            g2.setPaint(this.getPaintColor(state));
            boolean ltr = this.b.getComponentOrientation().isLeftToRight();
            int xOffset = SyntheticaLookAndFeel.getInt("JYTable.filterRow.clearButton.defaultIcon.xOffset", null, 0);
            int yOffset = SyntheticaLookAndFeel.getInt("JYTable.filterRow.clearButton.defaultIcon.yOffset", null, 0);
            float corr = xOffset != 0 ? 0.0f : (this.b.getWidth() % 2 == 0 && !ltr ? -1.0f : 0.0f);
            float x_ = w / 2.0f + (float)xOffset + corr;
            float y_ = h / 2.0f - 4.5f + (float)yOffset;
            Shape s = this.createArrowShape(x_, y_, ltr);
            g2.fill(s);
            g2.draw(s);
            y_ = h / 2.0f + 4.0f + (float)yOffset;
            g2.setStroke(new BasicStroke(1.2f));
            s = this.createClearShape(x_, y_);
            g2.draw(s);
        }

        private Shape createArrowShape(float x, float y, boolean ltr) {
            GeneralPath path = new GeneralPath();
            float o = ltr ? 1.0f : -1.0f;
            path.moveTo(x - 2.0f * o, y);
            path.lineTo(x + 1.0f * o, y - 2.5f);
            path.lineTo(x + 1.0f * o, y + 2.5f);
            path.closePath();
            return path;
        }

        private Shape createClearShape(float x, float y) {
            GeneralPath path = new GeneralPath();
            path.moveTo(x - 2.0f, y - 2.0f);
            path.lineTo(x + 2.0f, y + 3.0f);
            path.moveTo(x + 2.0f, y - 2.0f);
            path.lineTo(x - 2.0f, y + 3.0f);
            return path;
        }

        @Override
        public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
            int hash = super.getCacheHash(sc, w, h, meta, id);
            hash = 31 * hash + (this.b.getComponentOrientation().isLeftToRight() ? 0 : 1);
            return hash;
        }
    }
}

