/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingStateListener;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.ILayoutNode;
import de.javasoft.swing.jydocking.IPerspectiveFactory;
import de.javasoft.swing.jydocking.IPerspectiveListener;
import de.javasoft.swing.jydocking.IPerspectiveManager;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveEvent;
import de.javasoft.swing.jydocking.PerspectiveModel;
import de.javasoft.swing.jydocking.RootWindow;
import de.javasoft.swing.jydocking.XMLPersister;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveManager
implements IPerspectiveManager {
    static final String DEFAULT_PERSPECTIVE_ID = "PerspectiveManager.DefaultPerspective";
    private static final PerspectiveManager INSTANCE = new PerspectiveManager();
    private static DockingStateListener dockingStateListener;
    private static String defaultPerspectiveID;
    private static String currentPerspectiveID;
    private static HashMap<String, Perspective> perspectives;
    private static boolean restoreFloatingOnLoad;
    private String persistenceKey;
    private IPerspectiveFactory perspectiveFactory;
    private InputStream inputStream;
    private OutputStream outputStream;

    static {
        perspectives = new HashMap();
        dockingStateListener = new DockingStateListener();
        PerspectiveManager.setDefaultPerspectiveID(DEFAULT_PERSPECTIVE_ID);
        PerspectiveManager.loadPerspective(defaultPerspectiveID, null, false);
        restoreFloatingOnLoad = true;
    }

    private PerspectiveManager() {
    }

    static PerspectiveManager getInstance() {
        return INSTANCE;
    }

    private static void add(Perspective perspective, boolean bl) {
        if (perspective == null) {
            throw new NullPointerException("perspective cannot be null");
        }
        String string = perspective.getID();
        perspectives.put(string, perspective);
        if (bl) {
            PerspectiveManager.setDefaultPerspectiveID(string);
        }
        PerspectiveManager.dispatchEvent(new PerspectiveEvent(perspective, 0));
    }

    static void remove(String string) {
        if (string == null) {
            throw new NullPointerException("perspectiveId cannot be null");
        }
        Perspective perspective = DockingManager.getPerspectiveManager().getPerspective(string);
        if (perspective == null) {
            return;
        }
        perspectives.remove(string);
        if (defaultPerspectiveID.equals(string)) {
            PerspectiveManager.setDefaultPerspectiveID(DEFAULT_PERSPECTIVE_ID);
        }
        PerspectiveManager.dispatchEvent(new PerspectiveEvent(perspective, 1));
    }

    static Perspective getDefaultPerspective() {
        return DockingManager.getPerspectiveManager().getPerspective(defaultPerspectiveID);
    }

    public static String getDefaultPerspectiveID() {
        return defaultPerspectiveID;
    }

    public static void setDefaultPerspectiveID(String string) {
        defaultPerspectiveID = string;
    }

    public static void setCurrentPerspectiveID(String string, boolean bl) {
        string = string == null ? defaultPerspectiveID : string;
        PerspectiveManager.setCurrentPerspectiveID(string);
        if (bl) {
            PerspectiveManager.setDefaultPerspectiveID(string);
        }
    }

    static void setCurrentPerspectiveID(String string) {
        currentPerspectiveID = string;
    }

    static String getCurrentPerspectiveID() {
        return currentPerspectiveID;
    }

    private static void applyPerspectives(IDockingPort iDockingPort, boolean bl) {
        String string = PerspectiveManager.getCurrentPerspectiveID();
        String string2 = string == null ? defaultPerspectiveID : string;
        for (Perspective perspective : DockingManager.getPerspectiveManager().getPerspectives()) {
            String string3 = perspective.getID();
            if (string3.equals(DEFAULT_PERSPECTIVE_ID) || !bl) continue;
            perspective.getModel().setRestorationLayout(null);
        }
        PerspectiveManager.loadPerspective(string2, iDockingPort, bl);
    }

    public static void loadPerspective(String string, Component component, boolean bl) {
        IDockingPort iDockingPort = DockingPortTracker.getRootDockingPort(component);
        Perspective perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        if (perspective != null) {
            perspective.updateRestorationLayoutNode(iDockingPort);
            perspective.unload();
            if (bl) {
                perspective.getModel().setRestorationLayout(null);
            }
        }
        PerspectiveManager.loadPerspective(string, iDockingPort, bl);
    }

    private static void loadPerspective(String string, IDockingPort iDockingPort, boolean bl) {
        Perspective perspective = DockingManager.getPerspectiveManager().getPerspective(string);
        if (perspective == null) {
            return;
        }
        PerspectiveManager.setCurrentPerspectiveID(string);
        if (bl) {
            perspective.reset(iDockingPort);
        } else {
            perspective.load(iDockingPort);
        }
        perspective.updateRestorationLayoutNode(iDockingPort);
        if (iDockingPort != null) {
            RootWindow.getRootWindow(iDockingPort.getComponent()).setPerspectiveID(string);
        }
    }

    static DockingStateListener getDockingStateListener() {
        return dockingStateListener;
    }

    static void setDockingStateListening(boolean bl) {
        dockingStateListener.setEnabled(bl);
    }

    static boolean isDockingStateListening() {
        return dockingStateListener.isEnabled();
    }

    static void updateDockingStates(final IDockable[] iDockableArray) {
        if (iDockableArray == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int n = 0;
                while (n < iDockableArray.length) {
                    dockingStateListener.updateState(iDockableArray[n]);
                    ++n;
                }
            }
        });
    }

    static void clear(IDockingPort iDockingPort) {
        if (iDockingPort != null) {
            boolean bl = PerspectiveManager.isDockingStateListening();
            PerspectiveManager.setDockingStateListening(false);
            iDockingPort.clear();
            PerspectiveManager.setDockingStateListening(bl);
        }
    }

    private static boolean loadPerspectives(String string, InputStream inputStream) throws IOException {
        XMLPersister xMLPersister = new XMLPersister(string, PerspectiveManager.getInstance());
        xMLPersister.setInputStream(inputStream);
        if (string != null || inputStream != null) {
            return xMLPersister.load();
        }
        return false;
    }

    static void setPerspectives(Perspective[] perspectiveArray) {
        perspectives.clear();
        int n = 0;
        while (n < perspectiveArray.length) {
            PerspectiveManager.add(perspectiveArray[n], false);
            ++n;
        }
    }

    public static boolean isRestoreFloatingOnLoad() {
        return restoreFloatingOnLoad;
    }

    public static void setRestoreFloatingOnLoad(boolean bl) {
        restoreFloatingOnLoad = bl;
    }

    private static ILayoutNode createLayout(JSplitPane jSplitPane) {
        String string = (String)jSplitPane.getClientProperty("region");
        Component component = jSplitPane.getLeftComponent();
        Component component2 = jSplitPane.getRightComponent();
        float f = DockingUtility.calcSplitRatio(jSplitPane);
        PerspectiveModel.SplitNode splitNode = new PerspectiveModel.SplitNode(jSplitPane.getOrientation(), 0, f, null);
        splitNode.setDockingRegion(string);
        PerspectiveManager.link((ILayoutNode)splitNode, component);
        PerspectiveManager.link((ILayoutNode)splitNode, component2);
        return splitNode;
    }

    private static ILayoutNode createLayout(IDockable iDockable) {
        if (iDockable == null) {
            return null;
        }
        PerspectiveModel.DockableNode dockableNode = new PerspectiveModel.DockableNode();
        dockableNode.setDockableID(iDockable.getID());
        return dockableNode;
    }

    private static ILayoutNode[] createLayout(JTabbedPane jTabbedPane) {
        int n = jTabbedPane.getTabCount();
        ILayoutNode[] iLayoutNodeArray = new ILayoutNode[n];
        int n2 = 0;
        while (n2 < n) {
            Component component = jTabbedPane.getComponentAt(n2);
            IDockable iDockable = DockingManager.getDockable(component);
            iLayoutNodeArray[n2] = PerspectiveManager.createLayout(iDockable);
            ++n2;
        }
        return iLayoutNodeArray;
    }

    private static void link(ILayoutNode iLayoutNode, Component component) {
        if (component instanceof IDockingPort) {
            ILayoutNode iLayoutNode2 = DockingManager.getPerspectiveManager().createLayoutModel((IDockingPort)((Object)component));
            PerspectiveManager.link(iLayoutNode, iLayoutNode2);
        } else if (component instanceof JSplitPane) {
            ILayoutNode iLayoutNode3 = PerspectiveManager.createLayout((JSplitPane)component);
            PerspectiveManager.link(iLayoutNode, iLayoutNode3);
        } else if (component instanceof JTabbedPane) {
            ILayoutNode[] iLayoutNodeArray = PerspectiveManager.createLayout((JTabbedPane)component);
            int n = 0;
            while (n < iLayoutNodeArray.length) {
                PerspectiveManager.link(iLayoutNode, iLayoutNodeArray[n]);
                ++n;
            }
        } else {
            IDockable iDockable = DockingManager.getDockable(component);
            ILayoutNode iLayoutNode4 = PerspectiveManager.createLayout(iDockable);
            PerspectiveManager.link(iLayoutNode, iLayoutNode4);
        }
    }

    private static void link(ILayoutNode iLayoutNode, ILayoutNode iLayoutNode2) {
        if (iLayoutNode2 != null) {
            iLayoutNode.add(iLayoutNode2);
        }
    }

    static void dispatchEvent(PerspectiveEvent perspectiveEvent) {
        block6: for (IPerspectiveListener iPerspectiveListener : perspectiveEvent.getPerspective().getPerspectiveListeners()) {
            PerspectiveEvent perspectiveEvent2 = perspectiveEvent;
            switch (perspectiveEvent.getEventType()) {
                case 0: {
                    if (perspectiveEvent.getSource() instanceof Perspective) {
                        iPerspectiveListener.perspectiveAdded(perspectiveEvent2);
                        break;
                    }
                    if (!(perspectiveEvent.getSource() instanceof IDockable)) continue block6;
                    iPerspectiveListener.dockableAdded(perspectiveEvent2);
                    break;
                }
                case 1: {
                    if (perspectiveEvent.getSource() instanceof Perspective) {
                        iPerspectiveListener.perspectiveRemoved(perspectiveEvent2);
                        break;
                    }
                    if (!(perspectiveEvent.getSource() instanceof IDockable)) continue block6;
                    iPerspectiveListener.dockableRemoved(perspectiveEvent2);
                    break;
                }
                case 2: {
                    iPerspectiveListener.perspectiveChanged(perspectiveEvent2);
                    break;
                }
                case 3: {
                    iPerspectiveListener.perspectiveReset(perspectiveEvent2);
                    break;
                }
                default: {
                    throw new RuntimeException("Event not handled");
                }
            }
        }
    }

    @Override
    public ILayoutNode createLayoutModel(IDockingPort iDockingPort) {
        PerspectiveModel.DockingPortNode dockingPortNode = new PerspectiveModel.DockingPortNode();
        dockingPortNode.setUserObject(iDockingPort);
        JComponent jComponent = iDockingPort.getDockedComponent();
        PerspectiveManager.link((ILayoutNode)dockingPortNode, jComponent);
        return dockingPortNode;
    }

    @Override
    public boolean storePerspectives(Window window, String string) throws IOException {
        return this.storePerspectives(window, string, this.getOutputStream());
    }

    private boolean storePerspectives(Window window, String string, OutputStream outputStream) throws IOException {
        this.getCurrentPerspective().updateRestorationLayoutNode(DockingPortTracker.getRootDockingPort(window, false));
        String string2 = string == null ? this.getPersistenceKey() : string;
        XMLPersister xMLPersister = new XMLPersister(string2, this);
        xMLPersister.setOutputStream(outputStream);
        return xMLPersister.store();
    }

    @Override
    public boolean restorePerspectives(Window window, boolean bl) {
        return this.restorePerspectives(window, bl, this.getInputStream());
    }

    private boolean restorePerspectives(Window window, boolean bl, InputStream inputStream) {
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (bl) {
            try {
                bl2 = PerspectiveManager.loadPerspectives(this.getPersistenceKey(), inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        PerspectiveManager.applyPerspectives(DockingPortTracker.getRootDockingPort(window, false), this.getPersistenceKey() == null && inputStream == null);
        return bl2;
    }

    @Override
    public Perspective getCurrentPerspective() {
        return this.getPerspective(PerspectiveManager.getCurrentPerspectiveID());
    }

    @Override
    public Perspective getPerspective(String string) {
        if (string == null) {
            return null;
        }
        Perspective perspective = perspectives.get(string);
        if (perspective == null && (perspective = this.createPerspective(string)) != null) {
            PerspectiveManager.add(perspective, false);
        }
        return perspective;
    }

    boolean perspectiveIsValid(String string) {
        return perspectives.get(string) != null;
    }

    private Perspective createPerspective(String string) {
        if (DEFAULT_PERSPECTIVE_ID.equals(string)) {
            return new Perspective(DEFAULT_PERSPECTIVE_ID, DEFAULT_PERSPECTIVE_ID){
                private static final long serialVersionUID = 1781193914305449271L;

                public void load(IDockingPort iDockingPort) {
                }
            };
        }
        Perspective perspective = null;
        if (!(this.perspectiveFactory == null || (perspective = this.perspectiveFactory.getPerspective(string)) != null && perspective.getID().equals(string))) {
            throw new IllegalStateException("Perspective created by " + this.perspectiveFactory + " factory for perspective-ID: " + string + " is null or perspective-ID does not match intended ID. You're possibly using multiple perspective factories!");
        }
        return perspective;
    }

    @Override
    public ArrayList<Perspective> getPerspectives() {
        return new ArrayList<Perspective>(perspectives.values());
    }

    @Override
    public void removePerspective(Perspective perspective) {
        PerspectiveManager.remove(perspective.getID());
    }

    @Override
    public String getPersistenceKey() {
        return this.persistenceKey;
    }

    @Override
    public void setPersistenceKey(String string) {
        this.persistenceKey = string;
    }

    @Override
    public void setFactory(IPerspectiveFactory iPerspectiveFactory) {
        PerspectiveManager.getInstance().perspectiveFactory = iPerspectiveFactory;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

