/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.FloatPolicy;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IFloatPolicy;
import java.util.ArrayList;
import java.util.Map;

class FloatPolicyManager
implements IDockingEventListener {
    private static final FloatPolicyManager INSTANCE = new FloatPolicyManager();
    private static final String FLOATING_ALLOWED = "FloatPolicyManager.FLOATING_ALLOWED";
    private ArrayList<IFloatPolicy> policies = new ArrayList();
    private boolean globalFloatingEnabled;

    public static FloatPolicyManager getInstance() {
        return INSTANCE;
    }

    private FloatPolicyManager() {
        this.addPolicy(FloatPolicy.getInstance());
        this.globalFloatingEnabled = false;
    }

    public boolean isFloatingAllowed(IDockable iDockable) {
        Map<Object, Object> map = DragManager.getDragContext(iDockable);
        if (map == null) {
            return this.isPolicyFloatingSupported(iDockable);
        }
        Boolean bl = (Boolean)map.get(FLOATING_ALLOWED);
        return bl == null ? true : bl;
    }

    public boolean isPolicyFloatingSupported(IDockable iDockable) {
        if (iDockable == null) {
            return false;
        }
        for (IFloatPolicy iFloatPolicy : this.policies) {
            if (iFloatPolicy.isFloatingAllowed(iDockable)) continue;
            return false;
        }
        return true;
    }

    public void addPolicy(IFloatPolicy iFloatPolicy) {
        this.policies.add(iFloatPolicy);
    }

    public void removePolicy(IFloatPolicy iFloatPolicy) {
        this.policies.remove(iFloatPolicy);
    }

    public void setGlobalFloatingEnabled(boolean bl) {
        this.globalFloatingEnabled = bl;
    }

    public boolean isGlobalFloatingEnabled() {
        return this.globalFloatingEnabled;
    }

    public void dockableRegistered(DockingEvent dockingEvent) {
    }

    public void dockableUnregistered(DockingEvent dockingEvent) {
    }

    public void dockingCanceled(DockingEvent dockingEvent) {
    }

    public void dockingCompleted(DockingEvent dockingEvent) {
    }

    public void undockingStarted(DockingEvent dockingEvent) {
    }

    public void undockingCompleted(DockingEvent dockingEvent) {
    }

    public void dragStarted(DockingEvent dockingEvent) {
        Map<Object, Object> map = dockingEvent.getDragContext();
        IDockable iDockable = dockingEvent.getDockable();
        map.put(FLOATING_ALLOWED, this.isPolicyFloatingSupported(iDockable));
    }

    public void dropStarted(DockingEvent dockingEvent) {
        if (dockingEvent.isOverWindow()) {
            return;
        }
        if (!this.isFloatingAllowed(dockingEvent.getDockable())) {
            dockingEvent.consume();
            return;
        }
        for (IFloatPolicy iFloatPolicy : this.policies) {
            if (iFloatPolicy.isFloatDropAllowed(dockingEvent)) continue;
            dockingEvent.consume();
            return;
        }
    }
}

