/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.DragGlassPane;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.DragOperation;
import de.javasoft.swing.jydocking.FloatPolicyManager;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.RootWindow;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class DragPipeline {
    private boolean open;
    private RootWindow[] windows;
    private DragGlassPane currentGlasspane;
    private DragOperation dragOperation;
    private DragWindow dragWindow;

    public void open(DragOperation dragOperation) {
        this.dragOperation = dragOperation;
        this.setCurrentDragOperation(dragOperation);
        this.windows = RootWindow.getVisibleWindows();
        int n = 0;
        while (n < this.windows.length) {
            this.applyGlassPane(this.windows[n], this.createGlassPane());
            ++n;
        }
        dragOperation.start();
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    private DragGlassPane createGlassPane() {
        DragGlassPane dragGlassPane = new DragGlassPane();
        return dragGlassPane;
    }

    private void applyGlassPane(RootWindow rootWindow, DragGlassPane dragGlassPane) {
        dragGlassPane.setRootWindow(rootWindow);
        dragGlassPane.setCachedGlassPane(rootWindow.getGlassPane());
        rootWindow.setGlassPane(dragGlassPane);
        dragGlassPane.setVisible(true);
    }

    public DragOperation getDragOperation() {
        return this.dragOperation;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.clearDragWindow();
        int n = 0;
        while (n < this.windows.length) {
            Component component = this.windows[n].getGlassPane();
            if (component instanceof DragGlassPane) {
                DragGlassPane dragGlassPane = (DragGlassPane)component;
                dragGlassPane.setVisible(false);
                component = dragGlassPane.getCachedGlassPane();
                this.windows[n].setGlassPane(component);
                this.windows[n] = null;
            }
            ++n;
        }
        this.setCurrentDragOperation(null);
        this.open = false;
    }

    public void processDragEvent(MouseEvent mouseEvent) {
        if (!this.open) {
            return;
        }
        this.processDragEventImpl(mouseEvent);
    }

    private void processDragEventImpl(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RootWindow rootWindow = this.getTopmostWindow(point);
        boolean bl = rootWindow != null;
        DragGlassPane dragGlassPane = bl ? (DragGlassPane)rootWindow.getGlassPane() : null;
        this.dragOperation.updateMouse(mouseEvent);
        this.dragOperation.setOverWindow(bl);
        mouseEvent.consume();
        if (dragGlassPane == this.currentGlasspane) {
            if (this.currentGlasspane == null) {
                SwingUtilities.getRootPane(this.dragOperation.getDockableComponent()).setCursor(WidgetUtils.getDragCursor());
                this.drawDragWindow(null, this.dragOperation.getDragRect(true), point);
                return;
            }
            this.currentGlasspane.processDragEvent(this.dragOperation);
            this.clearDragWindow();
            return;
        }
        if (dragGlassPane == null) {
            this.currentGlasspane.clear();
            this.currentGlasspane = null;
            return;
        }
        if (this.currentGlasspane == null) {
            this.currentGlasspane = dragGlassPane;
            this.currentGlasspane.processDragEvent(this.dragOperation);
            return;
        }
        this.currentGlasspane.clear();
        this.currentGlasspane = dragGlassPane;
        this.currentGlasspane.processDragEvent(this.dragOperation);
    }

    private RootWindow getTopmostWindow(Point point) {
        RootWindow rootWindow = null;
        RootWindow[] rootWindowArray = this.windows;
        int n = this.windows.length;
        int n2 = 0;
        while (n2 < n) {
            RootWindow rootWindow2 = rootWindowArray[n2];
            Rectangle rectangle = rootWindow2.getRootComponent().getBounds();
            if (rectangle.contains(point) && rootWindow2.getGlassPane() instanceof DragGlassPane) {
                rootWindow = rootWindow2;
            }
            ++n2;
        }
        return rootWindow;
    }

    private void drawDragWindow(Graphics graphics, Rectangle rectangle, Point point) {
        Point point2;
        boolean bl = FloatPolicyManager.getInstance().isFloatingAllowed(this.dragOperation.getDockableReference());
        Point point3 = point2 = bl ? new Point(rectangle.x, rectangle.y) : new Point(point.x - 1, point.y - 1);
        if (this.dragWindow == null) {
            int n = bl ? rectangle.width : 3;
            int n2 = bl ? rectangle.height : 3;
            JComponent jComponent = this.dragOperation.getDockableComponent();
            this.dragWindow = new DragWindow(SwingUtilities.getWindowAncestor(jComponent), jComponent, bl);
            this.dragWindow.setBounds(point2.x, point2.y, n, n2);
            this.dragWindow.setVisible(true);
        } else {
            this.dragWindow.setLocation(point2.x, point2.y);
        }
    }

    private void clearDragWindow() {
        if (this.dragWindow != null) {
            this.dragWindow.setVisible(false);
            this.dragWindow.dispose();
            this.dragWindow = null;
        }
    }

    private void setCurrentDragOperation(DragOperation dragOperation) {
        DragOperation dragOperation2 = DragManager.getCurrentDragOperation();
        if (dragOperation == dragOperation2) {
            return;
        }
        IDockingPort iDockingPort = dragOperation == null ? dragOperation2.getSourcePort() : dragOperation.getSourcePort();
        DragManager.setCurrentDragOperation(dragOperation);
        if (iDockingPort instanceof Component) {
            iDockingPort.getComponent().repaint();
        }
    }

    private static class DragWindow
    extends JWindow {
        private static final long serialVersionUID = -8620509860787424418L;
        private BufferedImage image;
        private boolean floatingAllowed;

        public DragWindow(Window window, JComponent jComponent, boolean bl) throws HeadlessException {
            super(window);
            this.floatingAllowed = bl;
            this.setCursor(bl ? WidgetUtils.getDragCursor() : WidgetUtils.getStopCursor());
            if (bl) {
                this.image = new BufferedImage(jComponent.getWidth(), jComponent.getHeight(), 2);
                Graphics2D graphics2D = this.image.createGraphics();
                jComponent.print(graphics2D);
                graphics2D.dispose();
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.floatingAllowed) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.75f);
                graphics2D.setComposite(alphaComposite);
                graphics2D.drawImage((Image)this.image, 0, 0, null);
            }
        }
    }
}

