/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.BorderManager;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingSplitPane;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.DragTabListener;
import de.javasoft.swing.jydocking.IBorderManager;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.ILayoutNode;
import de.javasoft.swing.jydocking.IRegionChecker;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.PerspectiveModel;
import de.javasoft.swing.jydocking.RegionChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingPort
extends JPanel
implements IDockingPort,
IDockingConstants {
    private static final long serialVersionUID = -3178316774389639543L;
    private static final WeakHashMap<Component, String> COMPONENT_TITLES = new WeakHashMap();
    protected ArrayList<IDockingEventListener> dockingListeners;
    private IBorderManager borderManager;
    private String id;
    private boolean tabsAsDragSourceEnabled;
    private boolean rootPort;
    private static PropertyChangeListener dockablePropertyHandler = new DockablePropertyChangeHandler();
    private MaximizationInstallInfo maximizationInstallInfo;
    private MaximizationReleaseInfo maximizationReleaseInfo;
    private static final IRegionChecker DEFAULT_REGION_CHECKER = new RegionChecker();
    private IRegionChecker regionChecker;
    private boolean singleTabAllowed;
    private int tabPlacement;
    private HashMap<String, Float> regionInset;

    public DockingPort() {
        this(UUID.randomUUID().toString());
    }

    public DockingPort(String string) {
        this.setID(string);
        this.dockingListeners = new ArrayList(2);
        this.addDockingListener(this);
        this.addHierarchyListener(DockingPortTracker.getInstance());
        this.addAncestorListener(DockingPortTracker.getInstance());
        this.rootPort = true;
        this.setLayout(this.createLayout());
        this.setBorderManager(this.createBorderManager());
        this.regionChecker = DEFAULT_REGION_CHECKER;
        this.tabPlacement = 3;
        this.regionInset = new HashMap();
        this.regionInset.put("NORTH", Float.valueOf(0.25f));
        this.regionInset.put("SOUTH", Float.valueOf(0.25f));
        this.regionInset.put("EAST", Float.valueOf(0.25f));
        this.regionInset.put("WEST", Float.valueOf(0.25f));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public IDockable getDockable(String string) {
        JComponent jComponent = this.getDockedComponent(string);
        return DockingManager.getDockable(jComponent);
    }

    @Override
    public JComponent getDockedComponent() {
        return this.getDockedComponent(null);
    }

    @Override
    public JComponent getDockedComponent(String string) {
        JComponent jComponent;
        JComponent jComponent2 = jComponent = this.getComponentCount() == 0 ? null : (JComponent)this.getComponent(0);
        if (string == null) {
            return jComponent;
        }
        if (jComponent == null) {
            return null;
        }
        if (jComponent instanceof JTabbedPane) {
            if (!"CENTER".equals(string)) {
                return null;
            }
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            return (JComponent)jTabbedPane.getSelectedComponent();
        }
        if (jComponent instanceof JSplitPane) {
            Component component;
            boolean bl;
            if ("CENTER".equals(string)) {
                return null;
            }
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            boolean bl2 = bl = jSplitPane.getOrientation() == 1;
            if (bl ? "NORTH".equals(string) || "SOUTH".equals(string) : "EAST".equals(string) || "WEST".equals(string)) {
                return null;
            }
            boolean bl3 = "NORTH".equals(string) || "WEST".equals(string);
            Component component2 = component = bl3 ? jSplitPane.getLeftComponent() : jSplitPane.getRightComponent();
            if (!(component instanceof IDockingPort)) {
                return null;
            }
            return ((IDockingPort)((Object)component)).getDockedComponent();
        }
        return "CENTER".equals(string) ? jComponent : null;
    }

    public boolean dock(IDockable iDockable, String string) {
        return this.dock(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
    }

    @Override
    public boolean dock(IDockable iDockable, Perspective perspective, String string) {
        boolean bl;
        if (iDockable == null) {
            return false;
        }
        JComponent jComponent = iDockable.getComponent();
        if (jComponent == null) {
            return false;
        }
        JComponent jComponent2 = this.getDockedComponent();
        if (jComponent == jComponent2) {
            return false;
        }
        if (jComponent2 == null) {
            string = "CENTER";
        }
        String string2 = iDockable.getTabText();
        COMPONENT_TITLES.put(jComponent, string2);
        if (!this.isSingleTabAllowed() && jComponent2 == null) {
            this.setDockedComponent(jComponent, perspective, string);
            this.evaluateDockingBorderStatus();
            return true;
        }
        this.updateSelectedDockingState(iDockable, false);
        boolean bl2 = bl = "CENTER".equals(string) ? this.dockInCenterRegion(jComponent, perspective) : this.dockInOuterRegion(jComponent, perspective, string);
        if (bl) {
            this.evaluateDockingBorderStatus();
            if (!"CENTER".equals(string)) {
                this.resetSplitDividerLocation();
            }
        }
        return bl;
    }

    @Override
    public boolean undock(IDockable iDockable) {
        return this.undockComponent(iDockable.getComponent());
    }

    public boolean dockComponent(JComponent jComponent, String string) {
        return this.dockComponent(jComponent, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
    }

    @Override
    public boolean dockComponent(JComponent jComponent, Perspective perspective, String string) {
        if (jComponent == null || string == null) {
            return false;
        }
        IDockable iDockable = DockingManager.getDockable(jComponent);
        if (iDockable == null) {
            iDockable = DockingManager.registerDockableComponent(jComponent);
        }
        return this.dock(iDockable, perspective, string);
    }

    @Override
    public boolean undockComponent(JComponent jComponent) {
        if (!this.isParentDockingPort(jComponent)) {
            return false;
        }
        Container container = jComponent.getParent();
        if (container.getParent() instanceof JYTabbedPane) {
            container = container.getParent();
        }
        container.remove(jComponent);
        this.reevaluateContainerTree();
        return true;
    }

    @Override
    public void setID(String string) {
        if (string == null) {
            string = UUID.randomUUID().toString();
        }
        this.id = string;
        DockingPortTracker.updateIndex(this);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getRegion(Point point) {
        if (point == null) {
            return "UNKNOWN";
        }
        IRegionChecker iRegionChecker = this.getRegionChecker();
        IDockable iDockable = this.getDockableAt(point);
        JComponent jComponent = this;
        if (iDockable != null) {
            jComponent = iDockable.getComponent();
            point = SwingUtilities.convertPoint(this, point, jComponent);
        }
        return iRegionChecker.getRegion(jComponent, point);
    }

    @Override
    public IDockingStrategy getDockingStrategy() {
        return DockingManager.getDockingStrategy(this);
    }

    @Override
    public Set<IDockable> getDockables() {
        return this.getDockables(-1, 0, null);
    }

    protected Set<IDockable> getDockables(int n, int n2, Class<?> clazz) {
        Component component = this.getDockedComponent();
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            int n3 = jTabbedPane.getTabCount();
            HashSet<IDockable> hashSet = new HashSet<IDockable>(n3);
            int n4 = 0;
            while (n4 < n3) {
                component = jTabbedPane.getComponentAt(n4);
                if (this.isValidDockableChild(component, clazz)) {
                    if (component instanceof IDockable) {
                        hashSet.add((IDockable)((Object)component));
                    } else {
                        hashSet.add(DockingManager.getDockable(component));
                    }
                }
                ++n4;
            }
            return hashSet;
        }
        HashSet<IDockable> hashSet = new HashSet<IDockable>(1);
        if (component instanceof JSplitPane && (n < 0 || n2 <= n)) {
            JSplitPane jSplitPane = (JSplitPane)component;
            Component component2 = jSplitPane.getLeftComponent();
            Component component3 = jSplitPane.getRightComponent();
            if (component2 instanceof DockingPort) {
                hashSet.addAll(((DockingPort)component2).getDockables(n, n2 + 1, clazz));
            }
            if (component3 instanceof DockingPort) {
                hashSet.addAll(((DockingPort)component3).getDockables(n, n2 + 1, clazz));
            }
        }
        if (this.isValidDockableChild(component, clazz)) {
            if (component instanceof IDockable) {
                hashSet.add((IDockable)((Object)component));
            } else {
                hashSet.add(DockingManager.getDockable(component));
            }
        }
        return hashSet;
    }

    protected boolean isValidDockableChild(Component component, Class<?> clazz) {
        return clazz == null ? DockingManager.getDockable(component) != null : clazz.isAssignableFrom(component.getClass());
    }

    @Override
    public boolean isDockingAllowed(Component component, String string) {
        if (component == null || !DockingManager.isValidDockingRegion(string)) {
            return false;
        }
        IDockable iDockable = this.getCenterDockable();
        if (iDockable != null && component instanceof IDockable && !iDockable.getDockableAcceptor().acceptDockable((IDockable)((Object)component), string)) {
            return false;
        }
        if (!this.isParentDockingPort(component)) {
            return true;
        }
        JComponent jComponent = this.getDockedComponent();
        if (!(jComponent instanceof JTabbedPane)) {
            return false;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        return jTabbedPane.getTabCount() >= 2;
    }

    @Override
    public boolean isParentDockingPort(Component component) {
        if (component == null) {
            return false;
        }
        Container container = component.getParent();
        if (container == null) {
            return false;
        }
        if (container.getParent() instanceof JYTabbedPane) {
            container = container.getParent();
        }
        if (container == this) {
            return true;
        }
        return container == this.getDockedComponent();
    }

    @Override
    public void importLayout(ILayoutNode iLayoutNode) {
        if (!(iLayoutNode instanceof PerspectiveModel.DockingPortNode)) {
            return;
        }
        iLayoutNode.setUserObject(this);
        ArrayList<PerspectiveModel.SplitNode> arrayList = new ArrayList<PerspectiveModel.SplitNode>();
        this.constructLayout(iLayoutNode, arrayList);
        this.deferSplitPaneValidation(arrayList);
        this.revalidate();
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public void releaseForMaximization(IDockable iDockable) {
        if (this.maximizationReleaseInfo != null) {
            throw new IllegalStateException("Already released a Dockable for maximization.");
        }
        JComponent jComponent = iDockable.getComponent();
        this.maximizationReleaseInfo = new MaximizationReleaseInfo(jComponent, jComponent.getBorder());
        JComponent jComponent2 = this.getDockedComponent();
        if (jComponent2 == null) {
            throw new IllegalStateException("DefaultDockingPort is empty.");
        }
        if (jComponent2 instanceof JSplitPane) {
            throw new IllegalStateException("DefaultDockingPort does not directly contain a Dockable");
        }
        if (jComponent2 instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent2;
            this.maximizationReleaseInfo.setTabIndex(this.getTabIndex(jTabbedPane, jComponent));
            jTabbedPane.remove(jComponent);
        } else {
            if (jComponent != jComponent2) {
                throw new IllegalStateException("Dockable requesting maximization is not the one docked in this DefaultDockingPort.");
            }
            this.remove(jComponent);
        }
    }

    @Override
    public void returnFromMaximization() {
        JComponent jComponent = this.maximizationReleaseInfo.getContent();
        jComponent.setBorder(this.maximizationReleaseInfo.getBorder());
        int n = this.maximizationReleaseInfo.getTabIndex();
        this.maximizationReleaseInfo = null;
        JComponent jComponent2 = this.getDockedComponent();
        if (jComponent2 != null && jComponent2 instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent2;
            jTabbedPane.add(jComponent, this.getValidTabTitle(jTabbedPane, jComponent), n);
            jTabbedPane.setSelectedIndex(n);
        } else {
            this.setDockedComponent(jComponent);
        }
        this.revalidate();
    }

    @Override
    public void installMaximizedDockable(IDockable iDockable) {
        if (this.maximizationInstallInfo != null) {
            throw new IllegalStateException("Already maximized");
        }
        this.maximizationInstallInfo = new MaximizationInstallInfo(this.getDockedComponent(), this.getBorder());
        JComponent jComponent = iDockable.getComponent();
        this.setDockedComponent(jComponent);
        this.evaluateDockingBorderStatus();
        this.revalidate();
    }

    @Override
    public void uninstallMaximizedDockable() {
        if (this.maximizationInstallInfo == null) {
            throw new IllegalStateException("No dockable maximized.");
        }
        JComponent jComponent = this.maximizationInstallInfo.getContent();
        if (jComponent != null) {
            this.setDockedComponent(jComponent);
        }
        this.setBorder(this.maximizationInstallInfo.getBorder());
        this.maximizationInstallInfo = null;
        this.revalidate();
    }

    @Override
    public void addDockingListener(IDockingEventListener iDockingEventListener) {
        if (iDockingEventListener != null) {
            this.dockingListeners.add(iDockingEventListener);
        }
    }

    @Override
    public void removeDockingListener(IDockingEventListener iDockingEventListener) {
        if (iDockingEventListener != null) {
            this.dockingListeners.remove(iDockingEventListener);
        }
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.dockingListeners;
    }

    @Override
    public void setRegionChecker(IRegionChecker iRegionChecker) {
        IRegionChecker iRegionChecker2 = this.getRegionChecker();
        this.regionChecker = iRegionChecker;
        this.firePropertyChange("regionChecker", iRegionChecker2, iRegionChecker);
    }

    @Override
    public IRegionChecker getRegionChecker() {
        return this.regionChecker;
    }

    @Override
    public void setSingleTabAllowed(boolean bl) {
        boolean bl2 = this.isSingleTabAllowed();
        this.singleTabAllowed = bl;
        this.firePropertyChange("singleTabAllowed", bl2, bl);
    }

    @Override
    public boolean isSingleTabAllowed() {
        return this.singleTabAllowed;
    }

    @Override
    public void setTabPlacement(int n) {
        int n2 = this.getTabPlacement();
        this.tabPlacement = n;
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof JTabbedPane) {
            ((JTabbedPane)this.getComponent(0)).setTabPlacement(n);
        }
        this.firePropertyChange("tabPlacement", n2, n);
    }

    @Override
    public int getTabPlacement() {
        return this.tabPlacement;
    }

    @Override
    public void setSelectedTabIndex(int n) {
        if (this.getComponent(0) instanceof JYTabbedPane) {
            ((JYTabbedPane)this.getComponent(0)).setSelectedIndex(n, true);
        }
    }

    @Override
    public int getSelectedTabIndex() {
        if (this.getComponent(0) instanceof JTabbedPane) {
            return ((JTabbedPane)this.getComponent(0)).getSelectedIndex();
        }
        return -1;
    }

    @Override
    public void setRegionInset(String string, float f) {
        this.regionInset.put(string, Float.valueOf(f));
    }

    @Override
    public float getRegionInset(String string) {
        Float f = this.regionInset.get(string);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public void dockableRegistered(DockingEvent dockingEvent) {
    }

    @Override
    public void dockableUnregistered(DockingEvent dockingEvent) {
    }

    @Override
    public void dockingCanceled(DockingEvent dockingEvent) {
    }

    @Override
    public void dockingCompleted(DockingEvent dockingEvent) {
        IDockable iDockable = dockingEvent.getDockable();
        if (iDockable == null || dockingEvent.getNewDockingPort() != this) {
            return;
        }
        boolean bl = false;
        PropertyChangeListener[] propertyChangeListenerArray = iDockable.getComponent().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[n2];
            bl = propertyChangeListener == dockablePropertyHandler;
            ++n2;
        }
        if (!bl) {
            iDockable.getComponent().addPropertyChangeListener(dockablePropertyHandler);
        }
    }

    @Override
    public void undockingStarted(DockingEvent dockingEvent) {
    }

    @Override
    public void undockingCompleted(DockingEvent dockingEvent) {
        IDockable iDockable = dockingEvent.getDockable();
        iDockable.getComponent().removePropertyChangeListener(dockablePropertyHandler);
    }

    @Override
    public void dragStarted(DockingEvent dockingEvent) {
    }

    @Override
    public void dropStarted(DockingEvent dockingEvent) {
    }

    @Override
    public Component add(Component component) {
        return this.setDockedComponent((JComponent)component);
    }

    @Override
    public Component add(Component component, int n) {
        return this.setDockedComponent((JComponent)component);
    }

    @Override
    public void add(Component component, Object object) {
        this.setDockedComponent((JComponent)component);
    }

    @Override
    public void add(Component component, Object object, int n) {
        this.setDockedComponent((JComponent)component);
    }

    @Override
    public Component add(String string, Component component) {
        return this.setDockedComponent((JComponent)component);
    }

    private void addCmp(IDockingPort iDockingPort, JComponent jComponent) {
        if (iDockingPort instanceof Container) {
            ((Container)((Object)iDockingPort)).add(jComponent);
        }
    }

    public void dock(IDockable iDockable) {
        this.dock(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective());
    }

    void dock(IDockable iDockable, Perspective perspective) {
        this.dock(iDockable, perspective, "CENTER");
    }

    protected LayoutManager createLayout() {
        return new PortLayout();
    }

    protected IBorderManager createBorderManager() {
        return new BorderManager(new EmptyBorder(0, 0, 0, 0));
    }

    public void setBorderManager(IBorderManager iBorderManager) {
        this.borderManager = iBorderManager;
    }

    public IBorderManager getBorderManager() {
        return this.borderManager;
    }

    public void setTabsAsDragSourceEnabled(boolean bl) {
        this.tabsAsDragSourceEnabled = bl;
    }

    public boolean isTabsAsDragSourceEnabled() {
        return this.tabsAsDragSourceEnabled;
    }

    @Override
    public boolean isRoot() {
        return this.rootPort;
    }

    void setRoot(boolean bl) {
        this.rootPort = bl;
    }

    protected JTabbedPane createTabbedPane() {
        JYTabbedPane jYTabbedPane = new JYTabbedPane();
        jYTabbedPane.setFocusable(false);
        jYTabbedPane.setTabReorderByDraggingEnabled(false);
        jYTabbedPane.setTabPlacement(this.getTabPlacement());
        DragTabListener dragTabListener = new DragTabListener();
        jYTabbedPane.addMouseListener(dragTabListener);
        jYTabbedPane.addMouseMotionListener(dragTabListener);
        return jYTabbedPane;
    }

    protected void updateTab(IDockable iDockable) {
        JTabbedPane jTabbedPane;
        int n;
        JComponent jComponent = this.getDockedComponent();
        if (jComponent instanceof JTabbedPane && (n = (jTabbedPane = (JTabbedPane)jComponent).indexOfComponent(iDockable.getComponent())) > -1) {
            jTabbedPane.setIconAt(n, iDockable.getTabIcon());
            jTabbedPane.setTitleAt(n, iDockable.getTabText());
        }
    }

    void evaluateDockingBorderStatus() {
        if (this.borderManager == null) {
            return;
        }
        JComponent jComponent = this.getDockedComponent();
        if (jComponent == null) {
            this.borderManager.managePortNullChild(this);
        } else if (jComponent instanceof JSplitPane) {
            this.borderManager.managePortSplitChild(this);
        } else if (jComponent instanceof JTabbedPane) {
            this.borderManager.managePortTabbedChild(this);
        } else {
            this.borderManager.managePortSimpleChild(this);
        }
    }

    private IDockable getDockableAt(Point point) {
        if (point == null) {
            return null;
        }
        JComponent jComponent = this.getDockedComponent();
        if (jComponent == null || jComponent instanceof JSplitPane) {
            return null;
        }
        if (jComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            Component component = jTabbedPane.getComponentAt(jTabbedPane.getSelectedIndex());
            return component instanceof IDockable ? (IDockable)((Object)component) : DockingManager.getDockable(component);
        }
        return DockingManager.getDockable(jComponent);
    }

    private JComponent setDockedComponent(JComponent jComponent, Perspective perspective, String string) {
        JComponent jComponent2;
        IDockable iDockable = DockingManager.getDockable(jComponent);
        if (jComponent instanceof JTabbedPane) {
            jComponent2 = (JTabbedPane)jComponent;
            iDockable = DockingManager.getDockable(((JTabbedPane)jComponent2).getSelectedComponent());
            if (iDockable != null) {
                this.updateDockingState(iDockable, perspective, string);
            }
        } else if (jComponent instanceof JSplitPane) {
            jComponent2 = (JSplitPane)jComponent;
            iDockable = DockingManager.getDockable(((JSplitPane)jComponent2).getLeftComponent());
            if (iDockable != null) {
                this.updateDockingState(iDockable, perspective, string);
            }
            if ((iDockable = DockingManager.getDockable(((JSplitPane)jComponent2).getRightComponent())) != null) {
                this.updateDockingState(iDockable, perspective, string);
            }
        } else if (iDockable != null) {
            this.updateDockingState(iDockable, perspective, string);
        }
        jComponent2 = this.setDockedComponent(jComponent);
        return jComponent2;
    }

    private void updateDockingState(IDockable iDockable, Perspective perspective, String string) {
        DockingEvent dockingEvent = new DockingEvent(iDockable, iDockable.getDockingPort(), this, 4, DragManager.getDragContext(iDockable));
        dockingEvent.setPerspective(perspective);
        dockingEvent.setRegion(string);
        DockingManager.dispatchEvent(dockingEvent, true, true);
    }

    private JComponent setDockedComponent(JComponent jComponent) {
        this.removeAll();
        JComponent jComponent2 = (JComponent)super.add(jComponent);
        return jComponent2;
    }

    private void resetSplitDividerLocation() {
        JComponent jComponent = this.getDockedComponent();
        if (jComponent instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            IDockingStrategy iDockingStrategy = DockingManager.getDockingStrategy(this);
            int n = iDockingStrategy.getInitialDividerLocation(this, jSplitPane);
            jSplitPane.setDividerLocation(n);
        }
    }

    private void constructLayout(ILayoutNode iLayoutNode, ArrayList<PerspectiveModel.SplitNode> arrayList) {
        Object object = iLayoutNode.getUserObject();
        if (iLayoutNode instanceof PerspectiveModel.SplitNode) {
            arrayList.add((PerspectiveModel.SplitNode)iLayoutNode);
        }
        Enumeration<? extends TreeNode> enumeration = iLayoutNode.children();
        while (enumeration.hasMoreElements()) {
            ILayoutNode iLayoutNode2 = (ILayoutNode)enumeration.nextElement();
            this.constructLayout(iLayoutNode2, arrayList);
        }
        if (iLayoutNode instanceof PerspectiveModel.SplitNode) {
            this.reconstruct((PerspectiveModel.SplitNode)iLayoutNode);
        } else if (iLayoutNode instanceof PerspectiveModel.DockingPortNode) {
            this.reconstruct((PerspectiveModel.DockingPortNode)iLayoutNode);
        }
    }

    private boolean dockInCenterRegion(Component component, Perspective perspective) {
        JComponent jComponent = this.getDockedComponent();
        JTabbedPane jTabbedPane = null;
        if (jComponent instanceof JTabbedPane) {
            jTabbedPane = (JTabbedPane)jComponent;
            this.addTab(jTabbedPane, component);
            jTabbedPane.revalidate();
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            this.updateDockingState(DockingManager.getDockable(component), perspective, "CENTER");
            return true;
        }
        jTabbedPane = this.createTabbedPane();
        if (jTabbedPane == null) {
            return false;
        }
        jTabbedPane.addChangeListener(ActiveDockableTracker.getInstance());
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                int n2 = 0;
                while (n2 < jTabbedPane.getTabCount()) {
                    Component component = jTabbedPane.getComponentAt(n2);
                    if (component instanceof IDockable) {
                        IDockable iDockable = (IDockable)((Object)component);
                        boolean bl = n2 == n;
                        DockingPort.this.updateSelectedDockingState(iDockable, bl);
                    }
                    ++n2;
                }
            }
        });
        if (jComponent != null) {
            this.remove(jComponent);
            if (jComponent instanceof DockingSplitPane) {
                this.addSplitPanelToTabbedPane(jTabbedPane, (DockingSplitPane)jComponent);
            } else {
                this.addTab(jTabbedPane, jComponent);
            }
        }
        this.addTab(jTabbedPane, component);
        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        this.setDockedComponent(jTabbedPane, perspective, "CENTER");
        return true;
    }

    private void updateSelectedDockingState(IDockable iDockable, boolean bl) {
        DockingState dockingState;
        Perspective perspective = PerspectiveManager.getInstance().getCurrentPerspective();
        if (!perspective.isLoading() && !perspective.isUnloading() && (dockingState = perspective.getModel().getDockingState(iDockable, false)) != null) {
            dockingState.setSelected(bl);
        }
    }

    private void addSplitPanelToTabbedPane(JTabbedPane jTabbedPane, DockingSplitPane dockingSplitPane) {
        JComponent jComponent = ((DockingPort)dockingSplitPane.getLeftComponent()).getDockedComponent();
        if (jComponent instanceof DockingSplitPane) {
            this.addSplitPanelToTabbedPane(jTabbedPane, (DockingSplitPane)jComponent);
        } else {
            this.addTab(jTabbedPane, jComponent);
        }
        JComponent jComponent2 = ((DockingPort)dockingSplitPane.getRightComponent()).getDockedComponent();
        if (jComponent2 instanceof DockingSplitPane) {
            this.addSplitPanelToTabbedPane(jTabbedPane, (DockingSplitPane)jComponent2);
        } else {
            this.addTab(jTabbedPane, jComponent2);
        }
    }

    private void addTab(JTabbedPane jTabbedPane, Component component) {
        IDockable iDockable;
        String string = this.getValidTabTitle(jTabbedPane, component);
        jTabbedPane.add(component, string);
        if (!jTabbedPane.isValid()) {
            jTabbedPane.validate();
        }
        if ((iDockable = DockingManager.getDockable(component)) == null) {
            return;
        }
        Icon icon = iDockable.getTabIcon();
        int n = jTabbedPane.getTabCount() - 1;
        jTabbedPane.setIconAt(n, icon);
    }

    private boolean dockInOuterRegion(JComponent jComponent, Perspective perspective, String string) {
        JComponent jComponent2 = this.getDockedComponent();
        this.remove(jComponent2);
        IDockingStrategy iDockingStrategy = this.getDockingStrategy();
        IDockingPort iDockingPort = iDockingStrategy.createDockingPort(this);
        IDockingPort iDockingPort2 = iDockingStrategy.createDockingPort(this);
        this.addCmp(iDockingPort, jComponent2);
        iDockingPort2.dockComponent(jComponent, perspective, "CENTER");
        JSplitPane jSplitPane = iDockingStrategy.createSplitPane(this, string);
        IDockingPort[] iDockingPortArray = this.putPortsInOrder(iDockingPort, iDockingPort2, string);
        if (iDockingPortArray[0] != null) {
            jSplitPane.setLeftComponent(iDockingPortArray[0].getComponent());
        }
        if (iDockingPortArray[1] != null) {
            jSplitPane.setRightComponent(iDockingPortArray[1].getComponent());
        }
        double d = 0.5;
        IDockable iDockable = DockingManager.getDockable(jComponent2);
        if (iDockable != null && jSplitPane instanceof DockingSplitPane) {
            Float f = Float.valueOf(iDockable.getSiblingSize(string));
            if (f != null) {
                d = f.doubleValue();
            }
            ((DockingSplitPane)jSplitPane).setInitialDividerRatio(d);
        }
        jSplitPane.setDividerLocation(d);
        this.setDockedComponent(jSplitPane, perspective, string);
        if (this.isShowing()) {
            return true;
        }
        double d2 = iDockingStrategy.getDividerProportion(this, jSplitPane);
        iDockingPort.getComponent().putClientProperty("DefaultDockingStrategy.PREFERRED_PROPORTION", new Float(d2));
        iDockingPort2.getComponent().putClientProperty("DefaultDockingStrategy.PREFERRED_PROPORTION", new Float(1.0 - d2));
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        int n = SyntheticaLookAndFeel.getInt("JYDocking.minimumPortSizeWidth", this, 80);
        int n2 = SyntheticaLookAndFeel.getInt("JYDocking.minimumPortSizeHeight", this, 40);
        Dimension dimension2 = dimension = SyntheticaLookAndFeel.getBoolean("JYDocking.respectMinimumDockableSize", this, false) ? super.getMinimumSize() : null;
        if (dimension == null || dimension.width < n && dimension.height < n2) {
            return new Dimension(n, n2);
        }
        if (dimension.width < n) {
            return new Dimension(n, dimension.height);
        }
        if (dimension.height < n2) {
            return new Dimension(dimension.width, n2);
        }
        return dimension;
    }

    private String getValidTabTitle(JTabbedPane jTabbedPane, Component component) {
        String string = COMPONENT_TITLES.get(component);
        if (string == null || string.trim().length() == 0) {
            string = "null";
        }
        int n = jTabbedPane.getTabCount();
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        int n3 = 0;
        while (n3 < n) {
            string2 = jTabbedPane.getTitleAt(n3).toLowerCase();
            hashSet.add(string2);
            if (string2.startsWith(string.toLowerCase())) {
                ++n2;
            }
            ++n3;
        }
        if (hashSet.contains(string) && n2 > 0) {
            string = String.valueOf(string) + n2;
        }
        COMPONENT_TITLES.put(component, string);
        return string;
    }

    private boolean isSingleComponentDocked() {
        JComponent jComponent = this.getDockedComponent();
        if (jComponent == null) {
            return false;
        }
        if (jComponent instanceof JSplitPane) {
            return false;
        }
        if (jComponent instanceof JTabbedPane) {
            return ((JTabbedPane)jComponent).getTabCount() == 1;
        }
        return true;
    }

    protected IDockable getCenterDockable() {
        if (!this.isSingleComponentDocked()) {
            return null;
        }
        Component component = this.getDockedComponent();
        if (component instanceof JTabbedPane) {
            component = ((JTabbedPane)component).getComponentAt(0);
        }
        return DockingManager.getDockable(component);
    }

    private IDockingPort[] putPortsInOrder(IDockingPort iDockingPort, IDockingPort iDockingPort2, String string) {
        if ("NORTH".equals(string) || "WEST".equals(string)) {
            return new IDockingPort[]{iDockingPort2, iDockingPort};
        }
        return new IDockingPort[]{iDockingPort, iDockingPort2};
    }

    private void reevaluateContainerTree() {
        this.reevaluateDockingWrapper();
        this.reevaluateTabbedPane();
        this.evaluateDockingBorderStatus();
    }

    private void reevaluateDockingWrapper() {
        Container container;
        JComponent jComponent = this.getDockedComponent();
        Container container2 = this.getParent();
        Container container3 = container = container2 == null ? null : container2.getParent();
        if (jComponent == null && container2 instanceof JSplitPane && container instanceof DockingPort) {
            container2.remove(this);
            ((DockingPort)container).reevaluateContainerTree();
        } else if (jComponent instanceof JSplitPane) {
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            JComponent jComponent2 = (JComponent)jSplitPane.getLeftComponent();
            JComponent jComponent3 = (JComponent)jSplitPane.getRightComponent();
            if (jComponent2 != null && jComponent3 != null) {
                return;
            }
            if (jComponent2 == jComponent3) {
                this.removeAll();
                return;
            }
            JComponent jComponent4 = jComponent2 == null ? jComponent3 : jComponent2;
            jSplitPane.remove(jComponent4);
            if (jSplitPane instanceof DockingSplitPane) {
                ((DockingSplitPane)jSplitPane).cleanup();
            }
            super.remove(jSplitPane);
            if (jComponent4 instanceof DockingPort) {
                jComponent4 = ((DockingPort)jComponent4).getDockedComponent();
            }
            if (jComponent4 != null) {
                this.setDockedComponent(jComponent4);
            }
        }
    }

    private void reevaluateTabbedPane() {
        Container container;
        Container container2;
        int n;
        JComponent jComponent = this.getDockedComponent();
        if (!(jComponent instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        int n2 = jTabbedPane.getTabCount();
        int n3 = n = this.isSingleTabAllowed() ? 0 : 1;
        if (n2 > n) {
            return;
        }
        JComponent jComponent2 = n2 == 1 ? (JComponent)jTabbedPane.getComponentAt(0) : null;
        this.removeAll();
        if (jComponent2 != null) {
            jComponent2.setVisible(true);
            this.setDockedComponent(jComponent2);
        }
        Container container3 = container2 = (container = this.getParent()) == null ? null : container.getParent();
        if (jComponent2 == null && container instanceof JSplitPane && container2 instanceof DockingPort) {
            container.remove(this);
            ((DockingPort)container2).reevaluateContainerTree();
        }
    }

    private void reconstruct(PerspectiveModel.DockingPortNode dockingPortNode) {
        DockingPort dockingPort = (DockingPort)dockingPortNode.getDockingPort();
        if (dockingPortNode.isSplit()) {
            PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)dockingPortNode.getChildAt(0);
            JSplitPane jSplitPane = splitNode.getSplitPane();
            dockingPort.setDockedComponent(jSplitPane);
            dockingPort.evaluateDockingBorderStatus();
            return;
        }
        Enumeration<TreeNode> enumeration = dockingPortNode.children();
        while (enumeration.hasMoreElements()) {
            ILayoutNode iLayoutNode = (ILayoutNode)enumeration.nextElement();
            if (!(iLayoutNode instanceof PerspectiveModel.DockableNode)) continue;
            IDockable iDockable = ((PerspectiveModel.DockableNode)iLayoutNode).getDockable();
            dockingPort.dock(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), "CENTER");
        }
    }

    private void reconstruct(PerspectiveModel.SplitNode splitNode) {
        JSplitPane jSplitPane = splitNode.getSplitPane();
        Component component = splitNode.getLeftComponent();
        Component component2 = splitNode.getRightComponent();
        jSplitPane.setLeftComponent(component);
        jSplitPane.setRightComponent(component2);
    }

    private void deferSplitPaneValidation(final ArrayList<PerspectiveModel.SplitNode> arrayList) {
        int n;
        if (arrayList.size() == 0) {
            return;
        }
        PerspectiveModel.SplitNode splitNode = arrayList.get(0);
        JSplitPane jSplitPane = splitNode.getSplitPane();
        int n2 = n = jSplitPane.getOrientation() == 1 ? jSplitPane.getWidth() : jSplitPane.getHeight();
        if (!jSplitPane.isValid() || !jSplitPane.isVisible() || n == 0) {
            jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("dividerLocation".equals(propertyChangeEvent.getPropertyName())) {
                        JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                        jSplitPane.removePropertyChangeListener(this);
                        DockingPort.this.processImportedSplitPaneValidation(arrayList);
                    }
                }
            });
        } else {
            this.processImportedSplitPaneValidation(arrayList);
        }
    }

    private void processImportedSplitPaneValidation(ArrayList<PerspectiveModel.SplitNode> arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            PerspectiveModel.SplitNode splitNode = arrayList.get(n);
            JSplitPane jSplitPane = splitNode.getSplitPane();
            jSplitPane.setDividerLocation(DockingUtility.calcDividerLocation(jSplitPane, splitNode.getSplitRatio()));
            IDockingPort iDockingPort = DockingUtility.getParentDockingPort(jSplitPane);
            if (iDockingPort instanceof DockingPort) {
                ((DockingPort)iDockingPort).evaluateDockingBorderStatus();
            }
            jSplitPane.validate();
            ++n;
        }
    }

    private int getTabIndex(JTabbedPane jTabbedPane, Component component) {
        int n = jTabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            if (jTabbedPane.getComponentAt(n2) == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static class DockablePropertyChangeHandler
    implements PropertyChangeListener {
        private DockablePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof IDockable) {
                IDockable iDockable = (IDockable)object;
                String string = propertyChangeEvent.getPropertyName();
                if ("tabIcon".equals(string) || "tabText".equals(string)) {
                    IDockingPort iDockingPort = iDockable.getDockingPort();
                    if (iDockingPort instanceof DockingPort) {
                        ((DockingPort)iDockingPort).updateTab(iDockable);
                    }
                } else if ("active".equals(string) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && ActiveDockableTracker.getInstance().getActiveDockable() != iDockable) {
                    ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), true);
                }
            }
        }
    }

    private static class MaximizationInstallInfo {
        private final JComponent content;
        private final Border border;

        public MaximizationInstallInfo(JComponent jComponent, Border border) {
            this.content = jComponent;
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public JComponent getContent() {
            return this.content;
        }
    }

    private static class MaximizationReleaseInfo
    extends MaximizationInstallInfo {
        private int tabIndex;

        public MaximizationReleaseInfo(JComponent jComponent, Border border) {
            super(jComponent, border);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public void setTabIndex(int n) {
            this.tabIndex = n;
        }
    }

    protected class PortLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = 7776573881944632196L;

        protected PortLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = DockingPort.this.getInsets();
            Dimension dimension = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getPreferredSize() : container.getSize();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = DockingPort.this.getInsets();
            Dimension dimension = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getMinimumSize() : new Dimension(0, 0);
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public Dimension maximumLayoutSize(Container container) {
            Insets insets = DockingPort.this.getInsets();
            Dimension dimension = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - insets.top - insets.bottom);
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle = DockingPort.this.getBounds();
            Insets insets = DockingPort.this.getInsets();
            int n = rectangle.width - insets.right - insets.left;
            int n2 = rectangle.height - insets.top - insets.bottom;
            if (DockingPort.this.getDockedComponent() != null) {
                DockingPort.this.getDockedComponent().setBounds(insets.left, insets.top, n, n2);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

