/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockbarDeactivator;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockbarSlidePanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

class DockbarTracker
implements PropertyChangeListener,
AWTEventListener {
    DockbarTracker() {
    }

    public static void register() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockbarTracker dockbarTracker = new DockbarTracker();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.addPropertyChangeListener(dockbarTracker);
                long l = 48L;
                Toolkit.getDefaultToolkit().addAWTEventListener(dockbarTracker, l);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Component component;
        if ("activeWindow".equals(propertyChangeEvent.getPropertyName()) && (component = (Component)propertyChangeEvent.getNewValue()) != null) {
            DockbarManager.windowChanged(component);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        DockbarDeactivator dockbarDeactivator;
        int n = aWTEvent.getID();
        if (n != 503 && n != 501) {
            return;
        }
        DockbarManager dockbarManager = DockbarManager.getCurrent();
        DockbarDeactivator dockbarDeactivator2 = dockbarDeactivator = dockbarManager == null ? null : dockbarManager.getDockbarDeactivator();
        if (dockbarDeactivator == null || !dockbarManager.isDockbarActive()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        DockbarSlidePanel dockbarSlidePanel = dockbarManager.getSlidePanel();
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), dockbarSlidePanel.getRootPane());
        boolean bl = SwingUtilities.convertRectangle(dockbarSlidePanel.getParent(), dockbarSlidePanel.getBounds(), dockbarSlidePanel.getRootPane()).contains(point);
        if (n == 501) {
            dockbarDeactivator.mousePressed(point, bl);
        } else {
            this.handleMouseMove(dockbarDeactivator, point, bl);
        }
    }

    private void handleMouseMove(DockbarDeactivator dockbarDeactivator, Point point, boolean bl) {
        if (bl) {
            if (!dockbarDeactivator.isMouseOver()) {
                dockbarDeactivator.mouseEntered(point);
            }
        } else if (dockbarDeactivator.isMouseOver()) {
            dockbarDeactivator.mouseExited(point);
        }
    }
}

