/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.swing.JYDockingPort;
import de.javasoft.swing.jydocking.DockableComponentWrapper;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingStrategy;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockableAcceptor;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.plaf.DockingViewUI;
import de.javasoft.swing.plaf.addons.JYDockingAddon;
import de.javasoft.swing.plaf.jydocking.DockingButton;
import de.javasoft.swing.plaf.jydocking.DockingViewContentPane;
import de.javasoft.swing.plaf.jydocking.DockingViewTitlebar;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYDockingView
extends JComponent
implements IDockable,
IDockingConstants {
    private static final long serialVersionUID = 1910286791529421496L;
    public static final String uiClassID = "JYDockingViewUI";
    protected DockingViewTitlebar titlebar;
    protected JPanel contentPane;
    protected Container userContentPane;
    private DockableComponentWrapper delegate;
    static final IDockingStrategy VIEW_DOCKING_STRATEGY;
    private boolean paintContentPaneBackground;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYDockingAddon());
        VIEW_DOCKING_STRATEGY = JYDockingView.createDockingStrategy();
        if (DockingManager.getDockingStrategy(JYDockingView.class) == null) {
            DockingManager.setDockingStrategy(JYDockingView.class, VIEW_DOCKING_STRATEGY);
        }
    }

    public JYDockingView(String string, String string2, String string3) {
        this.delegate = new DockableComponentWrapper(this, string, string3, false);
        this.contentPane = new DockingViewContentPane();
        this.add(this.contentPane);
        this.setTitlebar(new DockingViewTitlebar());
        this.paintContentPaneBackground = true;
        this.setContentPane(this.createContentPane());
        super.setLayout(this.createLayout());
        this.setTitle(string2 == null ? "" : string2);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                JYDockingView.this.clearButtonRollovers();
            }
        });
        this.updateUI();
        DockingManager.registerDockable(this);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewUI.class));
        DockingManager.isMaximized(this);
    }

    @Override
    public DockingViewUI getUI() {
        return (DockingViewUI)this.ui;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof DockingViewTitlebar) {
            ((DockingViewTitlebar)component).setView(this);
            super.addImpl(component, object, n);
        } else if (component == this.contentPane) {
            super.addImpl(component, object, n);
        } else {
            this.getContentPane().add(component, object, n);
        }
    }

    @Override
    public void remove(Component component) {
        if (component == this.userContentPane) {
            this.contentPane.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    protected Container createContentPane() {
        return new JPanel();
    }

    protected LayoutManager createLayout() {
        return new ViewLayout();
    }

    public void setContentPane(Container container) throws IllegalArgumentException {
        if (this.userContentPane != null) {
            this.remove(this.userContentPane);
        }
        this.userContentPane = container;
        this.contentPane.add(this.userContentPane);
    }

    public Container getContentPane() {
        return this.userContentPane;
    }

    public void setTitle(String string) {
        if (this.titlebar != null) {
            this.titlebar.setTitleText(string);
        }
    }

    public String getTitle() {
        DockingViewTitlebar dockingViewTitlebar = this.getTitlebar();
        return dockingViewTitlebar == null ? null : dockingViewTitlebar.getTitleText();
    }

    public void setDraggingEnabled(boolean bl) {
        if (bl) {
            this.getDragSources().add(this.getTitlebar());
            DockingManager.updateDragListeners(this);
        } else {
            this.getDragSources().remove(this.getTitlebar());
            DockingManager.removeDragListeners(this.getTitlebar());
        }
    }

    public boolean isDraggingEnabled() {
        return this.getDragSources().contains(this.getTitlebar());
    }

    public void setTitlebar(DockingViewTitlebar dockingViewTitlebar) {
        if (dockingViewTitlebar != null && dockingViewTitlebar == this.userContentPane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        if (this.titlebar != null) {
            this.remove(this.titlebar);
            this.titlebar.setView(null);
            this.getDragSources().remove(this.titlebar);
            DockingManager.removeDragListeners(this.titlebar);
        }
        this.titlebar = dockingViewTitlebar;
        if (dockingViewTitlebar != null) {
            this.add(dockingViewTitlebar);
            this.setDraggingEnabled(true);
        }
    }

    public DockingViewTitlebar getTitlebar() {
        return this.titlebar;
    }

    public void addAction(Action action) {
        if (this.titlebar != null) {
            this.titlebar.addAction(action);
        }
    }

    public void removeAction(Action action) {
        if (this.titlebar != null) {
            this.titlebar.removeAction(action);
        }
    }

    public void setIcon(Icon icon) {
        if (this.titlebar != null) {
            this.titlebar.setTitleIcon(icon);
        }
    }

    public Icon getIcon() {
        return this.titlebar == null ? null : this.titlebar.getTitleIcon();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        this.getContentPane().setLayout(layoutManager);
    }

    @Override
    protected String paramString() {
        return "id=" + this.getID() + "," + super.paramString();
    }

    private static IDockingStrategy createDockingStrategy() {
        return new DockingStrategy(){

            protected IDockingPort createDockingPortImpl(IDockingPort iDockingPort) {
                return new JYDockingPort();
            }
        };
    }

    private void clearButtonRollovers() {
        if (this.titlebar == null) {
            return;
        }
        Component[] componentArray = this.titlebar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            DockingButton dockingButton;
            DockingButton dockingButton2 = dockingButton = componentArray[n] instanceof DockingButton ? (DockingButton)componentArray[n] : null;
            if (dockingButton != null) {
                dockingButton.getModel().setRollover(false);
            }
            ++n;
        }
    }

    public boolean dock(IDockable iDockable, String string, float f) {
        return this.delegate.dock(iDockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), string, f);
    }

    @Override
    public JComponent getComponent() {
        return this.delegate.getComponent();
    }

    @Override
    public String getID() {
        return this.delegate.getID();
    }

    @Override
    public IDockingPort getDockingPort() {
        return this.delegate.getDockingPort();
    }

    @Override
    public List<JComponent> getDragSources() {
        return this.delegate.getDragSources();
    }

    @Override
    public boolean dock(IDockable iDockable, Perspective perspective, String string, float f) {
        return this.delegate.dock(iDockable, perspective, string, f);
    }

    @Override
    public void addDockingListener(IDockingEventListener iDockingEventListener) {
        this.delegate.addDockingListener(iDockingEventListener);
    }

    @Override
    public void removeDockingListener(IDockingEventListener iDockingEventListener) {
        this.delegate.removeDockingListener(iDockingEventListener);
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.delegate.getDockingListeners();
    }

    @Override
    public void setDockingEnabled(boolean bl) {
        this.delegate.setDockingEnabled(bl);
    }

    @Override
    public boolean isDockingEnabled() {
        return this.delegate.isDockingEnabled();
    }

    @Override
    public void setActive(boolean bl) {
        this.delegate.setActive(bl);
    }

    @Override
    public boolean isActive() {
        return this.delegate.isActive();
    }

    @Override
    public void setActiveStateLocked(boolean bl) {
        this.delegate.setActiveStateLocked(bl);
    }

    @Override
    public boolean isActiveStateLocked() {
        return this.delegate.isActiveStateLocked();
    }

    @Override
    public void setTabText(String string) {
        String string2 = this.getTabText();
        this.delegate.setTabText(string);
        this.firePropertyChange("tabText", string2, string);
    }

    @Override
    public String getTabText() {
        return this.delegate.getTabText();
    }

    @Override
    public void setDockbarIcon(Icon icon) {
        Icon icon2 = this.getDockbarIcon();
        this.delegate.setDockbarIcon(icon);
        this.firePropertyChange("dockbarIcon", icon2, icon);
    }

    @Override
    public Icon getDockbarIcon() {
        Icon icon = this.delegate.getDockbarIcon();
        return icon == null ? this.getIcon() : icon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        Icon icon2 = this.getTabIcon();
        this.delegate.setTabIcon(icon);
        this.firePropertyChange("tabIcon", icon2, icon);
    }

    @Override
    public Icon getTabIcon() {
        Icon icon = this.delegate.getTabIcon();
        return icon == null ? this.getIcon() : icon;
    }

    @Override
    public void setRegionInset(String string, float f) {
        this.delegate.setRegionInset(string, f);
    }

    @Override
    public float getRegionInset(String string) {
        return this.delegate.getRegionInset(string);
    }

    @Override
    public void setSiblingSize(String string, float f) {
        this.delegate.setSiblingSize(string, f);
    }

    @Override
    public float getSiblingSize(String string) {
        return this.delegate.getSiblingSize(string);
    }

    @Override
    public void setTerritoryBlocked(String string, boolean bl) {
        this.delegate.setTerritoryBlocked(string, bl);
    }

    @Override
    public boolean isTerritoryBlocked(String string) {
        return this.delegate.isTerritoryBlocked(string);
    }

    @Override
    public void setDockableAcceptor(IDockableAcceptor iDockableAcceptor) {
        IDockableAcceptor iDockableAcceptor2 = this.getDockableAcceptor();
        this.delegate.setDockableAcceptor(iDockableAcceptor);
        this.firePropertyChange("dockableAcceptor", iDockableAcceptor2, iDockableAcceptor);
    }

    @Override
    public IDockableAcceptor getDockableAcceptor() {
        return this.delegate.getDockableAcceptor();
    }

    @Override
    public void setDragTheshold(float f) {
        this.delegate.setDragTheshold(f);
    }

    @Override
    public float getDragThreshold() {
        return this.delegate.getDragThreshold();
    }

    @Override
    public void setPreviewSize(float f) {
        this.delegate.setPreviewSize(f);
    }

    @Override
    public float getPreviewSize() {
        return this.delegate.getPreviewSize();
    }

    @Override
    public void setMouseMotionListenersBlockedWhileDragging(boolean bl) {
        this.delegate.setMouseMotionListenersBlockedWhileDragging(bl);
    }

    @Override
    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.delegate.isMouseMotionListenersBlockedWhileDragging();
    }

    public void setPaintContentPaneBackground(boolean bl) {
        this.paintContentPaneBackground = bl;
    }

    public boolean getPaintContentPaneBackground() {
        return this.paintContentPaneBackground;
    }

    @Override
    public void dockableRegistered(DockingEvent dockingEvent) {
        this.delegate.dockableRegistered(dockingEvent);
    }

    @Override
    public void dockableUnregistered(DockingEvent dockingEvent) {
        this.delegate.dockableUnregistered(dockingEvent);
    }

    @Override
    public void dockingCanceled(DockingEvent dockingEvent) {
        this.delegate.dockingCanceled(dockingEvent);
    }

    @Override
    public void dockingCompleted(DockingEvent dockingEvent) {
        this.delegate.dockingCompleted(dockingEvent);
        if (this.titlebar != null) {
            this.titlebar.revalidate();
        }
    }

    @Override
    public void dragStarted(DockingEvent dockingEvent) {
        this.delegate.dragStarted(dockingEvent);
    }

    @Override
    public void dropStarted(DockingEvent dockingEvent) {
        this.delegate.dropStarted(dockingEvent);
    }

    @Override
    public void undockingStarted(DockingEvent dockingEvent) {
        this.delegate.undockingStarted(dockingEvent);
    }

    @Override
    public void undockingCompleted(DockingEvent dockingEvent) {
        this.delegate.undockingCompleted(dockingEvent);
        this.clearButtonRollovers();
    }

    protected class ViewLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -785289772450064051L;

        protected ViewLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension dimension = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getPreferredSize() : container.getSize();
            Dimension dimension2 = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension dimension = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getMinimumSize() : container.getSize();
            Dimension dimension2 = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getMinimumSize() : new Dimension(0, 0);
            Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
            return dimension3;
        }

        public Dimension maximumLayoutSize(Container container) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension dimension = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getMaximumSize() : new Dimension(0, 0);
            Dimension dimension2 = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - insets.top - insets.bottom - dimension.height - 1);
            return new Dimension(Math.min(dimension2.width, dimension.width) + insets.left + insets.right, dimension2.height + dimension.height + insets.top + insets.bottom);
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle = container.getBounds();
            Insets insets = JYDockingView.this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = rectangle.width - insets.right - insets.left;
            int n4 = rectangle.height - insets.top - insets.bottom;
            if (JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible()) {
                Dimension dimension = JYDockingView.this.titlebar.getPreferredSize();
                JYDockingView.this.titlebar.setBounds(0, 0, n3, dimension.height);
                n4 -= (n2 += dimension.height);
            }
            if (JYDockingView.this.contentPane != null) {
                JYDockingView.this.contentPane.setBounds(n, n2, n3, n4);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

