/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.io.FileOperationEvent;
import de.javasoft.io.FileOperationListener;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FileOperationDialog
extends JDialog
implements FileOperationListener,
Runnable {
    public static final int COPY_OPERATION = 1;
    public static final int MOVE_OPERATION = 2;
    public static final int DELETE_OPERATION = 3;
    private boolean abort;
    private JLabel folderName;
    private JLabel fileName;
    private String currentFolderName;
    private String currentFileName;
    private JProgressBar progressBar;
    private static final int xGap = 10;
    private static final int yGap = 10;
    String title = "";
    String imagePath = "";
    Insets imageInsets;

    public FileOperationDialog(Dialog dialog, int n) {
        super(dialog);
        this.init(dialog, n);
    }

    public FileOperationDialog(Frame frame, int n) {
        super(frame);
        this.init(frame, n);
    }

    private void init(Window window, int n) {
        Image image = null;
        switch (n) {
            case 1: {
                this.title = UIManager.getString("FileOperationDialog.copy.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.copyBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.copyBackground.insets", null, new Insets(0, 0, 4, 100));
                image = (Image)UIManager.get("Synthetica.fileOperationDialog.copy.iconImage");
                break;
            }
            case 2: {
                this.title = UIManager.getString("FileOperationDialog.move.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.moveBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.moveBackground.insets", null, new Insets(0, 0, 4, 100));
                image = (Image)UIManager.get("Synthetica.fileOperationDialog.move.iconImage");
                break;
            }
            case 3: {
                this.title = UIManager.getString("FileOperationDialog.delete.title");
                this.imagePath = UIManager.getString("Synthetica.fileOperationDialog.title.deleteBackground");
                this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.fileOperationDialog.title.deleteBackground.insets", null, new Insets(0, 0, 4, 100));
                image = (Image)UIManager.get("Synthetica.fileOperationDialog.delete.iconImage");
            }
        }
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        this.getRootPane().putClientProperty("Synthetica.dialog.iconImage", image);
        JPanel jPanel = new JPanel(){
            private Image background;
            {
                this.background = new ImageIcon(SyntheticaLookAndFeel.class.getResource(FileOperationDialog.this.imagePath)).getImage();
            }

            public void paintComponent(Graphics graphics) {
                ImagePainter imagePainter = new ImagePainter(this.background, graphics, 0, 0, this.getWidth(), this.background.getHeight(null), FileOperationDialog.this.imageInsets, FileOperationDialog.this.imageInsets);
                imagePainter.draw();
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int n = UIManager.getInt("Synthetica.fileOperationDialog.title.xPos");
                int n2 = UIManager.getInt("Synthetica.fileOperationDialog.title.yPos");
                graphics2D.drawString(FileOperationDialog.this.title, n, n2);
                graphics2D.dispose();
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.background.getWidth(null), this.background.getHeight(null));
            }
        };
        float f = SyntheticaLookAndFeel.scaleFontSize(UIManager.getInt("Synthetica.fileOperationDialog.title.size"));
        jPanel.setFont(jPanel.getFont().deriveFont(1, f));
        jPanel.setForeground(UIManager.getColor("Synthetica.fileOperationDialog.title.color"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 10);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(UIManager.getString("FileOperationDialog.folder"));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.folderName = new JLabel();
        jPanel2.add((Component)this.folderName, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel2 = new JLabel(UIManager.getString("FileOperationDialog.file"));
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.fileName = new JLabel();
        jPanel2.add((Component)this.fileName, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.progressBar = new JProgressBar(0, 50);
        jPanel2.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.anchor = window.getComponentOrientation().isLeftToRight() ? 13 : 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton(UIManager.getString("FileOperationDialog.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileOperationDialog.this.abort = true;
                FileOperationDialog.this.dispose();
            }
        });
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add(jPanel2);
        this.pack();
        int n2 = window.getLocation().x + window.getSize().width / 2;
        int n3 = n2 - this.getSize().width / 2;
        int n4 = window.getLocation().y + window.getSize().height / 2;
        int n5 = n4 - this.getSize().height / 2;
        this.setLocation(n3, n5);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FileOperationDialog.this.abort = true;
            }
        });
    }

    public boolean processFileOperationEvent(FileOperationEvent fileOperationEvent) {
        this.currentFolderName = fileOperationEvent.getFile().getParentFile().getName();
        this.currentFileName = fileOperationEvent.getFile().getName();
        EventQueue.invokeLater(this);
        return !this.abort;
    }

    public void run() {
        this.folderName.setText(this.currentFolderName);
        this.fileName.setText(this.currentFileName);
        this.progressBar.setValue((this.progressBar.getValue() + 1) % 50);
    }
}

