/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SyntheticaState {
    private int cState = 0;

    public SyntheticaState() {
    }

    public SyntheticaState(int n) {
        this();
        this.cState = n;
    }

    public SyntheticaState(State state) {
        this.setState(state);
    }

    public int getState() {
        return this.cState;
    }

    public void setState(int n) {
        this.cState = n;
    }

    public void setState(State state) {
        this.cState |= state.toInt();
    }

    public void resetState(State state) {
        if (this.isSet(state)) {
            this.cState ^= state.toInt();
        }
    }

    public boolean isSet(State state) {
        return (this.getState() & state.toInt()) > 0;
    }

    public boolean isSet(int n) {
        return (this.getState() & n) != 0;
    }

    public boolean equals(Object object) {
        if (object instanceof SyntheticaState) {
            return ((SyntheticaState)object).getState() == this.getState();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        State[] stateArray = State.values();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State state = stateArray[n2];
            if ((this.getState() & state.toInt()) != 0) {
                stringBuilder.append(':');
                stringBuilder.append((Object)state);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNDEFINED("UNDEFINED", 0),
        ENABLED("ENABLED", 1),
        HOVER("HOVER", 2),
        PRESSED("PRESSED", 4),
        DISABLED("DISABLED", 8),
        FOCUSED("FOCUSED", 256),
        SELECTED("SELECTED", 512),
        DEFAULT("DEFAULT", 1024),
        LOCKED("LOCKED", 2048),
        ACTIVE("ACTIVE", 4096);

        private int state;
        private String name;
        private static Map<String, State> states;

        static {
            states = new HashMap<String, State>();
            State[] stateArray = State.values();
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                State state = stateArray[n2];
                states.put(state.name, state);
                ++n2;
            }
        }

        private State(String string2, int n2) {
            this.name = string2;
            this.state = n2;
        }

        public static State parse(String string) throws ParseException {
            State state = states.get(string.toUpperCase());
            if (state == null) {
                throw new ParseException("Unsupported state: " + string, -1);
            }
            return state;
        }

        public int toInt() {
            return this.state;
        }

        public String toString() {
            return this.name;
        }
    }
}

