/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.LauncherReplacementCallback;
import com.install4j.runtime.launcher.service.UnixServiceHandler;
import com.install4j.runtime.launcher.util.ErrorHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.launcher.util.SingleInstance;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class UnixLauncher {
    public static final String PROPNAME_EXECUTABLE_PATH = "executablePath";
    private static boolean isGuiApplication;
    private static boolean failOnMainMethodException;
    private static String[] originalArgs;
    private static String stdErrFile;
    private static String stdOutFile;
    private static String className;

    public static void start(String className, String method, String configId, Properties properties, String[] args) {
        LauncherHelper.INSTANCE.initIntegration();
        args = LauncherHelper.INSTANCE.initVariables(UnixLauncher.class, args);
        ArgumentStack argStack = new ArgumentStack(args);
        if (method == null) {
            method = argStack.popString();
        }
        try {
            System.setProperty("install4j.jvmDir", System.getProperty("java.home"));
            File runtimeDir = ResourceHelper.getRuntimeDir();
            String moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                String relativePath = properties.getProperty(PROPNAME_EXECUTABLE_PATH, "unknown");
                moduleName = FileUtil.getCanonicalPath(new File(new File(runtimeDir, ".."), relativePath));
                System.setProperty("exe4j.moduleName", moduleName);
            }
            LauncherEngine.setProperties(properties);
            if (method.equals("stop")) {
                UnixServiceHandler.INSTANCE.setStop();
            } else if (method.equals("status")) {
                UnixServiceHandler.INSTANCE.reportStatus();
            } else {
                File exeBaseDir = new File(moduleName).getParentFile();
                File installerTempDir = UnixLauncher.isInstaller(configId) ? runtimeDir : null;
                stdErrFile = UnixLauncher.getRedirectionFileName(exeBaseDir, installerTempDir, 102, 103);
                stdOutFile = UnixLauncher.getRedirectionFileName(exeBaseDir, installerTempDir, 104, 105);
                UnixLauncher.prepareLaunch(argStack, method, configId, LauncherEngine.getBooleanProperty(125));
                LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.reportError(e.toString());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        LauncherHelper.INSTANCE.initIntegration();
        args = LauncherHelper.INSTANCE.initVariables(UnixLauncher.class, args);
        try {
            ArgumentStack argStack = new ArgumentStack(args);
            String method = argStack.popString();
            if (method.equals("stop")) {
                UnixServiceHandler.INSTANCE.setStop();
            } else if (method.equals("status")) {
                UnixServiceHandler.INSTANCE.reportStatus();
            } else {
                String configId = argStack.popString();
                LauncherEngine.setProperties(UnixLauncher.readProperties(configId));
                stdErrFile = argStack.popString();
                stdOutFile = argStack.popString();
                className = argStack.popString();
                UnixLauncher.prepareLaunch(argStack, method, configId, Boolean.getBoolean("i4j.vpt"));
                LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.reportError(e.toString());
            System.exit(1);
        }
    }

    private static void prepareLaunch(ArgumentStack argStack, String method, String configId, boolean removeVmPassThrough) {
        if (LauncherUtil.isMacOS() && !LauncherHelper.INSTANCE.getInstallerFile(Common.getMacLibraryFilename(0)).isFile()) {
            System.setProperty("install4j.noNativeDialogs", "true");
        }
        isGuiApplication = LauncherEngine.getBooleanProperty(162);
        ErrorHandler.setIsGuiApplication(isGuiApplication);
        failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
        originalArgs = Launcher.getArgumentArray(argStack, argStack.size(), removeVmPassThrough);
        Launcher.setOriginalArgs(originalArgs);
        SplashEngine.setJavaSplashScreenConfig(new SplashScreenConfig().initFromLauncherEngine());
        if (method.equals("launch")) {
            UnixLauncher.checkSingleInstance(configId, originalArgs);
            UnixLauncher.checkWarning();
        } else if (method.equals("start")) {
            UnixServiceHandler.INSTANCE.setStart();
            if (LauncherEngine.getBooleanProperty(10011)) {
                UnixLauncher.checkSingleInstance(configId, originalArgs);
            }
        } else if (method.equals("run")) {
            UnixLauncher.checkSingleInstance(configId, originalArgs);
            UnixLauncher.checkWarning();
            stdErrFile = "";
            stdOutFile = "";
        } else if (method.equals("run-redirect")) {
            UnixLauncher.checkSingleInstance(configId, originalArgs);
            UnixLauncher.checkWarning();
        }
    }

    private static void checkSingleInstance(String configId, String[] originalArgs) {
        String moduleName;
        boolean languageRestart;
        boolean bl = languageRestart = originalArgs.length >= 1 && "__i4j_lang_restart".equals(originalArgs[0]);
        if (!languageRestart && LauncherEngine.getBooleanProperty(10005) && (moduleName = System.getProperty("exe4j.moduleName")) != null) {
            SingleInstance.checkForCurrentLauncher(new File(moduleName), LauncherEngine.getBooleanProperty(158), UnixLauncher.isInstaller(configId) ? null : originalArgs);
        }
    }

    private static void checkWarning() {
        if (LauncherEngine.getBooleanProperty(148)) {
            System.out.println("This launcher was created with an evaluation version of install4j.");
        }
    }

    private static Properties readProperties(String configId) {
        if (UnixLauncher.isInstaller(configId)) {
            Properties properties = new Properties();
            properties.setProperty(String.valueOf(162), String.valueOf(1));
            properties.setProperty(String.valueOf(10005), String.valueOf(1));
            return properties;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(LauncherHelper.INSTANCE.getInstallerFile(configId + ".lprop")));
            Properties properties = new Properties();
            properties.load(in);
            return LauncherUtil.replaceVariables(properties);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Properties();
        }
    }

    private static boolean isInstaller(String configId) {
        return configId.equals("0");
    }

    static String getRedirectionFileName(File exeBaseDir, File installerTempDir, int propertyRedirect, int propertyFile) {
        String redirectionFile = "";
        if (LauncherEngine.getBooleanProperty(propertyRedirect)) {
            String file = LauncherHelper.INSTANCE.replaceVariables(LauncherEngine.getProperty(propertyFile), new LauncherReplacementCallback(exeBaseDir, installerTempDir));
            if (!(file = file.replace("//", "/")).startsWith(File.separator)) {
                redirectionFile = exeBaseDir.getAbsolutePath() + File.separator;
            }
            redirectionFile = redirectionFile + file;
        }
        return redirectionFile;
    }
}

