/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.install4j.api.launcher.StartupNotification;
import java.io.File;
import java.net.URI;

class MacApiHelper {
    MacApiHelper() {
    }

    static void requestForeground() {
        Application.getApplication().requestForeground(true);
    }

    static void setMacStartupListener(final StartupNotification.Listener startupListener) {
        try {
            if (startupListener != null) {
                Application.getApplication().setOpenFileHandler(new OpenFilesHandler(){

                    public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
                        for (File file : openFilesEvent.getFiles()) {
                            startupListener.startupPerformed(file.getAbsolutePath());
                        }
                    }
                });
                Application.getApplication().setOpenURIHandler(new OpenURIHandler(){

                    public void openURI(AppEvent.OpenURIEvent openURIEvent) {
                        URI uri = openURIEvent.getURI();
                        if (uri != null) {
                            startupListener.startupPerformed(uri.toString());
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacHandleQuit(final boolean handleQuit) {
        try {
            Application.getApplication().setQuitHandler(new QuitHandler(){

                public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                    if (handleQuit) {
                        quitResponse.performQuit();
                    } else {
                        quitResponse.cancelQuit();
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacQuitHandler(final Runnable runnable) {
        try {
            if (runnable != null) {
                Application.getApplication().setQuitHandler(new QuitHandler(){

                    public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                        quitResponse.cancelQuit();
                        runnable.run();
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacAboutHandler(final Runnable runnable) {
        try {
            if (runnable != null) {
                Application.getApplication().setAboutHandler(new AboutHandler(){

                    public void handleAbout(AppEvent.AboutEvent aboutEvent) {
                        runnable.run();
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setMacPreferencesHandler(final Runnable runnable) {
        try {
            if (runnable != null) {
                Application.getApplication().setPreferencesHandler(new PreferencesHandler(){

                    public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
                        runnable.run();
                    }
                });
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

