/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beans.ExternalFile;
import com.install4j.runtime.beans.formcomponents.AbstractLabelComponent;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLabelWithIconComponent
extends AbstractLabelComponent {
    private ExternalFile labelIconFile = null;
    private int iconTextGap = 4;
    private JLabel label;

    public ExternalFile getLabelIconFile() {
        return this.replaceWithTextOverride("labelIconFile", this.labelIconFile, ExternalFile.class);
    }

    public void setLabelIconFile(ExternalFile labelIconFile) {
        this.labelIconFile = labelIconFile;
    }

    public int getIconTextGap() {
        return this.replaceWithTextOverride("iconTextGap", this.iconTextGap);
    }

    public void setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getLabelText().trim().length() > 0) {
            this.initializeLabel(this.label, this.getRawLabelText());
        }
    }

    protected JLabel createLabel() {
        this.label = this.createLabel(this.getRawLabelText(), this.getLabelIconFile(), this.getIconTextGap(), this.getLabelColor(), this.getLabelFont(), this.getLabelFontType(), this.getLabelFontStyle(), this.getLabelFontSizePercent());
        return this.label;
    }

    protected JLabel createLabel(String rawLabelText, ExternalFile labelIconFile, int iconTextGap, Color labelColor, Font labelFont, FontType fontType, FontStyle fontStyle, int fontSizePercent) {
        final JLabel label = new JLabel();
        if (labelIconFile != null) {
            GUIHelper.withIcon(labelIconFile, this.getContext(), new GUIHelper.IconConsumer<Object>(){

                @Override
                public Object call(@NotNull ImageIcon icon) {
                    label.setIcon(icon);
                    return null;
                }
            });
        }
        label.setIconTextGap(iconTextGap);
        this.applyLabelColorAndFont(labelColor, labelFont, fontType, fontStyle, fontSizePercent, label);
        if (rawLabelText.trim().length() > 0) {
            this.initializeLabel(label, rawLabelText);
        }
        return label;
    }

    protected void initializeLabel(JLabel label, String rawLabelText) {
        this.getFormEnvironment().bindTextWithVariables(rawLabelText, label);
    }

    protected JLabel getLabel() {
        return this.label;
    }
}

