/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class StringLength
extends OXMLFunction {
    private int numParams;

    StringLength(int n) {
        this.numParams = n;
    }

    @Override
    public String getFunctionName() {
        return "string-length";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TINTEGER;
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        Object object;
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        int n = -1;
        if (oXMLItem == null) {
            n = 0;
        } else {
            object = oXMLItem.getString();
            if (!FNUtil.validateSurrogateSequence((String)object)) {
                throw new XQException("FOCH0001");
            }
            n = ((String)object).codePointCount(0, ((String)object).length());
        }
        object = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setInt(OXMLSequenceType.TINTEGER, n);
        ((OXMLSequence)object).appendItem(oXMLItem2);
        return object;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLSequence oXMLSequence = FNFunctionLibrary.getInstance().getFunction("string", 0).invoke(oXMLFunctionContext);
        return this.invoke(oXMLFunctionContext, oXMLSequence);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 0: {
                oXMLSequence = this.invoke(oXMLFunctionContext);
                break;
            }
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
            }
        }
        return oXMLSequence;
    }
}

