/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.apache.batik.util.CleanerThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class DocumentLoader {
    protected SVGDocumentFactory documentFactory;
    protected HashMap cacheMap = new HashMap();
    protected UserAgent userAgent;

    protected DocumentLoader() {
    }

    public DocumentLoader(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document checkCache(String string) {
        DocumentState documentState;
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = 0;
        }
        if ((n = string.indexOf(35, n)) != -1) {
            string = string.substring(0, n);
        }
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            documentState = (DocumentState)this.cacheMap.get(string);
        }
        if (documentState != null) {
            return documentState.getDocument();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadDocument(String string) throws IOException {
        Document document = this.checkCache(string);
        if (document != null) {
            return document;
        }
        SVGDocument sVGDocument = this.documentFactory.createSVGDocument(string);
        DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
        DocumentState documentState = new DocumentState(string, sVGDocument, documentDescriptor);
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.put(string, documentState);
        }
        return documentState.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadDocument(String string, InputStream inputStream) throws IOException {
        Document document = this.checkCache(string);
        if (document != null) {
            return document;
        }
        SVGDocument sVGDocument = this.documentFactory.createSVGDocument(string, inputStream);
        DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
        DocumentState documentState = new DocumentState(string, sVGDocument, documentDescriptor);
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.put(string, documentState);
        }
        return documentState.getDocument();
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(Element element) {
        DocumentState documentState;
        String string = ((SVGDocument)element.getOwnerDocument()).getURL();
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            documentState = (DocumentState)this.cacheMap.get(string);
        }
        if (documentState == null) {
            return -1;
        }
        return documentState.desc.getLocationLine(element);
    }

    private class DocumentState
    extends CleanerThread.SoftReferenceCleared {
        private String uri;
        private DocumentDescriptor desc;

        public DocumentState(String string, Document document, DocumentDescriptor documentDescriptor) {
            super(document);
            this.uri = string;
            this.desc = documentDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            HashMap hashMap = DocumentLoader.this.cacheMap;
            synchronized (hashMap) {
                DocumentLoader.this.cacheMap.remove(this.uri);
            }
        }

        public DocumentDescriptor getDocumentDescriptor() {
            return this.desc;
        }

        public String getURI() {
            return this.uri;
        }

        public Document getDocument() {
            return (Document)this.get();
        }
    }
}

